#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Ghost of a Tale
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251024.4

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='ghost-of-a-tale'
GAME_NAME='Ghost of a Tale'

ARCHIVE_BASE_1_NAME='setup_ghost_of_a_tale_833(a)_(62775).exe'
ARCHIVE_BASE_1_MD5='9026bc3f002bb5c71fe55f490a4e80d7'
ARCHIVE_BASE_1_TYPE='innosetup'
ARCHIVE_BASE_1_PART1_NAME='setup_ghost_of_a_tale_833(a)_(62775)-1.bin'
ARCHIVE_BASE_1_PART1_MD5='9970b40b5c464a551ec1c2c8a780fe9c'
ARCHIVE_BASE_1_SIZE='4989232'
ARCHIVE_BASE_1_VERSION='8.33-gog62775'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/ghost_of_a_tale'

ARCHIVE_BASE_0_NAME='setup_ghost_of_a_tale_833_(28317).exe'
ARCHIVE_BASE_0_MD5='ce98494f39f3908d33ef46e438d94da4'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_ghost_of_a_tale_833_(28317)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='e5a2d7c834572c438c324a5104692afb'
ARCHIVE_BASE_0_SIZE='5000000'
ARCHIVE_BASE_0_VERSION='8.33-gog28317'

UNITY3D_NAME='goat'

CONTENT_PATH_DEFAULT='.'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/Documents/My Games/Ghost of a Tale'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
