"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const util = tslib_1.__importStar(require("util"));
const url = tslib_1.__importStar(require("url"));
let state = { fn: null, ret: null };
if (!process.send) {
    throw new Error("process.send! not defined");
}
process.on("message", function (message) {
    if (!message.directive) {
        process.send({ directive: "error", reason: "Message directive not found." });
        process.exit(1);
    }
    switch (message.directive) {
        case "load":
            import(url.pathToFileURL(message.path).toString())
                .then((module) => {
                state.fn = findBuildFn(module);
                process.send({ directive: "loaded" });
            })
                .catch((e) => {
                process.send({ directive: "callError", reason: e, message: util.inspect(e) });
                process.exit(1);
            });
            break;
        case "call":
            if (!state.fn) {
                process.send({ directive: "error", reason: "Function not loaded." });
                process.exit(1);
            }
            let ret = null;
            try {
                ret = state.fn.apply(null, message.args);
            }
            catch (e) {
                process.send({ directive: "callError", reason: e, message: util.inspect(e) });
                process.exit(1);
            }
            if (ret instanceof Promise) {
                ret.then((result) => process.send({ directive: "return", result })).catch((e) => {
                    process.send({ directive: "callError", reason: e, message: util.inspect(e) });
                    process.exit(1);
                });
            }
            else {
                process.send({ directive: "return", result: ret });
            }
            break;
        case "over":
            process.exit(0);
            break;
        default:
            process.send({ directive: "error", reason: "Message directive not recognized." });
            break;
    }
});
function findBuildFn(m) {
    if (m.build && m.build instanceof Function)
        return m.build;
    if (m.default && m.default instanceof Function)
        return m.default;
    if (m instanceof Function)
        return m;
}
setTimeout(() => process.send({ directive: "ready" }), 0);
