% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_mixture.R
\name{dist_mixture}
\alias{dist_mixture}
\title{Create a mixture of distributions}
\usage{
dist_mixture(..., weights = numeric())
}
\arguments{
\item{...}{Distributions to be used in the mixture. Can be any
distributional objects.}

\item{weights}{A numeric vector of non-negative weights that sum to 1.
The length must match the number of distributions passed to \code{...}.
Each weight \eqn{w_i} represents the probability that a random draw
comes from the \eqn{i}-th component distribution.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A mixture distribution combines multiple component distributions with
specified weights. The resulting distribution can model complex,
multimodal data by representing it as a weighted sum of simpler
distributions.
}
\details{
In the following, let \eqn{X} be a mixture random variable composed
of \eqn{K} component distributions \eqn{F_1, F_2, \ldots, F_K} with
corresponding weights \eqn{w_1, w_2, \ldots, w_K} where
\eqn{\sum_{i=1}^K w_i = 1} and \eqn{w_i \geq 0} for all \eqn{i}.

\strong{Support}: The union of the supports of all component distributions

\strong{Mean}:

For univariate mixtures:
\deqn{
    E(X) = \sum_{i=1}^K w_i \mu_i
  }{
    E(X) = sum_{i=1}^K w_i * mu_i
  }

where \eqn{\mu_i} is the mean of the \eqn{i}-th component distribution.

For multivariate mixtures:
\deqn{
    E(\mathbf{X}) = \sum_{i=1}^K w_i \boldsymbol{\mu}_i
  }{
    E(X) = sum_{i=1}^K w_i * mu_i
  }

where \eqn{\boldsymbol{\mu}_i} is the mean vector of the \eqn{i}-th
component distribution.

\strong{Variance}:

For univariate mixtures:
\deqn{
    \text{Var}(X) = \sum_{i=1}^K w_i (\mu_i^2 + \sigma_i^2) - \left(\sum_{i=1}^K w_i \mu_i\right)^2
  }{
    Var(X) = sum_{i=1}^K w_i * (mu_i^2 + sigma_i^2) - (sum_{i=1}^K w_i * mu_i)^2
  }

where \eqn{\sigma_i^2} is the variance of the \eqn{i}-th component
distribution.

\strong{Covariance}:

For multivariate mixtures:
\deqn{
    \text{Cov}(\mathbf{X}) = \sum_{i=1}^K w_i \left[ (\boldsymbol{\mu}_i - \bar{\boldsymbol{\mu}})(\boldsymbol{\mu}_i - \bar{\boldsymbol{\mu}})^T + \boldsymbol{\Sigma}_i \right]
  }{
    Cov(X) = sum_{i=1}^K w_i * [ (mu_i - mu_bar)(mu_i - mu_bar)^T + Sigma_i ]
  }

where \eqn{\bar{\boldsymbol{\mu}} = \sum_{i=1}^K w_i \boldsymbol{\mu}_i}
is the overall mean vector and \eqn{\boldsymbol{\Sigma}_i} is the
covariance matrix of the \eqn{i}-th component distribution.

\strong{Probability density/mass function (p.d.f/p.m.f)}:

\deqn{
    f(x) = \sum_{i=1}^K w_i f_i(x)
  }{
    f(x) = sum_{i=1}^K w_i * f_i(x)
  }

where \eqn{f_i(x)} is the density or mass function of the \eqn{i}-th
component distribution.

\strong{Cumulative distribution function (c.d.f)}:

For univariate mixtures:
\deqn{
    F(x) = \sum_{i=1}^K w_i F_i(x)
  }{
    F(x) = sum_{i=1}^K w_i * F_i(x)
  }

where \eqn{F_i(x)} is the c.d.f. of the \eqn{i}-th component
distribution.

For multivariate mixtures, the c.d.f. is approximated numerically.

\strong{Quantile function}:

For univariate mixtures, the quantile function has no closed form
and is computed numerically by inverting the c.d.f. using root-finding
(\code{\link[stats:uniroot]{stats::uniroot()}}).

For multivariate mixtures, quantiles are not yet implemented.
}
\examples{
# Univariate mixture of two normal distributions
dist <- dist_mixture(dist_normal(0, 1), dist_normal(5, 2), weights = c(0.3, 0.7))
dist

mean(dist)
variance(dist)

density(dist, 2)
cdf(dist, 2)
quantile(dist, 0.5)

generate(dist, 10)

}
\seealso{
\code{\link[stats:uniroot]{stats::uniroot()}}, \code{\link[vctrs:vec_unique]{vctrs::vec_unique_count()}}
}
