% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magrittr.R
\docType{package}
\name{magrittr-package}
\alias{magrittr}
\alias{magrittr-package}
\title{magrittr - Ceci n'est pas un pipe}
\description{
The magrittr package offers a set of operators which promote semantics
that will improve your code by
\itemize{
\item structuring sequences of data operations left-to-right
(as opposed to from the inside and out),
\item avoiding nested function calls,
\item minimizing the need for local variables and function definitions, and
\item making it easy to add steps anywhere in the sequence of operations.
}
The operators pipe their left-hand side values forward into expressions that
appear on the right-hand side, i.e. one can replace \code{f(x)} with
\code{x \%>\% f}, where \code{\%>\%} is the (main) pipe-operator.
}
\details{
Consider the example below. Four operations are performed to
arrive at the desired data set, and they are written in a natural order:
the same as the order of execution. Also, no temporary variables are needed.
If yet another operation is required, it is straight-forward to add to the
sequence of operations whereever it may be needed.

For a more detailed introduction see the vignette
(\code{vignette("magrittr")}) or the documentation pages for the
available operators:\cr
\tabular{ll}{
\code{\link{\%>\%}}  \tab pipe.\cr
\code{\link{\%T>\%}} \tab tee pipe.\cr
\code{\link{\%<>\%}} \tab assignment pipe.\cr
\code{\link{\%$\%}}  \tab exposition pipe.\cr
}
}
\examples{
\dontrun{

the_data <-
  read.csv('/path/to/data/file.csv') \%>\%
  subset(variable_a > x) \%>\%
  transform(variable_c = variable_a/variable_b) \%>\%
  head(100)
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://magrittr.tidyverse.org}
  \item \url{https://github.com/tidyverse/magrittr}
  \item Report bugs at \url{https://github.com/tidyverse/magrittr/issues}
}

}
\author{
\strong{Maintainer}: Lionel Henry \email{lionel@posit.co}

Authors:
\itemize{
  \item Stefan Milton Bache \email{stefan@stefanbache.dk} (Original author and creator of magrittr) [copyright holder]
  \item Hadley Wickham \email{hadley@posit.co}
}

Other contributors:
\itemize{
  \item Posit Software, PBC (\href{https://ror.org/03wc8by49}{ROR}) [copyright holder, funder]
}

}
\keyword{internal}
