/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FOURIResolver
implements URIResolver {
    private Log log = LogFactory.getLog("FOP");

    public Source resolve(String href, String base) throws TransformerException {
        URL absoluteURL = null;
        URL baseURL = this.toBaseURL(base);
        if (baseURL == null) {
            try {
                absoluteURL = new URL(href);
            }
            catch (MalformedURLException mue) {
                try {
                    absoluteURL = new URL("file:" + href);
                }
                catch (MalformedURLException mfue) {
                    this.log.error("Error with URL '" + href + "': " + mue.getMessage(), mue);
                    return null;
                }
            }
        } else {
            try {
                String scheme = baseURL.getProtocol() + ":";
                if (href.startsWith(scheme)) {
                    href = href.substring(scheme.length());
                }
                absoluteURL = new URL(baseURL, href);
            }
            catch (MalformedURLException mfue) {
                this.log.error("Error with URL '" + href + "': " + mfue.getMessage(), mfue);
                return null;
            }
        }
        try {
            return new StreamSource(absoluteURL.openStream(), absoluteURL.toExternalForm());
        }
        catch (IOException ioe) {
            this.log.error("Error with opening URL '" + href + "': " + ioe.getMessage(), ioe);
            return null;
        }
    }

    private URL toBaseURL(String baseURL) {
        try {
            return new URL(baseURL == null ? new File("").toURL().toExternalForm() : baseURL);
        }
        catch (MalformedURLException mfue) {
            this.log.error("Error with base URL: " + mfue.getMessage(), mfue);
            return null;
        }
    }
}

