/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.expr;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.expr.NumericOp;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;

public class RelativeNumericProperty
extends Property
implements Numeric,
Length {
    public static final int ADDITION = 1;
    public static final int SUBTRACTION = 2;
    public static final int MULTIPLY = 3;
    public static final int DIVIDE = 4;
    public static final int MODULO = 5;
    public static final int NEGATE = 6;
    public static final int ABS = 7;
    public static final int MAX = 8;
    public static final int MIN = 9;
    private static String operations = " +-*/%";
    private int operation;
    private Numeric op1;
    private Numeric op2;
    private int dimension;

    public RelativeNumericProperty(int operation, Numeric op1, Numeric op2) {
        this.operation = operation;
        this.op1 = op1;
        this.op2 = op2;
        switch (operation) {
            case 3: {
                this.dimension = op1.getDimension() + op2.getDimension();
                break;
            }
            case 4: {
                this.dimension = op1.getDimension() - op2.getDimension();
                break;
            }
            default: {
                this.dimension = op1.getDimension();
            }
        }
    }

    public RelativeNumericProperty(int operation, Numeric op) {
        this.operation = operation;
        this.op1 = op;
        this.dimension = op.getDimension();
    }

    private Numeric getResolved() throws PropertyException {
        switch (this.operation) {
            case 1: {
                return NumericOp.addition2(this.op1, this.op2);
            }
            case 2: {
                return NumericOp.subtraction2(this.op1, this.op2);
            }
            case 3: {
                return NumericOp.multiply2(this.op1, this.op2);
            }
            case 4: {
                return NumericOp.divide2(this.op1, this.op2);
            }
            case 5: {
                return NumericOp.modulo2(this.op1, this.op2);
            }
            case 6: {
                return NumericOp.negate2(this.op1);
            }
            case 7: {
                return NumericOp.abs2(this.op1);
            }
            case 8: {
                return NumericOp.max2(this.op1, this.op2);
            }
            case 9: {
                return NumericOp.min2(this.op1, this.op2);
            }
        }
        throw new PropertyException("Unknown expr operation " + this.operation);
    }

    public double getNumericValue() throws PropertyException {
        return this.getResolved().getNumericValue();
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isAbsolute() {
        return false;
    }

    public Length getLength() {
        if (this.dimension == 1) {
            return this;
        }
        log.error("Can't create length with dimension " + this.dimension);
        return null;
    }

    public Numeric getNumeric() {
        return this;
    }

    public int getValue() {
        try {
            return (int)this.getNumericValue();
        }
        catch (PropertyException exc) {
            log.error(exc);
            return 0;
        }
    }

    public String toString() {
        switch (this.operation) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return "(" + this.op1 + " " + operations.charAt(this.operation) + this.op2 + ")";
            }
            case 6: {
                return "-" + this.op1;
            }
            case 8: {
                return "max(" + this.op1 + ", " + this.op2 + ")";
            }
            case 9: {
                return "min(" + this.op1 + ", " + this.op2 + ")";
            }
            case 7: {
                return "abs(" + this.op1 + ")";
            }
        }
        return "unknown operation " + this.operation;
    }
}

