/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.xml.sax.Locator;

public class Footnote
extends FObj {
    private CommonAccessibility commonAccessibility;
    private Inline footnoteCitation = null;
    private FootnoteBody footnoteBody;

    public Footnote(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startFootnote(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        if (this.footnoteCitation == null || this.footnoteBody == null) {
            this.missingChildElementError("(inline,footnote-body)");
        }
        this.getFOEventHandler().endFootnote(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("inline")) {
            if (this.footnoteCitation != null) {
                this.tooManyNodesError(loc, "fo:inline");
            }
        } else if (FO_URI.equals(nsURI) && localName.equals("footnote-body")) {
            if (this.footnoteCitation == null) {
                this.nodesOutOfOrderError(loc, "fo:inline", "fo:footnote-body");
            } else if (this.footnoteBody != null) {
                this.tooManyNodesError(loc, "fo:footnote-body");
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public void addChildNode(FONode child) {
        if (((FObj)child).getNameId() == 15) {
            this.footnoteCitation = (Inline)child;
        } else if (((FObj)child).getNameId() == 13) {
            this.footnoteBody = (FootnoteBody)child;
        }
    }

    public Inline getFootnoteCitation() {
        return this.footnoteCitation;
    }

    public FootnoteBody getFootnoteBody() {
        return this.footnoteBody;
    }

    public String getName() {
        return "fo:footnote";
    }

    public int getNameId() {
        return 12;
    }
}

