/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class InlineContainer
extends FObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private int displayAlign;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lineHeight;
    private int overflow;
    private Numeric referenceOrientation;
    private Length width;
    private int writingMode;
    private boolean blockItemFound = false;

    public InlineContainer(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.displayAlign = pList.get(81).getEnum();
        this.dominantBaseline = pList.get(82).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lineHeight = pList.get(131).getLength();
        this.overflow = pList.get(153).getEnum();
        this.referenceOrientation = pList.get(179).getNumeric();
        this.width = pList.get(241).getLength();
        this.writingMode = pList.get(244).getEnum();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("marker")) {
            if (this.blockItemFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "(%block;)");
            }
        } else if (!this.isBlockItem(nsURI, localName)) {
            this.invalidChildError(loc, nsURI, localName);
        } else {
            this.blockItemFound = true;
        }
    }

    protected void endOfNode() throws FOPException {
        if (!this.blockItemFound) {
            this.missingChildElementError("marker* (%block;)+");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return "fo:inline-container";
    }

    public int getNameId() {
        return 16;
    }
}

