/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.awt.geom.Rectangle2D;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.Viewport;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;

public class ExternalGraphicLayoutManager
extends LeafNodeLayoutManager {
    private ExternalGraphic fobj;
    private int breakAfter;
    private int breakBefore;
    private int align;
    private int startIndent;
    private int endIndent;
    private int spaceBefore;
    private int spaceAfter;
    private int viewWidth = -1;
    private int viewHeight = -1;
    private boolean clip = false;
    private Rectangle2D placement = null;

    public ExternalGraphicLayoutManager(ExternalGraphic node) {
        super(node);
        this.fobj = node;
        this.setup();
        InlineArea area = this.getExternalGraphicInlineArea();
        this.setCurrentArea(area);
        this.setAlignment(this.fobj.getVerticalAlign());
        this.setLead(this.viewHeight);
    }

    private void setup() {
        int scaling;
        Length cw;
        Length ipd = this.fobj.getInlineProgressionDimension().getOptimum().getLength();
        if (ipd.getEnum() != 9) {
            this.viewWidth = ipd.getValue();
        } else {
            ipd = this.fobj.getWidth();
            if (ipd.getEnum() != 9) {
                this.viewWidth = ipd.getValue();
            }
        }
        Length bpd = this.fobj.getBlockProgressionDimension().getOptimum().getLength();
        if (bpd.getEnum() != 9) {
            this.viewHeight = bpd.getValue();
        } else {
            bpd = this.fobj.getHeight();
            if (bpd.getEnum() != 9) {
                this.viewHeight = bpd.getValue();
            }
        }
        int cwidth = -1;
        int cheight = -1;
        Length ch = this.fobj.getContentHeight();
        if (ch.getEnum() != 9) {
            if (ch.getEnum() == 125) {
                if (this.viewHeight != -1) {
                    cheight = this.viewHeight;
                }
            } else {
                cheight = ch.getValue();
            }
        }
        if ((cw = this.fobj.getContentWidth()).getEnum() != 9) {
            if (cw.getEnum() == 125) {
                if (this.viewWidth != -1) {
                    cwidth = this.viewWidth;
                }
            } else {
                cwidth = cw.getValue();
            }
        }
        if ((scaling = this.fobj.getScaling()) == 154 || cwidth == -1 || cheight == -1) {
            if (cwidth == -1 && cheight == -1) {
                cwidth = this.fobj.getIntrinsicWidth();
                cheight = this.fobj.getIntrinsicHeight();
            } else if (cwidth == -1) {
                cwidth = (int)((double)this.fobj.getIntrinsicWidth() * (double)cheight / (double)this.fobj.getIntrinsicHeight());
            } else if (cheight == -1) {
                cheight = (int)((double)this.fobj.getIntrinsicHeight() * (double)cwidth / (double)this.fobj.getIntrinsicWidth());
            } else {
                double rat2;
                double rat1 = (double)cwidth / (double)this.fobj.getIntrinsicWidth();
                if (rat1 < (rat2 = (double)cheight / (double)this.fobj.getIntrinsicHeight())) {
                    cheight = (int)(rat1 * (double)this.fobj.getIntrinsicHeight());
                } else if (rat1 > rat2) {
                    cwidth = (int)(rat2 * (double)this.fobj.getIntrinsicWidth());
                }
            }
        }
        if (this.viewWidth == -1) {
            this.viewWidth = cwidth;
        }
        if (this.viewHeight == -1) {
            this.viewHeight = cheight;
        }
        if (cwidth > this.viewWidth || cheight > this.viewHeight) {
            int overflow = this.fobj.getOverflow();
            if (overflow == 57) {
                this.clip = true;
            } else if (overflow == 42) {
                this.fobj.getLogger().error("Image: " + this.fobj.getURL() + " overflows the viewport, clipping to viewport");
                this.clip = true;
            }
        }
        int xoffset = 0;
        int yoffset = 0;
        switch (this.fobj.getDisplayAlign()) {
            case 13: {
                break;
            }
            case 3: {
                yoffset = this.viewHeight - cheight;
                break;
            }
            case 23: {
                yoffset = (this.viewHeight - cheight) / 2;
                break;
            }
        }
        switch (this.fobj.getTextAlign()) {
            case 23: {
                xoffset = (this.viewWidth - cwidth) / 2;
                break;
            }
            case 39: {
                xoffset = this.viewWidth - cwidth;
                break;
            }
            case 135: {
                break;
            }
        }
        CommonBorderPaddingBackground borderProps = this.fobj.getCommonBorderPaddingBackground();
        int beforeBPD = borderProps.getPadding(0, false);
        int afterBPD = borderProps.getPadding(1, false);
        yoffset += (beforeBPD += borderProps.getBorderWidth(0, false));
        this.viewHeight += beforeBPD;
        this.viewHeight += (afterBPD += borderProps.getBorderWidth(1, false));
        int startIPD = borderProps.getPadding(2, false);
        int endIPD = borderProps.getPadding(3, false);
        this.viewWidth += startIPD;
        this.viewWidth += (endIPD += borderProps.getBorderWidth(3, false));
        this.placement = new Rectangle2D.Float(xoffset += (startIPD += borderProps.getBorderWidth(2, false)), yoffset, cwidth, cheight);
    }

    public InlineArea getExternalGraphicInlineArea() {
        Image imArea = new Image(this.fobj.getSrc());
        TraitSetter.setProducerID(imArea, this.fobj.getId());
        Viewport vp = new Viewport(imArea);
        TraitSetter.setProducerID(vp, this.fobj.getId());
        vp.setIPD(this.viewWidth);
        vp.setBPD(this.viewHeight);
        vp.setClip(this.clip);
        vp.setContentPosition(this.placement);
        vp.setOffset(0);
        TraitSetter.addBorders(vp, this.fobj.getCommonBorderPaddingBackground());
        TraitSetter.addBackground(vp, this.fobj.getCommonBorderPaddingBackground());
        return vp;
    }

    protected void addId() {
        this.getPSLM().addIDToPage(this.fobj.getId());
    }
}

