/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.mif.MIFElement;
import org.apache.fop.render.mif.MIFFile;
import org.xml.sax.SAXException;

public class MIFHandler
extends FOEventHandler {
    protected MIFFile mifFile;
    protected OutputStream outStream;
    private MIFElement textFlow;
    private MIFElement para;

    public MIFHandler(FOUserAgent ua, OutputStream os) {
        super(ua);
        this.outStream = os;
        FontSetup.setup(this.fontInfo, null);
    }

    public void startDocument() throws SAXException {
        this.mifFile = new MIFFile();
        try {
            this.mifFile.output(this.outStream);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        this.mifFile.finish(true);
        try {
            this.mifFile.output(this.outStream);
            this.outStream.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq) {
        String name = pageSeq.getMasterReference();
        SimplePageMaster spm = pageSeq.getRoot().getLayoutMasterSet().getSimplePageMaster(name);
        if (spm == null) {
            PageSequenceMaster psm = pageSeq.getRoot().getLayoutMasterSet().getPageSequenceMaster(name);
        } else {
            MIFElement prop = new MIFElement("PageType");
            prop.setValue("BodyPage");
            MIFElement page = new MIFElement("Page");
            page.addElement(prop);
            prop = new MIFElement("PageBackground");
            prop.setValue("'Default'");
            page.addElement(prop);
            MIFElement textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("1");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 0.0");
            textRect.addElement(prop);
            page.addElement(textRect);
            textRect = new MIFElement("TextRect");
            prop = new MIFElement("ID");
            prop.setValue("2");
            textRect.addElement(prop);
            prop = new MIFElement("ShapeRect");
            prop.setValue("0.0 841.889 453.543 187.65");
            textRect.addElement(prop);
            page.addElement(textRect);
            this.mifFile.addPage(page);
        }
    }

    public void endPageSequence(PageSequence pageSeq) {
    }

    public void startFlow(Flow fl) {
        this.textFlow = new MIFElement("TextFlow");
    }

    public void endFlow(Flow fl) {
        this.textFlow.finish(true);
        this.mifFile.addElement(this.textFlow);
        this.textFlow = null;
    }

    public void startBlock(Block bl) {
        this.para = new MIFElement("Para");
        this.textFlow.addElement(this.para);
    }

    public void endBlock(Block bl) {
        this.para.finish(true);
        this.para = null;
    }

    public void startInline(Inline inl) {
    }

    public void endInline(Inline inl) {
    }

    public void startTable(Table tbl) {
    }

    public void endTable(Table tbl) {
    }

    public void startColumn(TableColumn tc) {
    }

    public void endColumn(TableColumn tc) {
    }

    public void startHeader(TableBody th) {
    }

    public void endHeader(TableBody th) {
    }

    public void startFooter(TableBody tf) {
    }

    public void endFooter(TableBody tf) {
    }

    public void startBody(TableBody tb) {
    }

    public void endBody(TableBody tb) {
    }

    public void startRow(TableRow tr) {
    }

    public void endRow(TableRow tr) {
    }

    public void startCell(TableCell tc) {
    }

    public void endCell(TableCell tc) {
    }

    public void startList(ListBlock lb) {
    }

    public void endList(ListBlock lb) {
    }

    public void startListItem(ListItem li) {
    }

    public void endListItem(ListItem li) {
    }

    public void startListLabel() {
    }

    public void endListLabel() {
    }

    public void startListBody() {
    }

    public void endListBody() {
    }

    public void startStatic() {
    }

    public void endStatic() {
    }

    public void startMarkup() {
    }

    public void endMarkup() {
    }

    public void startLink(BasicLink basicLink) {
    }

    public void endLink() {
    }

    public void image(ExternalGraphic eg) {
    }

    public void pageRef() {
    }

    public void foreignObject(InstreamForeignObject ifo) {
    }

    public void startFootnote(Footnote footnote) {
    }

    public void endFootnote(Footnote footnote) {
    }

    public void startFootnoteBody(FootnoteBody body) {
    }

    public void endFootnoteBody(FootnoteBody body) {
    }

    public void leader(Leader l) {
    }

    public void characters(char[] data, int start, int length) {
        if (this.para != null) {
            String str = new String(data, start, length);
            if ((str = str.trim()).length() == 0) {
                return;
            }
            MIFElement line = new MIFElement("ParaLine");
            MIFElement prop = new MIFElement("TextRectID");
            prop.setValue("2");
            line.addElement(prop);
            prop = new MIFElement("String");
            prop.setValue("\"" + str + "\"");
            line.addElement(prop);
            this.para.addElement(line);
        }
    }

    public void startPageNumber(PageNumber pagenum) {
    }

    public void endPageNumber(PageNumber pagenum) {
    }
}

