/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.Serializable;

public class JGoPen
implements Serializable {
    public static final int NONE = 0;
    public static final int SOLID = 65535;
    public static final int DASHED = 1;
    public static final int DOTTED = 2;
    public static final int DASHDOT = 3;
    public static final int DASHDOTDOT = 4;
    public static final int CUSTOM = 65534;
    public static final JGoPen black = new JGoPen(65535, 1, Color.black);
    public static final JGoPen darkGray = new JGoPen(65535, 1, Color.darkGray);
    public static final JGoPen gray = new JGoPen(65535, 1, Color.gray);
    public static final JGoPen lightGray = new JGoPen(65535, 1, Color.lightGray);
    public static final JGoPen white = new JGoPen(65535, 1, Color.white);
    public static final JGoPen Null = new JGoPen(0, 1, Color.black);
    private int myStyle;
    private int myWidth;
    private Color myColor;
    private transient Stroke \u0126 = null;

    public JGoPen() {
        this.myStyle = 65535;
        this.myWidth = 1;
        this.myColor = Color.black;
        this.\u0126 = null;
    }

    public JGoPen(int n, int n2, Color color) {
        this.myStyle = n;
        this.myWidth = n == 0 ? 0 : Math.max(n2, 1);
        this.myColor = color;
        this.\u0126 = null;
    }

    public JGoPen(Stroke stroke, Color color) {
        this.myStyle = 65534;
        this.myWidth = stroke != null && stroke instanceof BasicStroke ? (int)((BasicStroke)stroke).getLineWidth() : 1;
        this.myColor = color;
        this.\u0126 = stroke;
    }

    public static JGoPen makeStockPen(Color color) {
        if (color.equals(Color.black)) {
            return black;
        }
        if (color.equals(Color.darkGray)) {
            return darkGray;
        }
        if (color.equals(Color.gray)) {
            return gray;
        }
        if (color.equals(Color.lightGray)) {
            return lightGray;
        }
        if (color.equals(Color.white)) {
            return white;
        }
        return new JGoPen(65535, 1, color);
    }

    public static JGoPen make(int n, int n2, Color color) {
        if (n == 0) {
            return Null;
        }
        if (n == 65535 && n2 == 1) {
            return JGoPen.makeStockPen(color);
        }
        return new JGoPen(n, n2, color);
    }

    public int getStyle() {
        return this.myStyle;
    }

    public int getWidth() {
        return this.myWidth;
    }

    public Color getColor() {
        return this.myColor;
    }

    public Stroke getStroke() {
        if (this.\u0126 == null) {
            switch (this.getStyle()) {
                default: {
                    this.\u0126 = null;
                    break;
                }
                case 65535: {
                    int n = this.getWidth();
                    this.\u0126 = new BasicStroke(n, 0, 0, 2 * n);
                    break;
                }
                case 1: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f};
                    this.\u0126 = new BasicStroke(f, 0, 0, 2.0f * f, fArray, 0.0f);
                    break;
                }
                case 2: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{f, f};
                    this.\u0126 = new BasicStroke(f, 0, 0, 2.0f * f, fArray, 0.0f);
                    break;
                }
                case 3: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f, f, f};
                    this.\u0126 = new BasicStroke(f, 0, 0, 2.0f * f, fArray, 0.0f);
                    break;
                }
                case 4: {
                    float f = this.getWidth();
                    float[] fArray = new float[]{3.0f * f, f, f, f, f, f};
                    this.\u0126 = new BasicStroke(f, 0, 0, 2.0f * f, fArray, 0.0f);
                }
            }
        }
        return this.\u0126;
    }
}

