/*
 * Decompiled with CFR 0.152.
 */
package org.castor.cache.distributed;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.cache.CacheAcquireException;
import org.castor.cache.distributed.AbstractDistributedCache;

public final class GigaspacesCache
extends AbstractDistributedCache {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$castor$cache$distributed$GigaspacesCache == null ? (class$org$castor$cache$distributed$GigaspacesCache = GigaspacesCache.class$("org.castor.cache.distributed.GigaspacesCache")) : class$org$castor$cache$distributed$GigaspacesCache));
    public static final String TYPE = "gigaspaces";
    public static final String IMPLEMENTATION = "com.j_spaces.map.CacheFinder";
    private static final Class[] TYPES_FIND_CACHE = new Class[]{class$java$lang$String == null ? (class$java$lang$String = GigaspacesCache.class$("java.lang.String")) : class$java$lang$String};
    private static final String DEFAULT_CACHE_URL = "/./";
    private static final String DEFAULT_CACHE_PROPERTIES = "";
    static /* synthetic */ Class class$org$castor$cache$distributed$GigaspacesCache;
    static /* synthetic */ Class class$java$lang$String;

    public void initialize(Properties params) throws CacheAcquireException {
        this.initialize(IMPLEMENTATION, params);
    }

    public void initialize(String implementation, Properties params) throws CacheAcquireException {
        super.initialize(params);
        String cacheURL = params.getProperty("cacheURL", DEFAULT_CACHE_URL);
        String cacheProperties = params.getProperty("cacheProperties", DEFAULT_CACHE_PROPERTIES);
        StringBuffer clusterURL = new StringBuffer();
        clusterURL.append(cacheURL);
        clusterURL.append(this.getName());
        clusterURL.append("?");
        clusterURL.append(cacheProperties);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)clusterURL.toString());
        }
        try {
            ClassLoader ldr = this.getClass().getClassLoader();
            Class<?> cls = ldr.loadClass(implementation);
            this.setCache((Map)this.invokeStaticMethod(cls, "find", TYPES_FIND_CACHE, new Object[]{clusterURL.toString()}));
        }
        catch (Exception e) {
            LOG.error((Object)"Problem!", (Throwable)e);
            String msg = "Error creating Gigaspaces cache: " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
            throw new CacheAcquireException(msg, e);
        }
    }

    public String getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

