/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.InsBasicChartPanel;
import com.insightful.miner.MinerApp;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.NumberAxis;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class ChartPropertiesDialog
extends JDialog
implements ActionListener {
    public static String OK_ACTION_COMMAND = "ok";
    public static String CANCEL_ACTION_COMMAND = "cancel";
    public static String RESET_ACTION_COMMAND = "reset";
    public static String HELP_ACTION_COMMAND = "help";
    private JTextField maxValField = new JTextField();
    private JTextField minValField = new JTextField();
    private JCheckBox showTickMarkCheckBox = new JCheckBox();
    private JCheckBox showTickLabelCheckBox = new JCheckBox();
    private JCheckBox showGridLinesCheckBox = new JCheckBox();
    private JTextField verticalLabelField = new JTextField();
    private JTextField horizontalLabelField = new JTextField();
    private InsBasicChartPanel panel = null;
    private String originalMaxVal = "";
    private String originalMinVal = "";
    private NumberAxis axis = null;

    public ChartPropertiesDialog(Frame parent, InsBasicChartPanel p) {
        super(parent, "Chart Properties");
        this.panel = p;
        if (this.panel == null) {
            return;
        }
        this.axis = this.panel.getRangeAxis();
        try {
            this.jbInit();
            this.setSize(350, 400);
            this.setLocationRelativeTo(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JPanel createRangePanel() {
        JLabel minValLabel = new JLabel("Minimum Value");
        JLabel maxValLabel = new JLabel("Maximum Value");
        JButton resetButton = new JButton("Reset");
        minValLabel.setDisplayedMnemonic(77);
        minValLabel.setLabelFor(this.minValField);
        maxValLabel.setDisplayedMnemonic(88);
        maxValLabel.setLabelFor(this.maxValField);
        resetButton.setMnemonic(82);
        resetButton.setActionCommand(RESET_ACTION_COMMAND);
        resetButton.addActionListener(this);
        if (this.axis != null) {
            this.originalMaxVal = MinerApp.formatDouble(this.axis.getMaximumAxisValue());
        }
        this.maxValField.setText(this.originalMaxVal);
        if (this.axis != null) {
            this.originalMinVal = MinerApp.formatDouble(this.axis.getMinimumAxisValue());
        }
        this.minValField.setText(this.originalMinVal);
        JPanel rangePanel = new JPanel(new GridBagLayout());
        rangePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Range"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipadx = 5;
        gbc.weightx = 0.0;
        rangePanel.add((Component)minValLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        rangePanel.add((Component)this.minValField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        rangePanel.add((Component)maxValLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        rangePanel.add((Component)this.maxValField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 0;
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalGlue());
        p.add(resetButton);
        rangePanel.add((Component)p, gbc);
        return rangePanel;
    }

    private JPanel createTickPanel() {
        this.showTickMarkCheckBox.setText("Show Tick Marks");
        this.showTickLabelCheckBox.setText("Show Tick Labels");
        this.showTickMarkCheckBox.setMnemonic(75);
        this.showTickLabelCheckBox.setMnemonic(76);
        if (this.axis != null) {
            this.showTickMarkCheckBox.setSelected(this.axis.isTickMarksVisible());
        }
        if (this.axis != null) {
            this.showTickLabelCheckBox.setSelected(this.axis.isTickLabelsVisible());
        }
        JPanel tickPanel = new JPanel(new GridBagLayout());
        tickPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Tick Marks"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        tickPanel.add((Component)this.showTickMarkCheckBox, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        tickPanel.add((Component)this.showTickLabelCheckBox, gbc);
        return tickPanel;
    }

    private JPanel createGridPanel() {
        this.showGridLinesCheckBox.setText("Show Grid Lines");
        this.showGridLinesCheckBox.setMnemonic(71);
        if (this.axis != null) {
            this.showGridLinesCheckBox.setSelected(this.axis.isGridLinesVisible());
        }
        JPanel gridPanel = new JPanel(new GridBagLayout());
        gridPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Grid Lines"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gridPanel.add((Component)this.showGridLinesCheckBox, gbc);
        return gridPanel;
    }

    private JPanel createLabelPanel() {
        JLabel verticalLabel = new JLabel("Vertical Axis Label");
        JLabel horizontalLabel = new JLabel("Horizontal Axis Label");
        verticalLabel.setDisplayedMnemonic(86);
        verticalLabel.setLabelFor(this.verticalLabelField);
        horizontalLabel.setDisplayedMnemonic(90);
        horizontalLabel.setLabelFor(this.horizontalLabelField);
        if (this.axis != null) {
            this.verticalLabelField.setText(((Axis)this.panel.getChart().getPlot().getVerticalAxis()).getLabel());
        }
        if (this.axis != null) {
            this.horizontalLabelField.setText(((Axis)this.panel.getChart().getPlot().getHorizontalAxis()).getLabel());
        }
        JPanel labelPanel = new JPanel(new GridBagLayout());
        labelPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Labels"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.gridx = 0;
        gbc.ipadx = 5;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        labelPanel.add((Component)verticalLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        labelPanel.add((Component)this.verticalLabelField, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        labelPanel.add((Component)horizontalLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        labelPanel.add((Component)this.horizontalLabelField, gbc);
        return labelPanel;
    }

    private JPanel createButtonPanel() {
        JButton cancelButton = new JButton("Cancel");
        Dimension dim = cancelButton.getPreferredSize();
        cancelButton.setActionCommand(CANCEL_ACTION_COMMAND);
        cancelButton.addActionListener(this);
        cancelButton.setMnemonic(67);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand(OK_ACTION_COMMAND);
        okButton.addActionListener(this);
        okButton.setMnemonic(79);
        okButton.setPreferredSize(dim);
        JButton helpButton = new JButton("Help");
        helpButton.setActionCommand(HELP_ACTION_COMMAND);
        helpButton.addActionListener(this);
        helpButton.setMnemonic(72);
        helpButton.setPreferredSize(dim);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChartPropertiesDialog.this.setVisible(false);
            }
        };
        cancelButton.registerKeyboardAction(al, KeyStroke.getKeyStroke("ESCAPE"), 2);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(helpButton);
        return buttonPanel;
    }

    private void jbInit() throws Exception {
        JPanel rangePanel = this.createRangePanel();
        JPanel tickPanel = this.createTickPanel();
        JPanel gridPanel = this.createGridPanel();
        JPanel labelPanel = this.createLabelPanel();
        JPanel buttonPanel = this.createButtonPanel();
        JPanel backgroundPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridy = 0;
        gbc.gridx = 0;
        backgroundPanel.add((Component)rangePanel, gbc);
        ++gbc.gridy;
        backgroundPanel.add((Component)tickPanel, gbc);
        ++gbc.gridy;
        backgroundPanel.add((Component)gridPanel, gbc);
        ++gbc.gridy;
        backgroundPanel.add((Component)labelPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(10, 0, 0, 0);
        backgroundPanel.add((Component)buttonPanel, gbc);
        this.getContentPane().add((Component)backgroundPanel, "Center");
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(RESET_ACTION_COMMAND)) {
            if (!Double.isNaN(this.panel.getMaxVal()) && !Double.isNaN(this.panel.getMinVal())) {
                this.maxValField.setText(Double.toString(this.panel.getMaxVal()));
                this.minValField.setText(Double.toString(this.panel.getMinVal()));
            }
        } else if (command.equals(OK_ACTION_COMMAND)) {
            if (this.axis != null) {
                String strippedMin = this.stripCommas(this.minValField.getText());
                String strippedMax = this.stripCommas(this.maxValField.getText());
                double max = Double.NaN;
                double min = Double.NaN;
                try {
                    max = Double.parseDouble(strippedMax);
                }
                catch (NumberFormatException e) {
                    AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("ChartPropertiesDialog_message_maxValidNumber"), MinerApp.getText("ChartPropertiesDialog_message_maxBadNumber"), 0);
                    return;
                }
                try {
                    min = Double.parseDouble(strippedMin);
                }
                catch (NumberFormatException e) {
                    AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("ChartPropertiesDialog_message_minValidNumber"), MinerApp.getText("ChartPropertiesDialog_message_minBadNumber"), 0);
                    return;
                }
                if (max <= min) {
                    AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("ChartPropertiesDialog_message_minSmallThanMax"), MinerApp.getText("ChartPropertiesDialog_message_minSmallThanMaxBad"), 0);
                    return;
                }
                this.axis.setMaximumAxisValue(max);
                this.axis.setMinimumAxisValue(min);
                this.axis.setGridLinesVisible(this.showGridLinesCheckBox.isSelected());
                this.axis.setTickMarksVisible(this.showTickMarkCheckBox.isSelected());
                this.axis.setTickLabelsVisible(this.showTickLabelCheckBox.isSelected());
                ((Axis)this.panel.getChart().getPlot().getHorizontalAxis()).setLabel(this.horizontalLabelField.getText());
                ((Axis)this.panel.getChart().getPlot().getVerticalAxis()).setLabel(this.verticalLabelField.getText());
            }
            this.setVisible(false);
        } else if (command.equals(CANCEL_ACTION_COMMAND)) {
            this.setVisible(false);
        } else if (command.equals(HELP_ACTION_COMMAND)) {
            MinerApp.getHelpManager().showTopic("Chart_Properties");
        }
    }

    private String stripCommas(String s) {
        char comma = MinerApp.getWorksheetPropertiesManager().getThousandsSeparator();
        while (s.indexOf(comma) >= 0) {
            s = s.substring(0, s.indexOf(comma)) + s.substring(s.indexOf(comma) + 1, s.length());
        }
        return s;
    }
}

