/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeLinked;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.CollapsedLink;
import com.insightful.miner.CommentUtilities;
import com.insightful.miner.GridDataSource;
import com.insightful.miner.HelpManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.MinerTextNode;
import com.insightful.miner.NodeViewer;
import com.insightful.miner.PredictorLink;
import com.insightful.miner.PredictorPort;
import com.insightful.miner.StateVisualCueImage;
import com.insightful.miner.Viewable;
import com.insightful.miner.WinHelpManagerImpl;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.nwoods.jgo.JGoArea;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoSelection;
import com.nwoods.jgo.JGoView;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CollapsedNodeArea
extends BaseNodeArea
implements Viewable,
ChangeListener {
    protected Vector nodes = new Vector();
    protected Vector textNodes = new Vector();
    protected Vector links = new Vector();
    protected Vector modelLinks = new Vector();
    protected String helpFile = null;
    protected String smallIcon = null;
    protected String largeIcon = null;
    protected HashMap portInfo = new HashMap();
    protected Point centerpoint = new Point(10, 10);
    private static final String CROSSHAIRS_IMAGE_NAME = "crosshairs.gif";
    private JGoImage myCrosshairsImage = null;
    static final String SMALL_ICON_NAME = "collapsed_node_small.gif";
    static final String LARGE_ICON_NAME = "collapsed_node_large.gif";
    static final String HELP_TOPIC = "Collection";
    public static final String EXPANDING_COLLAPSED_NODE_UNDO_TAG = "Expanding Collapsed Nodes";
    public static final String EXPANDING_ALL_COLLAPSED_NODE_UNDO_TAG = "Expanding All Collapsed Nodes";
    public static final String CREATING_COLLAPSED_NODE_UNDO_TAG = "Creating Collapsed Nodes";
    private int m_id = -1;
    private XMLTree m_comments = null;
    private Vector m_containers = new Vector();

    public CollapsedNodeArea() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat df = new SimpleDateFormat("MMMMMMMMM dd, yyyy");
            this.setComments(CommentUtilities.createNewComments(document, MinerApp.getUserName(), df.format(now)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initialize() {
        super.initialize(HELP_TOPIC, LARGE_ICON_NAME, 0, 0);
        this.myCrosshairsImage = new JGoImage(DEFAULT_POINT, DEFAULT_SIZE);
        this.myCrosshairsImage.loadImage(MinerApp.getResourceManager().getImage(CROSSHAIRS_IMAGE_NAME), false);
        if (this.myCrosshairsImage != null) {
            this.myCrosshairsImage.setSelectable(false);
            this.myCrosshairsImage.setSize(8, 8);
            this.addObjectAtTail((JGoObject)this.myCrosshairsImage);
        }
        if (this.largeIcon != null) {
            this.loadIconImage(this.largeIcon, false);
        }
        this.layoutChildren();
    }

    public void setLinksOrthogonal(boolean b) {
        BaseLink bl;
        int i;
        for (i = 0; i < this.links.size(); ++i) {
            bl = (BaseLink)((Object)this.links.get(i));
            bl.setOrthogonal(b);
        }
        for (i = 0; i < this.modelLinks.size(); ++i) {
            bl = (JGoLink)this.modelLinks.get(i);
            bl.setOrthogonal(b);
        }
    }

    public void toggleLinksOrthogonal() {
        BaseLink bl;
        int i;
        for (i = 0; i < this.links.size(); ++i) {
            bl.setOrthogonal(!(bl = (BaseLink)((Object)this.links.get(i))).isOrthogonal());
        }
        for (i = 0; i < this.modelLinks.size(); ++i) {
            bl.setOrthogonal(!(bl = (JGoLink)this.modelLinks.get(i)).isOrthogonal());
        }
    }

    public boolean doMouseDblClick(int modifiers, Point dc, Point vc, JGoView view) {
        JGoObject obj = view.pickDocObject(dc, false);
        if (obj == this.getCrosshairs()) {
            ((WorksheetView)view).expandCollapsedNodes();
            return true;
        }
        ActivityNodeState state = this.getMinimumState();
        boolean showViewerOnDblClick = MinerApp.getGlobalOptions().getBoolean("dblClickShowViewer", false);
        if (state instanceof ActivityNodeComputed && showViewerOnDblClick) {
            this.showDataViewer(0);
        } else {
            ((WorksheetView)view).editCollapsed(this);
        }
        return true;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof ActivityNodeState) {
            this.addStateVisualCue();
            this.fireStateChangedEvent();
        }
    }

    void addChangeListener(ChangeListener listener) {
        if (!this.m_containers.contains(listener)) {
            this.m_containers.add(listener);
        }
    }

    boolean removeChangeListener(ChangeListener listener) {
        return this.m_containers.remove(listener);
    }

    void fireStateChangedEvent() {
        for (int i = 0; i < this.m_containers.size(); ++i) {
            ChangeListener listener = (ChangeListener)this.m_containers.elementAt(i);
            if (listener == null) continue;
            listener.stateChanged(new ChangeEvent(this.getMinimumState()));
        }
    }

    protected void createPorts(int numPorts, boolean input) {
        super.createPorts(numPorts, input);
    }

    public Iterator getPortInfoKeys() {
        return this.portInfo.keySet().iterator();
    }

    public XTNetwork.PortInfo getPortInfo(Object key) {
        XTNetwork.PortInfo info = (XTNetwork.PortInfo)this.portInfo.get(key);
        CollapsedNodeArea area = this.findContainerOfNodeByID(Integer.parseInt(info.nodeID));
        if (area == null || area == this) {
            return info;
        }
        return area.getPortInfo(key);
    }

    public String getPortToolTipText(BaseNodePort port) {
        XTNetwork.PortInfo info = (XTNetwork.PortInfo)this.portInfo.get((Object)port);
        if (info != null) {
            return info.toolTip;
        }
        return null;
    }

    public boolean getPortInfoVisibility(Object key) {
        XTNetwork.PortInfo info = (XTNetwork.PortInfo)this.portInfo.get(key);
        if (info != null) {
            return info.visible;
        }
        return false;
    }

    public void setPortInfoVisibleFeatures(Object key, boolean visible, String toolTip) {
        XTNetwork.PortInfo info = (XTNetwork.PortInfo)this.portInfo.get(key);
        if (info == null) {
            return;
        }
        info.visible = visible;
        info.toolTip = toolTip;
    }

    public void addCollapsedPort(BaseNodePort port, boolean input, boolean visible, String nodeID, String toolTip, int portNum) {
        XTNetwork.PortInfo pi = new XTNetwork.PortInfo();
        pi.nodeID = nodeID;
        pi.visible = visible;
        pi.input = input;
        pi.portNum = portNum;
        pi.toolTip = toolTip;
        BaseNodePort key = port instanceof CollapsedNodePort ? ((CollapsedNodePort)port).getRepresentedPort() : port;
        this.portInfo.put(key, pi);
    }

    protected boolean isPortVisible(JGoPort port) {
        BaseNodePort key;
        XTNetwork.PortInfo info;
        if (port instanceof CollapsedNodePort && (info = (XTNetwork.PortInfo)this.portInfo.get((Object)(key = ((CollapsedNodePort)port).getRepresentedPort()))) != null) {
            return info.visible;
        }
        return true;
    }

    public JMenu getPropertiesMenu(String title) {
        String label = title == null ? this.getText().replaceAll("\n", "") : title;
        JMenu menu = new JMenu(label);
        if (title != null) {
            menu.setIcon(MinerApp.getResourceManager().getIcon("plain_gray.gif"));
            menu.setHorizontalTextPosition(11);
            menu.setHorizontalAlignment(10);
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object node = this.nodes.get(i);
            if (node instanceof ActivityNodeArea) {
                JMenuItem mi = new JMenuItem(new PropertiesAction((ActivityNodeArea)node));
                menu.add(mi);
                continue;
            }
            if (!(node instanceof CollapsedNodeArea)) continue;
            JMenu subMenu = ((CollapsedNodeArea)node).getPropertiesMenu(null);
            menu.add(subMenu);
        }
        return menu;
    }

    public boolean isChild(ActivityNodeModel test) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object obj = this.nodes.get(i);
            if (!(obj instanceof CollapsedNodeArea ? ((CollapsedNodeArea)obj).isChild(test) : obj instanceof ActivityNodeArea && ((ActivityNodeArea)obj).getNodeModel().isChild(test))) continue;
            return true;
        }
        return false;
    }

    public void getContainedNodes(Vector cNodes) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            Object obj = this.nodes.get(i);
            if (obj instanceof CollapsedNodeArea) {
                ((CollapsedNodeArea)obj).getContainedNodes(cNodes);
                continue;
            }
            if (!(obj instanceof ActivityNodeArea)) continue;
            cNodes.add(obj);
        }
    }

    public String getToolTipText() {
        return this.getText().replaceAll("\n", "");
    }

    public void showDataViewer(int initialPortSelected) {
        MinerFrame frame = MinerApp.getMainFrame();
        Component comp = MinerApp.getMainFrame().getGlassPane();
        Cursor oldCursor = comp.getCursor();
        comp.setCursor(Cursor.getPredefinedCursor(3));
        comp.setVisible(true);
        try {
            NodeViewer nv = null;
            if (this.getNumOutputs() > 0) {
                nv = new NodeViewer(this.getText().replaceAll("\n", ""), this.getID(), this, this.getMetaDataArray(false), false, initialPortSelected);
                nv.show();
            } else if (this.getNumInputs() > 0) {
                nv = new NodeViewer(this.getText().replaceAll("\n", ""), this.getID(), this, this.getMetaDataArray(true), true, initialPortSelected);
                nv.show();
            } else {
                AcceleratorOptionPane.showOKDialog(frame, MinerApp.getText("CollapsedNodeArea_message_noOutputs"), MinerApp.getText("CollapsedNodeArea_message_noDataViewer"), 2);
            }
        }
        catch (Exception e) {
            String msg = MinerApp.getText("CollapsedNodeArea_message_errorViewing") + " " + this.getText().replaceAll("\n", "") + ":\n\n" + e.toString() + "\n";
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("CollapsedNodeArea_message_dataViewerError"), 0);
            e.printStackTrace();
        }
        catch (OutOfMemoryError err) {
            String msg = MinerApp.getText("CollapsedNodeArea_message_outofMemory") + " " + this.getText().replaceAll("\n", "") + ".";
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("CollapsedNodeArea_message_memoryError"), 0);
            err.printStackTrace();
        }
        comp.setCursor(oldCursor);
        comp.setVisible(false);
    }

    public XTMetaData[] getMetaDataArray(boolean input) {
        XTMetaData[] metaDataArray = null;
        try {
            Vector ports = input ? this.getInputPorts() : this.getOutputPorts();
            int numPorts = input ? this.getNumInputs() : this.getNumOutputs();
            int curIndex = 0;
            metaDataArray = new XTMetaData[numPorts];
            for (int i = 0; i < ports.size(); ++i) {
                BaseNodePort port = ((CollapsedNodePort)((Object)ports.get(i))).getRepresentedPort();
                XTNetwork.PortInfo pi = this.getPortInfo((Object)port);
                if (!this.isPortViewable(input, pi, port)) continue;
                metaDataArray[curIndex++] = this.getMetaData(input, i);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaDataArray;
    }

    public WorksheetDocument getWorksheetDocument() {
        return (WorksheetDocument)super.getDocument();
    }

    public int getNumInputs() {
        return this.countVisiblePorts(true);
    }

    public int getNumInputLinks() {
        return this.getNumInputs();
    }

    public int getNumOutputs() {
        return this.countVisiblePorts(false);
    }

    public String getPortToolTip(boolean isInput, int portIndex) {
        Object[] port_info_model_area = new Object[4];
        this.getPortInfoModelArea(isInput, portIndex, port_info_model_area);
        XTNetwork.PortInfo pi = (XTNetwork.PortInfo)port_info_model_area[1];
        if (pi.toolTip != null) {
            return pi.toolTip;
        }
        BaseNodePort port = (BaseNodePort)((Object)port_info_model_area[0]);
        return port.getToolTipText();
    }

    public GridDataSource getDataSource(int portIndex, boolean isInput) {
        Object[] port_info_model_area = new Object[4];
        this.getPortInfoModelArea(isInput, portIndex, port_info_model_area);
        XTNetwork.PortInfo pi = (XTNetwork.PortInfo)port_info_model_area[1];
        ActivityNodeModel model = (ActivityNodeModel)port_info_model_area[2];
        return model.getDataSource(pi.portNum, isInput);
    }

    public XTMetaData getInputMetaData(int input) throws Exception {
        return this.getMetaData(true, input);
    }

    public XTMetaData getOutputMetaData(int input) throws Exception {
        return this.getMetaData(false, input);
    }

    public ActivityNodeModel getAParentModel(int portNum) {
        Object[] port_info_model_area = new Object[4];
        this.getPortInfoModelArea(true, portNum, port_info_model_area);
        XTNetwork.PortInfo pi = (XTNetwork.PortInfo)port_info_model_area[1];
        ActivityNodeModel model = (ActivityNodeModel)port_info_model_area[2];
        return model.getAParentModel(pi.portNum);
    }

    private boolean isPortViewable(boolean isInput, XTNetwork.PortInfo pInfo, BaseNodePort port) {
        return pInfo.visible && (!isInput || port.isSingle());
    }

    private void getPortInfoModelArea(boolean isInput, int portIndex, Object[] portInfoAndModel) {
        Vector ports = isInput ? this.getInputPorts() : this.getOutputPorts();
        BaseNodePort port = ((CollapsedNodePort)((Object)ports.get(portIndex))).getRepresentedPort();
        portInfoAndModel[0] = port;
        portInfoAndModel[1] = this.getPortInfo((Object)port);
        ActivityNodeArea area = (ActivityNodeArea)port.getNode();
        portInfoAndModel[2] = area.getNodeModel();
        portInfoAndModel[3] = area;
    }

    private int countVisiblePorts(boolean input) {
        Vector ports = input ? this.getInputPorts() : this.getOutputPorts();
        int count = 0;
        for (int i = 0; i < ports.size(); ++i) {
            BaseNodePort port = ((CollapsedNodePort)((Object)ports.get(i))).getRepresentedPort();
            XTNetwork.PortInfo pi = this.getPortInfo((Object)port);
            if (!this.isPortViewable(input, pi, port)) continue;
            ++count;
        }
        return count;
    }

    private XTMetaData getMetaData(boolean isInput, int portIndex) throws Exception {
        Object[] port_info_model_area = new Object[4];
        this.getPortInfoModelArea(isInput, portIndex, port_info_model_area);
        XTNetwork.PortInfo pi = (XTNetwork.PortInfo)port_info_model_area[1];
        ActivityNodeModel model = (ActivityNodeModel)port_info_model_area[2];
        if (isInput) {
            return model.getInputMetaData(pi.portNum);
        }
        return model.getOutputMetaData(pi.portNum);
    }

    public String getNodeID(boolean isInput, int portIndex) {
        Object[] port_info_model_area = new Object[4];
        this.getPortInfoModelArea(isInput, portIndex, port_info_model_area);
        ActivityNodeModel model = (ActivityNodeModel)port_info_model_area[2];
        return Integer.toString(model.getID());
    }

    public boolean isComputed() {
        Vector ports = this.getInputPorts();
        int iPorts = ports.size();
        for (int i = 0; i < iPorts; ++i) {
            ActivityNodeArea area;
            BaseNodePort port = ((CollapsedNodePort)((Object)ports.get(i))).getRepresentedPort();
            XTNetwork.PortInfo pi = this.getPortInfo((Object)port);
            if (!this.isPortViewable(true, pi, port) || (area = (ActivityNodeArea)port.getNode()).getNodeModel().isComputed()) continue;
            return false;
        }
        ports = this.getOutputPorts();
        int oPorts = ports.size();
        for (int i = 0; i < oPorts; ++i) {
            ActivityNodeArea area;
            BaseNodePort port = ((CollapsedNodePort)((Object)ports.get(i))).getRepresentedPort();
            XTNetwork.PortInfo pi = this.getPortInfo((Object)port);
            if (!this.isPortViewable(false, pi, port) || (area = (ActivityNodeArea)port.getNode()).getNodeModel().isComputed()) continue;
            return false;
        }
        return iPorts != 0 || oPorts != 0;
    }

    public Element getComments() {
        if (this.m_comments == null) {
            return null;
        }
        return this.m_comments.getXML();
    }

    public void setComments(Element elt) {
        try {
            this.m_comments = new XMLTree(elt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    ActivityNodeState getMinimumState() {
        ActivityNodeState minState = ActivityNodeComputed.instance();
        for (int i = 0; i < this.nodes.size(); ++i) {
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            ActivityNodeState testState = null;
            testState = area instanceof CollapsedNodeArea ? ((CollapsedNodeArea)area).getMinimumState() : ((ActivityNodeArea)area).getNodeModel().getState();
            if (testState == null || testState.isPresentStateAtLeastAsAdvancedAsTestState(minState)) continue;
            minState = testState;
        }
        return minState;
    }

    protected StateVisualCueImage getStateIcon() {
        return this.getMinimumState().getStateVisualCue();
    }

    public void layoutChildren() {
        super.layoutChildren();
        if (this.myCrosshairsImage != null) {
            if (this.getIcon() != null) {
                this.myCrosshairsImage.setSpotLocation(6, this.getIcon(), 1);
            } else {
                this.myCrosshairsImage.setSpotLocation(1, (JGoObject)this, 1);
            }
        }
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        CollapsedNodeArea newobj = (CollapsedNodeArea)super.copyObject(env);
        if (newobj == null) {
            return null;
        }
        newobj.layoutChildren();
        newobj.setLocation(this.getLocation());
        return newobj;
    }

    public void copyChildren(JGoArea newarea, JGoCopyEnvironment env) {
        BaseLink newLink;
        JGoObject origLink;
        JGoArea copy;
        JGoArea orig;
        int i;
        CollapsedNodeArea newobj = (CollapsedNodeArea)newarea;
        newobj.nodes.removeAllElements();
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            orig = (BaseNodeArea)this.nodes.get(i);
            copy = (BaseNodeArea)orig.copyObject(env);
            newobj.nodes.add(copy);
            if (copy instanceof ActivityNodeArea) {
                ((ActivityNodeArea)copy).getNodeModel().addChangeListener(newobj);
                continue;
            }
            if (!(copy instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)copy).addChangeListener(newobj);
        }
        newobj.textNodes.removeAllElements();
        for (i = this.textNodes.size() - 1; i >= 0; --i) {
            orig = (MinerTextNode)this.textNodes.get(i);
            copy = (MinerTextNode)orig.copyObject(env);
            newobj.textNodes.add(copy);
        }
        newobj.links.removeAllElements();
        for (i = this.links.size() - 1; i >= 0; --i) {
            origLink = (JGoObject)this.links.get(i);
            newLink = (BaseLink)origLink.copyObject(env);
            newobj.links.add(newLink);
        }
        newobj.modelLinks.removeAllElements();
        for (i = this.modelLinks.size() - 1; i >= 0; --i) {
            origLink = (JGoObject)this.modelLinks.get(i);
            newLink = (JGoLink)origLink.copyObject(env);
            newobj.modelLinks.add(newLink);
        }
        newobj.centerpoint = (Point)env.get((Object)this.centerpoint);
        for (BaseNodePort key : this.portInfo.keySet()) {
            XTNetwork.PortInfo pi = (XTNetwork.PortInfo)this.portInfo.get((Object)key);
            BaseNodePort copyKey = (BaseNodePort)((Object)env.get((Object)key));
            XTNetwork.PortInfo copyPI = pi.copy();
            copyPI.toolTip = null;
            newobj.portInfo.put(copyKey, copyPI);
        }
        if (this.getDoc() != null) {
            newobj.hiddenExpandForState(this.getDoc());
        }
        newobj.helpFile = this.helpFile;
        newobj.largeIcon = this.largeIcon;
        newobj.smallIcon = this.smallIcon;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element newComments = (Element)document.importNode(this.getComments().cloneNode(true), true);
            newobj.setComments(newComments);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.myCrosshairsImage != null) {
            newobj.myCrosshairsImage = (JGoImage)this.myCrosshairsImage.copyObject(env);
            if (newobj.myCrosshairsImage.getImage() == null) {
                newobj.removeObject((JGoObject)newobj.myCrosshairsImage);
                newobj.myCrosshairsImage = new JGoImage(DEFAULT_POINT, DEFAULT_SIZE);
                newobj.myCrosshairsImage.loadImage(MinerApp.getResourceManager().getImage(CROSSHAIRS_IMAGE_NAME), false);
                if (newobj.myCrosshairsImage != null) {
                    newobj.myCrosshairsImage.setSelectable(false);
                    newobj.myCrosshairsImage.setSize(8, 8);
                }
            }
            newobj.addObjectAtTail((JGoObject)newobj.myCrosshairsImage);
        }
        super.copyChildren(newarea, env);
    }

    public void hiddenExpandForState(WorksheetDocument dummy) {
        int i;
        if (dummy.isDummyEngineConnection()) {
            return;
        }
        Vector<JGoObject> storeLinks = new Vector<JGoObject>();
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            area.setVisible(false);
            dummy.addObjectAtHead((JGoObject)area);
        }
        for (i = this.links.size() - 1; i >= 0; --i) {
            JGoObject link = (JGoObject)this.links.get(i);
            link.setVisible(false);
            storeLinks.add(link);
            this.links.remove(i);
            dummy.addObjectAtTail(link);
        }
        boolean isCollapsing = dummy.isCollapsing();
        dummy.setCollapseTransaction(true);
        for (i = 0; i < storeLinks.size(); ++i) {
            JGoObject link = (JGoObject)storeLinks.get(i);
            dummy.removeObject(link);
            this.links.add(link);
            link.setVisible(true);
        }
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            dummy.removeObject((JGoObject)area);
            area.setVisible(true);
        }
        dummy.setCollapseTransaction(isCollapsing);
        dummy.setEngineNetworkDirty();
    }

    public void setDocument(WorksheetDocument doc) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            if (area instanceof ActivityNodeArea) {
                ((ActivityNodeArea)area).getNodeModel().setDocument(doc);
                continue;
            }
            if (!(area instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)area).setDocument(doc);
        }
    }

    public void adjustContainedNodesLocation(Point offset) {
        JGoArea area;
        int i;
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            area = (BaseNodeArea)this.nodes.get(i);
            area.setTopLeft(area.getLeft() + offset.x, area.getTop() + offset.y);
            if (!(area instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)area).adjustContainedNodesLocation(offset);
        }
        for (i = this.textNodes.size() - 1; i >= 0; --i) {
            area = (MinerTextNode)this.textNodes.get(i);
            area.setTopLeft(area.getLeft() + offset.x, area.getTop() + offset.y);
        }
    }

    protected void ownerChange(Object oldOwner, Object newOwner) {
        WorksheetDocument doc;
        if (oldOwner == null && newOwner != null && newOwner instanceof WorksheetDocument) {
            doc = (WorksheetDocument)((Object)newOwner);
            if (this.getID() == -1) {
                int id = doc.getNextNodeID();
                if (id != -1) {
                    this.setID(id);
                }
                this.setDocument((WorksheetDocument)((Object)newOwner));
                if (!doc.isCollapsing()) {
                    doc.setEngineNetworkDirty();
                }
            }
            this.addStateVisualCue();
        } else if (oldOwner != null && newOwner == null && !(doc = (WorksheetDocument)((Object)oldOwner)).isCollapsing()) {
            doc.setEngineNetworkDirty();
        }
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNodeArea bna = (BaseNodeArea)this.nodes.get(i);
            bna.forceOwnershipChange(oldOwner, newOwner);
            for (int j = 0; j < 2; ++j) {
                Vector ports = j == 0 ? bna.getInputPorts() : bna.getOutputPorts();
                for (int k = 0; k < ports.size(); ++k) {
                    BaseNodePort port = (BaseNodePort)((Object)ports.get(k));
                    XTNetwork.PortInfo PI = (XTNetwork.PortInfo)this.portInfo.get((Object)port);
                    if (PI == null) continue;
                    PI.nodeID = Integer.toString(bna.getID());
                }
            }
        }
    }

    public boolean containsNode(int id) {
        if (this.getID() == id) {
            return true;
        }
        int nodesLength = this.nodes.size();
        for (int i = 0; i < nodesLength; ++i) {
            BaseNodeArea node = (BaseNodeArea)this.nodes.get(i);
            if (!(node instanceof ActivityNodeArea ? ((ActivityNodeArea)node).getID() == id : node instanceof CollapsedNodeArea && ((CollapsedNodeArea)node).containsNode(id))) continue;
            return true;
        }
        return false;
    }

    public void collectNodes(JGoSelection selection, Vector inputPorts, Vector outputPorts) {
        BaseNodeArea node = null;
        BaseNodePort port = null;
        JGoObject nodeOrLink = null;
        JGoListPosition pos = null;
        pos = selection.getFirstObjectPos();
        while (pos != null) {
            nodeOrLink = selection.getObjectAtPos(pos);
            if (nodeOrLink instanceof BaseNodeArea) {
                int i;
                node = (BaseNodeArea)nodeOrLink;
                this.addNode(node);
                if (node instanceof ActivityNodeArea) {
                    ((ActivityNodeArea)node).getNodeModel().addChangeListener(this);
                } else if (node instanceof CollapsedNodeArea) {
                    ((CollapsedNodeArea)node).addChangeListener(this);
                }
                Vector ports = node.getInputPorts();
                block1: for (i = 0; i < ports.size(); ++i) {
                    port = (BaseNodePort)((Object)ports.get(i));
                    if (port.isCurrentlyLinkable()) {
                        this.addCollapsedPort(port, true, true, Integer.toString(node.getID()), null, i);
                        inputPorts.add(port);
                        continue;
                    }
                    JGoListPosition linkPos = port.getFirstLinkPos();
                    while (linkPos != null) {
                        JGoLink link = port.getLinkAtPos(linkPos);
                        JGoArea area = link.getFromPort().getParent();
                        if (!selection.isInSelection((JGoObject)area)) {
                            this.addCollapsedPort(port, true, true, Integer.toString(node.getID()), null, i);
                            inputPorts.add(port);
                            continue block1;
                        }
                        linkPos = port.getNextLinkPos(linkPos);
                    }
                }
                ports = node.getOutputPorts();
                for (i = 0; i < ports.size(); ++i) {
                    port = (BaseNodePort)((Object)ports.get(i));
                    this.addCollapsedPort(port, false, true, Integer.toString(node.getID()), null, i);
                    outputPorts.add(port);
                }
            } else if (nodeOrLink instanceof MinerTextNode) {
                this.textNodes.add(nodeOrLink);
            } else if (nodeOrLink instanceof BaseLink) {
                if (this.filterLink((JGoLink)nodeOrLink, selection)) {
                    this.addInternalLink((JGoLink)nodeOrLink);
                }
            } else if (nodeOrLink instanceof PredictorLink && this.filterLink((JGoLink)nodeOrLink, selection)) {
                this.addPredictorLink((PredictorLink)nodeOrLink);
            }
            pos = selection.getNextObjectPos(pos);
        }
        this.correctPortVisibility(true, inputPorts);
        this.layoutPorts(true);
        this.correctPortVisibility(false, outputPorts);
        this.layoutPorts(false);
        this.setCenterPointAndSize();
    }

    private void correctPortVisibility(boolean input, Vector origPortList) {
        for (int i = 0; i < origPortList.size(); ++i) {
            BaseNodePort bPort = (BaseNodePort)((Object)origPortList.get(i));
            JGoListPosition lPos = bPort.getFirstLinkPos();
            BaseNodePort key = bPort instanceof CollapsedNodePort ? ((CollapsedNodePort)bPort).getRepresentedPort() : bPort;
            XTNetwork.PortInfo cPortInfo = (XTNetwork.PortInfo)this.portInfo.get((Object)key);
            if (this.isPortEverInvisible((Object)key)) {
                cPortInfo.visible = false;
                continue;
            }
            if (lPos == null) continue;
            boolean externalLinkPresent = false;
            while (lPos != null) {
                BaseNodePort inspectPort = (BaseNodePort)(input ? bPort.getLinkAtPos(lPos).getFromPort() : bPort.getLinkAtPos(lPos).getToPort());
                BaseNodeArea fArea = (BaseNodeArea)inspectPort.getParent();
                lPos = bPort.getNextLinkPos(lPos);
                if (this.nodes.contains(fArea)) continue;
                externalLinkPresent = true;
                break;
            }
            if (externalLinkPresent) continue;
            cPortInfo.visible = false;
        }
    }

    public boolean isPortEverInvisible(Object key) {
        XTNetwork.PortInfo info = (XTNetwork.PortInfo)this.portInfo.get(key);
        if (!info.visible) {
            return true;
        }
        CollapsedNodeArea area = this.findContainerOfNodeByID(Integer.parseInt(info.nodeID));
        if (area == null || area == this) {
            return false;
        }
        return area.isPortEverInvisible(key);
    }

    public void createPorts(Vector inputPorts, Vector outputPorts) {
        Vector actualInputPorts = this.getInputPorts();
        actualInputPorts.removeAllElements();
        for (int i = 0; i < inputPorts.size(); ++i) {
            actualInputPorts.add(new CollapsedNodePort((BaseNodePort)((Object)inputPorts.get(i)), this));
        }
        Vector actualOutputPorts = this.getOutputPorts();
        actualOutputPorts.removeAllElements();
        for (int i = 0; i < outputPorts.size(); ++i) {
            actualOutputPorts.add(new CollapsedNodePort((BaseNodePort)((Object)outputPorts.get(i)), this));
        }
        this.layoutChildren();
    }

    public void collectCollapsedLinks(JGoSelection selection, Vector collapsedLinkList, boolean input) {
        BaseNodeArea node = null;
        JGoPort port = null;
        JGoObject nodeOrLink = null;
        JGoListPosition pos = null;
        pos = selection.getFirstObjectPos();
        while (pos != null) {
            nodeOrLink = selection.getObjectAtPos(pos);
            if (nodeOrLink instanceof BaseNodeArea) {
                node = (BaseNodeArea)nodeOrLink;
                Vector ports = null;
                ports = input ? node.getInputPorts() : node.getOutputPorts();
                if (ports != null) {
                    for (int i = ports.size() - 1; i >= 0; --i) {
                        port = (JGoPort)ports.elementAt(i);
                        this.getCollapsedLinksForThisPort(port, selection, collapsedLinkList, input);
                    }
                }
            }
            pos = selection.getNextObjectPos(pos);
        }
    }

    public void collectModelLinks(JGoSelection selection, boolean input) {
        ActivityNodeArea node = null;
        JGoObject nodeOrLink = null;
        JGoListPosition pos = null;
        pos = selection.getFirstObjectPos();
        while (pos != null) {
            nodeOrLink = selection.getObjectAtPos(pos);
            if (nodeOrLink instanceof ActivityNodeArea) {
                node = (ActivityNodeArea)nodeOrLink;
                PredictorPort port = null;
                port = input ? node.getModelLinkInputPort() : node.getModelLinkOutputPort();
                if (port != null) {
                    this.getModelLinksForThisPort(port, selection, input);
                }
            }
            pos = selection.getNextObjectPos(pos);
        }
    }

    public void includeLinksInSelection(WorksheetDocument doc, JGoSelection selection) {
        BaseLink link = null;
        JGoObject nodeOrLink = null;
        JGoListPosition pos = null;
        pos = doc.getFirstObjectPos();
        while (pos != null) {
            nodeOrLink = doc.getObjectAtPos(pos);
            if (nodeOrLink instanceof BaseLink) {
                link = (BaseLink)nodeOrLink;
                if (selection.isInSelection((JGoObject)link)) {
                    pos = doc.getNextObjectPos(pos);
                    continue;
                }
                if (selection.isInSelection((JGoObject)link.getFromNode()) && selection.isInSelection((JGoObject)link.getToNode())) {
                    selection.extendSelection((JGoObject)link);
                }
            }
            pos = doc.getNextObjectPos(pos);
        }
    }

    private void getCollapsedLinksForThisPort(JGoPort port, JGoSelection selection, Vector collapsedLinkList, boolean input) {
        JGoListPosition linkpos = null;
        BaseNodeArea fromArea = null;
        BaseNodeArea toArea = null;
        CollapsedLink clink = null;
        BaseNodePort fromPort = null;
        BaseNodePort toPort = null;
        JGoLink link = null;
        linkpos = port.getFirstLinkPos();
        while (linkpos != null) {
            BaseNodePort compare;
            CollapsedNodePort cPort;
            int i;
            link = port.getLinkAtPos(linkpos);
            fromPort = (BaseNodePort)link.getFromPort();
            toPort = (BaseNodePort)link.getToPort();
            fromArea = (BaseNodeArea)fromPort.getParent();
            toArea = (BaseNodeArea)toPort.getParent();
            if (selection.isInSelection((JGoObject)fromArea) && selection.isInSelection((JGoObject)toArea)) {
                linkpos = port.getNextLinkPos(linkpos);
                continue;
            }
            BaseNodePort fPort = fromPort;
            BaseNodePort tPort = toPort;
            if (input) {
                Vector iPorts = this.getInputPorts();
                for (i = 0; i < iPorts.size(); ++i) {
                    cPort = (CollapsedNodePort)((Object)iPorts.get(i));
                    BaseNodePort baseNodePort = compare = tPort instanceof CollapsedNodePort ? ((CollapsedNodePort)tPort).getRepresentedPort() : tPort;
                    if (cPort.getRepresentedPort() != compare) continue;
                    tPort = cPort;
                    break;
                }
            } else {
                Vector oPorts = this.getOutputPorts();
                for (i = 0; i < oPorts.size(); ++i) {
                    cPort = (CollapsedNodePort)((Object)oPorts.get(i));
                    BaseNodePort baseNodePort = compare = fPort instanceof CollapsedNodePort ? ((CollapsedNodePort)fPort).getRepresentedPort() : fPort;
                    if (cPort.getRepresentedPort() != compare) continue;
                    fPort = cPort;
                    break;
                }
            }
            clink = new CollapsedLink(fPort, tPort);
            if (fromPort instanceof CollapsedNodePort) {
                fromPort = ((CollapsedNodePort)fromPort).getRepresentedPort();
            }
            if (toPort instanceof CollapsedNodePort) {
                toPort = ((CollapsedNodePort)toPort).getRepresentedPort();
            }
            clink.addRepresentedLink(fromPort, toPort, link.isOrthogonal());
            collapsedLinkList.add(clink);
            linkpos = port.getNextLinkPos(linkpos);
        }
    }

    private void getModelLinksForThisPort(JGoPort port, JGoSelection selection, boolean input) {
        JGoListPosition linkpos = port.getFirstLinkPos();
        while (linkpos != null) {
            JGoLink link = port.getLinkAtPos(linkpos);
            if (!this.modelLinks.contains(link)) {
                this.modelLinks.add(link);
            }
            linkpos = port.getNextLinkPos(linkpos);
        }
    }

    public boolean filterLink(JGoLink link, JGoSelection selection) {
        boolean answer = true;
        JGoPort fromPort = link.getFromPort();
        JGoPort toPort = link.getToPort();
        if (!selection.isInSelection((JGoObject)fromPort.getParent())) {
            answer = false;
        }
        if (!selection.isInSelection((JGoObject)toPort.getParent())) {
            answer = false;
        }
        if (!selection.isInSelection((JGoObject)fromPort.getParent()) && !selection.isInSelection((JGoObject)toPort.getParent())) {
            answer = true;
        }
        return answer;
    }

    public void setCenterPointAndSize() {
        double numTextNodes;
        double numNodes = this.getNumberNodes();
        double totalNumNodes = numNodes + (numTextNodes = this.textNodes != null ? (double)this.textNodes.size() : 0.0);
        if (totalNumNodes == 0.0) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        Point p = null;
        int i = 0;
        while ((double)i < numNodes) {
            p = this.getNodeAt(i).getLocation();
            if (i == 0) {
                minx = x = (double)p.x;
                maxx = x;
                miny = y = (double)p.y;
                maxy = y;
            } else {
                x += (double)p.x;
                y += (double)p.y;
                if ((double)p.x > maxx) {
                    maxx = p.x;
                }
                if ((double)p.x < minx) {
                    minx = p.x;
                }
                if ((double)p.y > maxy) {
                    maxy = p.y;
                }
                if ((double)p.y < miny) {
                    miny = p.y;
                }
            }
            ++i;
        }
        i = 0;
        while ((double)i < numTextNodes) {
            p = ((MinerTextNode)this.textNodes.get(i)).getLocation();
            if (i == 0) {
                minx = x = (double)p.x;
                maxx = x;
                miny = y = (double)p.y;
                maxy = y;
            } else {
                x += (double)p.x;
                y += (double)p.y;
                if ((double)p.x > maxx) {
                    maxx = p.x;
                }
                if ((double)p.x < minx) {
                    minx = p.x;
                }
                if ((double)p.y > maxy) {
                    maxy = p.y;
                }
                if ((double)p.y < miny) {
                    miny = p.y;
                }
            }
            ++i;
        }
        this.centerpoint = new Point((int)(x /= totalNumNodes), (int)(y /= totalNumNodes));
    }

    public JGoSelection expand(WorksheetDocument doc) {
        int i;
        JGoSelection selection = new JGoSelection();
        Vector<BaseLink> collapsedLinkList = new Vector<BaseLink>();
        boolean needCollapsedLink = false;
        CollapsedLink collLink = null;
        boolean shouldBeAdded = true;
        BaseNodeArea fromNode = null;
        BaseNodeArea toNode = null;
        JGoListPosition pos = null;
        BaseLink newLink = null;
        JGoObject object = null;
        JGoPort fromPort = null;
        JGoPort toPort = null;
        JGoLink link = null;
        HashMap<BaseNodePort, CollapsedNodePort> portMap = new HashMap<BaseNodePort, CollapsedNodePort>();
        for (i = this.getNumberNodes() - 1; i >= 0; --i) {
            CollapsedNodePort cPort;
            int p;
            toNode = this.getNodeAt(i);
            doc.addObjectAtTail((JGoObject)toNode);
            toNode.setTopLeft(toNode.getLocation());
            selection.extendSelection((JGoObject)toNode);
            if (toNode instanceof ActivityNodeArea) {
                ActivityNodeModel model = ((ActivityNodeArea)toNode).getNodeModel();
                model.setDocument(doc);
                model.getNodeInfo().container = null;
                model.removeChangeListener(this);
                continue;
            }
            if (!(toNode instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)toNode).layoutPorts(true);
            Vector cPorts = ((CollapsedNodeArea)toNode).getInputPorts();
            for (p = 0; p < cPorts.size(); ++p) {
                cPort = (CollapsedNodePort)((Object)cPorts.get(p));
                portMap.put(cPort.getRepresentedPort(), cPort);
            }
            ((CollapsedNodeArea)toNode).layoutPorts(false);
            cPorts = ((CollapsedNodeArea)toNode).getOutputPorts();
            for (p = 0; p < cPorts.size(); ++p) {
                cPort = (CollapsedNodePort)((Object)cPorts.get(p));
                portMap.put(cPort.getRepresentedPort(), cPort);
            }
        }
        for (i = this.textNodes.size() - 1; i >= 0; --i) {
            MinerTextNode mtn = (MinerTextNode)this.textNodes.get(i);
            doc.addObjectAtTail((JGoObject)mtn);
            mtn.container = null;
            mtn.setTopLeft(mtn.getLocation());
            selection.extendSelection((JGoObject)mtn);
        }
        for (i = this.getNumberInternalLinks() - 1; i >= 0; --i) {
            link = this.getInternalLinkAt(i);
            if (link instanceof CollapsedLink) {
                collLink = new CollapsedLink(((CollapsedLink)link).getFromPort(), ((CollapsedLink)link).getToPort());
                collLink.addRepresentedLink((CollapsedLink)link);
                newLink = doc.newCollapsedLink(collLink);
            } else {
                newLink = doc.newLink(link.getFromPort(), link.getToPort(), true);
            }
            newLink.setOrthogonal(link.isOrthogonal());
            selection.extendSelection((JGoObject)newLink);
        }
        pos = doc.getFirstObjectPos();
        while (pos != null) {
            object = doc.getObjectAtPos(pos);
            if (object instanceof CollapsedLink) {
                collLink = (CollapsedLink)object;
                fromNode = collLink.getFromNode();
                toNode = collLink.getToNode();
                if (toNode == this || fromNode == this) {
                    for (i = collLink.getNumLinksRepresented() - 1; i >= 0; --i) {
                        needCollapsedLink = false;
                        if (fromNode == this) {
                            fromPort = collLink.getOriginalFromPortAt(i);
                            fromNode = collLink.getOriginalFromNodeAt(i);
                            toPort = collLink.getToPort();
                            needCollapsedLink = toNode instanceof CollapsedNodeArea;
                        } else if (toNode == this) {
                            toPort = collLink.getOriginalToPortAt(i);
                            toNode = collLink.getOriginalToNodeAt(i);
                            fromPort = collLink.getFromPort();
                            needCollapsedLink = fromNode instanceof CollapsedNodeArea;
                        }
                        if (portMap.get(fromPort) != null) {
                            fromPort = (CollapsedNodePort)((Object)portMap.get(fromPort));
                            needCollapsedLink = true;
                        }
                        if (portMap.get(toPort) != null) {
                            toPort = (CollapsedNodePort)((Object)portMap.get(toPort));
                            needCollapsedLink = true;
                        }
                        if (needCollapsedLink) {
                            newLink = new CollapsedLink(fromPort, toPort);
                            ((CollapsedLink)newLink).addRepresentedLink(collLink.getOriginalFromPortAt(i), collLink.getOriginalToPortAt(i), collLink.getOrthogonalAt(i));
                            shouldBeAdded = true;
                            collapsedLinkList.add(newLink);
                        } else {
                            newLink = doc.newLink(fromPort, toPort, true);
                            selection.extendSelection((JGoObject)newLink);
                        }
                        newLink.setOrthogonal(collLink.getOrthogonalAt(i));
                    }
                }
            }
            pos = doc.getNextObjectPos(pos);
        }
        for (i = collapsedLinkList.size() - 1; i >= 0; --i) {
            newLink = doc.newCollapsedLink((CollapsedLink)((Object)collapsedLinkList.get(i)));
            selection.extendSelection((JGoObject)newLink);
        }
        for (i = this.modelLinks.size() - 1; i >= 0; --i) {
            PredictorLink p1 = (PredictorLink)((Object)this.modelLinks.get(i));
            PredictorLink p2 = PredictorLink.newPredictionLink(p1.getFromNode().getID(), p1.getToNode().getID(), doc);
            p2.setOrthogonal(p1.isOrthogonal());
        }
        return selection;
    }

    public CollapsedNodeArea findContainerOfNodeByID(int containedNodeID) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            CollapsedNodeArea node;
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            if (!(area instanceof CollapsedNodeArea) || !(node = (CollapsedNodeArea)area).containsNode(containedNodeID)) continue;
            return node;
        }
        return null;
    }

    public ActivityNodeArea findNodeByID(int nodeID) {
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNodeArea area = (BaseNodeArea)this.nodes.get(i);
            if (area instanceof CollapsedNodeArea) {
                CollapsedNodeArea node = (CollapsedNodeArea)area;
                ActivityNodeArea ana = node.findNodeByID(nodeID);
                if (ana == null) continue;
                return ana;
            }
            if (area.getID() != nodeID) continue;
            return (ActivityNodeArea)area;
        }
        return null;
    }

    public XTNetwork.CollapsedNodeInfo createCollapsedNodeInfo(XTNetwork net) throws Exception {
        Serializable contained;
        Object obj;
        XTNetwork.PortInfo pInfo;
        CollapsedNodePort port;
        int i;
        int i2;
        XTNetwork.CollapsedNodeInfo info = new XTNetwork.CollapsedNodeInfo();
        info.nodeID = Integer.toString(this.m_id);
        info.labelText = this.toString().replaceAll("\n", "");
        info.comments = new XTNetwork.XMLInfo(new XMLTree(this.getComments()));
        Point point = this.getTopLeft();
        info.x = point.x;
        info.y = point.y;
        info.helpFile = this.helpFile;
        info.smallIcon = this.smallIcon;
        info.largeIcon = this.largeIcon;
        for (i2 = 0; i2 < this.nodes.size(); ++i2) {
            Serializable contained2;
            Object obj2 = this.nodes.get(i2);
            if (obj2 instanceof ActivityNodeArea) {
                contained2 = ((ActivityNodeArea)obj2).getNodeInfo();
                contained2.container = info.nodeID;
                info.nodes.add(contained2.nodeID);
                net.addFlatNode((XTNetwork.NodeInfo)contained2);
                continue;
            }
            if (!(obj2 instanceof CollapsedNodeArea)) continue;
            contained2 = ((CollapsedNodeArea)obj2).createCollapsedNodeInfo(net);
            ((XTNetwork.CollapsedNodeInfo)contained2).container = info.nodeID;
            info.nodes.add(((XTNetwork.CollapsedNodeInfo)contained2).nodeID);
            net.addCollapsedNode((XTNetwork.CollapsedNodeInfo)contained2);
        }
        for (i2 = 0; i2 < this.textNodes.size(); ++i2) {
            MinerTextNode mtn = (MinerTextNode)this.textNodes.get(i2);
            info.textNodes.add(mtn.createTextNodeInfo());
        }
        Vector ports = this.getInputPorts();
        for (i = 0; i < ports.size(); ++i) {
            port = (CollapsedNodePort)((Object)ports.get(i));
            pInfo = (XTNetwork.PortInfo)this.portInfo.get((Object)port.getRepresentedPort());
            info.inputPorts.add(pInfo);
        }
        ports = this.getOutputPorts();
        for (i = 0; i < ports.size(); ++i) {
            port = (CollapsedNodePort)((Object)ports.get(i));
            pInfo = (XTNetwork.PortInfo)this.portInfo.get((Object)port.getRepresentedPort());
            info.outputPorts.add(pInfo);
        }
        for (i = 0; i < this.links.size(); ++i) {
            obj = this.links.get(i);
            if (obj instanceof CollapsedLink) {
                contained = ((CollapsedLink)((Object)obj)).createExternalLinkInfo(net);
                contained.container = info.nodeID;
                info.links.add(contained);
                net.addExternalLink((XTNetwork.ExternalLinkInfo)contained);
                continue;
            }
            if (!(obj instanceof BaseLink)) continue;
            contained = ((BaseLink)((Object)obj)).createLinkInfo(net);
            ((XTNetwork.LinkInfo)contained).container = info.nodeID;
            info.links.add(contained);
            net.addFlatLink((XTNetwork.LinkInfo)contained);
        }
        for (i = 0; i < this.modelLinks.size(); ++i) {
            obj = this.modelLinks.get(i);
            if (!(obj instanceof PredictorLink)) continue;
            contained = ((PredictorLink)((Object)obj)).createLinkInfo(net);
            ((XTNetwork.ModelLinkInfo)contained).container = info.nodeID;
            info.links.add(contained);
            net.addModelLink((XTNetwork.ModelLinkInfo)contained);
        }
        return info;
    }

    public static CollapsedNodeArea buildCollapsedNodeFromInfo(XTNetwork network, WorksheetDocument doc, XTNetwork.CollapsedNodeInfo info, CollapsedNodeArea cnode, HashMap lazyModelLinkCreation) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        XTNetwork.NodeInfo obj;
        int i;
        if (info == null) {
            return null;
        }
        CollapsedNodeArea cn = new CollapsedNodeArea();
        cn.initialize();
        int cnid = Integer.parseInt(info.nodeID);
        cn.setID(cnid);
        String text = info.labelText;
        if (text != null) {
            cn.setText(text);
        }
        cn.setCenterPoint(new Point(info.x, info.y));
        cn.setTopLeft(info.x, info.y);
        if (info.helpFile != null) {
            cn.helpFile = info.helpFile;
        }
        if (info.largeIcon != null) {
            cn.largeIcon = info.largeIcon;
            cn.loadIconImage(cn.largeIcon, false);
        }
        if (info.smallIcon != null) {
            cn.smallIcon = info.smallIcon;
        }
        if (info.comments != null) {
            cn.setComments(info.comments.tree.getXML());
        }
        doc.addObjectAtTail((JGoObject)cn);
        if (cnode != null) {
            cnode.addNode(cn);
            WorksheetDocument.storeForRemoval((JGoObject)cn);
        }
        for (i = 0; i < info.nodes.size(); ++i) {
            String nodeID = (String)info.nodes.get(i);
            obj = network.getNodeInfo(nodeID);
            if (obj == null) {
                XTNetwork.CollapsedNodeInfo cObj = network.getCollapsedNodeInfo(nodeID);
                if (info == null) continue;
                CollapsedNodeArea containedCNA = CollapsedNodeArea.buildCollapsedNodeFromInfo(network, doc, cObj, cn, lazyModelLinkCreation);
                containedCNA.addChangeListener(cn);
                continue;
            }
            ActivityNodeArea act = ActivityNodeArea.buildActivityNodeFromInfo(obj);
            if (act == null) continue;
            doc.addObjectAtTail((JGoObject)act);
            cn.addNode(act);
            WorksheetDocument.storeForRemoval((JGoObject)act);
            act.getNodeModel().addChangeListener(cn);
            act.getNodeModel().setDocument(doc);
        }
        for (i = 0; i < info.textNodes.size(); ++i) {
            XTNetwork.TextNodeInfo tni = (XTNetwork.TextNodeInfo)info.textNodes.get(i);
            if (tni == null) continue;
            MinerTextNode mtn = new MinerTextNode(tni.labelText);
            mtn.setLocation(tni.x, tni.y);
            doc.addObjectAtTail((JGoObject)mtn);
            cn.textNodes.add(mtn);
            WorksheetDocument.storeForRemoval((JGoObject)mtn);
        }
        for (int output = 0; output < 2; ++output) {
            Vector ports = output == 0 ? info.inputPorts : info.outputPorts;
            Vector storage = output == 0 ? cn.getInputPorts() : cn.getOutputPorts();
            for (int i2 = 0; i2 < ports.size(); ++i2) {
                XTNetwork.PortInfo pi = (XTNetwork.PortInfo)ports.get(i2);
                String reprID = pi.nodeID;
                int reprPort = pi.portNum;
                BaseNodeArea area = doc.findNodeByID(Integer.parseInt(reprID));
                if (area == null) continue;
                BaseNodePort port = output == 0 ? (BaseNodePort)((Object)area.getInputPorts().get(reprPort)) : (BaseNodePort)((Object)area.getOutputPorts().get(reprPort));
                CollapsedNodePort cPort = new CollapsedNodePort(port, cn);
                cn.addCollapsedPort(port, output == 0, pi.visible, reprID, pi.toolTip, reprPort);
                storage.add(cPort);
            }
        }
        cn.layoutPorts(true);
        cn.layoutPorts(false);
        BaseLink blink = null;
        for (int i3 = 0; i3 < info.links.size(); ++i3) {
            obj = info.links.get(i3);
            if (obj instanceof XTNetwork.ExternalLinkInfo) {
                blink = CollapsedLink.buildLinkFromInfo((XTNetwork.ExternalLinkInfo)((Object)obj), doc);
            } else if (obj instanceof XTNetwork.ModelLinkInfo) {
                lazyModelLinkCreation.put(obj, cn);
                blink = null;
            } else if (obj instanceof XTNetwork.LinkInfo) {
                blink = BaseLink.buildLinkFromInfo((XTNetwork.LinkInfo)((Object)obj), doc);
            }
            if (blink == null) continue;
            doc.addObjectAtHead((JGoObject)blink);
            cn.addInternalLink((JGoLink)blink);
        }
        cn.addStateVisualCue();
        cn.setDocument(doc);
        return cn;
    }

    public static CollapsedNodeArea buildCollapsedNodeFromXML(Element elt, WorksheetDocument doc, CollapsedNodeArea cnode) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        CollapsedNodePort cPort;
        BaseNodePort port;
        BaseNodeArea area;
        String tooltip;
        boolean visible;
        String reprID;
        Element portElement;
        Element actualNode;
        int i;
        if (!elt.getTagName().equals(XTNetwork.COLLAPSED_NODE_NODE_TAG)) {
            return null;
        }
        CollapsedNodeArea cn = new CollapsedNodeArea();
        cn.initialize();
        int cnid = Integer.parseInt(elt.getAttribute(XTNetwork.ID_ATTRIBUTE_TAG));
        cn.setID(cnid);
        Element node = (Element)elt.getFirstChild();
        if (node.getNodeName().equals(XTNetwork.DISPLAY_INFO_NODE_TAG)) {
            String text = node.getAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG);
            if (text != null) {
                cn.setText(text);
            }
            cn.largeIcon = node.getAttribute(XTNetwork.LARGE_ICON_ATTRIBUTE_TAG);
            if (cn.largeIcon == null || cn.largeIcon.length() == 0) {
                cn.largeIcon = LARGE_ICON_NAME;
            }
            cn.smallIcon = node.getAttribute(XTNetwork.SMALL_ICON_ATTRIBUTE_TAG);
            if (cn.smallIcon == null || cn.smallIcon.length() == 0) {
                cn.smallIcon = SMALL_ICON_NAME;
            }
            cn.helpFile = node.getAttribute(XTNetwork.HELP_FILE_ATTRIBUTE_TAG);
            if (cn.helpFile == null || cn.helpFile.length() == 0) {
                cn.helpFile = null;
            }
            int x = Integer.parseInt(node.getAttribute(XTNetwork.X_ATTRIBUTE_TAG));
            int y = Integer.parseInt(node.getAttribute(XTNetwork.Y_ATTRIBUTE_TAG));
            cn.setCenterPoint(new Point(x, y));
            cn.setTopLeft(x, y);
            node = (Element)node.getNextSibling();
        }
        if (node.getNodeName().equals(XTNetwork.COMPONENT_COMMENTS_NODE_TAG)) {
            cn.setComments(node);
            node = (Element)node.getNextSibling();
        }
        doc.addObjectAtTail((JGoObject)cn);
        if (cnode != null) {
            cnode.addNode(cn);
            WorksheetDocument.storeForRemoval((JGoObject)cn);
        }
        Element inputList = null;
        Element outputList = null;
        if (node != null && node.getNodeName().equals(XTNetwork.INPUT_PORT_LIST_NODE_TAG)) {
            inputList = node;
            node = (Element)node.getNextSibling();
        }
        if (node != null && node.getNodeName().equals(XTNetwork.OUTPUT_PORT_LIST_NODE_TAG)) {
            outputList = node;
            node = (Element)node.getNextSibling();
        }
        if (node != null && node.getNodeName().equals(XTNetwork.ACTIVITY_NODE_LIST_NODE_TAG)) {
            NodeList activityNodeList = node.getChildNodes();
            for (i = 0; i < activityNodeList.getLength(); ++i) {
                actualNode = (Element)activityNodeList.item(i);
                XTNetwork.NodeInfo info = new XTNetwork.NodeInfo();
                info.convertFromXML(actualNode);
                ActivityNodeArea act = ActivityNodeArea.buildActivityNodeFromInfo(info);
                if (act == null) continue;
                doc.addObjectAtTail((JGoObject)act);
                cn.addNode(act);
                act.getNodeModel().addChangeListener(cn);
                WorksheetDocument.storeForRemoval((JGoObject)act);
            }
            node = (Element)node.getNextSibling();
        }
        if (node != null && node.getNodeName().equals(XTNetwork.TEXT_NODE_LIST_NODE_TAG)) {
            NodeList textNodeList = node.getChildNodes();
            for (i = 0; i < textNodeList.getLength(); ++i) {
                actualNode = (Element)textNodeList.item(i);
                MinerTextNode mtn = MinerTextNode.buildTextNodeFromXML(actualNode);
                if (mtn == null) continue;
                doc.addObjectAtTail((JGoObject)mtn);
                cn.textNodes.add(mtn);
                WorksheetDocument.storeForRemoval((JGoObject)mtn);
            }
            node = (Element)node.getNextSibling();
        }
        if (inputList != null) {
            NodeList iPorts = inputList.getChildNodes();
            for (i = 0; i < iPorts.getLength(); ++i) {
                portElement = (Element)iPorts.item(i);
                reprID = portElement.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG);
                int reprPort = Integer.parseInt(portElement.getAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG));
                visible = portElement.getAttribute(XTNetwork.VISIBLE_ATTRIBUTE_TAG).compareToIgnoreCase("true") == 0;
                tooltip = portElement.getAttribute(XTNetwork.TOOLTIP_ATTRIBUTE_TAG);
                area = doc.findNodeByID(Integer.parseInt(reprID));
                port = (BaseNodePort)((Object)area.getInputPorts().get(reprPort));
                cPort = new CollapsedNodePort(port, cn);
                cn.addCollapsedPort(port, true, visible, reprID, tooltip, reprPort);
                cn.getInputPorts().add(cPort);
            }
            cn.layoutPorts(true);
        }
        if (outputList != null) {
            NodeList iPorts = outputList.getChildNodes();
            for (i = 0; i < iPorts.getLength(); ++i) {
                portElement = (Element)iPorts.item(i);
                reprID = portElement.getAttribute(XTNetwork.TO_NODE_ATTRIBUTE_TAG);
                int reprPort = Integer.parseInt(portElement.getAttribute(XTNetwork.TO_PORT_ATTRIBUTE_TAG));
                visible = portElement.getAttribute(XTNetwork.VISIBLE_ATTRIBUTE_TAG).compareToIgnoreCase("true") == 0;
                tooltip = portElement.getAttribute(XTNetwork.TOOLTIP_ATTRIBUTE_TAG);
                area = doc.findNodeByID(Integer.parseInt(reprID));
                port = (BaseNodePort)((Object)area.getOutputPorts().get(reprPort));
                cPort = new CollapsedNodePort(port, cn);
                cn.addCollapsedPort(port, false, visible, reprID, tooltip, reprPort);
                cn.getOutputPorts().add(cPort);
            }
            cn.layoutPorts(false);
        }
        if (node != null && node.getNodeName().equals(XTNetwork.COLLAPSED_NODE_LIST_NODE_TAG)) {
            NodeList collapsedNodeList = node.getChildNodes();
            for (i = 0; i < collapsedNodeList.getLength(); ++i) {
                actualNode = (Element)collapsedNodeList.item(i);
                CollapsedNodeArea.buildCollapsedNodeFromXML(actualNode, doc, cn);
            }
            node = (Element)node.getNextSibling();
        }
        if (node != null && node.getNodeName().equals(XTNetwork.LINK_LIST_NODE_TAG)) {
            NodeList linkList = node.getChildNodes();
            boolean isCollapsing = doc.isCollapsing();
            doc.setCollapseTransaction(true);
            for (int i2 = 0; i2 < linkList.getLength(); ++i2) {
                Element actualNode2 = (Element)linkList.item(i2);
                BaseLink blink = null;
                if (actualNode2.getNodeName().equals(XTNetwork.MODEL_LINK_NODE_TAG)) {
                    PredictorLink pl = PredictorLink.buildLinkFromXML(actualNode2, doc);
                    doc.addObjectAtHead((JGoObject)pl);
                    cn.addPredictorLink(pl);
                    blink = null;
                } else {
                    blink = actualNode2.hasChildNodes() ? CollapsedLink.buildLinkFromXML(actualNode2, doc) : BaseLink.buildLinkFromXML(actualNode2, doc);
                }
                if (blink == null) continue;
                doc.addObjectAtHead((JGoObject)blink);
                cn.addInternalLink((JGoLink)blink);
            }
            doc.setCollapseTransaction(isCollapsing);
            node = (Element)node.getNextSibling();
        }
        WorksheetDocument.removeTempObjects(doc);
        cn.setDocument(doc);
        return cn;
    }

    public void addNode(BaseNodeArea node) {
        this.nodes.addElement(node);
    }

    public void addInternalLink(JGoLink link) {
        this.links.addElement(link);
    }

    public void addPredictorLink(PredictorLink link) {
        this.modelLinks.addElement(link);
    }

    public BaseNodeArea getFlatNodeByID(int id) {
        int length = this.nodes.size();
        for (int i = 0; i < length; ++i) {
            BaseNodeArea node = (BaseNodeArea)this.nodes.elementAt(i);
            if (node instanceof ActivityNodeArea) {
                if (node.getID() != id) continue;
                return node;
            }
            if (!(node instanceof CollapsedNodeArea)) continue;
            if (node.getID() == id) {
                return node;
            }
            BaseNodeArea test = ((CollapsedNodeArea)node).getFlatNodeByID(id);
            if (test == null || test.getID() != id) continue;
            return test;
        }
        return null;
    }

    public BaseNodeArea getNodeAt(int i) {
        return (BaseNodeArea)this.nodes.elementAt(i);
    }

    public JGoLink getInternalLinkAt(int i) {
        return (JGoLink)this.links.elementAt(i);
    }

    public int getNumberNodes() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    public int getNumberInternalLinks() {
        if (this.links == null) {
            return 0;
        }
        return this.links.size();
    }

    public Point getCenterPoint() {
        return this.centerpoint;
    }

    public void setCenterPoint(Point p) {
        this.centerpoint = p;
    }

    public JGoImage getCrosshairs() {
        return this.myCrosshairsImage;
    }

    public int getID() {
        return this.m_id;
    }

    public void setID(int id) {
        this.m_id = id;
    }

    public String getSmallIconName() {
        if (this.smallIcon != null) {
            return this.smallIcon;
        }
        return SMALL_ICON_NAME;
    }

    public String getLargeIconName() {
        if (this.largeIcon != null) {
            return this.largeIcon;
        }
        return LARGE_ICON_NAME;
    }

    public void showHelp() {
        String str = this.helpFile;
        if (str == null || str.equals("")) {
            MinerApp.getHelpManager().showTopic(HELP_TOPIC);
        } else {
            HelpManager mgr = MinerApp.getHelpManager();
            if (mgr instanceof WinHelpManagerImpl) {
                WinHelpManagerImpl helpManager = new WinHelpManagerImpl(str);
                helpManager.showIndex();
            }
        }
    }

    public static class CollapsedNodePort
    extends BaseNodePort {
        private BaseNodePort m_representedPort = null;

        public CollapsedNodePort() {
        }

        public CollapsedNodePort(BaseNodePort representedPort, JGoArea parent) {
            super(representedPort.isInput(), representedPort.isSingle(), parent);
            this.m_representedPort = representedPort instanceof CollapsedNodePort ? ((CollapsedNodePort)representedPort).getRepresentedPort() : representedPort;
        }

        public JGoObject copyObject(JGoCopyEnvironment env) {
            CollapsedNodePort port = (CollapsedNodePort)super.copyObject(env);
            port.m_representedPort = (BaseNodePort)((Object)env.get((Object)this.m_representedPort));
            return port;
        }

        public BaseNodePort getRepresentedPort() {
            return this.m_representedPort;
        }

        public String getToolTipText() {
            CollapsedNodeArea area = (CollapsedNodeArea)this.getNode();
            String str = area.getPortToolTipText(this.m_representedPort);
            if (str == null) {
                return this.m_representedPort.getToolTipText();
            }
            return str;
        }
    }

    private class PropertiesAction
    extends AppAction {
        ActivityNodeModel m_model;

        public PropertiesAction(ActivityNodeArea area) {
            super(area.getNodeModel().getLabelText());
            this.m_model = area.getNodeModel();
        }

        public boolean canAct() {
            return this.m_model.getState().isPresentStateAtLeastAsAdvancedAsTestState(ActivityNodeLinked.instance());
        }

        public void actionPerformed(ActionEvent e) {
            this.m_model.showPropertiesDialog();
        }
    }
}

