/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.LibraryTreeNode;
import com.insightful.miner.MinerApp;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class IconableTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (leaf) {
            Object userObj = null;
            if (value instanceof JTree.DynamicUtilTreeNode) {
                userObj = ((JTree.DynamicUtilTreeNode)value).getUserObject();
            } else if (value instanceof DefaultMutableTreeNode) {
                userObj = ((DefaultMutableTreeNode)value).getUserObject();
            }
            if (userObj == null) {
                return this;
            }
            String iconFileName = null;
            String toolTipText = null;
            if (userObj instanceof DragAndDropTree.LibraryFolder) {
                this.setIcon(this.getClosedIcon());
                this.setToolTipText(((DragAndDropTree.LibraryFolder)userObj).toString());
            } else {
                if (userObj instanceof LibraryTreeNode) {
                    iconFileName = ((LibraryTreeNode)userObj).getTreeNodeIconFilename();
                    toolTipText = ((LibraryTreeNode)userObj).toString();
                } else if (userObj instanceof ActivityNodeArea) {
                    ActivityNodeModel model = ((ActivityNodeArea)userObj).getNodeModel();
                    iconFileName = model.getSmallIconName();
                    toolTipText = model.getLabelText();
                } else if (userObj instanceof CollapsedNodeArea) {
                    iconFileName = ((CollapsedNodeArea)userObj).getSmallIconName();
                    toolTipText = ((CollapsedNodeArea)userObj).toString().replaceAll("\n", "");
                }
                if (iconFileName != null) {
                    ImageIcon icon = MinerApp.getResourceManager().getIcon(iconFileName);
                    if (icon == null) {
                        icon = MinerApp.getResourceManager().getIcon(ActivityNodeModel.UNKNOWN_NODE_SMALL_ICON);
                    }
                    this.setIcon(icon);
                }
                if (toolTipText != null) {
                    this.setToolTipText(toolTipText);
                }
            }
        }
        return this;
    }
}

