/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.RegressionDialog;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinearRegressionNodeModel
extends PredictableNodeModel
implements ColumnFilterGenerator {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{"copyInputColumns", "independent"}, props.getValue(new String[]{"copyInputColumns", "independent"}, "false"));
        props.set(new String[]{"copyInputColumns", "dependent"}, props.getValue(new String[]{"copyInputColumns", "dependent"}, "true"));
        props.set(new String[]{"copyInputColumns", "other"}, props.getValue(new String[]{"copyInputColumns", "other"}, "false"));
        props.set(new String[]{"newColumns", "fittedValues"}, props.getValue(new String[]{"newColumns", "fittedValues"}, "true"));
        props.set(new String[]{"newColumns", "residuals"}, props.getValue(new String[]{"newColumns", "residuals"}, "false"));
    }

    public void showPropertiesDialog(boolean modality) {
        RegressionDialog dialog = RegressionDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, 1);
    }

    public boolean isPropertiesValid() {
        String role;
        int i;
        boolean indepValid = false;
        boolean depValid = false;
        XTProps props = this.getXTProps();
        Vector roleVec = props.getSubPropertyValues("columnRoles");
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                Vector columns = props.getSubProperties("columnRoles");
                for (i = columns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)columns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        indepValid = props.getBoolean("includeIntercept", true);
        for (int i2 = 0; !(depValid && indepValid || i2 >= roleVec.size()); ++i2) {
            role = (String)roleVec.get(i2);
            if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) {
                depValid = true;
            }
            if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
            indepValid = true;
        }
        if (this.getState() != null && this.isInputValid()) {
            try {
                XTMetaData md = this.getInputMetaData(0);
                if (md != null) {
                    roleVec = md.getColumnRoles();
                    for (i = 0; !(depValid && indepValid || i >= roleVec.size()); ++i) {
                        role = (String)roleVec.get(i);
                        if (!depValid && XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role) && md.isContinuousColumn(i)) {
                            depValid = true;
                        }
                        if (indepValid || !XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG.equals(role)) continue;
                        indepValid = true;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return indepValid && depValid;
    }

    public void showView(Frame frame) {
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                String htmlString = xt.getHtmlString(XMLTree.GENERAL_REGRESSION_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getModelOutputType() {
        return "regression";
    }

    public String getModelAlgorithm() {
        return "glm";
    }

    public String[] getFilterColumnsToExclude() {
        String[] colNames = null;
        double[] importanceValues = null;
        try {
            XMLTree xt = this.getFittedModel();
            if (xt != null) {
                Element elt = (Element)xt.getXML().getElementsByTagName("GeneralRegressionModel").item(0);
                int numNames = Integer.parseInt((elt = (Element)elt.getElementsByTagName("Importance").item(0)).getAttribute("count"));
                if (numNames > 0) {
                    colNames = new String[numNames];
                    importanceValues = new double[numNames];
                    NodeList effects = elt.getElementsByTagName("Effect");
                    if (effects.getLength() != numNames) {
                        throw new RuntimeException("Number of Effect elements does not match Importance count attribute");
                    }
                    for (int i = 0; i < numNames; ++i) {
                        colNames[i] = ((Element)effects.item(i)).getAttribute("name");
                        importanceValues[i] = Double.parseDouble(((Element)effects.item(i)).getAttribute("value"));
                    }
                    colNames = ColumnFilterTools.showDefaultFilterSpecificationDialog(colNames, importanceValues, "Column Importance");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return colNames;
    }
}

