/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsNNErrorGraphPanel;
import com.insightful.miner.InsTickUnits;
import com.insightful.miner.NeuralNetViewer;
import com.insightful.miner.NeuralNetworkExecViewer;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.gui.ColorBroker;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.chart.combination.NumberAxisRange;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class NeuralNetGraphPanel
extends JPanel {
    private ColorBroker colorBroker = null;
    private Vector xvals = null;
    private Vector yvals = null;
    private double[][] arrow = null;
    private Vector epochVector = null;
    private Vector mseTrainVector = null;
    private Vector mseValidateVector = null;
    private XTProps xtprops = null;
    private double currentEpoch = 0.0;
    private int numEpochsDesired = 50;
    private InsNNErrorGraphPanel mainPanel = null;
    private InsNNErrorGraphPanel enlargedPanel = null;
    private InsNNErrorGraphPanel smallPanel = null;
    private MyCombinedPlot overlaidPlot = null;
    private NeuralNetViewer parent = null;
    double bestWeightsEpoch = 0.0;
    int numEpochs = 0;
    double[] yRangeVal = null;
    double maxYVal = 0.0;
    double minYVal = Double.MAX_VALUE;
    double rangeK = 0.1;
    public static String TRAINING_ERROR_VAL_VECTOR_TAG = "trainingErrorVals";
    public static String TEST_ERROR_VAL_VECTOR_TAG = "testErrorVals";
    public static String EPOCH_VECTOR_TAG = "epochs";
    public static String ARROWS_TAG = "arrowLocations";
    public static String SAVE_ARROWS_TAG = "saveArrowLocations";
    private XYDataset[] m_dataset = null;
    private Object[][][][] m_finaldata = null;
    private Object[][][] m_arrowdata = null;
    private DefaultXYDataset m_refLine = null;
    private double m_yMin = Double.NaN;
    private double m_yMax = Double.NaN;

    public NeuralNetGraphPanel(NeuralNetViewer parent) {
        this.parent = parent;
        this.colorBroker = ColorBroker.getInstance();
        this.arrow = new double[4][2];
        this.yRangeVal = new double[2];
        this.yRangeVal[0] = -0.3;
        this.yRangeVal[1] = 1.0;
        this.setLayout(new BorderLayout());
    }

    public void initChart(int num_epochs) {
        this.numEpochs = num_epochs;
        if (this.epochVector == null) {
            this.epochVector = new Vector();
        }
        if (this.mseTrainVector == null) {
            this.mseTrainVector = new Vector();
        }
        if (this.mseValidateVector == null) {
            this.mseValidateVector = new Vector();
        }
        if (this.xvals == null) {
            this.xvals = new Vector();
        }
        if (this.yvals == null) {
            this.yvals = new Vector();
        }
        this.mainPanel = this.createErrorGraphPanel();
        this.enlargedPanel = this.createErrorGraphPanel();
        this.enlargedPanel.setIsEnlarged(true);
        this.enlargedPanel.setVisible(false);
        this.add((Component)((Object)this.mainPanel));
        this.yRangeVal[0] = -0.3;
        this.yRangeVal[1] = 1.0;
    }

    public void resetEpochs(String numEpochs) {
        this.numEpochsDesired = Integer.parseInt(numEpochs);
        if (this.overlaidPlot != null) {
            this.overlaidPlot.setRange((AxisRange)new NumberAxisRange((Number)new Integer(0), (Number)new Integer(this.numEpochsDesired)), this.overlaidPlot.getHorizontalAxes());
        }
    }

    public void resetArrows(Vector v) {
        this.mainPanel.resetArrows(v);
    }

    public void repaintGraph() {
        this.mainPanel.repaint();
    }

    public JFreeChart getChart() {
        return this.mainPanel.getChart();
    }

    public void releaseMemory() {
        this.removeAll();
        this.arrow = null;
        this.xvals.removeAllElements();
        this.yvals.removeAllElements();
        this.epochVector.removeAllElements();
        this.mseTrainVector.removeAllElements();
        this.mseValidateVector.removeAllElements();
    }

    public void updateData(Hashtable h) {
        double d = 0.0;
        try {
            d = Double.parseDouble((String)h.get(NeuralNetworkExecViewer.DEV_TAG));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.mseTrainVector.add(Double.toString(d));
        d = 0.0;
        try {
            d = Double.parseDouble((String)h.get(NeuralNetworkExecViewer.VALIDATEDEV_TAG));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        this.mseValidateVector.add(Double.toString(d));
        this.bestWeightsEpoch = Double.parseDouble((String)h.get(NeuralNetworkExecViewer.BEST_WEIGHTS_EPOCH_NUM_TAG));
        String currentEpochString = (String)h.get(NeuralNetworkExecViewer.EPOCH_TAG);
        this.currentEpoch = Double.parseDouble(currentEpochString);
        this.epochVector.add(currentEpochString);
        this.createValArrays(currentEpochString, this.epochVector, this.mseTrainVector, this.mseValidateVector, this.bestWeightsEpoch);
        JFreeChart chart = this.createChart(this.mainPanel == null ? null : this.mainPanel.getChart());
        this.mainPanel.setChart(chart);
        this.mainPanel.setArrowInfo(this.bestWeightsEpoch, this.numEpochs, this.mseValidateVector);
        this.mainPanel.repaint();
        if (this.enlargedPanel != null) {
            this.enlargedPanel.setChart(chart);
            this.enlargedPanel.setArrowInfo(this.bestWeightsEpoch, this.numEpochs, this.mseValidateVector);
            this.enlargedPanel.repaint();
        }
        if (this.smallPanel != null && this.smallPanel.isVisible()) {
            this.smallPanel.setChart(chart);
            this.smallPanel.repaint();
        }
    }

    private void createValArrays(String currentEpoch, Vector epochs, Vector trainErrorVals, Vector validateErrorVals, double bestWeightsEpoch) {
        int epoch = Integer.parseInt(currentEpoch);
        if (this.xvals == null) {
            this.xvals = new Vector();
        }
        if (this.yvals == null) {
            this.yvals = new Vector();
        }
        this.xvals.removeAllElements();
        this.yvals.removeAllElements();
        double[] xlines = null;
        double[] ylines = null;
        double bestEpochY = 0.0;
        int k = 0;
        this.minYVal = 0.0;
        this.maxYVal = 0.0;
        for (int i = 0; i < epoch; ++i) {
            xlines = new double[]{Double.parseDouble((String)epochs.elementAt(i)), Double.parseDouble((String)epochs.elementAt(i))};
            this.xvals.addElement(xlines);
            ylines = new double[]{Double.parseDouble((String)trainErrorVals.elementAt(i)), Double.parseDouble((String)validateErrorVals.elementAt(i))};
            this.yvals.addElement(ylines);
            if (i >= k && this.maxYVal < Math.max(ylines[0], ylines[1])) {
                this.maxYVal = Math.max(ylines[0], ylines[1]);
            }
            if (xlines[0] != bestWeightsEpoch) continue;
            bestEpochY = ylines[1];
        }
        this.yRangeVal[1] = 1.1 * this.maxYVal;
        this.arrow = new double[2][2];
        this.arrow[0][0] = bestWeightsEpoch;
        this.arrow[0][1] = bestEpochY;
        this.arrow[1][0] = bestWeightsEpoch;
        this.arrow[1][1] = bestEpochY;
    }

    public void recreateErrorGraph(Vector epochs, Vector trainingVals, Vector testVals) {
        this.createValArrays((String)epochs.elementAt(epochs.size() - 1), epochs, trainingVals, testVals, 2.0);
        JFreeChart chart = this.mainPanel.getChart();
        chart = null;
        this.mainPanel.setChart(this.createChart());
        this.mainPanel.setArrowInfo(this.bestWeightsEpoch, this.numEpochs, this.mseValidateVector);
        JFreeChart echart = this.enlargedPanel.getChart();
        echart = null;
        this.enlargedPanel.setChart(this.createChart());
        this.enlargedPanel.setArrowInfo(this.bestWeightsEpoch, this.numEpochs, this.mseValidateVector);
    }

    public InsNNErrorGraphPanel createErrorGraphPanel() {
        JFreeChart chart = this.createChart();
        InsNNErrorGraphPanel panel = new InsNNErrorGraphPanel(this.parent, chart, 270, 230, 270.0, 230.0, true, true, true, true, true, true);
        panel.setPreferredSize(new Dimension(270, 230));
        panel.setMinimumSize(new Dimension(270, 230));
        panel.setBackground(Color.white);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        return panel;
    }

    public InsNNErrorGraphPanel enlargeGraphPanel() {
        this.enlargedPanel.setVisible(true);
        return this.enlargedPanel;
    }

    public InsNNErrorGraphPanel createSmallGraphPanel() {
        this.smallPanel = this.createErrorGraphPanel();
        this.smallPanel.setIsEnlarged(true);
        return this.smallPanel;
    }

    public void addArrow() {
        this.mainPanel.addArrow(this.currentEpoch);
        if (this.enlargedPanel != null) {
            this.enlargedPanel.addArrow(this.currentEpoch);
        }
    }

    public void saveBestArrow() {
        this.mainPanel.addArrow(this.bestWeightsEpoch);
        if (this.enlargedPanel != null) {
            this.enlargedPanel.addArrow(this.bestWeightsEpoch);
        }
    }

    public void setNumEpochs(int num) {
        this.numEpochs = num;
    }

    private JFreeChart createChart() {
        return this.createChart(null);
    }

    private JFreeChart createChart(JFreeChart chart) {
        XYDataset[] datasets = this.buildXYDatasets(this.xvals, this.yvals, this.arrow);
        int numGraphs = datasets.length + 1;
        CombinedDataset data = new CombinedDataset();
        XYDataset refLineDataset = this.buildRefDataset();
        ((DefaultXYDataset)refLineDataset).setSeriesNames(new String[]{""});
        data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)refLineDataset, 0));
        XYDataset trainDataset = datasets[0];
        String[] trainDataText = new String[]{NeuralNetViewer.getText("nnvis_gui_error_graph_trainingSetName")};
        ((DefaultXYDataset)trainDataset).setSeriesNames(trainDataText);
        data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)trainDataset, 0));
        if (datasets.length > 1) {
            XYDataset testDataset = datasets[1];
            String[] testDataText = new String[]{NeuralNetViewer.getText("nnvis_gui_error_graph_testSetName")};
            ((DefaultXYDataset)testDataset).setSeriesNames(testDataText);
            data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)testDataset, 0));
        }
        if (datasets.length > 2) {
            XYDataset bestWeightDataset = datasets[2];
            String[] bestArrowDataText = new String[]{NeuralNetViewer.getText("nnvis_gui_error_graph_bestArrowName")};
            ((DefaultXYDataset)bestWeightDataset).setSeriesNames(bestArrowDataText);
            data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)bestWeightDataset, 0));
        }
        try {
            if (this.overlaidPlot == null) {
                String xAxisLabel = NeuralNetViewer.getText("nnvis_gui_error_graph_xaxis");
                String yAxisLabel = this.parent.getIsRegression() ? NeuralNetViewer.getText("nnvis_gui_error_graph_reg_yaxis") : NeuralNetViewer.getText("nnvis_gui_error_graph_class_yaxis");
                VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
                HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
                xAxis.setStandardTickUnits(InsTickUnits.createIntegerTickUnits());
                yAxis.setStandardTickUnits(InsTickUnits.createStandardTickUnits());
                yAxis.setAutoRangeIncludesZero(false);
                yAxis.setLabelInsets(new Insets(0, 0, 0, 10));
                yAxis.setGridLinesVisible(false);
                xAxis.setGridLinesVisible(false);
                xAxis.setAutoRangeIncludesZero(false);
                this.overlaidPlot = new MyCombinedPlot((Axis)xAxis, (Axis)yAxis);
                this.overlaidPlot.setRange((AxisRange)new NumberAxisRange((Number)new Integer(0), (Number)new Integer(this.numEpochsDesired)), this.overlaidPlot.getHorizontalAxes());
                this.overlaidPlot.setInsets(new Insets(2, 2, 15, 15));
            } else {
                this.overlaidPlot.removeCharts();
            }
            for (int i = 0; i < numGraphs; ++i) {
                CombinedChart cc = ChartFactory.createCombinableXYChart((ValueAxis)((HorizontalNumberAxis)this.overlaidPlot.getHorizontalAxis()), (ValueAxis)((VerticalNumberAxis)this.overlaidPlot.getVerticalAxis()), (Dataset)new SubSeriesDataset((SeriesDataset)data, i));
                this.overlaidPlot.add(cc);
            }
            if (chart == null) {
                chart = new JFreeChart((Dataset)data, (Plot)this.overlaidPlot, NeuralNetViewer.getText("nnvis_gui_error_graph_title"), JFreeChart.DEFAULT_TITLE_FONT, true);
            } else if (this.numEpochs > 0) {
                chart.setDataset((Dataset)data);
            }
            this.overlaidPlot.setChart(chart);
            this.overlaidPlot.adjustPlots();
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    private XYDataset[] buildXYDatasets(Vector xvals, Vector yvals, double[][] arrow) {
        int numVals = 0;
        int numLines = 0;
        if (xvals != null) {
            numVals = xvals.size();
            numLines = 2;
        }
        if (this.m_dataset == null || this.m_dataset.length != numLines + 1) {
            this.m_dataset = new XYDataset[numLines + 1];
        }
        if (this.m_finaldata == null || numLines != this.m_finaldata.length || numVals != this.m_finaldata[0][0].length) {
            this.m_finaldata = new Object[numLines][1][numVals][2];
        }
        for (int j = 0; j < numVals; ++j) {
            double[] xVals = (double[])xvals.elementAt(j);
            double[] yVals = (double[])yvals.elementAt(j);
            for (int i = 0; i < numLines; ++i) {
                this.m_finaldata[i][0][j][0] = new Double(xVals[i]);
                this.m_finaldata[i][0][j][1] = new Double(yVals[i]);
            }
        }
        for (int i = 0; i < numLines; ++i) {
            this.m_dataset[i] = new DefaultXYDataset(this.m_finaldata[i]);
        }
        if (this.m_arrowdata == null) {
            this.m_arrowdata = new Object[1][2][2];
        }
        this.m_arrowdata[0][0][0] = new Double(arrow[0][0]);
        this.m_arrowdata[0][0][1] = new Double(arrow[0][1]);
        this.m_arrowdata[0][1][0] = new Double(arrow[1][0]);
        this.m_arrowdata[0][1][1] = new Double(arrow[1][1]);
        this.m_dataset[this.m_dataset.length - 1] = new DefaultXYDataset(this.m_arrowdata);
        return this.m_dataset;
    }

    public XYDataset buildRefDataset() {
        if (this.m_refLine == null || this.m_yMin != this.yRangeVal[0] || this.m_yMax != this.yRangeVal[1]) {
            Object[][][] finaldata = null;
            finaldata = new Object[][][]{{{new Integer(1), new Double(this.yRangeVal[0])}, {new Integer(50), new Double(this.yRangeVal[1])}}};
            this.m_refLine = new DefaultXYDataset(finaldata);
            this.m_yMin = this.yRangeVal[0];
            this.m_yMax = this.yRangeVal[1];
        }
        return this.m_refLine;
    }

    public Hashtable getErrorGraphData() {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put(TRAINING_ERROR_VAL_VECTOR_TAG, this.mseTrainVector);
        h.put(TEST_ERROR_VAL_VECTOR_TAG, this.mseValidateVector);
        h.put(EPOCH_VECTOR_TAG, this.epochVector);
        h.put(ARROWS_TAG, this.arrow);
        h.put(SAVE_ARROWS_TAG, this.mainPanel.getArrowVector());
        return h;
    }

    public int getCurrentEpoch() {
        return (int)this.currentEpoch;
    }

    public int getBestEpoch() {
        return (int)this.bestWeightsEpoch;
    }

    private Paint[] getLineColors() {
        Paint[] paints = new Paint[]{Color.white, ColorBroker.getColor("neuralNetErrorGraphTrainingColor"), ColorBroker.getColor("neuralNetErrorGraphTestColor"), Color.black};
        return paints;
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    private double[][] getTestXVals() {
        return new double[][]{{0.0, 1.0, 2.0, 3.0, 4.0}, {0.0, 1.0, 2.0, 3.0, 4.0}};
    }

    private double[][] getTestYVals() {
        return new double[][]{{90.0, 30.0, 8.0, 2.0, 1.0}, {100.0, 35.0, 10.0, 5.0, 1.0}};
    }

    public class MyCombinedPlot
    extends CombinedPlot {
        private Object syncObject;
        private Paint[] myPaint;

        public MyCombinedPlot(Axis xAxis, Axis yAxis) {
            super(xAxis, yAxis);
            this.syncObject = new Object();
            this.myPaint = null;
            this.myPaint = new Paint[4];
            this.myPaint[0] = Color.white;
            this.myPaint[1] = ColorBroker.getColor("neuralNetErrorGraphTrainingColor");
            this.myPaint[2] = ColorBroker.getColor("neuralNetErrorGraphTestColor");
            this.myPaint[3] = Color.black;
        }

        public void removeCharts() {
            this.weights -= this.charts.size();
            this.isAdjusted = false;
            for (int i = 0; i < this.axisRangeSet.length; ++i) {
                this.axisRangeSet[i] = false;
            }
            this.charts.clear();
        }

        public Paint getSeriesPaint(int index) {
            return this.myPaint[index];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustPlots() {
            Object object = this.syncObject;
            synchronized (object) {
                super.adjustPlots();
            }
        }
    }
}

