/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadTextFileDialog
extends ReadOtherFileDialog {
    private JComboBox m_encodingComboBox;
    private JComboBox m_delimiterComboBox;
    private JTextField m_userDefinedDelimiterTextField;
    private JCheckBox m_readFieldNamesCheckBox;
    private JTextField m_NAStringTextField;
    private JTextField m_maxLineWidthTextField;
    private JTextField m_lookMaxLinesTextField;
    private NodeDialog.DateParseFormatComboBox m_timeDateFormatComboBox;
    private static final String[] m_encodingStrings = new String[]{"ASCII", "UTF-8"};
    private static final String[] m_delimiters = new String[]{"comma delimited", "tab delimited", "single space delimited", "single quote delimited", "user selected"};
    private static final String[] m_delimiterChars = new String[]{",", "\t", " ", "'", ""};
    private static String[] m_typeDescriptionList = new String[]{"Text files (*.txt; *.dat; *.asc; *.csv; *.prn)", "Text File (*.txt)", "Data File (*.dat)", "ASCII File (*.asc)", "Comma Separated Values File (*.csv)", "Print Format File (*.prn)"};
    private static String[][] m_extensionList = new String[][]{{".txt", ".dat", ".asc", ".csv", ".prn"}, {".txt"}, {".dat"}, {".asc"}, {".csv"}, {".prn"}};
    private static ReadTextFileDialog m_ReadTextFileDialog = null;

    public static ReadTextFileDialog getReadTextFileDialog() {
        if (m_ReadTextFileDialog == null) {
            m_ReadTextFileDialog = new ReadTextFileDialog();
        }
        return m_ReadTextFileDialog;
    }

    protected ReadTextFileDialog() {
        Dimension min = new Dimension(525, 600);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        ReadTextFileDialog.restoreDelimiterComboBox(this.m_delimiterComboBox, m_delimiterChars, this.m_userDefinedDelimiterTextField, props);
        this.m_readFieldNamesCheckBox.setSelected(props.getBoolean("useColumnNames", true));
        String currentPath = props.getValue("filePath", "");
        this.m_fileNameTextField.setText(currentPath);
        this.m_NAStringTextField.setText(props.getValue("NAString", ""));
        this.m_maxLineWidthTextField.setText(props.getValue("maxLineWidth", ""));
        this.m_lookMaxLinesTextField.setText(props.getValue("lookMaxLines", ""));
        this.m_timeDateFormatComboBox.setText(props.getValue("timeDateFormat", MinerApp.getWorksheetPropertiesManager().getDateParseString()));
        ReadTextFileDialog.restoreComboBoxChoice(this.m_encodingComboBox, m_encodingStrings, 0, props.getValue("textEncoding", "ASCII"));
    }

    public static void restoreDelimiterComboBox(JComboBox delimiterComboBox, String[] delimiterChars, JTextField userDelimiterTextField, XTProps props) {
        String userDelim = props.getValue("userDelimiter");
        String cbChoice = props.getValue("delimiter");
        int index = 0;
        for (index = 0; index < delimiterChars.length && !delimiterChars[index].equals(cbChoice); ++index) {
        }
        if (index == delimiterChars.length) {
            --index;
        }
        userDelimiterTextField.setText(userDelim);
        delimiterComboBox.setSelectedIndex(index);
    }

    public static void saveDelimiterFromComboBox(JComboBox delimiterComboBox, String[] delimiterChars, JTextField userDelimTextField, XTProps props) {
        props.set("userDelimiter", userDelimTextField.getText());
        int index = delimiterComboBox.getSelectedIndex();
        if (index == -1) {
            index = delimiterChars.length - 1;
        }
        props.set("delimiter", delimiterChars[index]);
    }

    public static void restoreComboBoxChoice(JComboBox comboBox, String[] choiceStrings, int defaultIndex, String selectedString) {
        int index = 0;
        for (index = 0; index < choiceStrings.length && !choiceStrings[index].equals(selectedString); ++index) {
        }
        if (index >= choiceStrings.length) {
            index = defaultIndex;
        }
        comboBox.setSelectedIndex(index);
    }

    public static String getComboBoxChoice(JComboBox comboBox, String[] choiceStrings, int defaultIndex) {
        int index = comboBox.getSelectedIndex();
        if (index < 0 || index >= choiceStrings.length) {
            index = defaultIndex;
        }
        return choiceStrings[index];
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        ReadTextFileDialog.saveDelimiterFromComboBox(this.m_delimiterComboBox, m_delimiterChars, this.m_userDefinedDelimiterTextField, props);
        props.set("useColumnNames", this.m_readFieldNamesCheckBox.isSelected());
        props.set("NAString", this.m_NAStringTextField.getText());
        props.set("maxLineWidth", this.m_maxLineWidthTextField.getText());
        props.set("lookMaxLines", this.m_lookMaxLinesTextField.getText());
        props.set("timeDateFormat", this.m_timeDateFormatComboBox.getText());
        props.set("textEncoding", ReadTextFileDialog.getComboBoxChoice(this.m_encodingComboBox, m_encodingStrings, 0));
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel upperPanel = new JPanel(new GridBagLayout());
        upperPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_timeDateFormatComboBox = new NodeDialog.DateParseFormatComboBox();
        Dimension minSize = this.m_timeDateFormatComboBox.getPreferredSize();
        this.m_timeDateFormatComboBox.setMinimumSize(minSize);
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadTextFileDialog.this.m_fileNameTextField, m_extensionList, null);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadTextFileDialog.this.m_fileNameTextField, m_extensionList, null);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadTextFileDialog, ReadTextFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, null);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        upperPanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        upperPanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        upperPanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_readFieldNamesCheckBox = new JCheckBox(MinerApp.getText("ReadTextFileDialog_readFieldNames"));
        this.m_readFieldNamesCheckBox.setMnemonic('a');
        JLabel encodingLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_encodingLabel"));
        encodingLabel.setDisplayedMnemonic(88);
        this.m_encodingComboBox = new JComboBox<String>(m_encodingStrings);
        encodingLabel.setLabelFor(this.m_encodingComboBox);
        this.m_encodingComboBox.setEditable(false);
        JLabel delimiterLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_delimiter"));
        delimiterLabel.setDisplayedMnemonic(76);
        this.m_delimiterComboBox = new JComboBox<String>(m_delimiters);
        this.m_delimiterComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean userDef = ReadTextFileDialog.this.m_delimiterComboBox.getSelectedIndex() == m_delimiters.length - 1;
                ReadTextFileDialog.this.m_userDefinedDelimiterTextField.setEnabled(userDef);
            }
        });
        delimiterLabel.setLabelFor(this.m_delimiterComboBox);
        this.m_delimiterComboBox.setEditable(false);
        this.m_userDefinedDelimiterTextField = new JTextField(10);
        this.m_delimiterComboBox.setPreferredSize(minSize);
        JLabel naLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_missingValString"));
        this.m_NAStringTextField = new JTextField(15);
        naLabel.setDisplayedMnemonic('v');
        naLabel.setLabelFor(this.m_NAStringTextField);
        JLabel maxLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_maxLineWidth"));
        this.m_maxLineWidthTextField = new JTextField(15);
        this.m_maxLineWidthTextField.setDocument(new NodeDialog.InputIntegerDoc());
        maxLabel.setDisplayedMnemonic('m');
        maxLabel.setLabelFor(this.m_maxLineWidthTextField);
        JLabel lookLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_lookMaxLines"));
        this.m_lookMaxLinesTextField = new JTextField(15);
        this.m_lookMaxLinesTextField.setDocument(new NodeDialog.InputIntegerDoc());
        lookLabel.setDisplayedMnemonic('k');
        lookLabel.setLabelFor(this.m_lookMaxLinesTextField);
        JLabel timeDateFormatLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_dateTimeFormat"));
        timeDateFormatLabel.setDisplayedMnemonic('f');
        timeDateFormatLabel.setLabelFor(this.m_timeDateFormatComboBox);
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('t');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        Insets noIndent = new Insets(0, 0, 0, 3);
        Insets indent = new Insets(0, 3, 0, 3);
        int gridy = 1;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.gridwidth = 0;
        moreOptionsPanel.add((Component)this.m_readFieldNamesCheckBox, optionsConstraints);
        optionsConstraints.gridwidth = 1;
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)encodingLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_encodingComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)delimiterLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.gridwidth = 1;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_delimiterComboBox, optionsConstraints);
        optionsConstraints.gridx = 2;
        optionsConstraints.weightx = 0.65;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_userDefinedDelimiterTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)naLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_NAStringTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)lookLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_lookMaxLinesTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)maxLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_maxLineWidthTextField, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)timeDateFormatLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_timeDateFormatComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 0.35;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        JPanel samplePanel = this.createSamplePanel(true);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)upperPanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        topPanel.add((Component)samplePanel, "South");
        panel.add((Component)topPanel, "North");
        panel.add((Component)this.createPreviewPanel(), "Center");
        return panel;
    }
}

