/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ResourceManager {
    private Hashtable loadedCursors;
    private Hashtable loadedIcons = new Hashtable();
    private Hashtable loadedImages = new Hashtable();
    private Hashtable foundFiles;
    private Vector searchPaths;

    public ResourceManager() {
        this.loadedCursors = new Hashtable();
        this.foundFiles = new Hashtable();
        this.searchPaths = new Vector();
    }

    public ResourceManager(String[] pathList) {
        this();
        if (pathList != null) {
            for (int i = 0; i < pathList.length; ++i) {
                this.addSearchPath(pathList[i]);
            }
        }
    }

    public ImageIcon getIcon(String name) {
        ImageIcon icon = (ImageIcon)this.loadedIcons.get(name);
        if (icon == null && (icon = this.loadIcon(name)) != null) {
            icon.setDescription(name);
        }
        return icon;
    }

    public Image getImage(String name) {
        Image image = (Image)this.loadedImages.get(name);
        if (image == null) {
            image = this.loadImage(name);
        }
        return image;
    }

    public Cursor getCursor(String name, int x, int y) {
        Cursor cursor = (Cursor)this.loadedCursors.get(name);
        if (cursor != null) {
            cursor = this.loadCursor(name, x, y);
        }
        return cursor;
    }

    public void addSearchPath(String path) {
        if (path != null) {
            this.searchPaths.add(path);
        }
    }

    public String findImageFile(String name) {
        if (name == null) {
            return null;
        }
        String cachedFile = (String)this.foundFiles.get(name);
        if (cachedFile != null) {
            return cachedFile;
        }
        File file = new File(name);
        if (file.isAbsolute() && file.exists()) {
            this.foundFiles.put(name, file.getPath());
            return name;
        }
        for (int i = 0; this.searchPaths != null && i < this.searchPaths.size(); ++i) {
            file = new File(this.searchPaths.get(i).toString(), name);
            if (!file.exists()) continue;
            this.foundFiles.put(name, file.getPath());
            return file.getPath();
        }
        return null;
    }

    private ImageIcon loadIcon(String name) {
        String fullFileName = this.findImageFile(name);
        if (fullFileName != null) {
            try {
                ImageIcon icon = new ImageIcon(fullFileName);
                this.loadedIcons.put(name, icon);
                return icon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Image loadImage(String name) {
        String fullFileName = this.findImageFile(name);
        if (fullFileName != null) {
            try {
                Image image = Toolkit.getDefaultToolkit().createImage(fullFileName);
                this.loadedImages.put(name, image);
                return image;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Cursor loadCursor(String name, int x, int y) {
        String fullFileName = this.findImageFile(name);
        if (fullFileName != null) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                Cursor cursor = tk.createCustomCursor(tk.createImage(new File(fullFileName).toURL()), new Point(x, y), name);
                this.loadedCursors.put(name, cursor);
                return cursor;
            }
            catch (MalformedURLException e) {
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }
}

