/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.InsTickUnits;
import com.insightful.miner.SurvivalViewer;
import com.insightful.miner.XMLTree;
import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartPanel;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.combination.AxisRange;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.chart.combination.NumberAxisRange;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DefaultXYDataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Paint;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SurvivalGraphPanel
extends JPanel {
    private SurvivalViewer m_viewer = null;
    private CombinedPlot m_overlaidPlot = null;
    private JFreeChartPanel m_graphPanel = null;
    private double[] m_survival = null;
    private double[] m_time = null;
    private double[] m_survSE = null;
    private int[] m_nFailures = null;
    private String[] m_strata = null;
    private double[] m_tRange = new double[2];
    public static final Color[] m_colors = new Color[]{Color.blue, Color.red, Color.green, Color.darkGray, Color.pink, Color.orange, Color.magenta, Color.cyan, Color.yellow, Color.black};

    public SurvivalGraphPanel() {
        super(new BorderLayout());
    }

    public SurvivalGraphPanel(SurvivalViewer viewer) {
        super(new BorderLayout());
        this.m_viewer = viewer;
    }

    public void setViewer(SurvivalViewer viewer) {
        this.m_viewer = viewer;
    }

    protected Vector extractVector(Node node, String delim) throws Exception {
        NamedNodeMap attrib = node.getAttributes();
        if (attrib.getLength() == 0) {
            throw new Exception();
        }
        node = attrib.getNamedItem("values");
        String values = node.getNodeValue();
        Vector<Object> v = new Vector<Object>();
        StringTokenizer tok = new StringTokenizer(values, delim);
        while (tok.hasMoreElements()) {
            v.add(tok.nextElement());
        }
        return v;
    }

    protected double[] extractValues(Node node, String delim) throws Exception {
        Vector v = this.extractVector(node, delim);
        double[] result = null;
        int n = v.size();
        if (n > 0) {
            result = new double[n];
            for (int i = 0; i < n; ++i) {
                result[i] = Double.parseDouble((String)v.get(i));
            }
        }
        return result;
    }

    public boolean setSurvival(XMLTree fit) {
        int i;
        Document doc = fit.getDocument();
        NodeList vals = doc.getElementsByTagName("BaselineSurvival");
        if (vals.getLength() == 0) {
            return false;
        }
        Node node = vals.item(0);
        vals = node.getChildNodes();
        NamedNodeMap attrib = node.getAttributes();
        String delim = " ";
        if (attrib.getLength() > 0 && (node = attrib.getNamedItem("delimiter")) != null) {
            delim = node.getNodeValue();
        }
        int n = vals.getLength();
        Node hazard = null;
        Node time = null;
        Node varH = null;
        Node strata = null;
        for (i = 0; i < n; ++i) {
            node = vals.item(i);
            if (node.getNodeName().equals("Time")) {
                time = node;
                continue;
            }
            if (node.getNodeName().equals("Hazard")) {
                hazard = node;
                continue;
            }
            if (node.getNodeName().equals("VarHazard")) {
                varH = node;
                continue;
            }
            if (!node.getNodeName().equals("Strata")) continue;
            strata = node;
        }
        if (time == null || hazard == null) {
            return false;
        }
        try {
            this.m_time = this.extractValues(time, delim);
            this.m_survival = this.extractValues(hazard, delim);
            if (this.m_survival.length != this.m_time.length) {
                return false;
            }
            for (i = 0; i < this.m_survival.length; ++i) {
                this.m_survival[i] = Math.exp(-this.m_survival[i]);
            }
            if (varH != null) {
                this.m_survSE = this.extractValues(varH, delim);
                for (i = 0; i < this.m_survSE.length; ++i) {
                    this.m_survSE[i] = Math.sqrt(this.m_survSE[i]);
                }
            }
            double t = 0.0;
            this.m_tRange[0] = this.m_time[0];
            this.m_tRange[1] = this.m_time[this.m_time.length - 1];
            if (strata != null) {
                String stratai;
                Vector vstrata = this.extractVector(strata, delim);
                if (vstrata.size() != this.m_time.length) {
                    return false;
                }
                n = 1;
                String strat = (String)vstrata.get(0);
                for (i = 1; i < this.m_time.length; ++i) {
                    stratai = (String)vstrata.get(i);
                    if (strat.equals(stratai)) continue;
                    strat = stratai;
                    ++n;
                }
                this.m_nFailures = new int[n];
                this.m_strata = new String[n];
                n = 1;
                int is = 0;
                this.m_strata[is] = strat = (String)vstrata.get(0);
                for (i = 1; i < this.m_time.length; ++i) {
                    stratai = (String)vstrata.get(i);
                    if (!strat.equals(stratai)) {
                        this.m_nFailures[is++] = n;
                        this.m_strata[is] = strat = stratai;
                        n = 1;
                        if (this.m_time[i] < this.m_tRange[0]) {
                            this.m_tRange[0] = this.m_time[i];
                        }
                        if (!(this.m_time[i - 1] > this.m_tRange[1])) continue;
                        this.m_tRange[1] = this.m_time[i - 1];
                        continue;
                    }
                    t += this.m_time[i] - this.m_time[i - 1];
                    ++n;
                }
                this.m_nFailures[is] = n;
                t /= (double)(this.m_time.length - this.m_nFailures.length);
            } else {
                n = this.m_time.length;
                this.m_nFailures = new int[1];
                this.m_nFailures[0] = this.m_survival.length;
                for (i = 1; i < n; ++i) {
                    t += this.m_time[i] - this.m_time[i - 1];
                }
                t /= (double)(n - 1);
            }
            this.m_tRange[0] = this.m_tRange[0] - t;
            if (this.m_tRange[0] < 0.0) {
                this.m_tRange[0] = 0.0;
            }
            this.m_tRange[1] = this.m_tRange[1] + t;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void createGraph() {
        JFreeChart chart = this.createChart();
        this.m_graphPanel = new JFreeChartPanel(chart);
        this.m_graphPanel.setPreferredSize(new Dimension(770, 300));
        this.m_graphPanel.setMinimumSize(new Dimension(770, 300));
        this.m_graphPanel.setBackground(Color.white);
        this.m_graphPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.m_graphPanel.setVisible(true);
        this.add((Component)this.m_graphPanel);
    }

    public JFreeChart getChart() {
        return this.m_graphPanel.getChart();
    }

    private JFreeChart createChart() {
        String xAxisLabel = "Time";
        String yAxisLabel = "Survival";
        String title = "Baseline Survival";
        CombinedDataset data = this.buildSurvivalDataset();
        int n = data.getSeriesCount();
        JFreeChart chart = null;
        if (n == 0) {
            return chart;
        }
        try {
            VerticalNumberAxis yAxis = new VerticalNumberAxis(yAxisLabel);
            HorizontalNumberAxis xAxis = new HorizontalNumberAxis(xAxisLabel);
            xAxis.setStandardTickUnits(InsTickUnits.createStandardTickUnits());
            yAxis.setStandardTickUnits(InsTickUnits.createStandardTickUnits());
            yAxis.setAutoRangeIncludesZero(true);
            yAxis.setLabelInsets(new Insets(0, 0, 10, 10));
            yAxis.setGridLinesVisible(false);
            xAxis.setGridLinesVisible(false);
            xAxis.setAutoRangeIncludesZero(false);
            this.m_overlaidPlot = new CombinedPlot((Axis)xAxis, (Axis)yAxis);
            this.m_overlaidPlot.setRange((AxisRange)new NumberAxisRange((Number)new Double(this.m_tRange[0]), (Number)new Double(this.m_tRange[1])), this.m_overlaidPlot.getHorizontalAxes());
            this.m_overlaidPlot.setRange((AxisRange)new NumberAxisRange((Number)new Double(0.0), (Number)new Double(1.1)), this.m_overlaidPlot.getVerticalAxes());
            this.m_overlaidPlot.setInsets(new Insets(2, 2, 15, 15));
            Paint[] strataColor = new Paint[n];
            for (int i = 0; i < n; ++i) {
                CombinedChart cc = ChartFactory.createCombinableXYChart((ValueAxis)xAxis, (ValueAxis)yAxis, (Dataset)new SubSeriesDataset((SeriesDataset)data, i));
                this.m_overlaidPlot.add(cc);
                strataColor[i] = m_colors[i % m_colors.length];
            }
            this.m_overlaidPlot.adjustPlots();
            this.m_overlaidPlot.setSeriesPaint(strataColor);
            chart = new JFreeChart((Dataset)data, (Plot)this.m_overlaidPlot, title, JFreeChart.DEFAULT_TITLE_FONT, n > 1);
        }
        catch (AxisNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        catch (PlotNotCompatibleException e) {
            System.err.println("axis not compatible.");
        }
        chart.setBackgroundPaint((Paint)Color.white);
        return chart;
    }

    private CombinedDataset buildSurvivalDataset() {
        CombinedDataset data = new CombinedDataset();
        if (this.m_time == null) {
            return data;
        }
        int n = this.m_time.length;
        if (n == 0) {
            return data;
        }
        if (this.m_survival.length != n) {
            return data;
        }
        int i = 0;
        for (int j = 0; j < this.m_nFailures.length; ++j) {
            int nj = this.m_nFailures[j];
            Object[][][] dataj = new Object[1][2 * nj + 2][2];
            dataj[0][0][0] = new Double(this.m_tRange[0]);
            dataj[0][0][1] = new Double(1.0);
            dataj[0][1][0] = new Double(this.m_time[i]);
            dataj[0][1][1] = new Double(1.0);
            for (int k = 1; k < nj; ++k) {
                dataj[0][2 * k][0] = new Double(this.m_time[i]);
                dataj[0][2 * k][1] = new Double(this.m_survival[i]);
                dataj[0][2 * k + 1][0] = new Double(this.m_time[i + 1]);
                dataj[0][2 * k + 1][1] = new Double(this.m_survival[i++]);
            }
            dataj[0][2 * k][0] = new Double(this.m_time[i]);
            dataj[0][2 * k][1] = new Double(this.m_survival[i]);
            dataj[0][2 * k + 1][0] = new Double(this.m_tRange[1]);
            dataj[0][2 * k + 1][1] = new Double(this.m_survival[i++]);
            DefaultXYDataset xyData = new DefaultXYDataset(dataj);
            if (this.m_nFailures.length > 1) {
                xyData.setSeriesNames(new String[]{this.m_strata[j]});
            }
            data.add((SeriesDataset)new SubSeriesDataset((SeriesDataset)xyData, 0));
        }
        return data;
    }

    public void releaseMemory() {
        this.removeAll();
        this.m_survival = null;
        this.m_time = null;
        this.m_survSE = null;
    }
}

