/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.SetRolesPanel;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class TreeDialog
extends NodeDialog {
    private SetRolesPanel setRolesPanel;
    private PredictionPanel predictionPanel;
    private int treeType;
    public static final int REGRESSION_TREE = 0;
    public static final int CLASSIFICATION_TREE = 1;
    private int singleTreeTab = 2;
    private int ensembleTreeTab = 3;
    private JRadioButton[] methodRadioButtons;
    private JLabel splittingCriteriaLabel;
    private JTextField beforeSplitTextField;
    private JTextField afterSplitTextField;
    private JRadioButton[] splittingRadioButtons;
    private JPanel singleOptionsPanel;
    private JTextField maxRowsTextField;
    private JTextField complexityTextField;
    private JTextField crossvalidationTextField;
    private JRadioButton[] pruningRadioButtons;
    private JPanel ensembleOptionsPanel;
    private JTextField numTreesTextField;
    private JTextField rowsPerTreeTextField;
    private JTextField minNodeDevTextField;
    private AbstractAction singleAction;
    private AbstractAction ensembleAction;
    private static TreeDialog instance = null;

    public static TreeDialog getInstance() {
        if (instance == null) {
            instance = new TreeDialog();
        }
        return instance;
    }

    private TreeDialog() {
        this.setSize(510, 550);
        this.setMinimumSize(new Dimension(475, 500));
        this.setResizable(true);
        this.chunkTextField.setEnabled(false);
        for (int i = 0; i < this.chunkButtons.length; ++i) {
            this.chunkButtons[i].setEnabled(false);
        }
    }

    public void show(ActivityNodeModel newModel, int treeType) {
        if (newModel != null) {
            this.treeType = treeType;
            this.show(newModel);
            this.chunkButtons[1].setSelected(true);
            if (treeType == 1) {
                this.setRolesPanel.changeDependentType(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                for (int i = 0; i < this.splittingRadioButtons.length; ++i) {
                    this.splittingRadioButtons[i].setEnabled(true);
                }
                this.splittingCriteriaLabel.setEnabled(true);
            } else {
                this.setRolesPanel.changeDependentType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
                for (int i = 0; i < this.splittingRadioButtons.length; ++i) {
                    this.splittingRadioButtons[i].setEnabled(false);
                }
                this.splittingCriteriaLabel.setEnabled(false);
            }
        }
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.setRolesPanel.restoreProperties(this.getNodeModel());
        this.predictionPanel.restoreProperties(this.getNodeModel(), this.treeType);
        XTProps props = this.getNodeModel().getXTProps();
        this.beforeSplitTextField.setText(props.getValue("min.size", Integer.toString(10)));
        this.afterSplitTextField.setText(props.getValue("min.cut", Integer.toString(5)));
        this.maxRowsTextField.setText(props.getValue("max.rows", Integer.toString(10000)));
        this.complexityTextField.setText(props.getValue("cp", Double.toString(0.001)));
        this.numTreesTextField.setText(props.getValue("n.trees", Integer.toString(10)));
        this.rowsPerTreeTextField.setText(props.getValue("rows.per.tree", Integer.toString(10000)));
        this.minNodeDevTextField.setText(props.getValue("min.dev", Double.toString(0.01)));
        if (props.getBoolean("tree.ensemble", false)) {
            this.methodRadioButtons[1].setSelected(true);
            this.methodRadioButtons[1].doClick();
        } else {
            this.methodRadioButtons[0].setSelected(true);
            this.methodRadioButtons[0].doClick();
        }
        if (this.treeType == 1) {
            if (props.getBoolean("split.entropy", true)) {
                this.splittingRadioButtons[1].setSelected(true);
                this.splittingRadioButtons[1].doClick();
            } else {
                this.splittingRadioButtons[0].setSelected(true);
                this.splittingRadioButtons[0].doClick();
            }
        }
        String cvValue = props.getValue("CV.k", Integer.toString(0));
        this.crossvalidationTextField.setText(cvValue);
        if (Integer.parseInt(cvValue) < 2) {
            this.pruningRadioButtons[0].setSelected(true);
            this.pruningRadioButtons[0].doClick();
            this.pruningRadioButtons[0].disable();
            this.pruningRadioButtons[1].disable();
            this.pruningRadioButtons[2].disable();
        } else {
            int i = props.getInt("prune.criterion", 0);
            if (i < 0 || i > 2) {
                i = 1;
            }
            this.pruningRadioButtons[i].setSelected(true);
            this.pruningRadioButtons[i].doClick();
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        this.setRolesPanel.saveProperties(this.getNodeModel());
        this.predictionPanel.saveProperties(this.getNodeModel(), this.treeType);
        XTProps props = this.getNodeModel().getXTProps();
        props.set("tree.ensemble", this.methodRadioButtons[1].isSelected() ? "true" : "false");
        props.set("min.size", this.beforeSplitTextField.getText());
        props.set("min.cut", this.afterSplitTextField.getText());
        if (this.treeType == 1) {
            props.set("split.entropy", this.splittingRadioButtons[1].isSelected() ? "true" : "false");
        }
        props.set("max.rows", this.maxRowsTextField.getText());
        props.set("cp", this.complexityTextField.getText());
        props.set("CV.k", this.crossvalidationTextField.getText());
        if (this.pruningRadioButtons[1].isSelected()) {
            props.set("prune.criterion", "1");
        } else if (this.pruningRadioButtons[2].isSelected()) {
            props.set("prune.criterion", "2");
        } else {
            props.set("prune.criterion", "0");
        }
        props.set("n.trees", this.numTreesTextField.getText());
        props.set("rows.per.tree", this.rowsPerTreeTextField.getText());
        props.set("min.dev", this.minNodeDevTextField.getText());
    }

    public void createActions() {
        super.createActions();
        this.singleAction = new AbstractAction(MinerApp.getText("TreeDialog_single")){

            public void actionPerformed(ActionEvent e) {
                Component[] singleComponents = TreeDialog.this.singleOptionsPanel.getComponents();
                for (int i = 0; i < singleComponents.length; ++i) {
                    singleComponents[i].setEnabled(true);
                }
                Component[] ensembleComponents = TreeDialog.this.ensembleOptionsPanel.getComponents();
                for (int i = 0; i < ensembleComponents.length; ++i) {
                    ensembleComponents[i].setEnabled(false);
                }
                TreeDialog.this.chunkTextField.setText(TreeDialog.this.maxRowsTextField.getText());
            }
        };
        this.ensembleAction = new AbstractAction(MinerApp.getText("TreeDialog_ensemble")){

            public void actionPerformed(ActionEvent e) {
                Component[] singleComponents = TreeDialog.this.singleOptionsPanel.getComponents();
                for (int i = 0; i < singleComponents.length; ++i) {
                    singleComponents[i].setEnabled(false);
                }
                Component[] ensembleComponents = TreeDialog.this.ensembleOptionsPanel.getComponents();
                for (int i = 0; i < ensembleComponents.length; ++i) {
                    ensembleComponents[i].setEnabled(true);
                }
                TreeDialog.this.chunkTextField.setText(TreeDialog.this.rowsPerTreeTextField.getText());
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.setRolesPanel = new SetRolesPanel(this.okAction, false);
        this.setRolesPanel.setExcludedColumnType(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        this.setRolesPanel.addPropertyChangeListener("dependentChange", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                TreeDialog.this.predictionPanel.dependentChanged((String)e.getNewValue());
            }
        });
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 1));
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("TreeDialog_method")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        ButtonGroup methodGroup = new ButtonGroup();
        this.methodRadioButtons = new JRadioButton[2];
        JRadioButton singleRadioButton = new JRadioButton(this.singleAction);
        singleRadioButton.setMnemonic('s');
        methodGroup.add(singleRadioButton);
        this.methodRadioButtons[0] = singleRadioButton;
        JRadioButton ensembleRadioButton = new JRadioButton(this.ensembleAction);
        ensembleRadioButton.setMnemonic('e');
        methodGroup.add(ensembleRadioButton);
        this.methodRadioButtons[1] = ensembleRadioButton;
        optionsPanel.add(singleRadioButton);
        optionsPanel.add(ensembleRadioButton);
        panel.add((Component)optionsPanel, "South");
        panel.add((Component)this.setRolesPanel, "Center");
        return panel;
    }

    private JPanel getTreeGrowthPanel() {
        JPanel treeGrowthPanel = new JPanel(new GridBagLayout());
        treeGrowthPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("TreeDialog_treeGrowth")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel minNodeSizeLabel = new JLabel(MinerApp.getText("TreeDialog_minimumNodeSize"));
        JLabel beforeSplitLabel = new JLabel(MinerApp.getText("TreeDialog_beforeAttemptSplit"));
        this.beforeSplitTextField = new JTextField(11);
        this.beforeSplitTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        beforeSplitLabel.setDisplayedMnemonic('b');
        beforeSplitLabel.setLabelFor(this.beforeSplitTextField);
        JLabel afterSplitLabel = new JLabel(MinerApp.getText("TreeDialog_afterSplit"));
        this.afterSplitTextField = new JTextField(11);
        this.afterSplitTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        afterSplitLabel.setDisplayedMnemonic('a');
        afterSplitLabel.setLabelFor(this.afterSplitTextField);
        this.splittingCriteriaLabel = new JLabel(MinerApp.getText("TreeDialog_splittingCriteria"));
        ButtonGroup splittingGroup = new ButtonGroup();
        this.splittingRadioButtons = new JRadioButton[2];
        JRadioButton giniRadioButton = new JRadioButton(MinerApp.getText("TreeDialog_gini"));
        giniRadioButton.setMnemonic('g');
        splittingGroup.add(giniRadioButton);
        this.splittingRadioButtons[0] = giniRadioButton;
        JRadioButton entropyRadioButton = new JRadioButton(MinerApp.getText("TreeDialog_entropy"));
        entropyRadioButton.setMnemonic('e');
        splittingGroup.add(entropyRadioButton);
        this.splittingRadioButtons[1] = entropyRadioButton;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 5, 0);
        treeGrowthPanel.add((Component)minNodeSizeLabel, constraints);
        constraints.gridy = 1;
        constraints.insets = new Insets(0, 15, 0, 0);
        treeGrowthPanel.add((Component)beforeSplitLabel, constraints);
        constraints.gridy = 1;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        treeGrowthPanel.add((Component)this.beforeSplitTextField, constraints);
        constraints.gridy = 2;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        treeGrowthPanel.add((Component)afterSplitLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        treeGrowthPanel.add((Component)this.afterSplitTextField, constraints);
        constraints.gridy = 3;
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 0, 10, 0);
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        treeGrowthPanel.add((Component)new JSeparator(), constraints);
        constraints.gridy = 4;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 1;
        treeGrowthPanel.add((Component)this.splittingCriteriaLabel, constraints);
        constraints.gridy = 5;
        constraints.insets = new Insets(0, 15, 0, 0);
        treeGrowthPanel.add((Component)giniRadioButton, constraints);
        constraints.gridy = 6;
        constraints.weighty = 1.0;
        treeGrowthPanel.add((Component)entropyRadioButton, constraints);
        return treeGrowthPanel;
    }

    private JPanel getGeneralOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        String name = MinerApp.getText("TreeDialog_options");
        optionsPanel.setName(name);
        optionsPanel.add((Component)this.getTreeGrowthPanel(), "North");
        return optionsPanel;
    }

    private JPanel getSingleTreeOptionsPanel() {
        this.singleOptionsPanel = new JPanel(new GridBagLayout());
        String name = MinerApp.getText("TreeDialog_singleTree");
        this.singleOptionsPanel.setName(name);
        this.singleOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(name), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel maxRowsLabel = new JLabel(MinerApp.getText("TreeDialog_maximumRows"));
        this.maxRowsTextField = new JTextField(10);
        this.maxRowsTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        this.maxRowsTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    JTextField textField = (JTextField)e.getSource();
                    TreeDialog.this.chunkTextField.setText(textField.getText());
                }
            }
        });
        maxRowsLabel.setLabelFor(this.maxRowsTextField);
        maxRowsLabel.setDisplayedMnemonic('m');
        JLabel complexityLabel = new JLabel(MinerApp.getText("TreeDialog_complexityStop"));
        this.complexityTextField = new JTextField(10);
        this.complexityTextField.setDocument(new NodeDialog.InputDoubleDoc());
        complexityLabel.setLabelFor(this.complexityTextField);
        complexityLabel.setDisplayedMnemonic('s');
        JLabel crossvalidationLabel = new JLabel(MinerApp.getText("TreeDialog_crossValidK"));
        this.crossvalidationTextField = new JTextField(10);
        this.crossvalidationTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.crossvalidationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                JTextField textField;
                int k;
                if (!e.isTemporary() && (k = Integer.parseInt((textField = (JTextField)e.getSource()).getText())) == 0) {
                    TreeDialog.this.pruningRadioButtons[0].setSelected(true);
                }
            }
        });
        crossvalidationLabel.setLabelFor(this.crossvalidationTextField);
        crossvalidationLabel.setDisplayedMnemonic('k');
        this.crossvalidationTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent ev) {
                if (!ev.isTemporary()) {
                    try {
                        int i = Integer.parseInt(TreeDialog.this.crossvalidationTextField.getText());
                        if (i < 0) {
                            TreeDialog.this.crossvalidationTextField.setText("0");
                        }
                        if (i < 2) {
                            TreeDialog.this.pruningRadioButtons[0].setSelected(true);
                            TreeDialog.this.pruningRadioButtons[0].doClick();
                            TreeDialog.this.pruningRadioButtons[0].disable();
                            TreeDialog.this.pruningRadioButtons[1].disable();
                            TreeDialog.this.pruningRadioButtons[2].disable();
                        } else {
                            TreeDialog.this.pruningRadioButtons[0].enable();
                            TreeDialog.this.pruningRadioButtons[1].enable();
                            TreeDialog.this.pruningRadioButtons[2].enable();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        JLabel pruningLabel = new JLabel(MinerApp.getText("TreeDialog_pruning"));
        ButtonGroup pruningGroup = new ButtonGroup();
        this.pruningRadioButtons = new JRadioButton[3];
        JRadioButton noPruneRadioButton = new JRadioButton(MinerApp.getText("TreeDialog_none"));
        noPruneRadioButton.setMnemonic('o');
        pruningGroup.add(noPruneRadioButton);
        this.pruningRadioButtons[0] = noPruneRadioButton;
        JRadioButton stdErrorRuleRadioButton = new JRadioButton(MinerApp.getText("TreeDialog_standardErrorRule"));
        stdErrorRuleRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int k = Integer.parseInt(TreeDialog.this.crossvalidationTextField.getText());
                if (k == 0) {
                    TreeDialog.this.crossvalidationTextField.setText("5");
                }
            }
        });
        stdErrorRuleRadioButton.setMnemonic('t');
        pruningGroup.add(stdErrorRuleRadioButton);
        this.pruningRadioButtons[1] = stdErrorRuleRadioButton;
        JRadioButton minComplexityRadioButton = new JRadioButton(MinerApp.getText("TreeDialog_minimumComplexity"));
        minComplexityRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int k = Integer.parseInt(TreeDialog.this.crossvalidationTextField.getText());
                if (k == 0) {
                    TreeDialog.this.crossvalidationTextField.setText("5");
                }
            }
        });
        minComplexityRadioButton.setMnemonic('n');
        pruningGroup.add(minComplexityRadioButton);
        this.pruningRadioButtons[2] = minComplexityRadioButton;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        this.singleOptionsPanel.add((Component)maxRowsLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.singleOptionsPanel.add((Component)this.maxRowsTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.singleOptionsPanel.add((Component)complexityLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.singleOptionsPanel.add((Component)this.complexityTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.singleOptionsPanel.add((Component)crossvalidationLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.singleOptionsPanel.add((Component)this.crossvalidationTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        constraints.fill = 1;
        constraints.insets = new Insets(10, 0, 10, 0);
        constraints.gridwidth = 5;
        this.singleOptionsPanel.add((Component)new JSeparator(), constraints);
        constraints.gridy = 4;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.gridwidth = 1;
        this.singleOptionsPanel.add((Component)pruningLabel, constraints);
        constraints.insets = new Insets(0, 15, 0, 0);
        constraints.gridy = 5;
        this.singleOptionsPanel.add((Component)noPruneRadioButton, constraints);
        constraints.gridy = 6;
        this.singleOptionsPanel.add((Component)stdErrorRuleRadioButton, constraints);
        constraints.gridy = 7;
        constraints.weighty = 1.0;
        this.singleOptionsPanel.add((Component)minComplexityRadioButton, constraints);
        return this.singleOptionsPanel;
    }

    private JPanel getEnsembleOptionsPanel() {
        this.ensembleOptionsPanel = new JPanel(new GridBagLayout());
        String name = MinerApp.getText("TreeDialog_ensemble");
        this.ensembleOptionsPanel.setName(name);
        this.ensembleOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(name), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel numTreesLabel = new JLabel(MinerApp.getText("TreeDialog_numTrees"));
        this.numTreesTextField = new JTextField(10);
        this.numTreesTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        numTreesLabel.setLabelFor(this.numTreesTextField);
        numTreesLabel.setDisplayedMnemonic('n');
        JLabel rowsPerTreeLabel = new JLabel(MinerApp.getText("TreeDialog_rowsPerTree"));
        this.rowsPerTreeTextField = new JTextField(10);
        this.rowsPerTreeTextField.setDocument(new NodeDialog.InputPositiveIntegerDoc());
        this.rowsPerTreeTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    JTextField textField = (JTextField)e.getSource();
                    TreeDialog.this.chunkTextField.setText(textField.getText());
                }
            }
        });
        rowsPerTreeLabel.setLabelFor(this.rowsPerTreeTextField);
        rowsPerTreeLabel.setDisplayedMnemonic('r');
        JLabel minNodeDevLabel = new JLabel(MinerApp.getText("TreeDialog_nodeDevStop"));
        this.minNodeDevTextField = new JTextField(10);
        this.minNodeDevTextField.setDocument(new NodeDialog.InputDoubleDoc());
        minNodeDevLabel.setLabelFor(this.minNodeDevTextField);
        minNodeDevLabel.setDisplayedMnemonic('s');
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridx = 0;
        this.ensembleOptionsPanel.add((Component)numTreesLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.ensembleOptionsPanel.add((Component)this.numTreesTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.ensembleOptionsPanel.add((Component)rowsPerTreeLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.ensembleOptionsPanel.add((Component)this.rowsPerTreeTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.ensembleOptionsPanel.add((Component)minNodeDevLabel, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 15, 0, 0);
        this.ensembleOptionsPanel.add((Component)this.minNodeDevTextField, constraints);
        return this.ensembleOptionsPanel;
    }

    public Vector createOtherTabs() {
        Vector<JPanel> panels = new Vector<JPanel>();
        panels.add(this.getGeneralOptionsPanel());
        panels.add(this.getSingleTreeOptionsPanel());
        panels.add(this.getEnsembleOptionsPanel());
        this.predictionPanel = new PredictionPanel();
        panels.add(this.predictionPanel);
        return panels;
    }
}

