/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.TwoDimChartEngineNode;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.nwoods.jgo.JGoObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class TwoDimChartDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane xColumnsScrollPane;
    private NodeDialog.SortingScrollPane yColumnsScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDList xColumnsList;
    private NodeDialog.DNDListModel xColumnsListModel;
    private NodeDialog.DNDList yColumnsList;
    private NodeDialog.DNDListModel yColumnsListModel;
    private JRadioButton[] chartTypeRadioButtons;
    private JComboBox styleComboBox;
    private JTextField maxRowsTextField;
    private JTextField shapeTextField;
    private JTextField xBinsTextField;
    private static final String[] styleEngineStrings = new String[]{TwoDimChartEngineNode.GRAYSCALE_ATTRIBUTE_TAG, TwoDimChartEngineNode.LATTICE_ATTRIBUTE_TAG, TwoDimChartEngineNode.CENTROIDS_ATTRIBUTE_TAG, TwoDimChartEngineNode.NESTED_LATTICE_ATTRIBUTE_TAG, TwoDimChartEngineNode.NESTED_CENTROIDS_ATTRIBUTE_TAG};
    public static final String[] HEXBIN_STYLE_TYPES = new String[]{MinerApp.getText("TwoDimChartDialog_grayscale"), MinerApp.getText("TwoDimChartDialog_lattice"), MinerApp.getText("TwoDimChartDialog_centroids"), MinerApp.getText("TwoDimChartDialog_nestedLattice"), MinerApp.getText("TwoDimChartDialog_nestedCentroids")};
    private Vector m_deleteOnCloseVector = null;
    private AbstractAction addxColumnsAction;
    private AbstractAction removexColumnsAction;
    private AbstractAction addyColumnsAction;
    private AbstractAction removeyColumnsAction;
    private static TwoDimChartDialog instance = null;

    public static TwoDimChartDialog getInstance() {
        if (instance == null) {
            instance = new TwoDimChartDialog();
        }
        return instance;
    }

    private TwoDimChartDialog() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(600, 500));
    }

    public void restoreProperties() {
        int i;
        XTMetaData metaData;
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.xColumnsListModel.removeAllElements();
        this.yColumnsListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propxColumns = props.getSubProperties(TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG);
        Vector propyColumns = props.getSubProperties(TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            String name = (String)names.get(i2);
            String role = (String)roles.get(i2);
            String type = (String)types.get(i2);
            if (!type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) continue;
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i2);
            if (propxColumns.contains(name)) {
                this.xColumnsListModel.addElement(info);
                propxColumns.remove(name);
                continue;
            }
            if (propyColumns.contains(name)) {
                this.yColumnsListModel.addElement(info);
                propyColumns.remove(name);
                continue;
            }
            this.availableListModel.addElement(info);
        }
        boolean hexBin = props.getBoolean(TwoDimChartEngineNode.HEX_BIN_ATTRIBUTE_TAG, true);
        this.chartTypeRadioButtons[0].setSelected(hexBin);
        this.chartTypeRadioButtons[1].setSelected(!hexBin);
        this.xBinsTextField.setEnabled(hexBin);
        this.shapeTextField.setEnabled(hexBin);
        this.styleComboBox.setEnabled(hexBin);
        this.maxRowsTextField.setEnabled(!hexBin);
        String xBins = props.getValue(TwoDimChartEngineNode.X_BINS_ATTRIBUTE_TAG, TwoDimChartEngineNode.X_BINS_DEFAULT);
        this.xBinsTextField.setText(xBins);
        String shape = props.getValue(TwoDimChartEngineNode.SHAPE_ATTRIBUTE_TAG, TwoDimChartEngineNode.SHAPE_DEFAULT);
        this.shapeTextField.setText(shape);
        String maxRows = props.getValue(TwoDimChartEngineNode.NUM_SCATTER_ATTRIBUTE_TAG, TwoDimChartEngineNode.NUM_SCATTER_DEFAULT);
        this.maxRowsTextField.setText(maxRows);
        String style = props.getValue(TwoDimChartEngineNode.STYLE_ATTRIBUTE_TAG, styleEngineStrings[0]);
        for (i = 0; i < styleEngineStrings.length && !style.equals(styleEngineStrings[i]); ++i) {
        }
        if (i == styleEngineStrings.length) {
            this.styleComboBox.setSelectedItem(HEXBIN_STYLE_TYPES[0]);
        } else {
            this.styleComboBox.setSelectedItem(HEXBIN_STYLE_TYPES[i]);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        Enumeration xColumnsColumns = this.xColumnsListModel.elements();
        while (xColumnsColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)xColumnsColumns.nextElement();
            props.set(TwoDimChartEngineNode.X_COLUMN_ATTRIBUTE_TAG, object.getText(), "");
        }
        Enumeration yColumnsColumns = this.yColumnsListModel.elements();
        while (yColumnsColumns.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)yColumnsColumns.nextElement();
            props.set(TwoDimChartEngineNode.Y_COLUMN_ATTRIBUTE_TAG, object.getText(), "");
        }
        boolean hexBin = this.chartTypeRadioButtons[0].isSelected();
        props.set(TwoDimChartEngineNode.HEX_BIN_ATTRIBUTE_TAG, hexBin);
        String maxRows = this.maxRowsTextField.getText();
        if (maxRows.equals("") && !hexBin) {
            throw new NodeDialog.DialogException(MinerApp.getText("TwoDimChartDialog_maxRowsError"));
        }
        props.set(TwoDimChartEngineNode.NUM_SCATTER_ATTRIBUTE_TAG, maxRows);
        String xBins = this.xBinsTextField.getText();
        if (xBins.equals("") && hexBin) {
            throw new NodeDialog.DialogException(MinerApp.getText("TwoDimChartDialog_xBinsError"));
        }
        props.set(TwoDimChartEngineNode.X_BINS_ATTRIBUTE_TAG, xBins);
        String shape = this.shapeTextField.getText();
        if (shape.equals("") && hexBin) {
            throw new NodeDialog.DialogException(MinerApp.getText("TwoDimChartDialog_shapeError"));
        }
        props.set(TwoDimChartEngineNode.SHAPE_ATTRIBUTE_TAG, shape);
        double numXBins = Integer.parseInt(xBins);
        double shapeVal = Double.parseDouble(shape);
        int x = (int)Math.floor(numXBins + 1.5001);
        int y = (int)(2.0 * Math.floor(numXBins * shapeVal / Math.sqrt(3.0) + 1.5001));
        int numBinsTotal = x * y;
        long checkTotal = (long)x * (long)y;
        if ((long)numBinsTotal != checkTotal) {
            throw new NodeDialog.DialogException(MinerApp.getText("TwoDimChartDialog_numBinsError"));
        }
        this.xBinsTextField.setEnabled(hexBin);
        this.shapeTextField.setEnabled(hexBin);
        props.set(TwoDimChartEngineNode.STYLE_ATTRIBUTE_TAG, styleEngineStrings[this.styleComboBox.getSelectedIndex()]);
    }

    public void createActions() {
        super.createActions();
        this.addxColumnsAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!TwoDimChartDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = TwoDimChartDialog.this.availableList.getSelectedValues();
                    int[] indices = TwoDimChartDialog.this.availableList.getSelectedIndices();
                    TwoDimChartDialog.this.availableList.getSelectionModel().clearSelection();
                    TwoDimChartDialog.this.xColumnsListModel.removeListDataListeners();
                    TwoDimChartDialog.this.availableListModel.removeListDataListeners();
                    int dif = 0;
                    for (int i = 0; i < values.length; ++i) {
                        String type;
                        if (TwoDimChartDialog.this.xColumnsListModel.isEmpty()) {
                            TwoDimChartDialog.this.xColumnsListModel.addElement(values[i]);
                            TwoDimChartDialog.this.availableListModel.removeElementAt(indices[i] - dif++);
                            continue;
                        }
                        String compareType = ((NodeDialog.ColumnInformationObject)TwoDimChartDialog.this.xColumnsListModel.get(0)).getType();
                        if (!compareType.equals(type = ((NodeDialog.ColumnInformationObject)values[i]).getType())) continue;
                        TwoDimChartDialog.this.xColumnsListModel.addElement(values[i]);
                        TwoDimChartDialog.this.availableListModel.removeElementAt(indices[i] - dif++);
                    }
                    TwoDimChartDialog.this.xColumnsListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.xColumnsScrollPane.sort();
                    TwoDimChartDialog.this.availableListModel.listContentsChanged();
                    TwoDimChartDialog.this.xColumnsListModel.listContentsChanged();
                    values = null;
                    Object var3_3 = null;
                }
            }
        };
        this.removexColumnsAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!TwoDimChartDialog.this.xColumnsList.isSelectionEmpty()) {
                    Object[] values = TwoDimChartDialog.this.xColumnsList.getSelectedValues();
                    int[] indices = TwoDimChartDialog.this.xColumnsList.getSelectedIndices();
                    TwoDimChartDialog.this.xColumnsList.getSelectionModel().clearSelection();
                    TwoDimChartDialog.this.xColumnsListModel.removeListDataListeners();
                    TwoDimChartDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        TwoDimChartDialog.this.xColumnsListModel.removeElementAt(indices[i] - i);
                        TwoDimChartDialog.this.availableListModel.addElement(values[i]);
                    }
                    TwoDimChartDialog.this.xColumnsListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.xColumnsListModel.listContentsChanged();
                    TwoDimChartDialog.this.availableListModel.listContentsChanged();
                    values = null;
                    Object var3_3 = null;
                }
            }
        };
        this.addyColumnsAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!TwoDimChartDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = TwoDimChartDialog.this.availableList.getSelectedValues();
                    int[] indices = TwoDimChartDialog.this.availableList.getSelectedIndices();
                    TwoDimChartDialog.this.availableList.getSelectionModel().clearSelection();
                    TwoDimChartDialog.this.yColumnsListModel.removeListDataListeners();
                    TwoDimChartDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        TwoDimChartDialog.this.yColumnsListModel.addElement(values[i]);
                        TwoDimChartDialog.this.availableListModel.removeElementAt(indices[i] - i);
                    }
                    TwoDimChartDialog.this.yColumnsListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.yColumnsScrollPane.sort();
                    TwoDimChartDialog.this.availableListModel.listContentsChanged();
                    TwoDimChartDialog.this.yColumnsListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeyColumnsAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!TwoDimChartDialog.this.yColumnsList.isSelectionEmpty()) {
                    Object[] values = TwoDimChartDialog.this.yColumnsList.getSelectedValues();
                    int[] indices = TwoDimChartDialog.this.yColumnsList.getSelectedIndices();
                    TwoDimChartDialog.this.yColumnsList.getSelectionModel().clearSelection();
                    TwoDimChartDialog.this.yColumnsListModel.removeListDataListeners();
                    TwoDimChartDialog.this.availableListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        TwoDimChartDialog.this.yColumnsListModel.removeElementAt(indices[i] - i);
                        TwoDimChartDialog.this.availableListModel.addElement(values[i]);
                    }
                    TwoDimChartDialog.this.yColumnsListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.availableListModel.undoRemoveListDataListeners();
                    TwoDimChartDialog.this.yColumnsListModel.listContentsChanged();
                    TwoDimChartDialog.this.availableListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getSelectColumnsPanel(), "Center");
        panel.add((Component)this.getOptionsPanel(), "South");
        return panel;
    }

    private JPanel getSelectColumnsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("TwoDimChartDialog_selectColumns")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_availableColumns"));
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 17;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addxColumnsButton = new JButton(this.addxColumnsAction);
        JButton removexColumnsButton = new JButton(this.removexColumnsAction);
        JButton addyColumnsButton = new JButton(this.addyColumnsAction);
        JButton removeyColumnsButton = new JButton(this.removeyColumnsAction);
        constraints.gridx = 5;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(3, 10, 3, 10);
        constraints.fill = 0;
        selectColumnsPanel.add((Component)addxColumnsButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removexColumnsButton, constraints);
        constraints.gridy = 7;
        selectColumnsPanel.add((Component)addyColumnsButton, constraints);
        constraints.gridy = 8;
        selectColumnsPanel.add((Component)removeyColumnsButton, constraints);
        JLabel xColumnsLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_xColumns"));
        xColumnsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.xColumnsListModel = new NodeDialog.DNDListModel();
        this.xColumnsList = new NodeDialog.DNDList(this.xColumnsListModel);
        this.xColumnsList.setCellRenderer(renderer);
        this.xColumnsScrollPane = new NodeDialog.SortingScrollPane(this.xColumnsList);
        this.xColumnsScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        JLabel yColumnsLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_yColumns"));
        yColumnsLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.yColumnsListModel = new NodeDialog.DNDListModel();
        this.yColumnsList = new NodeDialog.DNDList(this.yColumnsListModel);
        this.yColumnsList.setCellRenderer(renderer);
        this.yColumnsScrollPane = new NodeDialog.SortingScrollPane(this.yColumnsList);
        this.yColumnsScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = 6;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)xColumnsLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.xColumnsScrollPane, constraints);
        constraints.gridy = 6;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        selectColumnsPanel.add((Component)yColumnsLabel, constraints);
        constraints.gridy = 7;
        constraints.gridheight = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        selectColumnsPanel.add((Component)this.yColumnsScrollPane, constraints);
        return selectColumnsPanel;
    }

    private JPanel getOptionsPanel() {
        ButtonGroup chartTypesGroup = new ButtonGroup();
        this.chartTypeRadioButtons = new JRadioButton[2];
        JRadioButton hexbinRadioButton = new JRadioButton(MinerApp.getText("TwoDimChartDialog_hexbin"));
        chartTypesGroup.add(hexbinRadioButton);
        this.chartTypeRadioButtons[0] = hexbinRadioButton;
        hexbinRadioButton.setMnemonic(MinerApp.getText("TwoDimChartDialog_hexbinHotkey").charAt(0));
        JLabel styleLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_style"));
        this.styleComboBox = new JComboBox<String>(HEXBIN_STYLE_TYPES);
        styleLabel.setDisplayedMnemonic(MinerApp.getText("TwoDimChartDialog_styleHotkey").charAt(0));
        styleLabel.setLabelFor(this.styleComboBox);
        JLabel shapeLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_shape"));
        this.shapeTextField = new JTextField(15);
        this.styleComboBox.setPreferredSize(this.shapeTextField.getPreferredSize());
        this.shapeTextField.setPreferredSize(this.styleComboBox.getPreferredSize());
        this.shapeTextField.setDocument(new NodeDialog.InputDoubleDoc());
        shapeLabel.setDisplayedMnemonic(MinerApp.getText("TwoDimChartDialog_shapeHotkey").charAt(0));
        shapeLabel.setLabelFor(this.shapeTextField);
        JLabel xBinsLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_xBins"));
        this.xBinsTextField = new JTextField(15);
        this.xBinsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        xBinsLabel.setDisplayedMnemonic(MinerApp.getText("TwoDimChartDialog_xBinsHotkey").charAt(0));
        xBinsLabel.setLabelFor(this.xBinsTextField);
        JRadioButton scatterplotRadioButton = new JRadioButton(MinerApp.getText("TwoDimChartDialog_scatterplot"));
        chartTypesGroup.add(scatterplotRadioButton);
        this.chartTypeRadioButtons[1] = scatterplotRadioButton;
        scatterplotRadioButton.setMnemonic(MinerApp.getText("TwoDimChartDialog_scatterplotHotkey").charAt(0));
        JLabel maxRowsLabel = new JLabel(MinerApp.getText("TwoDimChartDialog_maxRows"));
        this.maxRowsTextField = new JTextField(15);
        this.maxRowsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        maxRowsLabel.setDisplayedMnemonic(MinerApp.getText("TwoDimChartDialog_maxRowsHotkey").charAt(0));
        maxRowsLabel.setLabelFor(this.maxRowsTextField);
        this.chartTypeRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean val = TwoDimChartDialog.this.chartTypeRadioButtons[0].isSelected();
                TwoDimChartDialog.this.maxRowsTextField.setEnabled(!val);
                TwoDimChartDialog.this.shapeTextField.setEnabled(val);
                TwoDimChartDialog.this.xBinsTextField.setEnabled(val);
                TwoDimChartDialog.this.styleComboBox.setEnabled(val);
            }
        });
        this.chartTypeRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean val = TwoDimChartDialog.this.chartTypeRadioButtons[1].isSelected();
                TwoDimChartDialog.this.maxRowsTextField.setEnabled(val);
                TwoDimChartDialog.this.shapeTextField.setEnabled(!val);
                TwoDimChartDialog.this.xBinsTextField.setEnabled(!val);
                TwoDimChartDialog.this.styleComboBox.setEnabled(!val);
            }
        });
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("TwoDimChartDialog_chartTypes")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        optionsPanel.add((Component)hexbinRadioButton, constraints);
        ++constraints.gridy;
        constraints.insets = new Insets(0, 20, 0, 0);
        optionsPanel.add((Component)styleLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.styleComboBox, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        optionsPanel.add((Component)shapeLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.shapeTextField, constraints);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.weightx = 0.0;
        optionsPanel.add((Component)xBinsLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        optionsPanel.add((Component)this.xBinsTextField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        optionsPanel.add((Component)scatterplotRadioButton, constraints);
        ++constraints.gridy;
        optionsPanel.add((Component)maxRowsLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        optionsPanel.add((Component)this.maxRowsTextField, constraints);
        return optionsPanel;
    }

    public void deleteNodes(Vector vec) {
        while (MinerApp.isRunning()) {
            try {
                Thread.yield();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        for (int i = 0; i < vec.size(); ++i) {
            if (!(vec.get(i) instanceof ActivityNodeModel)) continue;
            ActivityNodeModel model = (ActivityNodeModel)vec.get(i);
            BaseNodeArea area = doc.findNodeByID(model.getID());
            for (int j = 0; j < model.getNumInputs(); ++j) {
                BaseNodeArea inputArea = doc.findNodeByID(model.getAParentModel(j).getID());
                doc.removeObject((JGoObject)doc.findLinkByNodes(inputArea, area));
            }
            doc.removeObject((JGoObject)area);
            vec.remove(i);
        }
    }

    public void setDeleteOnClose(ActivityNodeModel nodeModel) {
        if (this.m_deleteOnCloseVector == null) {
            this.m_deleteOnCloseVector = new Vector();
        }
        this.m_deleteOnCloseVector.add(nodeModel);
    }

    public void onOk() {
        super.onOk();
        if (this.m_deleteOnCloseVector != null && this.m_deleteOnCloseVector.size() > 0) {
            this.deleteNodes(this.m_deleteOnCloseVector);
        }
    }

    public void onCancel() {
        super.onCancel();
        if (this.m_deleteOnCloseVector != null && this.m_deleteOnCloseVector.size() > 0) {
            this.deleteNodes(this.m_deleteOnCloseVector);
        }
    }
}

