/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsPanel;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class WorksheetPropertiesPanel
extends JPanel {
    private static final Insets GB_INSETS_NONE = new Insets(2, 0, 2, 0);
    private static final Insets GB_INSETS_INDENT = new Insets(2, 15, 2, 0);
    private boolean m_isGlobalDefaultPanel;
    private JTextField m_maxStringTextField;
    private JTextField m_maxCategoricalLevelsTextField;
    private JTextField m_numDigitsTextField;
    private JCheckBox m_stringLeftAlignCheckBox;
    private NodeDialog.DateFormatComboBox m_dateParseFormatComboBox;
    private NodeDialog.DateFormatComboBox m_dateOutputFormatComboBox;
    private JTextField m_dateCenturyCutoffTextField;
    private JTextField m_decimalSymbolsTextField;
    private JTextField m_maxBufferMBTextField;
    private JTextField m_rowsPerChunkTextField;
    private JRadioButton m_cachingYesRadioButton;
    private JRadioButton m_cachingNoRadioButton;
    private JRadioButton m_stringAlignLeftRadioButton;
    private JRadioButton m_stringAlignRightRadioButton;
    private JRadioButton m_randomSeedChangingRadioButton;
    private JRadioButton m_randomSeedFixedRadioButton;
    private JTextField m_defaultFileDirTextField;
    private JTextField m_wsdDirTextField;
    private JTextField m_splusWorkingChapterTextField;

    public WorksheetPropertiesPanel(boolean isGlobalDefaultPanel) {
        this.m_isGlobalDefaultPanel = isGlobalDefaultPanel;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("WorksheetPropertiesPanel_borderTitle")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new GridBagLayout());
        this.m_maxStringTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputIntegerDoc());
        JLabel maxStringLabel = WorksheetPropertiesPanel.createLabel(this.m_maxStringTextField, "WorksheetPropertiesPanel_maximumStringSizeLabel", "WorksheetPropertiesPanel_maximumStringSizeHotkey");
        this.m_maxCategoricalLevelsTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputIntegerDoc());
        JLabel maxLevelsLabel = WorksheetPropertiesPanel.createLabel(this.m_maxCategoricalLevelsTextField, "WorksheetPropertiesPanel_maximumCategoricalLevelsLabel", "WorksheetPropertiesPanel_maximumCategoricalLevelsHotkey");
        this.m_maxCategoricalLevelsTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                WorksheetPropertiesPanel.this.checkMaxCategoricalLevels();
            }
        });
        this.m_maxCategoricalLevelsTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    WorksheetPropertiesPanel.this.checkMaxCategoricalLevels();
                }
            }
        });
        this.m_numDigitsTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputIntegerDoc());
        JLabel numDigitsLabel = WorksheetPropertiesPanel.createLabel(this.m_numDigitsTextField, "WorksheetPropertiesPanel_numDigitsViewerLabel", "WorksheetPropertiesPanel_numDigitsViewerHotkey");
        this.m_dateParseFormatComboBox = new NodeDialog.DateParseFormatComboBox();
        JLabel dateParseStringLabel = WorksheetPropertiesPanel.createLabel(this.m_dateParseFormatComboBox, "WorksheetPropertiesPanel_dateParseStringLabel", "WorksheetPropertiesPanel_dateParseStringHotkey");
        this.m_dateOutputFormatComboBox = new NodeDialog.DateOutputFormatComboBox();
        JLabel dateFormatStringLabel = WorksheetPropertiesPanel.createLabel(this.m_dateOutputFormatComboBox, "WorksheetPropertiesPanel_dateFormatStringLabel", "WorksheetPropertiesPanel_dateFormatStringHotkey");
        this.m_dateCenturyCutoffTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputIntegerDoc());
        JLabel dateCenturyCutoffLabel = WorksheetPropertiesPanel.createLabel(this.m_dateCenturyCutoffTextField, "WorksheetPropertiesPanel_dateCenturyCutoffLabel", "WorksheetPropertiesPanel_dateCenturyCutoffHotkey");
        this.m_decimalSymbolsTextField = WorksheetPropertiesPanel.createTextField(10, null);
        JLabel decimalSymbolsLabel = WorksheetPropertiesPanel.createLabel(this.m_decimalSymbolsTextField, "WorksheetPropertiesPanel_decimalSymbolsLabel", "WorksheetPropertiesPanel_decimalSymbolsHotkey");
        int gridy = 0;
        Insets none = new Insets(2, 0, 2, 0);
        Insets frontback = new Insets(2, 10, 2, 10);
        Insets separatorIndent = new Insets(10, 10, 10, 10);
        GridBagConstraints constraints = new GridBagConstraints();
        WorksheetPropertiesPanel.addGBLabelText(this, maxStringLabel, this.m_maxStringTextField, gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, maxLevelsLabel, this.m_maxCategoricalLevelsTextField, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, numDigitsLabel, this.m_numDigitsTextField, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, dateParseStringLabel, this.m_dateParseFormatComboBox, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, dateFormatStringLabel, this.m_dateOutputFormatComboBox, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, dateCenturyCutoffLabel, this.m_dateCenturyCutoffTextField, ++gridy, constraints);
        WorksheetPropertiesPanel.addGBLabelText(this, decimalSymbolsLabel, this.m_decimalSymbolsTextField, ++gridy, constraints);
        this.m_maxBufferMBTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputPositiveIntegerDoc());
        JLabel maxBufferMBLabel = WorksheetPropertiesPanel.createLabel(this.m_maxBufferMBTextField, "WorksheetPropertiesPanel_maxBufferMBLabel", "WorksheetPropertiesPanel_maxBufferMBHotkey");
        WorksheetPropertiesPanel.addGBLabelText(this, maxBufferMBLabel, this.m_maxBufferMBTextField, ++gridy, constraints);
        this.m_rowsPerChunkTextField = WorksheetPropertiesPanel.createTextField(10, new NodeDialog.InputPositiveIntegerDoc());
        JLabel rowsPerChunkLabel = WorksheetPropertiesPanel.createLabel(this.m_rowsPerChunkTextField, "WorksheetPropertiesPanel_rowsPerChunkLabel", "WorksheetPropertiesPanel_rowsPerChunkHotkey");
        WorksheetPropertiesPanel.addGBLabelText(this, rowsPerChunkLabel, this.m_rowsPerChunkTextField, ++gridy, constraints);
        ++gridy;
        JLabel cachingLabel = WorksheetPropertiesPanel.createLabel(null, "WorksheetPropertiesPanel_cachingLabel", null);
        this.m_cachingYesRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_cachingYesLabel", "WorksheetPropertiesPanel_cachingYesHotkey");
        this.m_cachingNoRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_cachingNoLabel", "WorksheetPropertiesPanel_cachingNoHotkey");
        ButtonGroup cachingButtonGroup = new ButtonGroup();
        cachingButtonGroup.add(this.m_cachingYesRadioButton);
        cachingButtonGroup.add(this.m_cachingNoRadioButton);
        Box cacheButtonPanel = Box.createHorizontalBox();
        cacheButtonPanel.add(cachingLabel);
        cacheButtonPanel.add(Box.createHorizontalStrut(10));
        cacheButtonPanel.add(this.m_cachingYesRadioButton);
        cacheButtonPanel.add(Box.createHorizontalStrut(10));
        cacheButtonPanel.add(this.m_cachingNoRadioButton);
        WorksheetPropertiesPanel.addGB(this, cacheButtonPanel, constraints, 0, gridy, 0, 1, 0.0, this.m_isGlobalDefaultPanel ? 1.0 : 0.0, 18, 0, none);
        ++gridy;
        JLabel alignLabel = WorksheetPropertiesPanel.createLabel(null, "WorksheetPropertiesPanel_stringLeftAlignLabel", null);
        this.m_stringAlignLeftRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_leftLabel", "WorksheetPropertiesPanel_alignLeftHotkey");
        this.m_stringAlignRightRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_rightLabel", "WorksheetPropertiesPanel_alignRightHotkey");
        ButtonGroup alignButtonGroup = new ButtonGroup();
        alignButtonGroup.add(this.m_stringAlignLeftRadioButton);
        alignButtonGroup.add(this.m_stringAlignRightRadioButton);
        Box alignButtonPanel = Box.createHorizontalBox();
        alignButtonPanel.add(alignLabel);
        alignButtonPanel.add(Box.createHorizontalStrut(10));
        alignButtonPanel.add(this.m_stringAlignRightRadioButton);
        alignButtonPanel.add(Box.createHorizontalStrut(10));
        alignButtonPanel.add(this.m_stringAlignLeftRadioButton);
        WorksheetPropertiesPanel.addGB(this, alignButtonPanel, constraints, 0, gridy, 0, 1, 0.0, this.m_isGlobalDefaultPanel ? 1.0 : 0.0, 18, 0, none);
        ++gridy;
        if (!this.m_isGlobalDefaultPanel) {
            JButton useCurrentDefaultsButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_useCurrentDefaultsLabel", "WorksheetPropertiesPanel_useCurrentDefaultsHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    WorksheetPropertiesPanel.this.useCurrentDefaults();
                }
            });
            JButton useFactoryDefaultsButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_useFactoryDefaultsLabel", "WorksheetPropertiesPanel_useFactoryDefaultsHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    WorksheetPropertiesPanel.this.useFactoryDefaults();
                }
            });
            JButton setCurrentDefaultsButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_setCurrentDefaultsLabel", "WorksheetPropertiesPanel_setCurrentDefaultsHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    WorksheetPropertiesPanel.this.setCurrentDefaults();
                }
            });
            Box copyButtonsPanel = Box.createHorizontalBox();
            copyButtonsPanel.add(useCurrentDefaultsButton);
            copyButtonsPanel.add(Box.createHorizontalStrut(10));
            copyButtonsPanel.add(useFactoryDefaultsButton);
            copyButtonsPanel.add(Box.createHorizontalStrut(10));
            copyButtonsPanel.add(setCurrentDefaultsButton);
            WorksheetPropertiesPanel.addGB(this, copyButtonsPanel, constraints, 0, gridy, 0, 1, 0.0, 0.0, 18, 0, none);
            WorksheetPropertiesPanel.addGB(this, new JSeparator(0), constraints, 0, ++gridy, 0, 1, 1.0, 0.0, 18, 1, separatorIndent);
            ++gridy;
            JLabel randomSeedLabel = WorksheetPropertiesPanel.createLabel(null, "WorksheetPropertiesPanel_randomSeedLabel", null);
            this.m_randomSeedChangingRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_randomSeedChangingLabel", "WorksheetPropertiesPanel_randomSeedChangingHotkey");
            this.m_randomSeedFixedRadioButton = WorksheetPropertiesPanel.createRadioButton("WorksheetPropertiesPanel_randomSeedFixedLabel", "WorksheetPropertiesPanel_randomSeedFixedHotkey");
            ButtonGroup randomSeedButtonGroup = new ButtonGroup();
            randomSeedButtonGroup.add(this.m_randomSeedChangingRadioButton);
            randomSeedButtonGroup.add(this.m_randomSeedFixedRadioButton);
            Box randomButtonPanel = Box.createHorizontalBox();
            randomButtonPanel.add(randomSeedLabel);
            randomButtonPanel.add(Box.createHorizontalStrut(10));
            randomButtonPanel.add(this.m_randomSeedFixedRadioButton);
            randomButtonPanel.add(Box.createHorizontalStrut(10));
            randomButtonPanel.add(this.m_randomSeedChangingRadioButton);
            WorksheetPropertiesPanel.addGB(this, randomButtonPanel, constraints, 0, gridy, 0, 1, 0.0, 0.0, 18, 0, none);
            this.m_defaultFileDirTextField = WorksheetPropertiesPanel.createTextField(25, null);
            JLabel defaultFileDirLabel = WorksheetPropertiesPanel.createLabel(this.m_defaultFileDirTextField, "WorksheetPropertiesPanel_defaultFileDirLabel", "WorksheetPropertiesPanel_defaultFileDirHotkey");
            JButton defaultFileDirBrowseButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_defaultFileDirBrowseLabel", "WorksheetPropertiesPanel_defaultFileDirBrowseHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String newPath = WorksheetPropertiesPanel.this.browseForDirectory(WorksheetPropertiesPanel.this.m_defaultFileDirTextField.getText());
                    if (newPath != null) {
                        WorksheetPropertiesPanel.this.m_defaultFileDirTextField.setText(newPath);
                    }
                }
            });
            WorksheetPropertiesPanel.addGB(this, defaultFileDirLabel, constraints, 0, ++gridy, 1, 1, 0.0, 0.0, 17, 0, none);
            WorksheetPropertiesPanel.addGB(this, this.m_defaultFileDirTextField, constraints, 2, gridy, 2, 1, 1.0, 0.0, 10, 2, frontback);
            WorksheetPropertiesPanel.addGB(this, defaultFileDirBrowseButton, constraints, 4, gridy, 1, 1, 0.0, 0.0, 12, 0, none);
            this.m_wsdDirTextField = WorksheetPropertiesPanel.createTextField(25, null);
            JLabel wsdDirLabel = WorksheetPropertiesPanel.createLabel(this.m_wsdDirTextField, "WorksheetPropertiesPanel_wsdDirLabel", "WorksheetPropertiesPanel_wsdDirHotkey");
            JButton wsdDirBrowseButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_wsdDirBrowseLabel", "WorksheetPropertiesPanel_wsdDirBrowseHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String newPath = WorksheetPropertiesPanel.this.browseForDirectory(WorksheetPropertiesPanel.this.m_wsdDirTextField.getText());
                    if (newPath != null) {
                        WorksheetPropertiesPanel.this.m_wsdDirTextField.setText(newPath);
                    }
                }
            });
            WorksheetPropertiesPanel.addGB(this, wsdDirLabel, constraints, 0, ++gridy, 1, 1, 0.0, 0.0, 18, 0, none);
            WorksheetPropertiesPanel.addGB(this, this.m_wsdDirTextField, constraints, 2, gridy, 2, 1, 1.0, 0.0, 18, 2, frontback);
            WorksheetPropertiesPanel.addGB(this, wsdDirBrowseButton, constraints, 4, gridy, 1, 1, 0.0, 0.0, 12, 0, none);
            this.m_splusWorkingChapterTextField = WorksheetPropertiesPanel.createTextField(25, null);
            JLabel splusWorkingChapterLabel = WorksheetPropertiesPanel.createLabel(this.m_splusWorkingChapterTextField, "WorksheetPropertiesPanel_splusWorkingChapterLabel", "WorksheetPropertiesPanel_splusWorkingChapterHotkey");
            JButton splusWorkingChapterBrowseButton = WorksheetPropertiesPanel.createButton("WorksheetPropertiesPanel_splusWorkingChapterBrowseLabel", "WorksheetPropertiesPanel_splusWorkingChapterBrowseHotkey", new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    String newPath = WorksheetPropertiesPanel.this.browseForDirectory(WorksheetPropertiesPanel.this.m_splusWorkingChapterTextField.getText());
                    if (newPath != null) {
                        WorksheetPropertiesPanel.this.m_splusWorkingChapterTextField.setText(newPath);
                    }
                }
            });
            WorksheetPropertiesPanel.addGB(this, splusWorkingChapterLabel, constraints, 0, ++gridy, 1, 1, 0.0, 1.0, 18, 0, none);
            WorksheetPropertiesPanel.addGB(this, this.m_splusWorkingChapterTextField, constraints, 2, gridy, 2, 1, 1.0, 1.0, 18, 2, frontback);
            WorksheetPropertiesPanel.addGB(this, splusWorkingChapterBrowseButton, constraints, 4, gridy, 1, 1, 0.0, 1.0, 12, 0, none);
            ++gridy;
        }
    }

    public void useCurrentDefaults() {
        try {
            XTProps props = new XTProps();
            WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, MinerApp.getGlobalOptions());
            this.restoreDefaultingProperties(props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void useFactoryDefaults() {
        try {
            XTProps props = new XTProps();
            WorksheetPropertiesManager.copyBlankWorksheetPropsFromFactoryDefaults(props);
            this.restoreDefaultingProperties(props);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setCurrentDefaults() {
        try {
            XTProps props = new XTProps();
            this.saveDefaultingProperties(props);
            XTProps globalProps = MinerApp.getGlobalOptions();
            WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, globalProps);
            WorksheetPropertiesManager.setWorksheetPropsToBlank(globalProps);
            WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(globalProps, props);
            MinerApp.updateWorksheetPropertiesManager();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void restoreProperties(XTProps props) {
        this.restoreDefaultingProperties(props);
        if (!this.m_isGlobalDefaultPanel) {
            String randomSeedString = props.getValue("randomSeed", "newSeedEveryTime");
            boolean fixSeed = randomSeedString.equals("enterSeed");
            if (fixSeed) {
                this.m_randomSeedFixedRadioButton.setSelected(true);
            } else {
                this.m_randomSeedChangingRadioButton.setSelected(true);
            }
            this.m_defaultFileDirTextField.setText(props.getValue("defaultFileDir", ""));
            this.m_wsdDirTextField.setText(props.getValue("wsdDir", ""));
            this.m_splusWorkingChapterTextField.setText(props.getValue("splusWorkingChapter", ""));
        }
    }

    public void saveProperties(XTProps props) {
        this.saveDefaultingProperties(props);
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, MinerApp.getGlobalOptions());
        if (!this.m_isGlobalDefaultPanel) {
            String randomSeedString = this.m_randomSeedFixedRadioButton.isSelected() ? "enterSeed" : "newSeedEveryTime";
            props.set("randomSeed", randomSeedString);
            props.set("defaultFileDir", this.m_defaultFileDirTextField.getText());
            props.set("wsdDir", this.m_wsdDirTextField.getText());
            props.set("splusWorkingChapter", this.m_splusWorkingChapterTextField.getText());
        }
    }

    public void restoreDefaultingProperties(XTProps props) {
        int stringSize = props.getInt("maxStringSize", 33);
        this.m_maxStringTextField.setText(ModifyColumnsPanel.stringSizeIntToUserString(stringSize));
        this.m_maxCategoricalLevelsTextField.setText(props.getValue("maxCategoricalLevels", ""));
        this.checkMaxCategoricalLevels();
        this.m_numDigitsTextField.setText(props.getValue("numDigits", ""));
        this.m_dateParseFormatComboBox.setText(props.getValue("dateParseString", ""));
        this.m_dateOutputFormatComboBox.setText(props.getValue("dateFormatString", ""));
        this.m_dateCenturyCutoffTextField.setText(props.getValue("dateCenturyCutoff", ""));
        this.m_decimalSymbolsTextField.setText(props.getValue("decimalSymbols", ""));
        this.m_maxBufferMBTextField.setText(props.getValue("maxBufferMB", ""));
        this.m_rowsPerChunkTextField.setText(props.getValue("rowsToChunk", ""));
        String useCacheValue = props.getValue("useCache", "yes");
        if (useCacheValue.equals("no")) {
            this.m_cachingNoRadioButton.setSelected(true);
        } else {
            this.m_cachingYesRadioButton.setSelected(true);
        }
        boolean leftAlign = props.getBoolean("stringLeftAlign", false);
        this.m_stringAlignLeftRadioButton.setSelected(leftAlign);
        this.m_stringAlignRightRadioButton.setSelected(!leftAlign);
    }

    public void saveDefaultingProperties(XTProps props) {
        String tfString = this.m_maxStringTextField.getText();
        int sizeInt = ModifyColumnsPanel.userStringToStringSizeInt(this, tfString);
        props.set("maxStringSize", sizeInt < 0 ? "" : Integer.toString(sizeInt));
        this.checkMaxCategoricalLevels();
        tfString = this.m_maxCategoricalLevelsTextField.getText();
        props.set("maxCategoricalLevels", tfString);
        tfString = this.m_numDigitsTextField.getText();
        props.set("numDigits", tfString);
        tfString = this.m_dateParseFormatComboBox.getText();
        props.set("dateParseString", tfString);
        tfString = this.m_dateOutputFormatComboBox.getText();
        props.set("dateFormatString", tfString);
        tfString = this.m_dateCenturyCutoffTextField.getText();
        props.set("dateCenturyCutoff", tfString);
        tfString = this.m_decimalSymbolsTextField.getText();
        props.set("decimalSymbols", tfString);
        tfString = this.m_maxBufferMBTextField.getText();
        props.set("maxBufferMB", tfString);
        tfString = this.m_rowsPerChunkTextField.getText();
        props.set("rowsToChunk", tfString);
        String useCacheValue = "yes";
        if (this.m_cachingNoRadioButton.isSelected()) {
            useCacheValue = "no";
        }
        props.set("useCache", useCacheValue);
        props.set("stringLeftAlign", this.m_stringAlignLeftRadioButton.isSelected());
    }

    protected static JTextField createTextField(int size, Document doc) {
        JTextField tf = new JTextField(size);
        if (doc != null) {
            tf.setDocument(doc);
        }
        return tf;
    }

    protected static JLabel createLabel(Component c, String labelTag, String hotKeyTag) {
        String hotKeyString;
        JLabel label = new JLabel(MinerApp.getText(labelTag));
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            label.setDisplayedMnemonic(hotKeyString.charAt(0));
        }
        label.setLabelFor(c);
        return label;
    }

    protected static JCheckBox createCheckBox(String labelTag, String hotKeyTag) {
        String hotKeyString;
        JCheckBox cb = new JCheckBox(MinerApp.getText(labelTag));
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            cb.setMnemonic(hotKeyString.charAt(0));
        }
        return cb;
    }

    protected static JRadioButton createRadioButton(String labelTag, String hotKeyTag) {
        String hotKeyString;
        JRadioButton rb = new JRadioButton(MinerApp.getText(labelTag));
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            rb.setMnemonic(hotKeyString.charAt(0));
        }
        return rb;
    }

    protected static JButton createButton(String labelTag, String hotKeyTag, Action action) {
        String hotKeyString;
        String label = MinerApp.getText(labelTag);
        JButton b = null;
        if (action == null) {
            b = new JButton(label);
        } else {
            action.putValue("Name", label);
            b = new JButton(action);
        }
        if (hotKeyTag != null && (hotKeyString = MinerApp.getText(hotKeyTag)) != null && hotKeyString.length() > 0) {
            b.setMnemonic(hotKeyString.charAt(0));
        }
        return b;
    }

    private void checkMaxCategoricalLevels() {
        block5: {
            try {
                String str = this.m_maxCategoricalLevelsTextField.getText();
                int val = Integer.parseInt(str);
                int minVal = 500;
                int maxVal = 65534;
                if (val < minVal) {
                    this.m_maxCategoricalLevelsTextField.setText(Integer.toString(minVal));
                } else if (val > maxVal) {
                    this.m_maxCategoricalLevelsTextField.setText(Integer.toString(maxVal));
                }
            }
            catch (Exception ex) {
                if (!this.m_isGlobalDefaultPanel) break block5;
                this.m_maxCategoricalLevelsTextField.setText(Integer.toString(500));
            }
        }
    }

    public static void setGB(GridBagConstraints constraints, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = gridwidth;
        constraints.gridheight = gridheight;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.anchor = anchor;
        constraints.fill = fill;
        constraints.insets = insets;
    }

    public static void addGB(JPanel panel, Component comp, GridBagConstraints constraints, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        WorksheetPropertiesPanel.setGB(constraints, gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, insets);
        panel.add(comp, constraints);
    }

    public static void addGBLabelText(JPanel panel, Component labelComp, Component textComp, int gridy, GridBagConstraints constraints) {
        WorksheetPropertiesPanel.addGB(panel, labelComp, constraints, 0, gridy, 1, 1, 0.0, 0.0, 18, 0, GB_INSETS_NONE);
        WorksheetPropertiesPanel.addGB(panel, textComp, constraints, 2, gridy, 0, 1, 1.0, 0.0, 12, 2, GB_INSETS_INDENT);
    }

    public static void addGBLastLabelText(JPanel panel, Component labelComp, Component textComp, int gridy, GridBagConstraints constraints) {
        WorksheetPropertiesPanel.addGB(panel, labelComp, constraints, 0, gridy, 1, 1, 0.0, 1.0, 18, 0, GB_INSETS_NONE);
        WorksheetPropertiesPanel.addGB(panel, textComp, constraints, 2, gridy, 0, 1, 1.0, 0.0, 12, 2, GB_INSETS_INDENT);
    }

    private String browseForDirectory(String initPath) {
        return WorksheetPropertiesPanel.browseForDirectory(this, initPath, true);
    }

    public static String browseForDirectory(Component comp, String initPath) {
        return WorksheetPropertiesPanel.browseForDirectory(comp, initPath, true);
    }

    public static String browseForFile(Component comp, String initPath) {
        return WorksheetPropertiesPanel.browseForDirectory(comp, initPath, false);
    }

    private static String browseForDirectory(Component comp, String initPath, boolean directoriesOnly) {
        File file;
        int returnVal;
        WideFileChooser chooser = new WideFileChooser(initPath);
        if (directoriesOnly) {
            chooser.setFileSelectionMode(1);
        }
        if ((returnVal = chooser.showOpenDialog(comp)) == 0 && (file = chooser.getSelectedFile()) != null) {
            return file.getPath();
        }
        return null;
    }

    private void setTextFieldIfNotEmpty(JTextField tf, String newVal) {
        String oldVal = tf.getText();
        if (oldVal == null || oldVal.equals("")) {
            tf.setText(newVal);
        }
    }

    private void setComboBoxIfNotEmpty(NodeDialog.DateFormatComboBox comboBox, String newVal) {
        String oldVal = comboBox.getText();
        if (oldVal == null || oldVal.equals("")) {
            comboBox.setText(newVal);
        }
    }

    public static void main(String[] args) {
        Dimension min = new Dimension(675, 490);
        WorksheetPropertiesPanel panel = new WorksheetPropertiesPanel(false);
        try {
            panel.restoreProperties(new XTProps());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JFrame frame = new JFrame("worksheet props");
        frame.getContentPane().add(panel);
        frame.setSize(min);
        frame.setVisible(true);
        WorksheetPropertiesPanel panel2 = new WorksheetPropertiesPanel(true);
        try {
            panel2.restoreProperties(new XTProps());
        }
        catch (Exception ex) {
            // empty catch block
        }
        JFrame frame2 = new JFrame("default props");
        frame2.getContentPane().add(panel2);
        frame2.setSize(min);
        frame2.setVisible(true);
    }
}

