/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graph;

import com.insightful.controls.SplusDialog;
import com.insightful.gdevice.SCanvasPaneController;
import com.insightful.miner.MinerApp;
import com.insightful.miner.graph.CanvasTabbedPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GraphOptionsDialog
extends JDialog {
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    ButtonListener buttonListener;
    JPanel buttonPanel;
    JPanel colorSchemePanel;
    ButtonGroup grpNewGraph;
    JComboBox colorScheme;
    JCheckBox m_cbDisplayMouse = new JCheckBox(MinerApp.getText("graph_frame_displayMousePosition"));
    JCheckBox m_cbDisplayActive = new JCheckBox(MinerApp.getText("graph_frame_enableActiveRegions"));
    JTextField m_tfMouseFractionDigits = new JTextField(3);
    private static final String NEW_TAB_IN_EXPRESSION = MinerApp.getText("graph_frame_deleteThenAddNewPages");
    private static final String NEW_TAB = MinerApp.getText("graph_frame_new_page");
    private static final String EXISTING_TAB = MinerApp.getText("graph_frame_reuse_page");

    public GraphOptionsDialog() {
        this(MinerApp.getMainFrame());
    }

    public GraphOptionsDialog(Frame frame) {
        super(frame, "Graph Options", true);
        try {
            JPanel box = GraphOptionsDialog.makeTitleBox(null);
            JPanel panelGraphReaction = GraphOptionsDialog.makeTitleBox(MinerApp.getText("graph_frame_new_plot_action"));
            this.grpNewGraph = new ButtonGroup();
            int currentClearReaction = CanvasTabbedPane.getClearReaction();
            JRadioButton radio = new JRadioButton(NEW_TAB_IN_EXPRESSION, currentClearReaction == 0);
            radio.setActionCommand(NEW_TAB_IN_EXPRESSION);
            radio.setToolTipText("Delete any existing pages, and then add a new page with each plot");
            this.grpNewGraph.add(radio);
            panelGraphReaction.add(radio);
            radio = new JRadioButton(NEW_TAB, currentClearReaction == 1);
            radio.setActionCommand(NEW_TAB);
            radio.setToolTipText("Add a new page with each plot");
            this.grpNewGraph.add(radio);
            panelGraphReaction.add(radio);
            radio = new JRadioButton(EXISTING_TAB, currentClearReaction == 2);
            radio.setActionCommand(EXISTING_TAB);
            radio.setToolTipText("Reuse the current page with each plot");
            this.grpNewGraph.add(radio);
            panelGraphReaction.add(radio);
            this.buttonPanel = new JPanel();
            this.buttonListener = new ButtonListener();
            this.okButton = new JButton(MinerApp.getText("graph_frame_ok"));
            this.okButton.addActionListener(this.buttonListener);
            this.cancelButton = new JButton(MinerApp.getText("graph_frame_cancel"));
            this.cancelButton.addActionListener(this.buttonListener);
            this.helpButton = new JButton(MinerApp.getText("graph_frame_help"));
            this.helpButton.addActionListener(this.buttonListener);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(this.helpButton);
            this.getRootPane().setDefaultButton(this.okButton);
            JPanel mousePanel = GraphOptionsDialog.makeTitleBox(MinerApp.getText("graph_frame_mouse_actions"));
            mousePanel.add(GraphOptionsDialog.makeLeftFlowPanel(this.m_cbDisplayActive));
            mousePanel.add(GraphOptionsDialog.makeLeftFlowPanel(this.m_cbDisplayMouse));
            mousePanel.add(GraphOptionsDialog.makeLeftFlowPanel(new JLabel(MinerApp.getText("graph_frame_mousePositionDigits")), this.m_tfMouseFractionDigits));
            this.m_cbDisplayMouse.setSelected(SCanvasPaneController.getShowMouseLocation());
            this.m_cbDisplayActive.setSelected(SCanvasPaneController.getShowActiveRegions());
            this.m_tfMouseFractionDigits.setText(Integer.toString(SCanvasPaneController.getLocatorFractionDigits()));
            box.add(panelGraphReaction);
            box.add(Box.createVerticalStrut(5));
            box.add(mousePanel);
            box.setAlignmentX(0.0f);
            this.getContentPane().add((Component)box, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.pack();
            SplusDialog.centerComponent((Component)this, (Component)MinerApp.getMainFrame());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    static JPanel makeTitleBox(String title) {
        JPanel panel = new JPanel();
        if (title != null) {
            panel.setBorder(BorderFactory.createTitledBorder(title));
        }
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setAlignmentX(0.0f);
        return panel;
    }

    static JPanel makeLeftFlowPanel(JComponent comp) {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add(comp);
        return panel;
    }

    static JPanel makeLeftFlowPanel(JComponent comp1, JComponent comp2) {
        JPanel panel = GraphOptionsDialog.makeLeftFlowPanel(comp1);
        panel.add(comp2);
        return panel;
    }

    String getSelectedColorSchemeName() {
        return (String)this.colorScheme.getSelectedItem();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            JButton buttonPressed = (JButton)ae.getSource();
            if (buttonPressed == GraphOptionsDialog.this.okButton) {
                String strNewGraph = GraphOptionsDialog.this.grpNewGraph.getSelection().getActionCommand();
                if (strNewGraph.equals(NEW_TAB_IN_EXPRESSION)) {
                    CanvasTabbedPane.setClearReaction(0);
                } else if (strNewGraph.equals(NEW_TAB)) {
                    CanvasTabbedPane.setClearReaction(1);
                } else {
                    CanvasTabbedPane.setClearReaction(2);
                }
                SCanvasPaneController.setShowMouseLocation((boolean)GraphOptionsDialog.this.m_cbDisplayMouse.isSelected());
                SCanvasPaneController.setShowActiveRegions((boolean)GraphOptionsDialog.this.m_cbDisplayActive.isSelected());
                try {
                    SCanvasPaneController.setLocatorFractionDigits((int)Integer.parseInt(GraphOptionsDialog.this.m_tfMouseFractionDigits.getText()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                GraphOptionsDialog.this.dispose();
            } else if (buttonPressed == GraphOptionsDialog.this.cancelButton) {
                GraphOptionsDialog.this.dispose();
            } else if (buttonPressed == GraphOptionsDialog.this.helpButton) {
                MinerApp.getHelpManager().showTopic(GraphOptionsDialog.this.getTitle());
            }
        }
    }
}

