/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusElementHyperlink;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.parser.PObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.texteditor.ITextEditor;

public class SplusElementHyperlinkDetector
implements IHyperlinkDetector {
    private ITextEditor fTextEditor;

    public SplusElementHyperlinkDetector(ITextEditor iTextEditor) {
        this.fTextEditor = iTextEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHyperlink[] detectHyperlinks(ITextViewer iTextViewer, IRegion iRegion, boolean bl) {
        if (iRegion == null || bl || !(this.fTextEditor instanceof SplusEditor)) {
            return null;
        }
        int n = iRegion.getOffset();
        IDocument iDocument = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
        PObject pObject = ((SplusEditor)this.fTextEditor).getParseTree();
        if (pObject == null) {
            return null;
        }
        PObject pObject2 = null;
        PObject pObject3 = pObject;
        synchronized (pObject3) {
            try {
                int n2 = iDocument.getLineOfOffset(n);
                int n3 = iDocument.getLineOffset(n2);
                pObject2 = SplusParseTreeBuilder.findNamePObject(pObject, n2, n - n3);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        if (pObject2 != null) {
            return new IHyperlink[]{new SplusElementHyperlink(this.selectWord(iDocument, n))};
        }
        return null;
    }

    private IRegion selectWord(IDocument iDocument, int n) {
        try {
            char c;
            int n2;
            for (n2 = n; n2 >= 0 && (c = iDocument.getChar(n2)) != '_' && (c == '.' || Character.isJavaIdentifierPart(c)); --n2) {
            }
            int n3 = n2;
            int n4 = iDocument.getLength();
            for (n2 = n; n2 < n4 && (c = iDocument.getChar(n2)) != '_' && (c == '.' || Character.isJavaIdentifierPart(c)); ++n2) {
            }
            int n5 = n2;
            if (n3 == n5) {
                return new Region(n3, 0);
            }
            return new Region(n3 + 1, n5 - n3 - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

