/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.util;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusWordDetector;
import com.insightful.splus.eclipse.preferences.SplusEditorPreferencePage;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class SplusTextHover
implements ITextHover,
ITextHoverExtension,
IInformationControlCreator {
    private NoConnection m_connection = null;

    private NoConnection getConnection() {
        if (this.m_connection == null) {
            this.m_connection = SplusEditorPlugin.getDefault().getConnection();
        }
        return this.m_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHoverInfo(ITextViewer iTextViewer, IRegion iRegion) {
        block14: {
            if (iRegion != null) {
                try {
                    int n = iRegion.getOffset();
                    int n2 = iRegion.getLength();
                    if (n2 <= -1) break block14;
                    SplusWordDetector splusWordDetector = new SplusWordDetector();
                    IDocument iDocument = iTextViewer.getDocument();
                    if (n2 == 0) {
                        int n3;
                        int n4 = 0;
                        for (n3 = iRegion.getOffset(); n3 >= 0 && splusWordDetector.isWordPart(iDocument.getChar(n3)); --n3) {
                        }
                        for (n4 = ++n3; n4 < iDocument.getLength() && splusWordDetector.isWordPart(iDocument.getChar(n4)); ++n4) {
                        }
                        n = n3;
                        n2 = n4 - n3;
                    }
                    String string = iDocument.get(n, n2);
                    if (!SplusEditorPreferencePage.getHoverEvaluation()) {
                        return string;
                    }
                    SplusEditorPlugin.getDefault().setSplusBusy(true);
                    String string2 = string;
                    try {
                        string2 = this.getConnection().getHoverText(string);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        string2 = "object too big";
                    }
                    catch (Throwable throwable) {
                        string2 = "object not retrieved";
                    }
                    finally {
                        SplusEditorPlugin.getDefault().setSplusBusy(false);
                    }
                    return string2;
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    public IRegion getHoverRegion(ITextViewer iTextViewer, int n) {
        Point point = iTextViewer.getSelectedRange();
        if (point.x <= n && n < point.x + point.y) {
            return new Region(point.x, point.y);
        }
        return new Region(n, 0);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this;
    }

    public IInformationControl createInformationControl(Shell shell) {
        return new SplusInformationControl(shell);
    }

    private class SplusInformationControl
    extends DefaultInformationControl {
        private int m_width;
        private int m_height;

        public SplusInformationControl(Shell shell) {
            super(shell);
        }

        public Point computeSizeHint() {
            Point point = super.computeSizeHint();
            this.m_width = point.x;
            this.m_height = point.y;
            return point;
        }

        public void setSize(int n, int n2) {
            super.setSize(this.m_width, this.m_height);
        }
    }
}

