/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantFloat
extends Constant
implements ConstantObject {
    private float bytes;

    public ConstantFloat(float f) {
        super((byte)4);
        this.bytes = f;
    }

    public ConstantFloat(ConstantFloat constantFloat) {
        this(constantFloat.getBytes());
    }

    ConstantFloat(DataInputStream dataInputStream) throws IOException {
        this(dataInputStream.readFloat());
    }

    public void accept(Visitor visitor) {
        visitor.visitConstantFloat(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.tag);
        dataOutputStream.writeFloat(this.bytes);
    }

    public final float getBytes() {
        return this.bytes;
    }

    public final void setBytes(float f) {
        this.bytes = f;
    }

    public final String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    public Object getConstantValue(ConstantPool constantPool) {
        return new Float(this.bytes);
    }
}

