/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedBlockingQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -6903933977591709194L;
    private final int capacity;
    private final AtomicInteger count = new AtomicInteger(0);
    private transient Node<E> head;
    private transient Node<E> last;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final ReentrantLock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotEmpty() {
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNotFull() {
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            reentrantLock.unlock();
        }
    }

    private void insert(E e) {
        this.last.next = new Node<E>(e);
        this.last = this.last.next;
    }

    private E extract() {
        Node node = this.head.next;
        this.head = node;
        Object e = node.item;
        node.item = null;
        return e;
    }

    private void fullyLock() {
        this.putLock.lock();
        this.takeLock.lock();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    public LinkedBlockingQueue() {
        this(Integer.MAX_VALUE);
    }

    public LinkedBlockingQueue(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n;
        this.head = new Node<Object>(null);
        this.last = this.head;
    }

    public LinkedBlockingQueue(Collection<? extends E> collection) {
        this(Integer.MAX_VALUE);
        for (E e : collection) {
            this.add(e);
        }
    }

    @Override
    public int size() {
        return this.count.get();
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.count.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        AtomicInteger atomicInteger = this.count;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (atomicInteger.get() == this.capacity) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notFull.signal();
                throw interruptedException;
            }
            this.insert(e);
            n = atomicInteger.getAndIncrement();
            if (n + 1 < this.capacity) {
                this.notFull.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean offer(E var1_1, long var2_2, TimeUnit var4_3) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == this.capacity) {
            return false;
        }
        int n = -1;
        ReentrantLock reentrantLock = this.putLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() < this.capacity) {
                this.insert(e);
                n = atomicInteger.getAndIncrement();
                if (n + 1 < this.capacity) {
                    this.notFull.signal();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == 0) {
            this.signalNotEmpty();
        }
        return n >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        E e;
        int n = -1;
        AtomicInteger atomicInteger = this.count;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lockInterruptibly();
        try {
            try {
                while (atomicInteger.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException interruptedException) {
                this.notEmpty.signal();
                throw interruptedException;
            }
            e = this.extract();
            n = atomicInteger.getAndDecrement();
            if (n > 1) {
                this.notEmpty.signal();
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long var1_1, TimeUnit var3_2) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        AtomicInteger atomicInteger = this.count;
        if (atomicInteger.get() == 0) {
            return null;
        }
        E e = null;
        int n = -1;
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            if (atomicInteger.get() > 0) {
                e = this.extract();
                n = atomicInteger.getAndDecrement();
                if (n > 1) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            reentrantLock.unlock();
        }
        if (n == this.capacity) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        if (this.count.get() == 0) {
            return null;
        }
        ReentrantLock reentrantLock = this.takeLock;
        reentrantLock.lock();
        try {
            Node node = this.head.next;
            if (node == null) {
                E e = null;
                return e;
            }
            Object e = node.item;
            return e;
        }
        finally {
            reentrantLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        this.fullyLock();
        try {
            Node<E> node = this.head;
            Node node2 = this.head.next;
            while (node2 != null) {
                if (object.equals(node2.item)) {
                    bl = true;
                    break;
                }
                node = node2;
                node2 = node2.next;
            }
            if (bl) {
                node2.item = null;
                node.next = node2.next;
                if (this.last == node2) {
                    this.last = node;
                }
                if (this.count.getAndDecrement() == this.capacity) {
                    this.notFull.signalAll();
                }
            }
        }
        finally {
            this.fullyUnlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.fullyLock();
        try {
            int n = this.count.get();
            Object[] objectArray = new Object[n];
            int n2 = 0;
            Object object = this.head.next;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] objectArray) {
        this.fullyLock();
        try {
            int n = this.count.get();
            if (objectArray.length < n) {
                objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
            }
            int n2 = 0;
            Object object = this.head.next;
            while (object != null) {
                objectArray[n2++] = object.item;
                object = object.next;
            }
            if (objectArray.length > n2) {
                objectArray[n2] = null;
            }
            object = objectArray;
            return object;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        this.fullyLock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fullyLock();
        try {
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signalAll();
            }
        }
        finally {
            this.fullyUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection) {
        Node node;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.fullyLock();
        try {
            node = this.head.next;
            this.head.next = null;
            assert (this.head.item == null);
            this.last = this.head;
            if (this.count.getAndSet(0) == this.capacity) {
                this.notFull.signalAll();
            }
        }
        finally {
            this.fullyUnlock();
        }
        int n = 0;
        Node node2 = node;
        while (node2 != null) {
            collection.add(node2.item);
            node2.item = null;
            ++n;
            node2 = node2.next;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        this.fullyLock();
        try {
            int n2;
            Node node = this.head.next;
            for (n2 = 0; node != null && n2 < n; ++n2) {
                collection.add(node.item);
                node.item = null;
                node = node.next;
            }
            if (n2 != 0) {
                this.head.next = node;
                assert (this.head.item == null);
                if (node == null) {
                    this.last = this.head;
                }
                if (this.count.getAndAdd(-n2) == this.capacity) {
                    this.notFull.signalAll();
                }
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.fullyUnlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.fullyLock();
        try {
            objectOutputStream.defaultWriteObject();
            Node node = this.head.next;
            while (node != null) {
                objectOutputStream.writeObject(node.item);
                node = node.next;
            }
            objectOutputStream.writeObject(null);
        }
        finally {
            this.fullyUnlock();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.count.set(0);
        this.head = new Node<Object>(null);
        this.last = this.head;
        while ((object = objectInputStream.readObject()) != null) {
            this.add(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    implements Iterator<E> {
        private Node<E> current;
        private Node<E> lastRet;
        private E currentElement;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Itr() {
            ReentrantLock reentrantLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock reentrantLock2 = LinkedBlockingQueue.this.takeLock;
            reentrantLock.lock();
            reentrantLock2.lock();
            try {
                this.current = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
            }
            finally {
                reentrantLock2.unlock();
                reentrantLock.unlock();
            }
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            ReentrantLock reentrantLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock reentrantLock2 = LinkedBlockingQueue.this.takeLock;
            reentrantLock.lock();
            reentrantLock2.lock();
            try {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object e = this.currentElement;
                this.lastRet = this.current;
                this.current = this.current.next;
                if (this.current != null) {
                    this.currentElement = this.current.item;
                }
                Object e2 = e;
                return e2;
            }
            finally {
                reentrantLock2.unlock();
                reentrantLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            if (this.lastRet == null) {
                throw new IllegalStateException();
            }
            ReentrantLock reentrantLock = LinkedBlockingQueue.this.putLock;
            ReentrantLock reentrantLock2 = LinkedBlockingQueue.this.takeLock;
            reentrantLock.lock();
            reentrantLock2.lock();
            try {
                Node node = this.lastRet;
                this.lastRet = null;
                Node node2 = LinkedBlockingQueue.this.head;
                Node node3 = ((LinkedBlockingQueue)LinkedBlockingQueue.this).head.next;
                while (node3 != null && node3 != node) {
                    node2 = node3;
                    node3 = node3.next;
                }
                if (node3 == node) {
                    int n;
                    node3.item = null;
                    node2.next = node3.next;
                    if (LinkedBlockingQueue.this.last == node3) {
                        LinkedBlockingQueue.this.last = node2;
                    }
                    if ((n = LinkedBlockingQueue.this.count.getAndDecrement()) == LinkedBlockingQueue.this.capacity) {
                        LinkedBlockingQueue.this.notFull.signalAll();
                    }
                }
            }
            finally {
                reentrantLock2.unlock();
                reentrantLock.unlock();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node<E> {
        volatile E item;
        Node<E> next;

        Node(E e) {
            this.item = e;
        }
    }
}

