/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class BorderOpImage
extends OpImage {
    protected int leftPad;
    protected int rightPad;
    protected int topPad;
    protected int bottomPad;
    protected int type;
    protected double[] constants;

    public BorderOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, int n, int n2, int n3, int n4, int n5, double[] dArray) {
        super(renderedImage, null, tileCache, BorderOpImage.layoutHelper(imageLayout, renderedImage, n, n2, n3, n4), true);
        this.leftPad = n;
        this.rightPad = n2;
        this.topPad = n3;
        this.bottomPad = n4;
        this.type = n5;
        if (n5 == 1) {
            int n6 = this.getSampleModel().getNumBands();
            if (dArray.length < n6) {
                this.constants = new double[n6];
                int n7 = 0;
                while (n7 < n6) {
                    this.constants[n7] = dArray[0];
                    ++n7;
                }
            } else {
                this.constants = (double[])dArray.clone();
            }
        }
    }

    private void computeRectCopy(WritableRaster writableRaster, Rectangle rectangle) {
        PlanarImage planarImage = this.source0;
        IntegerSequence integerSequence = new IntegerSequence(rectangle.x, rectangle.x + rectangle.width);
        integerSequence.insert(rectangle.x);
        integerSequence.insert(rectangle.x + rectangle.width);
        IntegerSequence integerSequence2 = new IntegerSequence(rectangle.y, rectangle.y + rectangle.height);
        integerSequence2.insert(rectangle.y);
        integerSequence2.insert(rectangle.y + rectangle.height);
        planarImage.getSplits(integerSequence, integerSequence2, rectangle);
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterFormatTag rasterFormatTag = rasterFormatTagArray[0];
        RasterFormatTag rasterFormatTag2 = rasterFormatTagArray[1];
        ColorModel colorModel = this.source0.getColorModel();
        ColorModel colorModel2 = this.getColorModel();
        integerSequence2.startEnumeration();
        int n = integerSequence2.nextElement();
        while (integerSequence2.hasMoreElements()) {
            int n2 = integerSequence2.nextElement();
            int n3 = n2 - n;
            integerSequence.startEnumeration();
            int n4 = integerSequence.nextElement();
            while (integerSequence.hasMoreElements()) {
                int n5 = integerSequence.nextElement();
                int n6 = n5 - n4;
                Rectangle rectangle2 = new Rectangle(n4, n, n6, n3);
                int n7 = planarImage.XToTileX(n4);
                int n8 = planarImage.YToTileY(n);
                Raster raster = planarImage.getTile(n7, n8);
                RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTag, colorModel);
                RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTag2, colorModel2);
                ImageUtil.copyRaster(rasterAccessor, rasterAccessor2);
                n4 = n5;
            }
            n = n2;
        }
    }

    private void computeRectFill(WritableRaster writableRaster, Rectangle rectangle) {
        switch (this.type) {
            case 1: {
                this.fillRectConst(writableRaster, rectangle);
                break;
            }
            case 2: {
                this.fillRectExtend(writableRaster, rectangle);
                break;
            }
            case 3: {
                this.fillRectReflect(writableRaster, rectangle);
                break;
            }
        }
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = writableRaster.getBounds().intersection(this.getBounds());
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        if (rectangle2.isEmpty()) {
            this.computeRectFill(writableRaster, rectangle);
        } else {
            this.computeRectCopy(writableRaster, rectangle2);
            if (this.type != 0) {
                int n3 = rectangle2.x;
                int n4 = rectangle2.x + rectangle2.width;
                int n5 = rectangle2.y;
                int n6 = rectangle2.y + rectangle2.height;
                int n7 = rectangle.x;
                int n8 = rectangle.x + rectangle.width;
                int n9 = rectangle.y;
                int n10 = rectangle.y + rectangle.height;
                int n11 = rectangle.width;
                int n12 = n3 - n7;
                int n13 = n8 - n4;
                int n14 = n5 - n9;
                int n15 = rectangle2.height;
                int n16 = n10 - n6;
                Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(n7, n9, n11, n14), new Rectangle(n7, n5, n12, n15), new Rectangle(n4, n5, n13, n15), new Rectangle(n7, n6, n11, n16)};
                int n17 = 0;
                while (n17 < 4) {
                    if (!rectangleArray[n17].isEmpty()) {
                        this.computeRectFill(writableRaster, rectangleArray[n17]);
                    }
                    ++n17;
                }
            }
        }
        return writableRaster;
    }

    private void fillRectConst(WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor.getWidth() * n;
        int n4 = rasterAccessor.getHeight() * n2;
        int n5 = rasterAccessor.getNumBands();
        switch (rasterAccessor.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor.getByteDataArrays();
                int n6 = 0;
                while (n6 < n5) {
                    byte[] byArray2 = byArray[n6];
                    byte by = (byte)this.constants[n6];
                    int n7 = nArray[n6] + n4;
                    int n8 = nArray[n6];
                    while (n8 < n7) {
                        int n9 = n8 + n3;
                        int n10 = n8;
                        while (n10 < n9) {
                            byArray2[n10] = by;
                            n10 += n;
                        }
                        n8 += n2;
                    }
                    ++n6;
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor.getShortDataArrays();
                int n11 = 0;
                while (n11 < n5) {
                    short[] sArray2 = sArray[n11];
                    short s = (short)this.constants[n11];
                    int n12 = nArray[n11] + n4;
                    int n13 = nArray[n11];
                    while (n13 < n12) {
                        int n14 = n13 + n3;
                        int n15 = n13;
                        while (n15 < n14) {
                            sArray2[n15] = s;
                            n15 += n;
                        }
                        n13 += n2;
                    }
                    ++n11;
                }
                break;
            }
            case 3: {
                int[][] nArray2 = rasterAccessor.getIntDataArrays();
                int n16 = 0;
                while (n16 < n5) {
                    int[] nArray3 = nArray2[n16];
                    int n17 = (int)this.constants[n16];
                    int n18 = nArray[n16] + n4;
                    int n19 = nArray[n16];
                    while (n19 < n18) {
                        int n20 = n19 + n3;
                        int n21 = n19;
                        while (n21 < n20) {
                            nArray3[n21] = n17;
                            n21 += n;
                        }
                        n19 += n2;
                    }
                    ++n16;
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor.getFloatDataArrays();
                int n22 = 0;
                while (n22 < n5) {
                    float[] fArray2 = fArray[n22];
                    float f = (float)this.constants[n22];
                    int n23 = nArray[n22] + n4;
                    int n24 = nArray[n22];
                    while (n24 < n23) {
                        int n25 = n24 + n3;
                        int n26 = n24;
                        while (n26 < n25) {
                            fArray2[n26] = f;
                            n26 += n;
                        }
                        n24 += n2;
                    }
                    ++n22;
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor.getDoubleDataArrays();
                int n27 = 0;
                while (n27 < n5) {
                    double[] dArray2 = dArray[n27];
                    double d = this.constants[n27];
                    int n28 = nArray[n27] + n4;
                    int n29 = nArray[n27];
                    while (n29 < n28) {
                        int n30 = n29 + n3;
                        int n31 = n29;
                        while (n31 < n30) {
                            dArray2[n31] = d;
                            n31 += n;
                        }
                        n29 += n2;
                    }
                    ++n27;
                }
                break;
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    /*
     * Exception decompiling
     */
    private void fillRectExtend(WritableRaster var1_1, Rectangle var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fillRectReflect(WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = this.source0.getData();
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = n + rectangle2.width - 1;
        int n3 = rectangle2.y;
        int n4 = n3 + rectangle2.height - 1;
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.source0.getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n5 = rasterAccessor.getPixelStride();
        int n6 = rasterAccessor.getScanlineStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor2.getScanlineStride();
        int n8 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n9 = rasterAccessor2.getWidth();
        int n10 = rasterAccessor2.getHeight();
        int n11 = rasterAccessor2.getNumBands();
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                byte[][] byArray = rasterAccessor2.getByteDataArrays();
                byte[][] byArray2 = rasterAccessor.getByteDataArrays();
                int n12 = 0;
                int n13 = 0;
                while (n12 < n10) {
                    int n14 = n12 + rectangle.y;
                    if (n14 < n3) {
                        n14 = n3 + (n3 - n14);
                    } else if (n14 > n4) {
                        n14 = n4 - (n14 - n4);
                    }
                    if (n14 >= n3 && n14 <= n4) {
                        int n15 = n14 * n6;
                        int n16 = 0;
                        int n17 = n13;
                        while (n16 < n9) {
                            int n18 = n16 + rectangle.x;
                            if (n18 < n) {
                                n18 = n + (n - n18);
                            } else if (n18 > n2) {
                                n18 = n2 - (n18 - n2);
                            }
                            if (n18 >= n && n18 <= n2) {
                                int n19 = n15 + n18 * n5;
                                int n20 = 0;
                                while (n20 < n11) {
                                    byArray[n20][n17 + nArray2[n20]] = byArray2[n20][n19 + nArray[n20]];
                                    ++n20;
                                }
                            }
                            ++n16;
                            n17 += n8;
                        }
                    }
                    ++n12;
                    n13 += n7;
                }
                break;
            }
            case 1: 
            case 2: {
                short[][] sArray = rasterAccessor2.getShortDataArrays();
                short[][] sArray2 = rasterAccessor.getShortDataArrays();
                int n21 = 0;
                int n22 = 0;
                while (n21 < n10) {
                    int n23 = n21 + rectangle.y;
                    if (n23 < n3) {
                        n23 = n3 + (n3 - n23);
                    } else if (n23 > n4) {
                        n23 = n4 - (n23 - n4);
                    }
                    if (n23 >= n3 && n23 <= n4) {
                        int n24 = n23 * n6;
                        int n25 = 0;
                        int n26 = n22;
                        while (n25 < n9) {
                            int n27 = n25 + rectangle.x;
                            if (n27 < n) {
                                n27 = n + (n - n27);
                            } else if (n27 > n2) {
                                n27 = n2 - (n27 - n2);
                            }
                            if (n27 >= n && n27 <= n2) {
                                int n28 = n24 + n27 * n5;
                                int n29 = 0;
                                while (n29 < n11) {
                                    sArray[n29][n26 + nArray2[n29]] = sArray2[n29][n28 + nArray[n29]];
                                    ++n29;
                                }
                            }
                            ++n25;
                            n26 += n8;
                        }
                    }
                    ++n21;
                    n22 += n7;
                }
                break;
            }
            case 3: {
                int[][] nArray3 = rasterAccessor2.getIntDataArrays();
                int[][] nArray4 = rasterAccessor.getIntDataArrays();
                int n30 = 0;
                int n31 = 0;
                while (n30 < n10) {
                    int n32 = n30 + rectangle.y;
                    if (n32 < n3) {
                        n32 = n3 + (n3 - n32);
                    } else if (n32 > n4) {
                        n32 = n4 - (n32 - n4);
                    }
                    if (n32 >= n3 && n32 <= n4) {
                        int n33 = n32 * n6;
                        int n34 = 0;
                        int n35 = n31;
                        while (n34 < n9) {
                            int n36 = n34 + rectangle.x;
                            if (n36 < n) {
                                n36 = n + (n - n36);
                            } else if (n36 > n2) {
                                n36 = n2 - (n36 - n2);
                            }
                            if (n36 >= n && n36 <= n2) {
                                int n37 = n33 + n36 * n5;
                                int n38 = 0;
                                while (n38 < n11) {
                                    nArray3[n38][n35 + nArray2[n38]] = nArray4[n38][n37 + nArray[n38]];
                                    ++n38;
                                }
                            }
                            ++n34;
                            n35 += n8;
                        }
                    }
                    ++n30;
                    n31 += n7;
                }
                break;
            }
            case 4: {
                float[][] fArray = rasterAccessor2.getFloatDataArrays();
                float[][] fArray2 = rasterAccessor.getFloatDataArrays();
                int n39 = 0;
                int n40 = 0;
                while (n39 < n10) {
                    int n41 = n39 + rectangle.y;
                    if (n41 < n3) {
                        n41 = n3 + (n3 - n41);
                    } else if (n41 > n4) {
                        n41 = n4 - (n41 - n4);
                    }
                    if (n41 >= n3 && n41 <= n4) {
                        int n42 = n41 * n6;
                        int n43 = 0;
                        int n44 = n40;
                        while (n43 < n9) {
                            int n45 = n43 + rectangle.x;
                            if (n45 < n) {
                                n45 = n + (n - n45);
                            } else if (n45 > n2) {
                                n45 = n2 - (n45 - n2);
                            }
                            if (n45 >= n && n45 <= n2) {
                                int n46 = n42 + n45 * n5;
                                int n47 = 0;
                                while (n47 < n11) {
                                    fArray[n47][n44 + nArray2[n47]] = fArray2[n47][n46 + nArray[n47]];
                                    ++n47;
                                }
                            }
                            ++n43;
                            n44 += n8;
                        }
                    }
                    ++n39;
                    n40 += n7;
                }
                break;
            }
            case 5: {
                double[][] dArray = rasterAccessor2.getDoubleDataArrays();
                double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
                int n48 = 0;
                int n49 = 0;
                while (n48 < n10) {
                    int n50 = n48 + rectangle.y;
                    if (n50 < n3) {
                        n50 = n3 + (n3 - n50);
                    } else if (n50 > n4) {
                        n50 = n4 - (n50 - n4);
                    }
                    if (n50 >= n3 && n50 <= n4) {
                        int n51 = n50 * n6;
                        int n52 = 0;
                        int n53 = n49;
                        while (n52 < n9) {
                            int n54 = n52 + rectangle.x;
                            if (n54 < n) {
                                n54 = n + (n - n54);
                            } else if (n54 > n2) {
                                n54 = n2 - (n54 - n2);
                            }
                            if (n54 >= n && n54 <= n2) {
                                int n55 = n51 + n54 * n5;
                                int n56 = 0;
                                while (n56 < n11) {
                                    dArray[n56][n53 + nArray2[n56]] = dArray2[n56][n55 + nArray[n56]];
                                    ++n56;
                                }
                            }
                            ++n52;
                            n53 += n8;
                        }
                    }
                    ++n48;
                    n49 += n7;
                }
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        }
        ImageLayout imageLayout2 = new ImageLayout();
        int n7 = renderedImage.getMinX() - n;
        int n8 = renderedImage.getMinY() - n3;
        imageLayout2.setMinX(n7);
        imageLayout2.setMinY(n8);
        imageLayout2.setWidth(renderedImage.getWidth() + n + n2);
        imageLayout2.setHeight(renderedImage.getHeight() + n3 + n4);
        int n9 = imageLayout.getTileWidth(renderedImage);
        int n10 = imageLayout.getTileHeight(renderedImage);
        if (imageLayout.isValid(16)) {
            n6 = imageLayout.getTileGridXOffset(null);
        } else {
            n6 = renderedImage.getTileGridXOffset();
            while (n6 > n7) {
                n6 -= n9;
            }
        }
        if (imageLayout.isValid(32)) {
            n5 = imageLayout.getTileGridYOffset(null);
        } else {
            n5 = renderedImage.getTileGridYOffset();
            while (n5 > n8) {
                n5 -= n10;
            }
        }
        imageLayout2.setTileGridXOffset(n6);
        imageLayout2.setTileGridYOffset(n5);
        imageLayout2.setTileWidth(n9);
        imageLayout2.setTileHeight(n10);
        imageLayout2.setSampleModel(imageLayout.getSampleModel(renderedImage));
        imageLayout2.setColorModel(imageLayout.getColorModel(renderedImage));
        return imageLayout2;
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage2"));
        }
        Rectangle rectangle2 = this.source0.getBounds();
        return rectangle.intersection(rectangle2);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("BorderOpImage0"));
        }
        return new Rectangle(rectangle);
    }
}

