/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusDebugHandlerInterface;
import com.insightful.splus.SplusDebugListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;

public class SplusDebugHandler
extends UnicastRemoteObject
implements SplusDebugHandlerInterface {
    private static SplusDebugHandler g_instance = null;
    private Vector m_objName = new Vector();
    private Vector m_objClass = new Vector();
    private Vector m_objLength = new Vector();
    private Vector m_objExtent = new Vector();
    private Vector m_objDate = new Vector();
    private Vector m_objValue = new Vector();
    private Vector m_objMode = new Vector();
    private Vector m_stackItems = new Vector();
    private Vector m_functionNames = new Vector();
    private Vector m_containerFunctionNames = new Vector();
    private String m_breakInfo = "";
    private long[] m_breakAddress = null;
    private HashMap m_evalValues = new HashMap();
    private Vector m_listeners = new Vector();
    private static LinkedList m_runnableJobs = new LinkedList();
    private static Object m_syncLock = new Object();
    private static boolean m_gettingInfo = false;

    public SplusDebugHandler() throws RemoteException {
        this.jobQueue();
    }

    public static SplusDebugHandler getInstance() throws RemoteException {
        if (g_instance == null) {
            g_instance = new SplusDebugHandler();
        }
        return g_instance;
    }

    public void start() throws RemoteException {
        SplusDebugHandler.getInstance();
        SplusDebugHandler.setGettingInfo(false);
    }

    private static void addJob(Runnable runnable) {
        m_runnableJobs.addLast(runnable);
    }

    private static void removeDataRequests() {
        SplusDebugHandler.setGettingInfo(true);
        for (int i = m_runnableJobs.size() - 1; i >= 0; --i) {
            if (!(m_runnableJobs.get(i) instanceof DataRequestThread)) continue;
            m_runnableJobs.remove(i);
        }
        SplusDebugHandler.setGettingInfo(false);
    }

    private void jobQueue() {
        new Thread("SplusDebug-JobQueue"){

            public void run() {
                while (true) {
                    if (m_runnableJobs.size() > 0 && g_instance != null) {
                        Runnable runnable = (Runnable)m_runnableJobs.getFirst();
                        m_runnableJobs.removeFirst();
                        runnable.run();
                        SplusDebugHandler.waitWhileBusy();
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setObjectsInfo(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7) throws RemoteException {
        Object object = m_syncLock;
        synchronized (object) {
            SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
            splusDebugHandler.m_objName.clear();
            splusDebugHandler.m_objClass.clear();
            splusDebugHandler.m_objMode.clear();
            splusDebugHandler.m_objLength.clear();
            splusDebugHandler.m_objExtent.clear();
            splusDebugHandler.m_objDate.clear();
            splusDebugHandler.m_objValue.clear();
            int n = Math.min(Math.min(Math.min(Math.min(Math.min(Math.min(stringArray.length, stringArray2.length), stringArray3.length), stringArray4.length), stringArray5.length), stringArray6.length), stringArray7.length);
            for (int i = 0; i < n; ++i) {
                splusDebugHandler.m_objName.add(stringArray[i]);
                splusDebugHandler.m_objClass.add(stringArray2[i]);
                splusDebugHandler.m_objMode.add(stringArray3[i]);
                splusDebugHandler.m_objLength.add(stringArray4[i]);
                splusDebugHandler.m_objExtent.add(stringArray5[i]);
                splusDebugHandler.m_objDate.add(stringArray6[i]);
                splusDebugHandler.m_objValue.add(stringArray7[i]);
            }
            splusDebugHandler.notifyObjectsListeners();
            SplusDebugHandler.setGettingInfo(false);
        }
    }

    public int getNumObjects() throws RemoteException {
        return this.m_objName.size();
    }

    public String getObjectName(int n) throws RemoteException {
        return (String)this.m_objName.get(n);
    }

    public String[] getObjectData(int n) {
        String string = (String)this.m_objClass.get(n);
        String string2 = (String)this.m_objMode.get(n);
        String string3 = (String)this.m_objLength.get(n);
        String string4 = (String)this.m_objExtent.get(n);
        String string5 = (String)this.m_objDate.get(n);
        String string6 = (String)this.m_objValue.get(n);
        String[] stringArray = new String[]{string, string2, string3, string4, string5, string6};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCallStackInfo(String[] stringArray, String[] stringArray2, String[] stringArray3) throws RemoteException {
        Object object = m_syncLock;
        synchronized (object) {
            SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
            splusDebugHandler.m_stackItems.clear();
            splusDebugHandler.m_functionNames.clear();
            splusDebugHandler.m_containerFunctionNames.clear();
            int n = Math.min(stringArray3.length, stringArray.length);
            for (int i = 0; i < n; ++i) {
                splusDebugHandler.m_stackItems.add(stringArray3[i]);
                splusDebugHandler.m_functionNames.add(stringArray[i]);
                splusDebugHandler.m_containerFunctionNames.add(stringArray2[i]);
            }
            splusDebugHandler.notifyCallStackListeners();
            SplusDebugHandler.setGettingInfo(false);
        }
    }

    public int getNumCalls() throws RemoteException {
        return this.m_stackItems.size();
    }

    public String getCall(int n) throws RemoteException {
        return (String)this.m_stackItems.get(n);
    }

    public String getCallName(int n) throws RemoteException {
        return (String)this.m_functionNames.get(n);
    }

    public String getContainerCallName(int n) throws RemoteException {
        return (String)this.m_containerFunctionNames.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEvalInfo(String string, String[] stringArray) throws RemoteException {
        Object object = m_syncLock;
        synchronized (object) {
            SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
            Vector<String> vector = new Vector<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
            splusDebugHandler.m_evalValues.put(string, vector);
            splusDebugHandler.notifyEvalInfoListeners(string);
            SplusDebugHandler.setGettingInfo(false);
        }
    }

    public int getNumEvals(String string) throws RemoteException {
        if (this.m_evalValues.get(string) != null) {
            return ((Vector)this.m_evalValues.get(string)).size();
        }
        return -1;
    }

    public String getEval(String string, int n) throws RemoteException {
        if (this.m_evalValues.get(string) != null) {
            return (String)((Vector)this.m_evalValues.get(string)).get(n);
        }
        return "";
    }

    public static void setBreakInfo(String string, long[] lArray) throws RemoteException {
        SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
        splusDebugHandler.m_breakInfo = string;
        splusDebugHandler.m_breakAddress = lArray;
        splusDebugHandler.notifyBreakInfoListeners();
    }

    public String getBreakInfo() throws RemoteException {
        return SplusDebugHandler.getInstance().m_breakInfo;
    }

    public long[] getBreakAddress() throws RemoteException {
        return SplusDebugHandler.getInstance().m_breakAddress;
    }

    public void addSplusDebugListener(SplusDebugListener splusDebugListener) throws RemoteException {
        SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
        if (!splusDebugHandler.m_listeners.contains(splusDebugListener)) {
            splusDebugHandler.m_listeners.add(splusDebugListener);
        }
    }

    public void removeSplusDebugListener(SplusDebugListener splusDebugListener) throws RemoteException {
        SplusDebugHandler splusDebugHandler = SplusDebugHandler.getInstance();
        splusDebugHandler.m_listeners.remove(splusDebugListener);
    }

    private static void setGettingInfo(boolean bl) {
        m_gettingInfo = bl;
    }

    private static void waitWhileBusy() {
        while (m_gettingInfo) {
            try {
                Thread.sleep(100L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private void notifyObjectsListeners() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((SplusDebugListener)this.m_listeners.get(i)).objectsRetrieved(this);
        }
    }

    private void notifyCallStackListeners() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((SplusDebugListener)this.m_listeners.get(i)).callStackRetrieved(this);
        }
    }

    private void notifyEvalInfoListeners(String string) {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((SplusDebugListener)this.m_listeners.get(i)).evalInfoRetrieved(string, this);
        }
        this.m_evalValues.remove(string);
    }

    private void notifyBreakInfoListeners() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            ((SplusDebugListener)this.m_listeners.get(i)).breakpointHit(this);
        }
    }

    public void doSetCommandLine(boolean bl) {
        SplusDebugHandler.doNativeSetCommandLine(bl);
    }

    public boolean doParse(String string) {
        boolean bl = SplusDebugHandler.doNativeParse(string);
        return bl;
    }

    public long doStart(String string) {
        long l = SplusDebugHandler.doNativeStart(string);
        return l;
    }

    public void doStop(long l) {
        SplusDebugHandler.doNativeStop(l);
        SplusDebugHandler.removeDataRequests();
    }

    public void doPause(long l) {
        SplusDebugHandler.doNativePause(l);
    }

    public void doResume(long l) {
        SplusDebugHandler.doNativeResume(l);
    }

    public void doStep(long l) {
        SplusDebugHandler.doNativeStep(l);
    }

    public void doStepIn(long l) {
        SplusDebugHandler.doNativeStepIn(l);
    }

    public void doStepOut(long l) {
        SplusDebugHandler.doNativeStepOut(l);
    }

    public void doFrameUp(long l) {
        SplusDebugHandler.doNativeFrameUp(l);
    }

    public void doFrameDown(long l) {
        SplusDebugHandler.doNativeFrameDown(l);
    }

    public void doInvisibleEvaluate(long l, String string) {
        SplusDebugHandler.doNativeEvaluate(l, "invisible(" + string + ")");
    }

    public void doEvaluate(final long l, final String string) {
        SplusDebugHandler.addJob(new DataRequestThread("evaluate"){

            public void doRunAction() {
                SplusDebugHandler.doNativeEvaluate(l, string);
            }
        });
    }

    public void doObjects(final long l) {
        SplusDebugHandler.addJob(new DataRequestThread("objects"){

            public void doRunAction() {
                SplusDebugHandler.doNativeObjects(l);
            }
        });
    }

    public void doCallStack(final long l) {
        SplusDebugHandler.addJob(new DataRequestThread("callStack"){

            public void doRunAction() {
                SplusDebugHandler.doNativeCallStack(l);
            }
        });
    }

    public void addBreakpoint(final String string, final String string2, final long[] lArray) {
        SplusDebugHandler.addJob(new CommandThread("addBreakpoint"){

            public void run() {
                SplusDebugHandler.doNativeAddBreakpoint(string, string2, lArray, lArray.length);
            }
        });
    }

    public void removeBreakpoint(final String string, final String string2, final long[] lArray) {
        SplusDebugHandler.addJob(new CommandThread("removeBreakpoint"){

            public void run() {
                SplusDebugHandler.doNativeRemoveBreakpoint(string, string2, lArray, lArray.length);
            }
        });
    }

    public void setDebugMode(boolean bl) {
        SplusDebugHandler.doNativeSetCommandLine(!bl);
        SplusDebugHandler.doNativeSetDebugMode(bl);
    }

    public void setErrorBreakpoint(boolean bl) {
        SplusDebugHandler.doNativeSetErrorBreakpoint(bl);
    }

    public void setWarningBreakpoint(boolean bl) {
        SplusDebugHandler.doNativeSetWarningBreakpoint(bl);
    }

    private static native void doNativeSetCommandLine(boolean var0);

    private static native long doNativeStart(String var0);

    private static native boolean doNativeParse(String var0);

    private static native void doNativeStop(long var0);

    private static native void doNativePause(long var0);

    private static native void doNativeResume(long var0);

    private static native void doNativeStep(long var0);

    private static native void doNativeStepIn(long var0);

    private static native void doNativeStepOut(long var0);

    private static native void doNativeFrameUp(long var0);

    private static native void doNativeFrameDown(long var0);

    private static native void doNativeEvaluate(long var0, String var2);

    private static native void doNativeObjects(long var0);

    private static native void doNativeCallStack(long var0);

    private static native void doNativeAddBreakpoint(String var0, String var1, long[] var2, long var3);

    private static native void doNativeRemoveBreakpoint(String var0, String var1, long[] var2, long var3);

    private static native void doNativeSetDebugMode(boolean var0);

    private static native void doNativeSetErrorBreakpoint(boolean var0);

    private static native void doNativeSetWarningBreakpoint(boolean var0);

    private static abstract class DataRequestThread
    extends Thread {
        public DataRequestThread(String string) {
            super("Blocking job: " + string);
        }

        public void run() {
            SplusDebugHandler.setGettingInfo(true);
            this.doRunAction();
        }

        public abstract void doRunAction();
    }

    private static abstract class CommandThread
    extends Thread {
        public CommandThread(String string) {
            super("Nonblocking job: " + string);
        }

        public abstract void run();
    }
}

