/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusHelpManagerInstance;
import com.insightful.splus.SplusHelpQueryHandler;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusLicenseException;
import com.insightful.splus.SplusMinGui;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import java.rmi.RemoteException;
import javax.swing.JOptionPane;

public class SplusWinApp
implements SplusEngineQueryHandler,
SplusHelpQueryHandler {
    private static SplusWinApp theApp;
    private SplusSession m_splusSession;
    private static String engineBusyText;
    private static String engineBusyTitle;

    private SplusWinApp() throws RemoteException, SplusLicenseException {
        SplusSystem.setEngineQueryHandler(this);
        SplusSystem.setHelpQueryHandler(this);
        System.setProperty("splus.use.win32", "true");
        this.m_splusSession = new SplusWinSessionImpl();
        new SplusMinGui();
    }

    public static void start() throws RemoteException, SplusLicenseException {
        if (theApp == null) {
            theApp = new SplusWinApp();
        }
    }

    public SplusDataResult processDataQuery(String string) {
        return this.eval(string);
    }

    public SplusDataResult processDataQuery(String string, int n) {
        return this.eval(string);
    }

    public void processDialogCommand(String string) {
        this.eval(string);
    }

    public void writeEngineOutput(String string, boolean bl) {
    }

    private SplusDataResult eval(String string) {
        try {
            return this.m_splusSession.evalDataQuery("{" + string + "}");
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), engineBusyText, engineBusyTitle, 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), splusIncompleteExpressionException.getMessage(), "Data Query Error:  Incomplete Expression", 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Problem contacting engine:\n" + remoteException.getMessage(), "Data Query Error:  Remote Exception", 0);
            return new SplusDataResult(null, null, null, null);
        }
    }

    public void displayHelpOnTopic(String string) {
        JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Help has not been implemented.", "Help Not Available", 0);
    }

    public void displayHelpView(String string) {
        JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), "Help has not been implemented.", "Help Not Available", 0);
    }

    public SplusHelpManagerInstance getHelpManagerInstance() {
        return null;
    }

    static {
        engineBusyText = "The S-PLUS computation engine is not responding.\nThis condition may be caused by one of the following:\n\n1)  The Commands window is waiting for input.\n2)  Another S-PLUS operation is already in progress.\n3)  Other processes are preempting S-PLUS.\n4)  Low memory is causing thrashing in virtual memory.\n\n";
        engineBusyTitle = "Data Query Error:  Engine Busy";
    }
}

