/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.report;

import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.TextPrinter;
import com.insightful.splus.client.ServerFile;
import com.insightful.splus.util.FileUtilities;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ReportWindow
extends JInternalFrame
implements SplusPrintable,
SaveAsable,
CaretListener {
    JTextArea textArea;
    private int maxTextRows = 2048;
    JScrollPane scrollPane;
    private TextPrinter m_print = null;

    public ReportWindow(SplusGui splusGui) {
        super("Report Window", true, true, true, true);
        this.setFrameIcon(new ImageIcon(System.getProperty("splus.shome", "") + "/java/res/reptwin.gif"));
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.scrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add(this.scrollPane);
        this.setSize(700, 400);
        this.textArea.addCaretListener(this);
    }

    public void append(String string) {
        this.m_print = null;
        this.textArea.append(string);
        int n = this.textArea.getLineCount() - this.maxTextRows - 1;
        if (n > 0) {
            try {
                this.textArea.replaceRange("", 0, this.textArea.getLineEndOffset(n));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public File saveAs(Frame frame, File file) {
        JFileChooser jFileChooser = new JFileChooser(file, SplusSystem.getServerFileHandler().getServerFileSystemView());
        jFileChooser.setDialogType(1);
        if (jFileChooser.showSaveDialog(frame) == 0) {
            String string = ServerFile.convertServerFilePath(jFileChooser.getSelectedFile().getAbsolutePath());
            if (FileUtilities.confirmSaveAs(frame, string)) {
                try {
                    FileOutputStream fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string);
                    fileOutputStream.write(this.textArea.getText().getBytes());
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(frame, "Problem saving file:\n" + exception.getMessage(), "File Save Error", 2);
                }
            }
            return jFileChooser.getCurrentDirectory();
        }
        return file;
    }

    public void save() {
    }

    public int getNumberOfPages() {
        if (this.m_print == null) {
            this.m_print = new TextPrinter(this.textArea.getText(), this.textArea.getFont());
        }
        return this.m_print.getNumberOfPages();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.m_print == null) {
            this.m_print = new TextPrinter(this.textArea.getText(), this.textArea.getFont());
        }
        return this.m_print.print(graphics, pageFormat, n);
    }

    public void caretUpdate(CaretEvent caretEvent) {
    }

    public int getMaxTextRows() {
        return this.maxTextRows;
    }

    public void setMaxTextRows(int n) {
        if (n > 0 && n < 16385) {
            this.maxTextRows = n;
        } else {
            System.out.println("Warning: Bad maxTextRow value (" + n + ") ignored in report window");
        }
    }

    public void setSelected(boolean bl) {
        try {
            super.setSelected(bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.requestFocus();
        }
    }

    public void clear() {
        this.textArea.setText(null);
    }

    public void save(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = SplusSystem.getServerFileHandler().getServerFileOutputStream(string);
        fileOutputStream.write(this.textArea.getText().getBytes());
        fileOutputStream.close();
    }
}

