/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.gdevice.SCanvas;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusPrintable;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.CanvasTabbedPane;
import com.insightful.splus.graph.ExportGraphCommand;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class GraphWindow
extends JInternalFrame
implements SplusPrintable,
SaveAsable {
    CanvasTabbedPane paneTabs;
    static int graphNameCounter = 0;

    public GraphWindow(SplusCanvasHandler splusCanvasHandler, SCanvas sCanvas) {
        super("", true, true, true, true);
        this.setFrameIcon(new ImageIcon(System.getProperty("splus.shome", "") + "/java/res/graphwin.gif"));
        this.setTitle("Graph Window " + ++graphNameCounter);
        this.paneTabs = new CanvasTabbedPane();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)this.paneTabs, "Center");
        if (splusCanvasHandler != null) {
            splusCanvasHandler.addGraphWindow(this);
        }
        this.paneTabs.setActiveCanvas(sCanvas);
        this.paneTabs.addCanvasTab(sCanvas);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                int n = GraphWindow.this.paneTabs.getDeviceNumber();
                if (n > 0) {
                    GraphWindow.this.paneTabs.unlinkCanvases();
                    String string = "{dev.off(" + n + ");vector(\"missing\",0)}\n";
                    SplusSystem.getEngineQueryHandler().processDataQuery(string, 5);
                }
            }
        });
        Dimension dimension = null;
        if (sCanvas != null) {
            dimension = new Dimension(sCanvas.getUserSize());
        }
        if (dimension == null || dimension.width < 1 || dimension.height < 1) {
            dimension = new Dimension(520, 390);
        }
        dimension.width = Math.min(1000, Math.max(100, dimension.width));
        dimension.height = Math.min(1000, Math.max(100, dimension.height));
        this.setSize(dimension.width + 10, dimension.height + 47);
        this.show();
        Dimension dimension2 = this.paneTabs.getCanvasComponent().getSize();
        this.setSize(this.getWidth() + dimension.width - dimension2.width, this.getHeight() + dimension.height - dimension2.height);
    }

    public int getNumberOfPages() {
        return this.paneTabs.getTabCount();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        return GraphWindow.doPrint(graphics, pageFormat, n, this.paneTabs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int doPrint(Graphics graphics, PageFormat pageFormat, int n, CanvasTabbedPane canvasTabbedPane) {
        if (n >= canvasTabbedPane.getTabCount()) {
            return 1;
        }
        SCanvas sCanvas = canvasTabbedPane.getCanvas(n);
        int n2 = sCanvas.getWidth();
        int n3 = sCanvas.getHeight();
        try {
            int n4 = (int)pageFormat.getImageableWidth() - 8;
            int n5 = (int)pageFormat.getImageableHeight() - 8;
            int n6 = (int)pageFormat.getImageableX() + 4;
            int n7 = (int)pageFormat.getImageableY() + 4;
            Dimension dimension = sCanvas.getBestFitSize(new Dimension(n4, n5));
            sCanvas.setSize(dimension.width, dimension.height);
            graphics.translate(n6 + (n4 - dimension.width) / 2, n7 + (n5 - dimension.height) / 2);
            sCanvas.paint(graphics);
        }
        finally {
            sCanvas.setSize(n2, n3);
        }
        return 0;
    }

    public File saveAs(Frame frame, File file) {
        return GraphWindow.doSaveAs(frame, file, this.paneTabs);
    }

    static File doSaveAs(Frame frame, File file, CanvasTabbedPane canvasTabbedPane) {
        if (file != null) {
            SplusSystem.setCwd(file);
        }
        ExportGraphCommand exportGraphCommand = new ExportGraphCommand(frame, canvasTabbedPane);
        exportGraphCommand.doExecute();
        return SplusSystem.getCwd();
    }

    public void save() {
    }

    public CanvasTabbedPane getCanvasTabbedPane() {
        return this.paneTabs;
    }

    public SCanvas getCanvas() {
        return this.paneTabs.getCanvas();
    }

    public SCanvas getCanvas(int n) {
        return this.paneTabs.getCanvas(n);
    }

    public void zoom(double d) {
        this.paneTabs.zoom(d);
    }

    public void zoomToRect() {
        this.paneTabs.zoomToRect();
    }

    public void zoomToFrame() {
        this.paneTabs.zoomToFrame();
    }
}

