/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.CategoryAxis;
import com.jrefinery.chart.CategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.DrawInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalCategoryAxis;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.ToolTipsCollection;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetUtilities;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;

public class HorizontalCategoryPlot
extends CategoryPlot
implements HorizontalValuePlot {
    public HorizontalCategoryPlot(Axis axis, Axis axis2, CategoryItemRenderer categoryItemRenderer) {
        this(axis, axis2, categoryItemRenderer, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f, 0.05, 0.05, 0.2, 0.15, null);
    }

    public HorizontalCategoryPlot(Axis axis, Axis axis2, CategoryItemRenderer categoryItemRenderer, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2, double d, double d2, double d3, double d4, CategoryToolTipGenerator categoryToolTipGenerator) {
        super(axis, axis2, categoryItemRenderer, insets, paint, image, f, stroke, paint2, f2, d, d2, d3, d4, categoryToolTipGenerator);
    }

    public CategoryDataset getDataset() {
        CategoryDataset categoryDataset = null;
        if (this.chart != null) {
            categoryDataset = (CategoryDataset)this.chart.getDataset();
        }
        return categoryDataset;
    }

    public void setHorizontalAxis(Axis axis) throws AxisNotCompatibleException {
        super.setHorizontalAxis(axis);
    }

    public void setVerticalAxis(Axis axis) throws AxisNotCompatibleException {
        super.setVerticalAxis(axis);
    }

    public CategoryAxis getDomainAxis() {
        return (CategoryAxis)this.verticalAxis;
    }

    public ValueAxis getRangeAxis() {
        return (ValueAxis)this.horizontalAxis;
    }

    public double getCategoryCoordinate(int n, Rectangle2D rectangle2D) {
        double d = rectangle2D.getY() + rectangle2D.getHeight() * this.introGapPercent;
        int n2 = this.getDataset().getCategoryCount();
        if (n2 > 1) {
            double d2 = rectangle2D.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent - this.categoryGapsPercent);
            double d3 = rectangle2D.getHeight() * this.categoryGapsPercent;
            d = d + ((double)n + 0.5) * (d2 / (double)n2) + (double)n * (d3 / (double)(n2 - 1));
        } else {
            d += ((double)n + 0.5) * rectangle2D.getHeight() * (1.0 - this.introGapPercent - this.trailGapPercent);
        }
        return d;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalNumberAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalCategoryAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, DrawInfo drawInfo) {
        ToolTipsCollection toolTipsCollection = null;
        if (drawInfo != null) {
            drawInfo.setPlotArea(rectangle2D);
            toolTipsCollection = drawInfo.getToolTipsCollection();
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        VerticalAxis verticalAxis = this.getVerticalAxis();
        HorizontalAxis horizontalAxis = this.getHorizontalAxis();
        double d = verticalAxis.reserveWidth(graphics2D, this, rectangle2D);
        Rectangle2D rectangle2D2 = horizontalAxis.reserveAxisArea(graphics2D, this, rectangle2D, d);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + d, rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight() - rectangle2D2.getHeight());
        if (drawInfo != null) {
            drawInfo.setDataArea(double_);
        }
        this.drawOutlineAndBackground(graphics2D, double_);
        this.getDomainAxis().draw(graphics2D, rectangle2D, double_);
        this.getRangeAxis().draw(graphics2D, rectangle2D, double_);
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset != null) {
            Object object;
            Shape shape;
            Shape shape2 = graphics2D.getClip();
            graphics2D.clip(double_);
            Composite composite = graphics2D.getComposite();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.foregroundAlpha);
            graphics2D.setComposite(alphaComposite);
            int n = categoryDataset.getSeriesCount();
            this.renderer.initialise(graphics2D, double_, this, categoryDataset);
            int n2 = 0;
            Object var17_16 = null;
            Iterator iterator = categoryDataset.getCategories().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int n3 = 0;
                while (n3 < n) {
                    shape = this.renderer.drawCategoryItem(graphics2D, double_, this, this.getRangeAxis(), categoryDataset, n3, e, n2, var17_16);
                    if (toolTipsCollection != null) {
                        if (this.toolTipGenerator == null) {
                            this.toolTipGenerator = new StandardCategoryToolTipGenerator();
                        }
                        object = this.toolTipGenerator.generateToolTip(categoryDataset, n3, e);
                        if (shape != null) {
                            toolTipsCollection.addToolTip((String)object, shape);
                        }
                    }
                    ++n3;
                }
                ++n2;
                var17_16 = e;
            }
            double d2 = this.getRangeAxis().translateValueToJava2D(0.0, double_);
            shape = new Line2D.Double(d2, ((RectangularShape)double_).getY(), d2, double_.getMaxY());
            graphics2D.setPaint(Color.gray);
            graphics2D.setStroke(new BasicStroke());
            graphics2D.draw(shape);
            object = this.getRangeAxis();
            if (((ValueAxis)object).isCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, double_, ((ValueAxis)object).getCrosshairValue(), ((ValueAxis)object).getCrosshairStroke(), ((ValueAxis)object).getCrosshairPaint());
            }
            graphics2D.setClip(shape2);
            graphics2D.setComposite(composite);
        }
    }

    public String getPlotType() {
        return "Horizontal Bar Plot";
    }

    public Number getMinimumHorizontalDataValue() {
        Number number = null;
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset != null) {
            number = this.renderer.isStacked() ? (Number)DatasetUtilities.getMinimumStackedRangeValue((CategoryDataset)categoryDataset) : (Number)DatasetUtilities.getMinimumRangeValue((Dataset)categoryDataset);
        }
        return number;
    }

    public Number getMaximumHorizontalDataValue() {
        Number number = null;
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset != null) {
            number = this.renderer.isStacked() ? (Number)DatasetUtilities.getMaximumStackedRangeValue((CategoryDataset)categoryDataset) : (Number)DatasetUtilities.getMaximumRangeValue((Dataset)categoryDataset);
        }
        return number;
    }

    public void handleClick(int n, int n2, DrawInfo drawInfo) {
        ValueAxis valueAxis = this.getRangeAxis();
        double d = valueAxis.translateJava2DtoValue(n, drawInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        valueAxis.setCrosshairValue(d);
    }

    private void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }
}

