/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.PatternOpImage;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;

final class ConstantOpImage
extends PatternOpImage {
    public ConstantOpImage(int n, int n2, int n3, int n4, int n5, int n6, Number[] numberArray) {
        super(ConstantOpImage.patternHelper(n5, n6, numberArray), ConstantOpImage.colorModelHelper(numberArray), n, n2, n3, n4);
    }

    private static ColorModel colorModelHelper(Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(1, 1, numberArray);
        return PlanarImage.createColorModel(sampleModel);
    }

    private static Raster makePattern(SampleModel sampleModel, Number[] numberArray) {
        Object object;
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        int n3 = sampleModel.getTransferType();
        int n4 = sampleModel.getNumBands();
        switch (n3) {
            case 0: {
                object = new int[n4];
                int n5 = 0;
                while (n5 < n4) {
                    object[n5] = numberArray[n5].intValue() & 0xFF;
                    ++n5;
                }
                n5 = 0;
                while (n5 < n) {
                    writableRaster.setPixel(n5, 0, (int[])object);
                    ++n5;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = new int[n4];
                int n6 = 0;
                while (n6 < n4) {
                    nArray[n6] = numberArray[n6].intValue();
                    ++n6;
                }
                n6 = 0;
                while (n6 < n) {
                    writableRaster.setPixel(n6, 0, nArray);
                    ++n6;
                }
                break;
            }
            case 4: {
                float[] fArray = new float[n4];
                int n7 = 0;
                while (n7 < n4) {
                    fArray[n7] = numberArray[n7].floatValue();
                    ++n7;
                }
                n7 = 0;
                while (n7 < n) {
                    writableRaster.setPixel(n7, 0, fArray);
                    ++n7;
                }
                break;
            }
            case 5: {
                double[] dArray = new double[n4];
                int n8 = 0;
                while (n8 < n4) {
                    dArray[n8] = numberArray[n8].doubleValue();
                    ++n8;
                }
                n8 = 0;
                while (n8 < n) {
                    writableRaster.setPixel(n8, 0, dArray);
                    ++n8;
                }
                break;
            }
        }
        object = writableRaster.getDataElements(0, 0, n, 1, null);
        int n9 = 1;
        while (n9 < n2) {
            writableRaster.setDataElements(0, n9, n, 1, object);
            ++n9;
        }
        return writableRaster;
    }

    private static SampleModel makeSampleModel(int n, int n2, Number[] numberArray) {
        int n3;
        int n4 = numberArray.length;
        if (numberArray instanceof Byte[]) {
            n3 = 0;
        } else if (numberArray instanceof Short[]) {
            n3 = 1;
            Short[] shortArray = (Short[])numberArray;
            int n5 = 0;
            while (n5 < n4) {
                if (shortArray[n5] < 0) {
                    n3 = 2;
                    break;
                }
                ++n5;
            }
        } else {
            n3 = numberArray instanceof Integer[] ? 3 : (numberArray instanceof Float[] ? 4 : (numberArray instanceof Double[] ? 5 : 32));
        }
        return RasterFactory.createPixelInterleavedSampleModel(n3, n, n2, n4);
    }

    private static Raster patternHelper(int n, int n2, Number[] numberArray) {
        SampleModel sampleModel = ConstantOpImage.makeSampleModel(n, n2, numberArray);
        return ConstantOpImage.makePattern(sampleModel, numberArray);
    }
}

