/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ReaderWriterLock;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.jai.OperationGraph;
import javax.media.jai.PartialOrderNode;

class ProductOperationGraph
implements Serializable {
    protected Vector operations = new Vector();
    protected Vector orderedProducts;
    protected boolean isChanged = true;
    ReaderWriterLock lock = new ReaderWriterLock();

    public void addProduct(String string) {
        this.lock.getWriteLock();
        OperationGraph operationGraph = new OperationGraph();
        PartialOrderNode partialOrderNode = new PartialOrderNode(operationGraph, string);
        this.operations.addElement(partialOrderNode);
        this.isChanged = true;
        this.lock.releaseWriteLock();
    }

    public Vector getOrderedOperationList() {
        Cloneable cloneable;
        PartialOrderNode partialOrderNode;
        PartialOrderNode partialOrderNode2;
        this.lock.getReadLock();
        if (!this.isChanged) {
            Vector vector = this.orderedProducts;
            this.lock.releaseReadLock();
            return vector;
        }
        this.lock.releaseReadLock();
        this.lock.getWriteLock();
        if (!this.isChanged) {
            Vector vector = this.orderedProducts;
            this.lock.releaseWriteLock();
            return vector;
        }
        int n = this.operations.size();
        int n2 = 0;
        while (n2 < n) {
            partialOrderNode2 = (PartialOrderNode)this.operations.elementAt(n2);
            partialOrderNode2.setCopyInDegree(partialOrderNode2.getInDegree());
            ++n2;
        }
        this.orderedProducts = new Vector(n);
        this.isChanged = false;
        partialOrderNode2 = null;
        int n3 = 0;
        while (n3 < n) {
            partialOrderNode = (PartialOrderNode)this.operations.elementAt(n3);
            if (partialOrderNode.getCopyInDegree() == 0) {
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            if (partialOrderNode2 == null) {
                this.orderedProducts = null;
                this.lock.releaseWriteLock();
                return null;
            }
            cloneable = partialOrderNode2;
            this.orderedProducts.addElement(cloneable);
            partialOrderNode2 = partialOrderNode2.getZeroLink();
            Enumeration enumeration = ((PartialOrderNode)cloneable).getNeighbors();
            while (enumeration.hasMoreElements()) {
                partialOrderNode = (PartialOrderNode)enumeration.nextElement();
                partialOrderNode.decrementCopyInDegree();
                if (partialOrderNode.getCopyInDegree() != 0) continue;
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n3;
        }
        cloneable = this.orderedProducts;
        this.lock.releaseWriteLock();
        return cloneable;
    }

    public PartialOrderNode lookupOp(String string) {
        this.lock.getReadLock();
        int n = this.operations.size();
        int n2 = 0;
        while (n2 < n) {
            PartialOrderNode partialOrderNode = (PartialOrderNode)this.operations.elementAt(n2);
            if (partialOrderNode.getName().equalsIgnoreCase(string)) {
                PartialOrderNode partialOrderNode2 = partialOrderNode;
                this.lock.releaseReadLock();
                return partialOrderNode2;
            }
            ++n2;
        }
        this.lock.releaseReadLock();
        return null;
    }

    public synchronized void setPreference(String string, String string2) {
        PartialOrderNode partialOrderNode = this.lookupOp(string);
        PartialOrderNode partialOrderNode2 = this.lookupOp(string2);
        this.lock.getWriteLock();
        partialOrderNode.addEdge(partialOrderNode2);
        this.isChanged = true;
        this.lock.releaseWriteLock();
    }

    public synchronized void unsetPreference(String string, String string2) {
        PartialOrderNode partialOrderNode = this.lookupOp(string);
        PartialOrderNode partialOrderNode2 = this.lookupOp(string2);
        this.lock.getWriteLock();
        partialOrderNode.removeEdge(partialOrderNode2);
        this.isChanged = true;
        this.lock.releaseWriteLock();
    }
}

