/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUIImages;
import org.eclipse.equinox.internal.provisional.p2.ui.model.IUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.query.IUPropertyUtils;
import org.eclipse.equinox.internal.provisional.p2.ui.viewers.IUColumnConfig;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class IUDetailsLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider,
IFontProvider {
    static final int PRIMARY_COLUMN = 0;
    static final String BLANK = "";
    private String toolTipProperty = null;
    private FilteredTree filteredTree;
    private boolean useBoldFont = false;
    private boolean showingId = false;
    private IUColumnConfig[] columnConfig;
    Shell shell;
    HashMap jobs = new HashMap();
    static /* synthetic */ Class class$0;

    public IUDetailsLabelProvider() {
        this(null, null, null);
    }

    public IUDetailsLabelProvider(FilteredTree filteredTree, IUColumnConfig[] columnConfig, Shell shell) {
        this.filteredTree = filteredTree;
        this.columnConfig = columnConfig == null ? ProvUI.getIUColumnConfig() : columnConfig;
        int i = 0;
        while (i < this.columnConfig.length) {
            if (this.columnConfig[i].columnField == 0) {
                this.showingId = true;
                break;
            }
            ++i;
        }
        this.shell = shell;
    }

    public String getText(Object obj) {
        return this.getColumnText(obj, 0);
    }

    public Image getImage(Object obj) {
        return this.getColumnImage(obj, this.columnConfig[0].columnField);
    }

    public String getColumnText(Object element, int columnIndex) {
        IInstallableUnit iu;
        Class<?> clazz;
        int columnContent = 0;
        if (columnIndex < this.columnConfig.length) {
            columnContent = this.columnConfig[columnIndex].columnField;
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iu = (IInstallableUnit)ProvUI.getAdapter(element, clazz)) == null) {
            if (columnIndex == 0) {
                if (element instanceof ProvElement) {
                    return ((ProvElement)element).getLabel(element);
                }
                return element.toString();
            }
            return BLANK;
        }
        switch (columnContent) {
            case 0: {
                return iu.getId();
            }
            case 1: {
                String name = IUPropertyUtils.getIUProperty(iu, "org.eclipse.equinox.p2.name");
                if (name != null) {
                    return name;
                }
                if (this.showingId) {
                    return BLANK;
                }
                return iu.getId();
            }
            case 2: {
                if (element instanceof IUElement) {
                    if (((IUElement)element).shouldShowVersion()) {
                        return iu.getVersion().toString();
                    }
                    return BLANK;
                }
                return iu.getVersion().toString();
            }
            case 3: {
                if (element instanceof IUElement && ((IUElement)element).shouldShowSize()) {
                    return this.getIUSize((IUElement)element);
                }
                return BLANK;
            }
        }
        return BLANK;
    }

    public Image getColumnImage(Object element, int index) {
        if (index == 0) {
            if (element instanceof ProvElement) {
                return ((ProvElement)element).getImage(element);
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (ProvUI.getAdapter(element, clazz) != null) {
                return ProvUIImages.getImage("obj/iu_obj.gif");
            }
        }
        return null;
    }

    private String getIUSize(final IUElement element) {
        long size = element.getSize();
        if (size != -1L) {
            return this.getFormattedSize(size);
        }
        if (!this.jobs.containsKey(element)) {
            Job resolveJob = new Job(element.getIU().getId()){

                protected IStatus run(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (IUDetailsLabelProvider.this.shell == null || IUDetailsLabelProvider.this.shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    element.computeSize(monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (element.getSize() == -1L) {
                        return Status.OK_STATUS;
                    }
                    if (IUDetailsLabelProvider.this.shell == null || IUDetailsLabelProvider.this.shell.isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    IUDetailsLabelProvider.this.shell.getDisplay().asyncExec(new Runnable(this, element){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IUElement val$element;
                        {
                            this.this$1 = var1_1;
                            this.val$element = iUElement;
                        }

                        public void run() {
                            if (1.access$0(this.this$1).shell != null || !1.access$0(this.this$1).shell.isDisposed()) {
                                IUDetailsLabelProvider.access$0(1.access$0(this.this$1), new LabelProviderChangedEvent((IBaseLabelProvider)1.access$0(this.this$1), (Object)this.val$element));
                            }
                        }
                    });
                    return Status.OK_STATUS;
                }

                static /* synthetic */ IUDetailsLabelProvider access$0(1 var0) {
                    return var0.IUDetailsLabelProvider.this;
                }
            };
            this.jobs.put(element, resolveJob);
            resolveJob.setSystem(true);
            resolveJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    IUDetailsLabelProvider.this.jobs.remove(element);
                }
            });
            resolveJob.schedule();
        }
        return ProvUIMessages.IUDetailsLabelProvider_ComputingSize;
    }

    private String getFormattedSize(long size) {
        if (size == -1L || size == -2L) {
            return ProvUIMessages.IUDetailsLabelProvider_Unknown;
        }
        if (size > 1000L) {
            long kb = size / 1000L;
            return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_KB, (Object)NumberFormat.getInstance().format(new Long(kb)));
        }
        return NLS.bind((String)ProvUIMessages.IUDetailsLabelProvider_Bytes, (Object)NumberFormat.getInstance().format(new Long(size)));
    }

    public void setToolTipProperty(String propertyName) {
        this.toolTipProperty = propertyName;
    }

    public void setUseBoldFontForFilteredItems(boolean useBoldFont) {
        this.useBoldFont = useBoldFont;
    }

    public String getToolTipText(Object element) {
        IInstallableUnit iu;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iu = (IInstallableUnit)ProvUI.getAdapter(element, clazz)) == null || this.toolTipProperty == null) {
            return null;
        }
        return IUPropertyUtils.getIUProperty(iu, this.toolTipProperty);
    }

    public Font getFont(Object element) {
        if (this.filteredTree != null && this.useBoldFont) {
            return FilteredTree.getBoldFont((Object)element, (FilteredTree)this.filteredTree, (PatternFilter)this.filteredTree.getPatternFilter());
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        Iterator iter = this.jobs.values().iterator();
        while (iter.hasNext()) {
            Job job = (Job)iter.next();
            job.cancel();
        }
    }

    static /* synthetic */ void access$0(IUDetailsLabelProvider iUDetailsLabelProvider, LabelProviderChangedEvent labelProviderChangedEvent) {
        iUDetailsLabelProvider.fireLabelProviderChanged(labelProviderChangedEvent);
    }
}

