/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.ColorScheme;
import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XMLElement;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class XML {
    public static final String MULTICANVAS_TAG = "MULTICANVAS";
    public static final String MULTICANVAS_VERSION_PROP_TAG = "VERSION";
    public static final String MULTICANVAS_VERSION = "1.2";
    public static final String DATA_PROP_TAG = "D";
    public static final String COLOR_RED_PROP_TAG = "R";
    public static final String COLOR_GREEN_PROP_TAG = "G";
    public static final String COLOR_BLUE_PROP_TAG = "B";
    public static final String DEFINE_TAG = "DEFINE";
    public static final String DEFINE_ID_PROP_TAG = "ID";
    public static final String DEFINE_REF_PROP_TAG = "REF";
    public static final String IDENTIFY_TAG = "IDENTIFY";
    public static final String IMAGE_TAG = "IMAGE";
    public static final String LINES_TAG = "LINES";
    public static final String POINTS_TAG = "POINTS";
    public static final String POLYGON_TAG = "POLYGON";
    public static final String SEGMENTS_TAG = "SEGMENTS";
    public static final String TEXT_TAG = "TEXT";
    public static final String CANVAS_TAG = "CANVAS";
    public static final String COLORSCHEME_TAG = "COLORSCHEME";

    public static int indexOfMatchingRects(Vector vector, SGraphCommand sGraphCommand) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SGraphCommand sGraphCommand2 = (SGraphCommand)vector.elementAt(i);
            if (!sGraphCommand.sameRectProps(sGraphCommand2)) continue;
            return i;
        }
        return -1;
    }

    public static String getDefineRectTag(int n) {
        return COLOR_RED_PROP_TAG + n;
    }

    public static void writeCanvasVectorToFile(OutputStream outputStream, Vector vector) {
        if (vector == null) {
            return;
        }
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(outputStream);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)gZIPOutputStream, "UTF8");
            PrintWriter printWriter = new PrintWriter(outputStreamWriter);
            XML.writeCanvasVector(printWriter, vector);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public static void writeCanvasVector(PrintWriter printWriter, Vector vector) {
        int n;
        Serializable serializable;
        int n2;
        if (vector == null) {
            return;
        }
        ColorScheme colorScheme = null;
        Vector<SGraphCommand> vector2 = new Vector<SGraphCommand>();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            Object e = vector.elementAt(n2);
            if (!(e instanceof SCanvasAWT)) continue;
            serializable = (SCanvasAWT)e;
            if (colorScheme == null) {
                colorScheme = serializable.getColorScheme();
            }
            Enumeration enumeration = serializable.m_displayList.elements();
            while (enumeration.hasMoreElements()) {
                SGraphCommand sGraphCommand = (SGraphCommand)enumeration.nextElement();
                int n3 = XML.indexOfMatchingRects(vector2, sGraphCommand);
                if (n3 >= 0) continue;
                vector2.addElement(sGraphCommand);
            }
        }
        if (colorScheme == null) {
            return;
        }
        printWriter.print("<MULTICANVAS VERSION=1.2>\n");
        colorScheme.writeXML(printWriter, "CS1");
        n2 = vector2.size();
        for (n = 0; n < n2; ++n) {
            serializable = (SGraphCommand)vector2.elementAt(n);
            printWriter.print("<DEFINE ID=" + XML.getDefineRectTag(n));
            ((SGraphCommand)serializable).writeXMLRectProps(printWriter);
            printWriter.print("/>\n");
        }
        for (n = 0; n < vector.size(); ++n) {
            serializable = vector.elementAt(n);
            if (!(serializable instanceof SCanvasAWT)) continue;
            serializable.writeXML(printWriter, "CS1", vector2);
        }
        printWriter.print("</MULTICANVAS>\n");
    }

    public static void writeProperty(PrintWriter printWriter, String string, float f) {
        printWriter.print(" " + string + "=" + f);
    }

    public static void writeProperty(PrintWriter printWriter, String string, int n) {
        printWriter.print(" " + string + "=" + n);
    }

    public static void writeProperty(PrintWriter printWriter, String string, String string2) {
        printWriter.print(" " + string + "=");
        XML.writeString(printWriter, string2);
    }

    public static void writeData(PrintWriter printWriter, String string, float[] fArray) {
        if (fArray == null) {
            return;
        }
        int n = fArray.length;
        for (int i = 0; i < fArray.length; i += 10) {
            printWriter.print("  <" + string + " " + DATA_PROP_TAG + "=\"");
            for (int j = i; j < fArray.length && j < i + 10; ++j) {
                printWriter.print(j > i ? "," : "");
                float f = fArray[j];
                int n2 = (int)f;
                if (f == (float)n2) {
                    printWriter.print(n2);
                    continue;
                }
                printWriter.print(f);
            }
            printWriter.print("\"/>\n");
        }
    }

    public static void writeData(PrintWriter printWriter, String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = stringArray.length;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            printWriter.print("  <" + string + " " + DATA_PROP_TAG + "=");
            XML.writeString(printWriter, string2);
            printWriter.print("/>\n");
        }
    }

    public static void writeData(PrintWriter printWriter, String string, Color[] colorArray) {
        if (colorArray == null) {
            return;
        }
        int n = colorArray.length;
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            XML.writeData(printWriter, string, color);
        }
    }

    public static void writeData(PrintWriter printWriter, String string, Color color) {
        if (color == null) {
            return;
        }
        printWriter.print("  <" + string + " " + COLOR_RED_PROP_TAG + "=" + color.getRed() + " " + COLOR_GREEN_PROP_TAG + "=" + color.getGreen() + " " + COLOR_BLUE_PROP_TAG + "=" + color.getBlue() + "/>\n");
    }

    public static void writeString(PrintWriter printWriter, String string) {
        if (string == null) {
            string = "";
        }
        printWriter.print("\"");
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    printWriter.print("&amp;");
                    continue block7;
                }
                case '<': {
                    printWriter.print("&lt;");
                    continue block7;
                }
                case '>': {
                    printWriter.print("&gt;");
                    continue block7;
                }
                case '\"': {
                    printWriter.print("&quot;");
                    continue block7;
                }
                case '\'': {
                    printWriter.print("&apos;");
                    continue block7;
                }
                default: {
                    printWriter.print(c);
                }
            }
        }
        printWriter.print("\"");
    }

    public static String toXMLString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String getXMLString(XMLElement xMLElement) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        XML.writeElt(printWriter, xMLElement);
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    public static void writeElt(PrintWriter printWriter, XMLElement xMLElement) {
        Object object;
        if (printWriter == null || xMLElement == null) {
            return;
        }
        printWriter.print("<" + xMLElement.getTagName());
        Enumeration enumeration = xMLElement.enumeratePropertyNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            printWriter.print(" " + (String)object + "=");
            XML.writeString(printWriter, xMLElement.getProperty((String)object));
        }
        if (xMLElement.countChildren() < 1) {
            printWriter.print("/>");
            return;
        }
        printWriter.print(">");
        enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            object = (XMLElement)enumeration.nextElement();
            XML.writeElt(printWriter, (XMLElement)object);
        }
        printWriter.print("</" + xMLElement.getTagName() + ">");
    }

    public static Vector readCanvasVector(String string) {
        if (string == null) {
            return new Vector();
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return XML.readCanvasVector(fileInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            Vector<SCanvasAWT> vector = new Vector<SCanvasAWT>();
            String string2 = "Error opening SPJ file: " + exception.getLocalizedMessage();
            vector.addElement(SCanvasAWT.createErrorCanvas(string2));
            return vector;
        }
    }

    public static Vector readCanvasVector(InputStream inputStream) {
        if (inputStream == null) {
            return new Vector();
        }
        try {
            GZIPInputStream gZIPInputStream = new GZIPInputStream(inputStream);
            return XML.readCanvasVectorFromXML(gZIPInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            Vector<SCanvasAWT> vector = new Vector<SCanvasAWT>();
            String string = "Error reading SPJ file: " + exception.getLocalizedMessage();
            vector.addElement(SCanvasAWT.createErrorCanvas(string));
            return vector;
        }
    }

    public static Vector readCanvasVectorFromXML(InputStream inputStream) {
        if (inputStream == null) {
            return new Vector();
        }
        Vector<Object> vector = new Vector<Object>();
        XMLElement xMLElement = new XMLElement();
        String string = null;
        try {
            Object object;
            String string2;
            XMLElement xMLElement2;
            Object object2;
            long l = System.currentTimeMillis();
            int n = 4096;
            System.gc();
            byte[] byArray = new byte[n];
            int n2 = 0;
            int n3 = 0;
            while (true) {
                if (n2 >= byArray.length) {
                    object2 = new byte[byArray.length + 10 * n];
                    System.arraycopy(byArray, 0, object2, 0, byArray.length);
                    byArray = object2;
                }
                if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) < 0) break;
                n2 += n3;
            }
            object2 = new String(byArray, 0, n2, "UTF8");
            byArray = null;
            char[] cArray = ((String)object2).toCharArray();
            object2 = null;
            long l2 = System.currentTimeMillis();
            int n4 = cArray.length;
            System.out.println("read " + n4 + " characters in " + (double)(l2 - l) / 1000.0 + " seconds");
            xMLElement.parseCharArray(cArray, 0, n4, 1);
            long l3 = System.currentTimeMillis();
            System.out.println("parsed XML in " + (double)(l3 - l2) / 1000.0 + " seconds");
            System.gc();
            String string3 = xMLElement.getTagName();
            if (string3 == null || !string3.equalsIgnoreCase(MULTICANVAS_TAG)) {
                throw new Exception("Bad SPJ File Format");
            }
            String string4 = xMLElement.getProperty(MULTICANVAS_VERSION_PROP_TAG);
            System.out.println("SPJ file version=" + string4);
            IDHash iDHash = new IDHash();
            Enumeration enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                xMLElement2 = (XMLElement)enumeration.nextElement();
                string2 = xMLElement2.getTagName();
                if (string2 == null) continue;
                if (string2.equalsIgnoreCase(DEFINE_TAG)) {
                    object = xMLElement2.getProperty(DEFINE_ID_PROP_TAG);
                    if (object == null) continue;
                    iDHash.put(object, xMLElement2);
                    continue;
                }
                if (!string2.equalsIgnoreCase(COLORSCHEME_TAG) || (object = xMLElement2.getProperty(DEFINE_ID_PROP_TAG)) == null) continue;
                iDHash.put(object, ColorScheme.createFromXML(xMLElement2));
            }
            enumeration = xMLElement.enumerateChildren();
            while (enumeration.hasMoreElements()) {
                xMLElement2 = (XMLElement)enumeration.nextElement();
                string2 = xMLElement2.getTagName();
                if (string2 == null || !string2.equalsIgnoreCase(CANVAS_TAG)) continue;
                object = new SCanvasAWT();
                ((SCanvasAWT)object).setFromXML(xMLElement2, iDHash);
                if (object == null) continue;
                vector.addElement(object);
                String string5 = ((SCanvasAWT)object).getTitle();
                string5 = string5 != null && string5.equals("#") ? "" : " \"" + string5 + "\"";
                System.out.println("read canvas" + string5 + " with " + ((SCanvasAWT)object).m_displayList.size() + " commands");
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace(System.out);
            string = "Error: Out of memory";
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            String string6 = exception.getLocalizedMessage();
            string = "Error: " + string6;
        }
        if (string != null) {
            vector.addElement(SCanvasAWT.createErrorCanvas(string));
        }
        return vector;
    }

    public static Color[] getColorData(XMLElement xMLElement, String string) {
        Enumeration enumeration = xMLElement.enumerateChildren();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string2 = xMLElement2.getTagName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            ++n;
        }
        return XML.getColorData(xMLElement, string, n);
    }

    public static Color[] getColorData(XMLElement xMLElement, String string, int n) {
        int n2;
        Color[] colorArray = new Color[n];
        for (n2 = 0; n2 < n; ++n2) {
            colorArray[n2] = Color.black;
        }
        n2 = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (n2 < n && enumeration.hasMoreElements()) {
            XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
            String string2 = xMLElement2.getTagName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            try {
                n3 = Integer.parseInt(xMLElement2.getProperty(COLOR_RED_PROP_TAG, "0"));
                n4 = Integer.parseInt(xMLElement2.getProperty(COLOR_GREEN_PROP_TAG, "0"));
                n5 = Integer.parseInt(xMLElement2.getProperty(COLOR_BLUE_PROP_TAG, "0"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            colorArray[n2++] = new Color(Math.max(0, Math.min(255, n3)), Math.max(0, Math.min(255, n4)), Math.max(0, Math.min(255, n5)));
        }
        return colorArray;
    }

    public static String getStringProperty(XMLElement xMLElement, String string) {
        return XML.getStringProperty(xMLElement, string, null);
    }

    public static String getStringProperty(XMLElement xMLElement, String string, IDHash iDHash) {
        XMLElement xMLElement2;
        String string2;
        String string3 = string.toUpperCase();
        String string4 = xMLElement.getProperty(string3);
        if (string4 == null && iDHash != null && (string2 = xMLElement.getProperty(DEFINE_REF_PROP_TAG)) != null && (xMLElement2 = iDHash.getXMLElement(string2)) != null) {
            string4 = XML.getStringProperty(xMLElement2, string3, null);
        }
        return string4;
    }

    public static int getIntProperty(XMLElement xMLElement, String string, IDHash iDHash) {
        String string2 = XML.getStringProperty(xMLElement, string, iDHash);
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static float getFloatProperty(XMLElement xMLElement, String string, IDHash iDHash) {
        String string2 = XML.getStringProperty(xMLElement, string, iDHash);
        try {
            return Float.valueOf(string2).floatValue();
        }
        catch (Exception exception) {
            return 0.0f;
        }
    }

    public static float[] getFloatArrayProperty(XMLElement xMLElement, String string, IDHash iDHash) {
        String string2 = XML.getStringProperty(xMLElement, string, iDHash);
        if (string2 == null) {
            string2 = "";
        }
        int n = 0;
        int n2 = string2.indexOf(44);
        while (n2 >= 0 && n2 < string2.length()) {
            ++n;
            ++n2;
            n2 = string2.indexOf(44, n2);
        }
        float[] fArray = new float[n + 1];
        int n3 = 0;
        for (int i = 0; i < fArray.length && n3 < string2.length(); ++i) {
            int n4 = string2.indexOf(44, n3);
            String string3 = null;
            if (n4 >= 0) {
                string3 = string2.substring(n3, n4);
                n3 = n4 + 1;
            } else {
                string3 = string2.substring(n3);
                n3 = string2.length();
            }
            fArray[i] = Float.NaN;
            try {
                fArray[i] = Float.valueOf(string3).floatValue();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fArray;
    }

    public static float[] getFloatArrayData(XMLElement xMLElement, String string) {
        Object object;
        Object object2;
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            object2 = (XMLElement)enumeration.nextElement();
            String string2 = ((XMLElement)object2).getTagName();
            if (string2 == null || !string2.equalsIgnoreCase(string) || (object = XML.getStringProperty((XMLElement)object2, DATA_PROP_TAG)) == null) continue;
            int n2 = 0;
            int n3 = ((String)object).indexOf(44);
            while (n3 >= 0 && n3 < ((String)object).length()) {
                ++n2;
                ++n3;
                n3 = ((String)object).indexOf(44, n3);
            }
            n += n2 + 1;
        }
        object2 = new float[n];
        int n4 = 0;
        enumeration = xMLElement.enumerateChildren();
        while (n4 < n && enumeration.hasMoreElements()) {
            String string3;
            object = (XMLElement)enumeration.nextElement();
            String string4 = ((XMLElement)object).getTagName();
            if (string4 == null || !string4.equalsIgnoreCase(string) || (string3 = XML.getStringProperty((XMLElement)object, DATA_PROP_TAG)) == null) continue;
            int n5 = 0;
            while (n4 < n && n5 < string3.length()) {
                int n6 = string3.indexOf(44, n5);
                String string5 = null;
                if (n6 >= 0) {
                    string5 = string3.substring(n5, n6);
                    n5 = n6 + 1;
                } else {
                    string5 = string3.substring(n5);
                    n5 = string3.length();
                }
                object2[n4] = Float.NaN;
                try {
                    object2[n4] = Float.valueOf(string5).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n4;
            }
        }
        return object2;
    }

    public static String[] getStringArrayData(XMLElement xMLElement, String string) {
        Object object;
        Object object2;
        int n = 0;
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            object2 = (XMLElement)enumeration.nextElement();
            String string2 = ((XMLElement)object2).getTagName();
            if (string2 == null || !string2.equalsIgnoreCase(string) || (object = XML.getStringProperty((XMLElement)object2, DATA_PROP_TAG)) == null) continue;
            ++n;
        }
        object2 = new String[n];
        int n2 = 0;
        enumeration = xMLElement.enumerateChildren();
        while (n2 < n && enumeration.hasMoreElements()) {
            String string3;
            object = (XMLElement)enumeration.nextElement();
            String string4 = ((XMLElement)object).getTagName();
            if (string4 == null || !string4.equalsIgnoreCase(string) || (string3 = XML.getStringProperty((XMLElement)object, DATA_PROP_TAG)) == null) continue;
            object2[n2++] = string3;
        }
        return object2;
    }
}

