/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.java;

import com.insightful.splusserver.api.CommonApi;
import com.insightful.splusserver.api.bridge.AdminServiceBridgeUrl;
import com.insightful.splusserver.api.bridge.IAdminServiceBridge;
import com.insightful.splusserver.domain.SplusDataResult;
import com.insightful.splusserver.domain.SplusJobs;
import com.insightful.splusserver.domain.Value;
import com.insightful.splusserver.exception.IException;
import com.insightful.splusserver.exception.NotAuthenticatedException;
import com.insightful.splusserver.exception.ServerNotRespondingException;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.exception.api.BridgeException;
import com.insightful.splusserver.util.XmlUtil;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;

public class AdministrationService
extends CommonApi
implements Serializable {
    private static final long serialVersionUID = 5102L;
    private IAdminServiceBridge mAdminServiceBridge = null;

    public AdministrationService(String serviceUrl) throws ApiException, ServerNotRespondingException {
        try {
            this.mAdminServiceBridge = new AdminServiceBridgeUrl(serviceUrl);
            this.setServerBridge(this.mAdminServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    public AdministrationService(String userName, String password, String serviceUrl) throws ApiException, NotAuthenticatedException, ServerNotRespondingException {
        try {
            this.mAdminServiceBridge = new AdminServiceBridgeUrl(userName, password, serviceUrl);
            this.setServerBridge(this.mAdminServiceBridge);
        }
        catch (BridgeException e) {
            throw new ApiException("Creation of ServerBridge failed", (Throwable)e);
        }
    }

    IAdminServiceBridge getAdminServiceBridge() {
        return this.mAdminServiceBridge;
    }

    void setAdminServiceBridge(IAdminServiceBridge serviceBridge) {
        this.mAdminServiceBridge = serviceBridge;
        this.setServerBridge(serviceBridge);
    }

    protected Log getLogger() {
        return LogFactory.getLog(AdministrationService.class);
    }

    public SplusDataResult getJob(String jobId) throws IException {
        SplusDataResult splus = null;
        String xml = null;
        try {
            xml = this.getAdminServiceBridge().getJob(jobId);
            Object unmarshalledObj = XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
            splus = SplusDataResult.class.isInstance(unmarshalledObj) ? XmlUtil.unmarshalSplusDataResult((String)xml) : (SplusDataResult)XmlUtil.unmarshal(SplusDataResult.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return splus;
    }

    public SplusJobs getJobs(String userid) throws IException {
        SplusJobs jobs = null;
        String xml = null;
        try {
            xml = this.getAdminServiceBridge().getJobs(userid);
            jobs = (SplusJobs)XmlUtil.unmarshal(SplusJobs.class, (String)xml);
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return jobs;
    }

    public Boolean interrupt(String jobId) throws IException {
        Boolean success = false;
        String xml = null;
        try {
            xml = this.getAdminServiceBridge().interrupt(jobId);
            Value v = (Value)XmlUtil.unmarshal(Value.class, (String)xml);
            success = v.getValue() != null && v.getValue().toLowerCase().equals("TRUE");
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return success;
    }

    public Boolean purge(String jobId) throws IException {
        Boolean success = false;
        String xml = null;
        try {
            xml = this.getAdminServiceBridge().purge(jobId);
            Value v = (Value)XmlUtil.unmarshal(Value.class, (String)xml);
            success = v.getValue() != null && v.getValue().toLowerCase().equals("true");
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException e) {
            // empty catch block
        }
        return success;
    }

    public Date getServerTime() throws IException {
        String xml = null;
        try {
            xml = this.getAdminServiceBridge().getServerTime();
            Value v = (Value)XmlUtil.unmarshal(Value.class, (String)xml);
            long time = -1L;
            try {
                time = Long.parseLong(v.getValue());
                return new Date(time);
            }
            catch (Exception ex) {
                return new Date();
            }
        }
        catch (BridgeException e) {
        }
        catch (MarshalException e) {
            if (xml != null) {
                this.checkException(xml);
            }
        }
        catch (MappingException e) {
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return new Date();
    }
}

