/*
 * Decompiled with CFR 0.152.
 */
import com.insightful.splus.SplusUserApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.PixelGrabber;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ImageCalculatorExample
extends JFrame {
    Image m_image = null;
    int m_imageWidth = 0;
    int m_imageHeight = 0;
    public static int[] m_red = new int[0];
    public static int[] m_green = new int[0];
    public static int[] m_blue = new int[0];
    String m_helpText = "Type an S-PLUS expression in the \"S-PLUS input\" field, and click the \"send to S-PLUS\" button to evaluate the expression, showing the output in the \"S-PLUS output\" window.\n\nAny java.graph output will be displayed in the upper-right window.\n\nThe \"load image\" button loads an image file (gif or jpeg) into the upper-left window.  If an image is loaded, before an S-PLUS expression is evaluated the variables \"red\", \"green\", and \"blue\" are set to matrices containing the RGB values in the image.";
    JFrame m_helpFrame = null;
    JComponent m_imagePane = new JComponent(){

        public void paintComponent(Graphics graphics) {
            if (ImageCalculatorExample.this.m_image == null) {
                graphics.setColor(Color.black);
                graphics.drawString("no image", 30, 30);
            } else {
                graphics.drawImage(ImageCalculatorExample.this.m_image, 0, 0, this.getWidth(), this.getHeight(), null);
            }
        }
    };
    JComponent m_splusGraph = SplusUserApp.getGraph();
    JTextArea m_splusInput = new JTextArea();
    JTextArea m_splusOutput = new JTextArea();
    String m_currentDirectory = null;

    public ImageCalculatorExample() {
        super("Image Calculator Example");
        JScrollPane jScrollPane = new JScrollPane(this.m_splusInput, 22, 32);
        JScrollPane jScrollPane2 = new JScrollPane(this.m_splusOutput, 22, 32);
        this.m_imagePane.setBorder(BorderFactory.createTitledBorder("image"));
        this.m_splusGraph.setBorder(BorderFactory.createTitledBorder("S-PLUS graph"));
        jScrollPane.setBorder(BorderFactory.createTitledBorder("S-PLUS input"));
        jScrollPane2.setBorder(BorderFactory.createTitledBorder("S-PLUS output"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 5, 5));
        jPanel2.add(this.m_imagePane);
        jPanel2.add(this.m_splusGraph);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jScrollPane);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(jScrollPane2);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.add(this.newButton("load image", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageCalculatorExample.this.loadImage();
            }
        }));
        jPanel3.add(this.newButton("send to S-PLUS", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageCalculatorExample.this.m_splusOutput.setText("sending command to splus...");
                Thread thread = new Thread(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        3.access$000(this.this$1).doSplusExpression();
                    }
                };
                thread.start();
            }

            static /* synthetic */ ImageCalculatorExample access$000(3 var0) {
                return var0.ImageCalculatorExample.this;
            }
        }));
        jPanel3.add(this.newButton("clear input", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImageCalculatorExample.this.m_splusInput.setText("");
            }
        }));
        jPanel3.add(this.newButton("help", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ImageCalculatorExample.this.m_helpFrame != null) {
                    ImageCalculatorExample.this.m_helpFrame.dispose();
                    ImageCalculatorExample.this.m_helpFrame = null;
                }
                ImageCalculatorExample.this.m_helpFrame = new JFrame("Help");
                ImageCalculatorExample.this.m_helpFrame.getContentPane().setLayout(new BorderLayout());
                JTextArea jTextArea = new JTextArea(ImageCalculatorExample.this.m_helpText);
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea, 22, 31);
                ImageCalculatorExample.this.m_helpFrame.getContentPane().add((Component)jScrollPane, "Center");
                ImageCalculatorExample.this.m_helpFrame.setSize(300, 200);
                ImageCalculatorExample.this.m_helpFrame.setVisible(true);
                jScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        }));
        jPanel3.add(this.newButton("quit", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        }));
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "South");
        this.setSize(600, 400);
        this.show();
    }

    public JButton newButton(String string, ActionListener actionListener) {
        JButton jButton = new JButton(string);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public void loadImage() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.m_currentDirectory == null ? null : new File(this.m_currentDirectory));
        int n = jFileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        this.m_currentDirectory = jFileChooser.getCurrentDirectory().getPath();
        String string = jFileChooser.getSelectedFile().getPath();
        this.m_image = Toolkit.getDefaultToolkit().createImage(string);
        try {
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.m_image, 0);
            mediaTracker.waitForAll(2000L);
            this.m_imageWidth = this.m_image.getWidth(this);
            this.m_imageHeight = this.m_image.getHeight(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_imagePane.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void doSplusExpression() {
        Object object;
        Object object2;
        String string = "";
        if (this.m_image != null) {
            void var5_9;
            int n2 = this.m_imageWidth * this.m_imageHeight;
            object2 = new int[n2];
            object = new PixelGrabber(this.m_image, 0, 0, this.m_imageWidth, this.m_imageHeight, (int[])object2, 0, this.m_imageWidth);
            try {
                boolean n = ((PixelGrabber)object).grabPixels();
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_red = new int[n2];
            m_green = new int[n2];
            m_blue = new int[n2];
            boolean bl = false;
            while (var5_9 < n2) {
                ImageCalculatorExample.m_red[var5_9] = (object2[var5_9] & 0xFF0000) >> 16;
                ImageCalculatorExample.m_green[var5_9] = (object2[var5_9] & 0xFF00) >> 8;
                ImageCalculatorExample.m_blue[var5_9] = object2[var5_9] & 0xFF;
                ++var5_9;
            }
            string = this.getImageMatrixCommand("red") + ";" + this.getImageMatrixCommand("green") + ";" + this.getImageMatrixCommand("blue") + ";";
        }
        String string2 = string + this.m_splusInput.getText();
        object2 = SplusUserApp.eval((String)string2, (boolean)true, (boolean)false, (boolean)true, (boolean)false, (boolean)false);
        object = "";
        if (object2.hasOutput()) {
            object = (String)object + object2.getOutput() + "\n\n";
        }
        if (object2.hasError()) {
            object = (String)object + object2.getError();
        }
        if (((String)object).length() < 1) {
            object = (String)object + "no output";
        }
        this.m_splusOutput.setText((String)object);
    }

    public String getImageMatrixCommand(String string) {
        String string2 = string;
        String string3 = "m_" + string;
        return string2 + " <- " + "matrix(data=.JavaField(" + "\"ImageCalculatorExample\"" + ", \"" + string3 + "\"" + ", \"[I\", client = T), nrow=" + this.m_imageHeight + ", ncol=" + this.m_imageWidth + ", byrow=T)";
    }

    public static void main(String[] stringArray) {
        new ImageCalculatorExample();
    }
}

