/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.pagination;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.pagination.PageSequenceMaster;
import org.apache.fop.fo.pagination.Region;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.xml.sax.Locator;

public class LayoutMasterSet
extends FObj {
    private Map simplePageMasters;
    private Map pageSequenceMasters;

    public LayoutMasterSet(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
    }

    protected void startOfNode() throws FOPException {
        this.getRoot().setLayoutMasterSet(this);
        this.simplePageMasters = new HashMap();
        this.pageSequenceMasters = new HashMap();
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes == null) {
            this.missingChildElementError("(simple-page-master|page-sequence-master)+");
        }
        this.checkRegionNames();
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI)) {
            if (!localName.equals("simple-page-master") && !localName.equals("page-sequence-master")) {
                this.invalidChildError(loc, nsURI, localName);
            }
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    private void checkRegionNames() throws ValidationException {
        HashMap<String, String> allRegions = new HashMap<String, String>();
        Iterator spm = this.simplePageMasters.values().iterator();
        while (spm.hasNext()) {
            SimplePageMaster simplePageMaster = (SimplePageMaster)spm.next();
            Map spmRegions = simplePageMaster.getRegions();
            Iterator e = spmRegions.values().iterator();
            while (e.hasNext()) {
                String defaultRegionName;
                Region region = (Region)e.next();
                if (allRegions.containsKey(region.getRegionName()) && !(defaultRegionName = (String)allRegions.get(region.getRegionName())).equals(region.getDefaultRegionName())) {
                    throw new ValidationException("Region-name (" + region.getRegionName() + ") is being mapped to multiple " + "region-classes (" + defaultRegionName + " and " + region.getDefaultRegionName() + ")", this.locator);
                }
                allRegions.put(region.getRegionName(), region.getDefaultRegionName());
            }
        }
    }

    protected void addSimplePageMaster(SimplePageMaster sPM) throws ValidationException {
        String masterName = sPM.getMasterName();
        if (this.existsName(masterName)) {
            throw new ValidationException("'master-name' (" + masterName + ") must be unique " + "across page-masters and page-sequence-masters", sPM.locator);
        }
        this.simplePageMasters.put(masterName, sPM);
    }

    private boolean existsName(String masterName) {
        return this.simplePageMasters.containsKey(masterName) || this.pageSequenceMasters.containsKey(masterName);
    }

    public SimplePageMaster getSimplePageMaster(String masterName) {
        return (SimplePageMaster)this.simplePageMasters.get(masterName);
    }

    protected void addPageSequenceMaster(String masterName, PageSequenceMaster pSM) throws ValidationException {
        if (this.existsName(masterName)) {
            throw new ValidationException("'master-name' (" + masterName + ") must be unique " + "across page-masters and page-sequence-masters", pSM.locator);
        }
        this.pageSequenceMasters.put(masterName, pSM);
    }

    public PageSequenceMaster getPageSequenceMaster(String masterName) {
        return (PageSequenceMaster)this.pageSequenceMasters.get(masterName);
    }

    public boolean regionNameExists(String regionName) {
        Iterator e = this.simplePageMasters.values().iterator();
        while (e.hasNext()) {
            if (!((SimplePageMaster)e.next()).regionNameExists(regionName)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "fo:layout-master-set";
    }

    public int getNameId() {
        return 18;
    }
}

