/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.XMLHandler;
import org.apache.fop.util.Service;

public class XMLHandlerRegistry {
    private static Log log = LogFactory.getLog(class$org$apache$fop$render$XMLHandlerRegistry == null ? (class$org$apache$fop$render$XMLHandlerRegistry = XMLHandlerRegistry.class$("org.apache.fop.render.XMLHandlerRegistry")) : class$org$apache$fop$render$XMLHandlerRegistry);
    private Map handlers = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$render$XMLHandlerRegistry;
    static /* synthetic */ Class class$org$apache$fop$render$XMLHandler;

    public XMLHandlerRegistry() {
        this.discoverXMLHandlers();
    }

    private void setDefaultXMLHandler(String mime, XMLHandler handler) {
        this.addXMLHandler(mime, "*", handler);
    }

    public void addXMLHandler(String classname) {
        try {
            XMLHandler handlerInstance = (XMLHandler)Class.forName(classname).newInstance();
            this.addXMLHandler(handlerInstance);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not find " + classname);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Could not instantiate " + classname);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Could not access " + classname);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(classname + " is not an ElementMapping");
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        String mime = handler.getMimeType();
        String ns = handler.getNamespace();
        if (ns == null) {
            this.setDefaultXMLHandler(mime, handler);
        } else {
            this.addXMLHandler(mime, ns, handler);
        }
    }

    private void addXMLHandler(String mime, String ns, XMLHandler handler) {
        HashMap<String, XMLHandler> mh = (HashMap<String, XMLHandler>)this.handlers.get(mime);
        if (mh == null) {
            mh = new HashMap<String, XMLHandler>();
            this.handlers.put(mime, mh);
        }
        mh.put(ns, handler);
    }

    public XMLHandler getXMLHandler(String mime, String ns) {
        XMLHandler handler = null;
        Map mh = (Map)this.handlers.get(mime);
        if (mh != null && (handler = (XMLHandler)mh.get(ns)) == null) {
            handler = (XMLHandler)mh.get("*");
        }
        if (handler == null && (mh = (Map)this.handlers.get("*")) != null && (handler = (XMLHandler)mh.get(ns)) == null) {
            handler = (XMLHandler)mh.get("*");
        }
        return handler;
    }

    private void discoverXMLHandlers() {
        Iterator providers = Service.providers(class$org$apache$fop$render$XMLHandler == null ? (class$org$apache$fop$render$XMLHandler = XMLHandlerRegistry.class$("org.apache.fop.render.XMLHandler")) : class$org$apache$fop$render$XMLHandler);
        if (providers != null) {
            while (providers.hasNext()) {
                String str = (String)providers.next();
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Dynamically adding XMLHandler: " + str);
                    }
                    this.addXMLHandler(str);
                }
                catch (IllegalArgumentException e) {
                    log.error("Error while adding XMLHandler", e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

