/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.traits;

import java.io.Serializable;
import org.apache.fop.datatypes.ColorType;

public class BorderProps
implements Serializable {
    public static final int SEPARATE = 0;
    public static final int COLLAPSE_INNER = 1;
    public static final int COLLAPSE_OUTER = 2;
    public int style;
    public ColorType color;
    public int width;
    public int mode;

    public BorderProps(int style, int width, ColorType color, int mode) {
        this.style = style;
        this.width = width;
        this.color = color;
        this.mode = mode;
    }

    public static int getClippedWidth(BorderProps bp) {
        if (bp != null && bp.mode != 0) {
            return bp.width / 2;
        }
        return 0;
    }

    private String getStyleString() {
        switch (this.style) {
            case 95: {
                return "none";
            }
            case 57: {
                return "hidden";
            }
            case 36: {
                return "dotted";
            }
            case 31: {
                return "dashed";
            }
            case 133: {
                return "solid";
            }
            case 37: {
                return "double";
            }
            case 55: {
                return "groove";
            }
            case 119: {
                return "ridge";
            }
            case 67: {
                return "inset";
            }
            case 101: {
                return "outset";
            }
        }
        throw new IllegalStateException("Illegal border style: " + this.style);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        sbuf.append(this.getStyleString());
        sbuf.append(',');
        sbuf.append(this.color);
        sbuf.append(',');
        sbuf.append(this.width);
        if (this.mode != 0) {
            sbuf.append(',');
            if (this.mode == 1) {
                sbuf.append("collapse-inner");
            } else {
                sbuf.append("collapse-outer");
            }
        }
        sbuf.append(')');
        return sbuf.toString();
    }
}

