/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.server.util;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.eclipse.server.UiProperties;
import com.insightful.splus.eclipse.server.util.RemoteUtils;

public class RemoteResults {
    public String splusCode;
    public String created;
    public String createdBy;
    public String jobId;
    public String status;
    public String resultsDir;
    public String error;
    public String warnings;
    public String output;
    public String resultSpxml;

    public static RemoteResults[] getRemoteResults(String[] stringArray) {
        RemoteResults[] remoteResultsArray = null;
        int n = Integer.parseInt(stringArray[0]);
        int n2 = 1;
        remoteResultsArray = new RemoteResults[n];
        for (int i = 0; i < n; ++i) {
            remoteResultsArray[i] = new RemoteResults();
            n2 = remoteResultsArray[i].initialize(stringArray, n2);
        }
        return remoteResultsArray;
    }

    private RemoteResults() {
    }

    public RemoteResults(SplusDataResult splusDataResult) {
        if (splusDataResult == null) {
            return;
        }
        try {
            String[] stringArray = splusDataResult.getStringData();
            this.initialize(stringArray, 0);
        }
        catch (SplusBadDataException splusBadDataException) {
            splusBadDataException.printStackTrace();
        }
    }

    private int initialize(String[] stringArray, int n) {
        int n2 = n;
        this.splusCode = stringArray[n2++];
        this.created = stringArray[n2++];
        this.createdBy = stringArray[n2++];
        this.jobId = stringArray[n2++];
        this.status = stringArray[n2++];
        this.resultsDir = stringArray[n2++];
        this.error = stringArray[n2++];
        this.warnings = stringArray[n2++];
        this.output = stringArray[n2++];
        this.resultSpxml = stringArray[n2++];
        return n2;
    }

    private boolean hasValidInfo(String string) {
        return string != null && string.length() != 0;
    }

    public String constructInput() {
        String string = this.splusCode;
        if (this.hasValidInfo(string)) {
            string = RemoteUtils.unwrapSplusCodeToRetrieveOutputAndReturnValue(string);
        }
        return string;
    }

    public String constructOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hasValidInfo(this.output)) {
            int n = this.output.indexOf(RemoteUtils.EXECUTION_DEMARCATION);
            int n2 = this.output.indexOf(RemoteUtils.STARTUP_DEMARCATION);
            stringBuffer.append(RemoteUtils.REMOTE_DEMARCATION);
            stringBuffer.append("\n");
            if (this.hasValidInfo(this.created)) {
                stringBuffer.append("\t");
                stringBuffer.append(UiProperties.getString("RemoteResults.Date"));
                stringBuffer.append(": ");
                stringBuffer.append(this.created);
                stringBuffer.append("\n");
            }
            if (this.hasValidInfo(this.resultsDir)) {
                stringBuffer.append("\t");
                stringBuffer.append(UiProperties.getString("RemoteResults.ResultsDirectory"));
                stringBuffer.append(": ");
                stringBuffer.append(this.resultsDir);
                stringBuffer.append("\n");
            }
            if (this.hasValidInfo(this.jobId)) {
                stringBuffer.append("\t");
                stringBuffer.append(UiProperties.getString("RemoteResults.JobId"));
                stringBuffer.append(": ");
                stringBuffer.append(this.jobId);
                stringBuffer.append("\n");
            }
            stringBuffer.append(RemoteUtils.REMOTE_DEMARCATION_END);
            stringBuffer.append("\n");
            stringBuffer.append(this.output.substring(n2 + RemoteUtils.STARTUP_DEMARCATION.length()).trim());
            stringBuffer.append("\n\n");
            stringBuffer.append(this.output.substring(n + RemoteUtils.EXECUTION_DEMARCATION.length(), n2).trim());
        }
        return stringBuffer.toString();
    }

    public String constructInput(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RemoteUtils.REMOTE_DECLARATION);
        stringBuffer.append("\n");
        if (this.hasValidInfo(this.jobId)) {
            stringBuffer.append("\t");
            stringBuffer.append(UiProperties.getString("RemoteResults.JobId"));
            stringBuffer.append(": ");
            stringBuffer.append(this.jobId);
            stringBuffer.append("\n");
        }
        if (string != null) {
            stringBuffer.append("\t");
            stringBuffer.append(UiProperties.getString("RemoteResults.SubmittedScript"));
            stringBuffer.append(":\n\n");
            stringBuffer.append(string);
            stringBuffer.append("\n\n");
        }
        stringBuffer.append(RemoteUtils.REMOTE_DEMARCATION_END);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

