/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppendEngineNode;
import com.insightful.miner.EngineOrderNodeModelInputIterator;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AppendDialog
extends NodeDialog {
    private static AppendDialog g_instance = null;
    private int m_rowHeight = 25;
    private int m_iconWidth = 75;
    private static final int g_inputNameColumn = 0;
    private static final int g_includeUnmatchedColumn = 1;
    private MATableModel m_tableModel;
    private NodeDialog.DialogTable m_table;
    private AbstractAction includeAllAction;
    private AbstractAction excludeAllAction;

    public static AppendDialog getInstance() {
        if (g_instance == null) {
            g_instance = new AppendDialog();
        }
        return g_instance;
    }

    private AppendDialog() {
        Dimension dim = new Dimension(550, 525);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        super.restoreProperties();
        try {
            this.m_tableModel.clearTable();
            ActivityNodeModel model = this.getNodeModel();
            XTProps props = model.getXTProps();
            Hashtable<String, String> columnNameMap = new Hashtable<String, String>();
            int nInputs = model.getExistingNumberInputs();
            XTMetaData[] inMDs = new XTMetaData[nInputs];
            String[] path = new String[2];
            boolean numKeys = false;
            boolean[] pInclude = AppendEngineNode.getMultiIncludeUnmatched(props, nInputs);
            EngineOrderNodeModelInputIterator iterator = new EngineOrderNodeModelInputIterator(model);
            while (iterator.hasNext()) {
                int i = iterator.getInputNumber();
                inMDs[i] = iterator.peekInputMetaData();
                ActivityNodeModel aModel = (ActivityNodeModel)iterator.next();
                int nodeID = aModel.getID();
                Vector<Object> row = new Vector<Object>();
                Vector cNames = inMDs[i].getColumnNames();
                for (int j = 0; j < cNames.size(); ++j) {
                    String cName = (String)cNames.get(j);
                    if (columnNameMap.get(cName) != null) continue;
                    columnNameMap.put(cName, cName);
                }
                row.add(aModel.getLabelText());
                row.add(new Boolean(pInclude[i]));
                this.m_tableModel.addRow(row);
            }
            this.setTableProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJoinByKey(boolean isByKey) {
        this.m_table.setEnabled(isByKey);
        this.includeAllAction.setEnabled(isByKey);
        this.excludeAllAction.setEnabled(isByKey);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        super.saveProperties();
        ActivityNodeModel model = this.getNodeModel();
        XTProps props = model.getXTProps();
        String[] unmatchedPath = new String[]{AppendEngineNode.MULTI_APPEND_UNMATCHED_ATTRIBUTE_TAG, ""};
        props.removeProperty(new String[]{AppendEngineNode.LEFT_TYPE_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{AppendEngineNode.RIGHT_TYPE_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{AppendEngineNode.MERGE_TYPE_ATTRIBUTE_TAG});
        int nInputs = this.m_table.getRowCount();
        for (int i = 0; i < nInputs; ++i) {
            unmatchedPath[1] = Integer.toString(i);
            props.set(unmatchedPath, (boolean)((Boolean)this.m_tableModel.getValueAt(i, 1)));
        }
        props.set(AppendEngineNode.MULTI_APPEND_NUM_INPUTS_ATTRIBUTE_TAG, this.m_tableModel.getRowCount());
    }

    public JPanel createOptionsPanel() {
        JLabel numInputsLabel = new JLabel(MinerApp.getText("JoinDialog_setNumInputs"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 15, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.createKeyColumnPanel(), gbc);
        return panel;
    }

    public void createActions() {
        super.createActions();
        this.includeAllAction = new AbstractAction(MinerApp.getText("JoinDialog_includeAll")){

            public void actionPerformed(ActionEvent e) {
                if (AppendDialog.this.m_table.isEditing()) {
                    AppendDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                int rows = AppendDialog.this.m_table.getRowCount();
                Boolean include = new Boolean(true);
                for (int i = 0; i < rows; ++i) {
                    AppendDialog.this.m_tableModel.setValueAt(include, i, 1);
                }
                AppendDialog.this.m_tableModel.fireTableDataChanged();
            }
        };
        this.excludeAllAction = new AbstractAction(MinerApp.getText("JoinDialog_excludeAll")){

            public void actionPerformed(ActionEvent e) {
                if (AppendDialog.this.m_table.isEditing()) {
                    AppendDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                int rows = AppendDialog.this.m_table.getRowCount();
                Boolean include = new Boolean(false);
                for (int i = 0; i < rows; ++i) {
                    AppendDialog.this.m_tableModel.setValueAt(include, i, 1);
                }
                AppendDialog.this.m_tableModel.fireTableDataChanged();
            }
        };
    }

    public JPanel createKeyColumnPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        Insets margins = new Insets(5, 5, 5, 5);
        this.m_tableModel = new MATableModel();
        NodeDialog.TableSorter sortingModel = new NodeDialog.TableSorter(this.m_tableModel);
        this.m_table = new NodeDialog.DialogTable(sortingModel);
        sortingModel.addMouseListenerToHeaderInTable(this.m_table);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setAutoResizeMode(0);
        this.setTableProperties();
        JScrollPane scrollingTable = new JScrollPane(this.m_table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        JButton includeAll = new JButton(this.includeAllAction);
        JButton excludeAll = new JButton(this.excludeAllAction);
        JPanel inclExclUnmatchedPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = margins;
        gbc.weightx = 0.5;
        inclExclUnmatchedPanel.add((Component)includeAll, gbc);
        inclExclUnmatchedPanel.add((Component)excludeAll, gbc);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        leftPanel.add((Component)scrollingTable, gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        leftPanel.add((Component)inclExclUnmatchedPanel, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = margins;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        panel.add((Component)leftPanel, gbc);
        return panel;
    }

    public void setTableProperties() {
        ActivityNodeModel model = this.getNodeModel();
        if (model != null) {
            this.m_table.setRowHeight(this.m_rowHeight);
        }
        int columnCount = this.m_tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.m_table.getColumn(this.m_table.getColumnName(i));
            column.setPreferredWidth(this.m_iconWidth);
            column.setCellRenderer(new NodeDialog.LeftJustifiedStringRenderer());
        }
        String inputColName = this.m_table.getColumnName(0);
        int width = new JLabel((String)inputColName).getPreferredSize().width * 5;
        this.m_table.getColumn(inputColName).setPreferredWidth(width);
        String inclUnmatchName = this.m_table.getColumnName(1);
        TableColumn checkBoxTableColumn = this.m_table.getColumn(inclUnmatchName);
        checkBoxTableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        checkBoxTableColumn.setCellRenderer(new BooleanRenderer());
        width = (int)((double)new JLabel((String)inclUnmatchName).getPreferredSize().width * 1.5);
        checkBoxTableColumn.setPreferredWidth(width);
    }

    private class BooleanRenderer
    implements TableCellRenderer,
    Serializable {
        private Color background = new JTextField("").getBackground();
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            this.rend.setBackground(this.background);
            return this.rend;
        }
    }

    private class MATableModel
    extends DefaultTableModel {
        private Vector m_columnNames = new Vector();
        private int m_numPreKeyColumns = 3;
        private int m_numKeyColumns = 1;

        public MATableModel() {
            this.setColumnNames();
        }

        private void setColumnNames() {
            this.m_columnNames.clear();
            this.m_columnNames.add(MinerApp.getText("JoinDialog_inputName"));
            this.m_columnNames.add(MinerApp.getText("JoinDialog_includeUnmatched"));
            this.setColumnIdentifiers(this.m_columnNames);
            if (AppendDialog.this.m_tableModel != null) {
                AppendDialog.this.setTableProperties();
            }
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
        }

        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.m_numKeyColumns = 1;
            this.setColumnNames();
            this.fireTableDataChanged();
        }
    }
}

