/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AggregateEngineNode;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;

public class CrosstabulateEngineNode
extends EngineNode {
    public static String CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG = AggregateEngineNode.AGGREGATE_COLUMNS_ATTRIBUTE_TAG;
    public static String TABULAR_ATTRIBUTE_TAG = "tabular";
    public static String CHART_ATTRIBUTE_TAG = "chart";
    public static String ROWS_ATTRIBUTE_TAG = "rows";
    public static String COLUMNS_ATTRIBUTE_TAG = "columns";
    public static String PAGES_ATTRIBUTE_TAG = "pages";
    public static String MAIN_EFFECT_ATTRIBUTE_TAG = "mainEffect";
    public static String COUNT_ATTRIBUTE_TAG = "Count";
    public static String SORT_ATTRIBUTE_TAG = "sort";
    public static String META_DATA_CACHE = "metadata_cache";
    public static String COUNTS_DATA_CACHE = "counts_cache";
    public static String LOWER_BOUND_PERCENT_ATTRIBUTE_TAG = "lowerBound";
    public static String TABLE_CELL_TYPE_ATTRIBUTE_TAG = "cellType";
    public static String ABSOLUTE_COUNT_ATTRIBUTE_TAG = "absCount";
    public static String ROW_PERCENT_ATTRIBUTE_TAG = "rowPercent";
    public static String COLUMN_PERCENT_ATTRIBUTE_TAG = "columnPercent";
    public static String TOTAL_PERCENT_ATTRIBUTE_TAG = "totalPercent";
    public static final boolean TABULAR_DEFAULT = true;
    public static final boolean CHART_DEFAULT = false;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        XTMetaData outputMetaData = new XTMetaData();
        XTMetaData inputMetaData = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector aggregateColumns = props.getSubProperties(CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
        String[] remPath = new String[]{CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG, ""};
        for (int i = aggregateColumns.size() - 1; i >= 0; --i) {
            String aggColumn = (String)aggregateColumns.get(i);
            if (inputMetaData.isCategoricalColumn(aggColumn)) continue;
            remPath[1] = aggColumn;
            props.removeProperty(remPath);
        }
        String inputFilename = this.getInputDataCacheFileName(0);
        int rowChunkSize = this.getMaxRowsPerBlock();
        boolean nanAtTop = false;
        boolean sortRequired = props.getBoolean(SORT_ATTRIBUTE_TAG, true);
        File aggFile = new File(this.getInputDataCacheFileName(0));
        File outputFile = this.createWorkspaceTempFile("crosstab", "tmp");
        outputFile.deleteOnExit();
        String outputFilename = outputFile.getAbsolutePath();
        AggregateEngineNode agg = new AggregateEngineNode();
        boolean success = agg.aggregateRows(inputMetaData, outputMetaData, props, this, inputFilename, outputFilename, rowChunkSize, nanAtTop, sortRequired, true);
        if (success) {
            XTProps outputProps = this.createNodeCache(outputFilename, props, inputMetaData, outputMetaData);
            boolean bl = success = outputProps != null;
            if (success) {
                this.setNodeCache(COUNTS_DATA_CACHE, outputProps);
            }
        }
        outputFile.delete();
        return success;
    }

    protected XTProps createNodeCache(String filename, XTProps dialogProps, XTMetaData inputMD, XTMetaData outputMD) throws Exception {
        int j;
        FileInputStream aggStream = new FileInputStream(filename);
        BufferedInputStream aggBuffer = new BufferedInputStream(aggStream);
        DataInputStream aggInputStream = new DataInputStream(aggBuffer);
        Vector crosstabColumns = dialogProps.getSubProperties(CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
        for (int i = crosstabColumns.size() - 1; i >= 0; --i) {
            String ctCol = (String)crosstabColumns.get(i);
            if (outputMD.isCategoricalColumn(ctCol)) continue;
            crosstabColumns.remove(i);
        }
        int numCrosstabColumns = crosstabColumns.size();
        if (numCrosstabColumns == 0) {
            this.printlnError("There are no valid columns selected.");
            return null;
        }
        Vector[] crosstabLevels = new Vector[numCrosstabColumns];
        int[] crosstabIndex = new int[numCrosstabColumns];
        int[] crosstabNumLevels = new int[numCrosstabColumns];
        int numCounts = 1;
        for (int i = 0; i < numCrosstabColumns; ++i) {
            String colName = (String)crosstabColumns.get(i);
            crosstabLevels[i] = outputMD.getCategoricalDataFieldLevels(colName);
            if (inputMD.getColumnMissingCount(colName) > 0.0) {
                crosstabLevels[i].add("NaN");
            }
            crosstabNumLevels[i] = crosstabLevels[i].size();
            numCounts *= crosstabNumLevels[i];
            crosstabIndex[i] = 0;
        }
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(outputMD);
        int rowNumColumns = rowBuf.getNumColumns();
        double[] currLevels = new double[numCrosstabColumns];
        XTProps outputProps = new XTProps();
        String[] path = new String[numCrosstabColumns * 2 + 3];
        path[0] = (String)crosstabColumns.get(0);
        path[numCrosstabColumns * 2 - 1] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[numCrosstabColumns * 2] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
        path[numCrosstabColumns * 2 + 2] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
        boolean notDone = true;
        try {
            rowBuf.readRowUnsafe(aggInputStream);
            for (j = 0; j < numCrosstabColumns; ++j) {
                currLevels[j] = rowBuf.getDouble(j);
            }
        }
        catch (Exception e) {
            notDone = false;
        }
        while (notDone) {
            double count;
            for (j = 1; j < numCrosstabColumns; ++j) {
                path[2 * j - 1] = (String)crosstabColumns.get(j);
                int colNum = inputMD.nameToOrdinal(path[2 * j - 1]);
                int levNum = (int)currLevels[j];
                path[2 * j] = Double.isNaN(currLevels[j]) ? "NaN" : inputMD.getCategoricalDataFieldLevel(colNum, levNum);
            }
            int levNum = (int)currLevels[0];
            path[numCrosstabColumns * 2 + 1] = Integer.toString(levNum);
            if (Double.isNaN(currLevels[0])) {
                path[numCrosstabColumns * 2 + 1] = "NaN";
            }
            if ((count = rowBuf.getDouble(rowNumColumns - 1)) != 0.0) {
                outputProps.set(path, Double.toString(count));
            }
            try {
                rowBuf.readRowUnsafe(aggInputStream);
                for (int j2 = 0; j2 < numCrosstabColumns; ++j2) {
                    currLevels[j2] = rowBuf.getDouble(j2);
                }
            }
            catch (Exception e) {
                notDone = false;
            }
        }
        aggInputStream.close();
        return outputProps;
    }

    protected XTProps createBDLNodeCache(String filename, XTProps dialogProps, XTMetaData inputMD, XTMetaData outputMD) throws Exception {
        int j;
        FileInputStream aggStream = new FileInputStream(filename);
        BufferedInputStream aggBuffer = new BufferedInputStream(aggStream);
        DataInputStream aggInputStream = new DataInputStream(aggBuffer);
        Vector crosstabColumns = dialogProps.getSubProperties(CROSSTABULATE_COLUMNS_ATTRIBUTE_TAG);
        for (int i = crosstabColumns.size() - 1; i >= 0; --i) {
            String ctCol = (String)crosstabColumns.get(i);
            if (outputMD.isCategoricalColumn(ctCol)) continue;
            crosstabColumns.remove(i);
        }
        int numCrosstabColumns = crosstabColumns.size();
        if (numCrosstabColumns == 0) {
            this.printlnError("There are no valid columns selected.");
            return null;
        }
        Vector[] crosstabLevels = new Vector[numCrosstabColumns];
        int[] crosstabIndex = new int[numCrosstabColumns];
        int[] crosstabNumLevels = new int[numCrosstabColumns];
        int numCounts = 1;
        for (int i = 0; i < numCrosstabColumns; ++i) {
            String colName = (String)crosstabColumns.get(i);
            crosstabLevels[i] = outputMD.getCategoricalDataFieldLevels(colName);
            if (inputMD.getColumnMissingCount(colName) > 0.0) {
                crosstabLevels[i].add("NaN");
            }
            crosstabNumLevels[i] = crosstabLevels[i].size();
            numCounts *= crosstabNumLevels[i];
            crosstabIndex[i] = 0;
        }
        DataCacheRowBuf rowBuf = new DataCacheRowBuf(outputMD);
        int rowNumColumns = rowBuf.getNumColumns();
        double[] currLevels = new double[numCrosstabColumns];
        XTProps outputProps = new XTProps();
        String[] path = new String[numCrosstabColumns * 2];
        boolean notDone = true;
        try {
            rowBuf.readRowUnsafe(aggInputStream);
            for (j = 0; j < numCrosstabColumns; ++j) {
                currLevels[j] = rowBuf.getDouble(j);
            }
        }
        catch (Exception e) {
            notDone = false;
        }
        while (notDone) {
            for (j = 0; j < numCrosstabColumns; ++j) {
                path[2 * j] = (String)crosstabColumns.get(j);
                int colNum = inputMD.nameToOrdinal(path[2 * j]);
                int levNum = (int)currLevels[j];
                path[2 * j + 1] = Double.isNaN(currLevels[j]) ? "NaN" : inputMD.getCategoricalDataFieldLevel(colNum, levNum);
            }
            double count = rowBuf.getDouble(rowNumColumns - 1);
            outputProps.set(path, Double.toString(count));
            try {
                rowBuf.readRowUnsafe(aggInputStream);
                for (int j2 = 0; j2 < numCrosstabColumns; ++j2) {
                    currLevels[j2] = rowBuf.getDouble(j2);
                }
            }
            catch (Exception e) {
                notDone = false;
            }
        }
        aggInputStream.close();
        return outputProps;
    }
}

