/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.CollapsedNodeDialog;
import com.insightful.miner.CommentUtilities;
import com.insightful.miner.DnDTreeUtility;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.IconableTreeCellRenderer;
import com.insightful.miner.LibraryTreeNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.MultiLineDocument;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.dndtree.DragOverData;
import com.insightful.miner.dndtree.VetoException;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DragAndDropTree
extends JTree
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    public static final String USER_LIBRARY_FILE_NAME = "UserLibrary.iml";
    public static final String USER_LIBRARY_TAG = "UserLibrary";
    public static final String EXPLORER_TREE_NODE_TAG = "ExplorerTree";
    public static final String EXPLORER_PAGE_NODE_TAG = "ExplorerPage";
    public static final String EXPLORER_NODE_LIST_NODE_TAG = "ExplorerNodeList";
    public static final String EXPLORER_FOLDER_NODE_TAG = "ExplorerFolder";
    public static final String EXPANDED_ATTRIBUTE_TAG = "expanded";
    public static final String LABEL_ATTRIBUTE_TAG = "labelText";
    public static final String DESCRIPTION_ATTRIBUTE_TAG = "description";
    public static final String AUTHOR_ATTRIBUTE_TAG = "author";
    public static final String EDITABLE_ATTRIBUTE_TAG = "editable";
    public static final String VERSION_ATTRIBUTE_TAG = "version";
    public static final String FOLDER_TAG = "Folder";
    protected static int rowHeight = DragAndDropTree.getDefaultRowHeight();
    protected static final int DO_COMMENT = 0;
    protected static final int DO_DEFAULT_PROPS = 1;
    protected static final int DO_HELP = 2;
    protected static final int DO_CREATE = 3;
    private String m_treeTitle = "";
    private String m_treeDescription = "";
    private String m_treeAuthor = "";
    private String m_editableFilename = "";
    private String m_originalFilepath = "";
    private String m_version = XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG;
    protected boolean m_disableDeleteKey = true;
    protected DnDTreeUtility m_DnDsupport = null;
    protected boolean m_editable = true;
    protected MinerPopupMenu m_nodePopup = null;
    protected MinerPopupMenu m_folderPopup = null;
    private JMenuItem m_undoFolderMenuItem = null;
    private JMenuItem m_undoNodeMenuItem = null;
    private JMenuItem m_redoFolderMenuItem = null;
    private JMenuItem m_redoNodeMenuItem = null;
    private Action m_undo = null;
    private Action m_redo = null;
    private AppAction m_createNewFolderAction;
    private AppAction m_collapseFolderAction;
    private AppAction m_expandFolderAction;
    private AppAction m_deleteAction;
    private AppAction m_pasteAction;
    private AppAction m_copyAction;
    private AppAction m_cutAction;
    private AppAction m_renameAction;
    private AppAction m_createNodeAction;
    private AppAction m_commentsAction;
    private AppAction m_helpAction;
    private AppAction m_setDefaultsAction;
    private AppAction m_undoAction;
    private AppAction m_redoAction;
    private AppAction m_copyToUserLibraryAction;

    public DragAndDropTree() {
        this(new InvisibleNode(null, true, true));
    }

    public DragAndDropTree(TreeNode root) {
        this(root, true);
    }

    public DragAndDropTree(TreeNode root, boolean useDnD) {
        this(new InvisibleTreeModel(root));
        this.initialize(useDnD);
    }

    public DragAndDropTree(TreeModel model) {
        this(model, true);
    }

    public DragAndDropTree(TreeModel model, boolean useDnD) {
        super(model);
        this.initialize(useDnD);
    }

    protected void initialize(boolean useDnD) {
        this.setCellRenderer(new IconableTreeCellRenderer());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.getSelectionModel().setSelectionMode(1);
        this.setRowHeight(rowHeight);
        JTextField tf = new JTextField();
        tf.setDocument(new MultiLineDocument(tf));
        this.setCellEditor(new DnDTreeCellEditor(tf, this));
        this.setEditable(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addListeners();
        if (useDnD) {
            this.m_DnDsupport = DnDTreeUtility.createUtility(this);
            this.m_undo = this.m_DnDsupport.getUndoAction();
            this.m_redo = this.m_DnDsupport.getRedoAction();
        } else {
            this.m_DnDsupport = null;
            this.m_undo = null;
            this.m_redo = null;
        }
        this.createMenus();
    }

    public void addListeners() {
        this.addMouseListener(new DefaultValuesMouseListener());
        this.addKeyListener(new NavigationKeyListener());
    }

    public void removeListeners() {
        KeyListener[] kls = this.getKeyListeners();
        for (int i = kls.length - 1; i >= 0; --i) {
            if (!(kls[i] instanceof NavigationKeyListener) && !(kls[i] instanceof DragAndDropTree)) continue;
            this.removeKeyListener(kls[i]);
        }
        MouseListener[] mls = this.getMouseListeners();
        for (int i = mls.length - 1; i >= 0; --i) {
            if (!(mls[i] instanceof DefaultValuesMouseListener)) continue;
            this.removeMouseListener(mls[i]);
        }
    }

    public void setDropable(boolean e) {
        this.m_editable = e;
        if (MinerApp.getMainFrame() != null) {
            AppAction.updateAllActions();
        }
    }

    public boolean isDropable() {
        return this.m_editable;
    }

    public void disableDeleteKey() {
        this.m_disableDeleteKey = true;
    }

    public void enableDeleteKey() {
        this.m_disableDeleteKey = false;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String v) {
        this.m_version = v;
    }

    public String getTitle() {
        return this.m_treeTitle;
    }

    public void setTitle(String t) {
        this.m_treeTitle = t;
    }

    public String getDescription() {
        return this.m_treeDescription;
    }

    public void setDescription(String t) {
        this.m_treeDescription = t;
    }

    public String getAuthor() {
        return this.m_treeAuthor;
    }

    public void setAuthor(String t) {
        this.m_treeAuthor = t;
    }

    public String getEditableFilename() {
        return this.m_editableFilename;
    }

    public void setEditableFilename(String f) {
        this.m_editableFilename = f;
    }

    public String getOriginalFilepath() {
        return this.m_originalFilepath;
    }

    public void setOriginalFilepath(String f) {
        this.m_originalFilepath = f;
    }

    public void expandJTree() {
        int rows = this.getRowCount();
        int index = 0;
        while (index < rows) {
            this.expandRow(index++);
            rows = this.getRowCount();
        }
    }

    public void collapseJTree() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.collapseNode(node);
    }

    public void doComments() {
        this.doNodeActivity(0);
    }

    public void doDefaultProperties() {
        this.doNodeActivity(1);
    }

    public void doHelp() {
        this.doNodeActivity(2);
    }

    public void onDoubleClick() {
        this.doNodeActivity(3);
    }

    public void removeNode(DefaultMutableTreeNode node) {
        this.removeNode(new TreePath(node.getPath()));
    }

    public void removeNode(TreePath path) {
        try {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (currentNode.getParent() != null) {
                this.m_DnDsupport.deleteSelectedNodes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeNodes(TreePath[] path) {
        for (int i = 0; i < path.length; ++i) {
            this.removeNode(path[i]);
        }
    }

    public Transferable convertSelectionToTransferable() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        return DragAndDropTree.convertNodeToTransferable(node);
    }

    public void addNodeToCurrentSelection(DefaultMutableTreeNode addNode) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        this.addChildNodeToNode(node, addNode);
    }

    public void addChildNodeToNode(DefaultMutableTreeNode parentNode, DefaultMutableTreeNode addNode) {
        int location;
        if (parentNode == null) {
            parentNode = (DefaultMutableTreeNode)this.getModel().getRoot();
            location = parentNode.getChildCount();
        } else if (!(parentNode.getUserObject() instanceof LibraryFolder)) {
            DefaultMutableTreeNode orig = parentNode;
            parentNode = (DefaultMutableTreeNode)parentNode.getParent();
            location = parentNode.getIndex(orig);
        } else {
            location = parentNode.getChildCount();
        }
        DefaultMutableTreeNode[] addNodes = new DefaultMutableTreeNode[]{addNode};
        this.m_DnDsupport.addNodes(parentNode, addNodes, location);
        TreePath path = new TreePath(parentNode.getPath());
        if (!this.isExpanded(path)) {
            this.expandPath(path);
        }
    }

    public void dropBaseNodeArea(BaseNodeArea ana) {
        TreeModel tm = this.getModel();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tm.getRoot();
        InvisibleNode newNode = new InvisibleNode(ana, false, true);
        node.add(newNode);
        TreePath tp = new TreePath(newNode.getPath()).getParentPath();
        if (!this.isExpanded(tp)) {
            this.expandPath(tp);
        }
    }

    public static Transferable convertNodeToTransferable(DefaultMutableTreeNode node) {
        return (InvisibleNode)node;
    }

    public static BaseNodeArea convertTransferableToArea(Transferable transfer) {
        try {
            if (transfer.isDataFlavorSupported(InvisibleNode.nodeFlavor)) {
                InvisibleNode iNode = (InvisibleNode)transfer.getTransferData(InvisibleNode.nodeFlavor);
                Object userObj = iNode.getUserObject();
                if (userObj instanceof LibraryTreeNode) {
                    return ((LibraryTreeNode)iNode.getUserObject()).createBaseNode();
                }
                if (userObj instanceof BaseNodeArea) {
                    return (BaseNodeArea)userObj;
                }
            } else if (transfer.isDataFlavorSupported(BaseNodeArea.nodeFlavor)) {
                Object transferObject = transfer.getTransferData(BaseNodeArea.nodeFlavor);
                if (transferObject instanceof BaseNodeArea) {
                    return (BaseNodeArea)transferObject;
                }
                if (transferObject instanceof JGoSelection) {
                    JGoSelection sel = (JGoSelection)transferObject;
                    JGoListPosition pos = sel.getFirstObjectPos();
                    while (pos != null) {
                        JGoObject selObject = sel.getObjectAtPos(pos).getTopLevelObject();
                        if (!(selObject instanceof BaseNodeArea)) continue;
                        return (BaseNodeArea)selObject;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        int max = this.getRowCount();
        if (prefix == null || startingRow < 0 || startingRow >= max) {
            return this.getPathForRow(0);
        }
        return super.getNextMatch(prefix, startingRow, bias);
    }

    protected static int getDefaultRowHeight() {
        JLabel l = new JLabel("H");
        return l.getFontMetrics(l.getFont()).getHeight() + 4;
    }

    public final String getToolTipText(MouseEvent evt) {
        int y;
        if (MinerApp.getMainFrame().getFocusOwner() == null) {
            return null;
        }
        String str = null;
        int x = evt.getX();
        TreePath path = this.getPathForLocation(x, y = evt.getY());
        if (path != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            str = node.toString();
        }
        return str;
    }

    public boolean isThisPathExpanded(TreePath tp) {
        Object lastComp = tp.getLastPathComponent();
        if (lastComp instanceof InvisibleNode && !((InvisibleNode)lastComp).isVisible()) {
            return true;
        }
        boolean expanded = this.isExpanded(tp);
        if (!expanded) {
            for (TreePath path = tp.getParentPath(); path != null && !this.isExpanded(path); path = path.getParentPath()) {
                this.expandPath(path);
                if (this.isExpanded(tp)) {
                    expanded = true;
                    break;
                }
                this.collapsePath(path);
            }
        }
        return expanded;
    }

    public void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(this);
        try {
            InvisibleNode fromClip = null;
            if (transfer.isDataFlavorSupported(BaseNodeArea.nodeFlavor)) {
                BaseNodeArea area = BaseNodeArea.convertTransferToArea(transfer);
                fromClip = new InvisibleNode(area, false, true);
            } else if (transfer.isDataFlavorSupported(InvisibleNode.nodeFlavor)) {
                fromClip = (InvisibleNode)transfer.getTransferData(InvisibleNode.nodeFlavor);
            }
            this.addNodeToCurrentSelection(fromClip);
        }
        catch (Exception uf) {
            uf.printStackTrace();
        }
    }

    private void createActions() {
        this.m_createNewFolderAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_createFolder"), ExplorerPane.getIcon("open.gif")){

            public void actionPerformed(ActionEvent e) {
                LibraryFolder folder = new LibraryFolder("New Folder");
                InvisibleNode newNode = new InvisibleNode(folder, true, true);
                DragAndDropTree.this.addNodeToCurrentSelection(newNode);
            }
        };
        this.m_collapseFolderAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_collapseFolder"), ExplorerPane.getPlainGrayIcon()){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DragAndDropTree.this.getLastSelectedPathComponent();
                TreePath path = DragAndDropTree.this.getSelectionPath();
                if (node != null && node.getUserObject() instanceof LibraryFolder) {
                    DragAndDropTree.this.collapsePath(path);
                }
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_expandFolderAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_expandFolder"), ExplorerPane.getPlainGrayIcon()){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DragAndDropTree.this.getLastSelectedPathComponent();
                TreePath path = DragAndDropTree.this.getSelectionPath();
                if (node != null && node.getUserObject() instanceof LibraryFolder) {
                    DragAndDropTree.this.expandPath(path);
                }
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_deleteAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_delete"), ExplorerPane.getIcon("delete.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.removeNode((DefaultMutableTreeNode)DragAndDropTree.this.getLastSelectedPathComponent());
            }
        };
        this.m_pasteAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_paste"), ExplorerPane.getIcon("paste.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.paste();
            }
        };
        this.m_copyAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_copy"), ExplorerPane.getIcon("copy.gif")){

            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = DragAndDropTree.this.getToolkit().getSystemClipboard();
                Transferable transfer = DragAndDropTree.this.convertSelectionToTransferable();
                if (transfer != null) {
                    clipboard.setContents(transfer, null);
                }
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_cutAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_cut"), ExplorerPane.getIcon("cut.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.m_copyAction.actionPerformed(e);
                DragAndDropTree.this.m_deleteAction.actionPerformed(e);
            }
        };
        this.m_renameAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_rename"), ExplorerPane.getPlainGrayIcon()){

            public void actionPerformed(ActionEvent e) {
                String jvmVersion = System.getProperty("java.version");
                if (jvmVersion.startsWith("1.4.0")) {
                    String newName;
                    TreePath tPath = DragAndDropTree.this.getSelectionPath();
                    DefaultMutableTreeNode iNode = (DefaultMutableTreeNode)tPath.getLastPathComponent();
                    String oldName = iNode.toString();
                    JTextField newNameTF = new JTextField(oldName);
                    newNameTF.selectAll();
                    JPanel renamePanel = new JPanel(new GridBagLayout());
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.weighty = 1.0;
                    gbc.weightx = 1.0;
                    gbc.anchor = 18;
                    gbc.fill = 2;
                    gbc.gridx = 0;
                    gbc.gridy = 0;
                    renamePanel.add((Component)newNameTF, gbc);
                    int option = AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), renamePanel, ExplorerPane.getText("ExplorerPane_rename"), -1);
                    if (option != 2 && !(newName = newNameTF.getText()).equals(oldName)) {
                        DragAndDropTree.this.renameNode(iNode, newName, oldName);
                        DragAndDropTree.this.startEditingAtPath(tPath);
                        DragAndDropTree.this.getUI().stopEditing(DragAndDropTree.this);
                    }
                } else {
                    DragAndDropTree.this.m_DnDsupport.getStartEditAction().actionPerformed(e);
                }
            }
        };
        this.m_createNodeAction = new AppAction(ExplorerPane.getText("ExplorerPane_createNewNode"), ExplorerPane.getIcon("new.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.onDoubleClick();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_commentsAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_comments"), ExplorerPane.getIcon("comments.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.doComments();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_helpAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_help"), ExplorerPane.getIcon("help.gif")){

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.doHelp();
            }

            public boolean canAct() {
                return true;
            }
        };
        this.m_setDefaultsAction = new DnDTreeAction(ExplorerPane.getText("ExplorerPane_setDefaultProperties"), ExplorerPane.getIcon("properties.gif")){

            public boolean canAct() {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)DragAndDropTree.this.getLastSelectedPathComponent();
                if (node == null || node.getUserObject() instanceof LibraryFolder) {
                    return false;
                }
                Object userObj = node.getUserObject();
                return userObj instanceof BaseNodeArea || userObj instanceof LibraryTreeNode;
            }

            public void actionPerformed(ActionEvent e) {
                DragAndDropTree.this.doDefaultProperties();
            }
        };
        if (this.m_DnDsupport != null) {
            this.m_undoAction = new DnDTreeAction(ExplorerPane.getText("MinerApp_action_undo"), ExplorerPane.getIcon("plain_gray.gif")){

                public void actionPerformed(ActionEvent e) {
                    DragAndDropTree.this.m_undo.actionPerformed(e);
                }

                public boolean canAct() {
                    return DragAndDropTree.this.m_DnDsupport.getUndoManager().canUndo();
                }

                public void updateEnabled() {
                    super.updateEnabled();
                    String str = DragAndDropTree.this.m_DnDsupport.getUndoManager().getUndoPresentationName();
                    if (DragAndDropTree.this.m_undoFolderMenuItem != null) {
                        DragAndDropTree.this.m_undoFolderMenuItem.setText(str);
                    }
                    if (DragAndDropTree.this.m_undoNodeMenuItem != null) {
                        DragAndDropTree.this.m_undoNodeMenuItem.setText(str);
                    }
                }
            };
            this.m_redoAction = new DnDTreeAction(ExplorerPane.getText("MinerApp_menu_item_redo"), ExplorerPane.getIcon("plain_gray.gif")){

                public void actionPerformed(ActionEvent e) {
                    DragAndDropTree.this.m_redo.actionPerformed(e);
                }

                public boolean canAct() {
                    return DragAndDropTree.this.m_DnDsupport.getUndoManager().canRedo();
                }

                public void updateEnabled() {
                    super.updateEnabled();
                    String str = DragAndDropTree.this.m_DnDsupport.getUndoManager().getRedoPresentationName();
                    if (DragAndDropTree.this.m_redoFolderMenuItem != null) {
                        DragAndDropTree.this.m_redoFolderMenuItem.setText(str);
                    }
                    if (DragAndDropTree.this.m_redoNodeMenuItem != null) {
                        DragAndDropTree.this.m_redoNodeMenuItem.setText(str);
                    }
                }
            };
        }
        this.m_copyToUserLibraryAction = new DnDTreeAction(ExplorerPane.getText("MinerApp_menu_item_copyToUserLibrary"), ExplorerPane.getIcon("copy_user_lib.gif")){

            public void actionPerformed(ActionEvent e) {
                MinerApp.getMainFrame().getExplorerPane().doCopyFromLibraryToUserLibrary();
            }

            public boolean canAct() {
                return MinerApp.getMainFrame().getExplorerPane().getUserLibrary().isDropable();
            }
        };
    }

    public AppAction getPasteAction() {
        return this.m_pasteAction;
    }

    private void createMenus() {
        this.createActions();
        this.m_folderPopup = new MinerPopupMenu();
        this.m_folderPopup.add(this.m_collapseFolderAction);
        this.m_folderPopup.add(this.m_expandFolderAction);
        this.m_folderPopup.addSeparator();
        this.m_folderPopup.add(this.m_createNewFolderAction);
        this.m_folderPopup.addSeparator();
        this.m_folderPopup.add(this.m_cutAction);
        this.m_folderPopup.add(this.m_copyAction);
        this.m_folderPopup.add(this.m_pasteAction);
        this.m_folderPopup.add(this.m_deleteAction);
        this.m_folderPopup.addSeparator();
        this.m_folderPopup.add(this.m_copyToUserLibraryAction);
        this.m_folderPopup.add(this.m_renameAction);
        this.m_folderPopup.addSeparator();
        this.m_folderPopup.add(this.m_helpAction);
        if (this.m_DnDsupport != null) {
            this.m_folderPopup.addSeparator();
            this.m_undoFolderMenuItem = this.m_folderPopup.add(this.m_undoAction);
            this.m_redoFolderMenuItem = this.m_folderPopup.add(this.m_redoAction);
        }
        this.m_nodePopup = new MinerPopupMenu();
        this.m_nodePopup.add(this.m_createNodeAction);
        this.m_nodePopup.add(this.m_setDefaultsAction);
        this.m_nodePopup.addSeparator();
        this.m_nodePopup.add(this.m_cutAction);
        this.m_nodePopup.add(this.m_copyAction);
        this.m_nodePopup.add(this.m_pasteAction);
        this.m_nodePopup.add(this.m_deleteAction);
        this.m_nodePopup.addSeparator();
        this.m_nodePopup.add(this.m_copyToUserLibraryAction);
        this.m_nodePopup.add(this.m_commentsAction);
        this.m_nodePopup.add(this.m_renameAction);
        this.m_nodePopup.addSeparator();
        this.m_nodePopup.add(this.m_helpAction);
        if (this.m_DnDsupport != null) {
            this.m_nodePopup.addSeparator();
            this.m_undoNodeMenuItem = this.m_nodePopup.add(this.m_undoAction);
            this.m_redoNodeMenuItem = this.m_nodePopup.add(this.m_redoAction);
        }
    }

    Object renameNode(DefaultMutableTreeNode node, String newname, String oldName) {
        Object userobject = node.getUserObject();
        boolean veto = false;
        try {
            this.m_DnDsupport.renameNode((DefaultTreeModel)this.getModel(), node, newname, node.toString());
        }
        catch (VetoException ex) {
            veto = true;
        }
        if (!veto) {
            if (userobject instanceof LibraryTreeNode) {
                ((LibraryTreeNode)userobject).setLabel(newname);
            } else if (userobject instanceof LibraryFolder) {
                ((LibraryFolder)userobject).m_label = newname;
            } else if (userobject instanceof BaseNodeArea) {
                ((BaseNodeArea)userobject).setText(newname);
            }
            this.m_DnDsupport.updateActionObjects();
        }
        return userobject;
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
    }

    public void storeXML(OutputStream outs) throws IOException {
        this.storeXMLPage(outs);
    }

    private void storeXMLPage(OutputStream outs) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outs, "UTF-8");
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.write("<ExplorerTree>\n");
        String indent = "\t";
        String xmlTitle = XTNetwork.convertToXML(this.getTitle());
        String xmlDescr = XTNetwork.convertToXML(this.getDescription());
        String xmlAuthr = XTNetwork.convertToXML(this.getAuthor());
        writer.write(indent + "<" + EXPLORER_PAGE_NODE_TAG + " " + VERSION_ATTRIBUTE_TAG + "=\"" + this.m_version + "\" " + EDITABLE_ATTRIBUTE_TAG + "=\"" + Boolean.toString(this.isDropable()) + "\" " + LABEL_ATTRIBUTE_TAG + "=\"" + xmlTitle + "\" " + DESCRIPTION_ATTRIBUTE_TAG + "=\"" + xmlDescr + "\" " + AUTHOR_ATTRIBUTE_TAG + "=\"" + xmlAuthr + "\">\n");
        indent = indent + "\t";
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        int numChildren = root.getChildCount();
        if (numChildren == 0) {
            writer.write(indent + "<" + EXPLORER_NODE_LIST_NODE_TAG + " />\n");
        } else {
            writer.write(indent + "<" + EXPLORER_NODE_LIST_NODE_TAG + ">\n");
            indent = indent + "\t";
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                Object obj = node.getUserObject();
                if (obj instanceof LibraryFolder) {
                    this.storeXMLFolder(writer, node, indent);
                    continue;
                }
                if (!(obj instanceof LibraryTreeNode) && !(obj instanceof ActivityNodeArea) && !(obj instanceof CollapsedNodeArea)) continue;
                this.storeXMLNode(writer, node, indent);
            }
            indent = indent.substring(0, indent.length() - 1);
            writer.write(indent + "</" + EXPLORER_NODE_LIST_NODE_TAG + ">\n");
            indent = indent.substring(0, indent.length() - 1);
        }
        writer.write(indent + "</" + EXPLORER_PAGE_NODE_TAG + ">\n");
        writer.write("</ExplorerTree>\n");
        writer.flush();
    }

    private void storeXMLFolder(Writer writer, DefaultMutableTreeNode node, String indent) throws IOException {
        int numChildren = node.getChildCount();
        TreePath tp = new TreePath(node.getPath());
        String label = ((LibraryFolder)node.getUserObject()).toString();
        if (numChildren == 0) {
            writer.write(indent + "<" + EXPLORER_FOLDER_NODE_TAG + " " + EXPANDED_ATTRIBUTE_TAG + "=\"" + this.isThisPathExpanded(tp) + "\" " + LABEL_ATTRIBUTE_TAG + "=\"" + label + "\" />\n");
        } else {
            writer.write(indent + "<" + EXPLORER_FOLDER_NODE_TAG + " " + EXPANDED_ATTRIBUTE_TAG + "=\"" + this.isThisPathExpanded(tp) + "\" " + LABEL_ATTRIBUTE_TAG + "=\"" + label + "\">\n");
            indent = indent + "\t";
            writer.write(indent + "<" + EXPLORER_NODE_LIST_NODE_TAG + ">\n");
            indent = indent + "\t";
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object obj = child.getUserObject();
                if (obj instanceof LibraryFolder) {
                    this.storeXMLFolder(writer, child, indent);
                    continue;
                }
                if (!(obj instanceof LibraryTreeNode) && !(obj instanceof ActivityNodeArea) && !(obj instanceof CollapsedNodeArea)) continue;
                this.storeXMLNode(writer, child, indent);
            }
            indent = indent.substring(0, indent.length() - 1);
            writer.write(indent + "</" + EXPLORER_NODE_LIST_NODE_TAG + ">\n");
            indent = indent.substring(0, indent.length() - 1);
            writer.write(indent + "</" + EXPLORER_FOLDER_NODE_TAG + ">\n");
        }
    }

    private void storeXMLNode(Writer writer, DefaultMutableTreeNode node, String indent) throws IOException {
        Object obj = node.getUserObject();
        if (obj instanceof LibraryTreeNode) {
            XTNetwork.NodeInfo info = new XTNetwork.NodeInfo();
            info.convertFromXML(((LibraryTreeNode)obj).getXml());
            info.write(writer, indent);
        } else if (obj instanceof ActivityNodeArea) {
            ((ActivityNodeArea)obj).getNodeInfo().write(writer, indent);
        } else if (obj instanceof CollapsedNodeArea) {
            try {
                XTNetwork net = new XTNetwork();
                XTNetwork.CollapsedNodeInfo cni = ((CollapsedNodeArea)obj).createCollapsedNodeInfo(net);
                net.writeCNA(cni, writer, indent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static DragAndDropTree convertXmlToPages(Element elt, DragAndDropTree dTree) {
        if (elt == null) {
            return dTree;
        }
        String eltTag = elt.getTagName();
        if (eltTag.equals(EXPLORER_TREE_NODE_TAG)) {
            NodeList pageList = elt.getElementsByTagName(EXPLORER_PAGE_NODE_TAG);
            if (pageList.getLength() > 0) {
                dTree = DragAndDropTree.convertXmlToPages((Element)pageList.item(0), dTree);
            }
        } else if (eltTag.equals(EXPLORER_PAGE_NODE_TAG)) {
            InvisibleNode rootNode = new InvisibleNode();
            Vector unexpandedFolders = new Vector();
            NodeList children = elt.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                DragAndDropTree.xmlToTreeNode((Element)children.item(i), rootNode, unexpandedFolders);
            }
            InvisibleTreeModel treeModel = new InvisibleTreeModel(rootNode, true, true);
            dTree = new DragAndDropTree(treeModel);
            dTree.expandJTree();
            for (int i = 0; i < unexpandedFolders.size(); ++i) {
                TreePath path = (TreePath)unexpandedFolders.get(i);
                dTree.collapsePath(path);
            }
            dTree.setTitle(elt.getAttribute(LABEL_ATTRIBUTE_TAG));
            dTree.setDescription(elt.getAttribute(DESCRIPTION_ATTRIBUTE_TAG));
            dTree.setAuthor(elt.getAttribute(AUTHOR_ATTRIBUTE_TAG));
            dTree.setDropable(elt.getAttribute(EDITABLE_ATTRIBUTE_TAG).compareToIgnoreCase("false") != 0);
            dTree.setVersion(elt.getAttribute(VERSION_ATTRIBUTE_TAG));
        }
        return dTree;
    }

    private static void xmlToTreeNode(Element elt, DefaultMutableTreeNode parentNode, Vector unexpandedFolders) {
        block6: {
            String eltTag;
            block8: {
                block7: {
                    block5: {
                        if (elt == null) {
                            return;
                        }
                        eltTag = elt.getTagName();
                        if (!eltTag.equals(EXPLORER_NODE_LIST_NODE_TAG)) break block5;
                        NodeList children = elt.getChildNodes();
                        for (int i = 0; i < children.getLength(); ++i) {
                            DragAndDropTree.xmlToTreeNode((Element)children.item(i), parentNode, unexpandedFolders);
                        }
                        break block6;
                    }
                    if (!eltTag.equals(EXPLORER_FOLDER_NODE_TAG)) break block7;
                    String labelText = elt.getAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG);
                    boolean expanded = elt.getAttribute(EXPANDED_ATTRIBUTE_TAG).equals("true");
                    InvisibleNode folder = new InvisibleNode(new LibraryFolder(labelText), true, true);
                    parentNode.add(folder);
                    NodeList children = elt.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        DragAndDropTree.xmlToTreeNode((Element)children.item(i), folder, unexpandedFolders);
                    }
                    if (expanded) break block6;
                    TreePath path = new TreePath(folder.getPath());
                    unexpandedFolders.add(path);
                    break block6;
                }
                if (!eltTag.equals(XTNetwork.ACTIVITY_NODE_NODE_TAG)) break block8;
                boolean show = MinerApp.showForBeta3(elt.getAttribute(XTNetwork.ENGINE_CLASS_ATTRIBUTE_TAG));
                LibraryTreeNode newNode = new LibraryTreeNode(elt);
                InvisibleNode iNode = new InvisibleNode(newNode, false, show);
                parentNode.add(iNode);
                break block6;
            }
            if (!eltTag.equals(XTNetwork.COLLAPSED_NODE_NODE_TAG)) break block6;
            try {
                WorksheetDocument doc = new WorksheetDocument(true);
                WorksheetView view = new WorksheetView(doc);
                CollapsedNodeArea area = CollapsedNodeArea.buildCollapsedNodeFromXML(elt, doc, null);
                boolean isCollapsing = doc.isCollapsing();
                doc.setCollapseTransaction(true);
                doc.removeObject((JGoObject)area);
                doc.setCollapseTransaction(isCollapsing);
                parentNode.add(new InvisibleNode(area, false, true));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void collapseNode(DefaultMutableTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            if (DragAndDropTree.hasOnlyLeaves(child)) {
                Object[] path = child.getPath();
                this.collapsePath(new TreePath(path));
                continue;
            }
            this.collapseNode(child);
        }
    }

    private static boolean hasOnlyLeaves(DefaultMutableTreeNode node) {
        int numChild = 0;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!node.getChildAt(i).isLeaf()) continue;
            ++numChild;
        }
        return numChild == node.getChildCount();
    }

    private void doNodeActivity(int type) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (node.getUserObject() instanceof LibraryFolder) {
            if (type == 2) {
                MinerApp.getHelpManager().showTopic(FOLDER_TAG);
            }
            return;
        }
        Object userObj = node.getUserObject();
        if (userObj == null) {
            return;
        }
        ActivityNodeModel model = null;
        if (userObj instanceof LibraryTreeNode) {
            if (((LibraryTreeNode)userObj).isActivityNode()) {
                try {
                    Element elt = ((LibraryTreeNode)userObj).getXml();
                    model = LibraryTreeNode.createActivityModel(elt);
                    if (type == 0) {
                        Element comments = CommentUtilities.editComments(model.getComments(), model.toString());
                        Element argList = (Element)elt.getElementsByTagName(XTNetwork.ARGUMENT_LIST_NODE_TAG).item(0);
                        Element oldComm = (Element)argList.getElementsByTagName(XTNetwork.COMPONENT_COMMENTS_NODE_TAG).item(0);
                        Element newComm = (Element)argList.getOwnerDocument().importNode(comments, true);
                        if (oldComm != null) {
                            argList.removeChild(oldComm);
                        }
                        argList.appendChild(newComm);
                    } else if (type == 1) {
                        WorksheetDocument dummy = new WorksheetDocument(false);
                        model.setDocument(dummy);
                        model.showPropertiesDialog(true);
                        Element argList = (Element)elt.getElementsByTagName(XTNetwork.ARGUMENT_LIST_NODE_TAG).item(0);
                        Element newProps = (Element)argList.getOwnerDocument().importNode(model.getXTProps().getXML(), true);
                        argList.removeChild(argList.getFirstChild());
                        argList.appendChild(newProps);
                    } else if (type == 2) {
                        model.showHelp();
                    } else if (type == 3) {
                        WorksheetView view = MinerApp.getCurrentView();
                        if (view == null) {
                            return;
                        }
                        ActivityNodeArea area = ((LibraryTreeNode)userObj).createActivityNode();
                        if (area != null) {
                            view.copyFromExplorerPane(area);
                        }
                    }
                }
                catch (ClassNotFoundException cnf) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (userObj instanceof CollapsedNodeArea) {
            CollapsedNodeArea cna = (CollapsedNodeArea)userObj;
            try {
                if (type == 0) {
                    Element comments = CommentUtilities.editComments(cna.getComments(), cna.toString().replaceAll("\n", ""));
                    cna.setComments(comments);
                } else if (type == 1) {
                    new CollapsedNodeDialog(cna).show();
                } else if (type == 2) {
                    cna.showHelp();
                } else if (type == 3) {
                    WorksheetView view = MinerApp.getCurrentView();
                    if (view == null) {
                        return;
                    }
                    BaseNodeArea area = (BaseNodeArea)((BaseNodeArea)userObj).copyObject((JGoCopyEnvironment)new JGoCopyMap());
                    if (area != null) {
                        view.copyFromExplorerPane(area);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (userObj instanceof ActivityNodeArea) {
            model = ((ActivityNodeArea)userObj).getNodeModel();
            try {
                if (type == 0) {
                    Element comments = CommentUtilities.editComments(model.getComments(), model.toString());
                    model.setComments(comments);
                } else if (type == 1) {
                    model.getState().showDialog(model);
                } else if (type == 2) {
                    model.showHelp();
                } else if (type == 3) {
                    WorksheetView view = MinerApp.getCurrentView();
                    if (view == null) {
                        return;
                    }
                    BaseNodeArea area = (BaseNodeArea)((BaseNodeArea)userObj).copyObject((JGoCopyEnvironment)new JGoCopyMap());
                    if (area != null) {
                        view.copyFromExplorerPane(area);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean doMouseAction(MouseEvent e) {
        boolean consumed = false;
        if (e.getButton() != 1) {
            DefaultMutableTreeNode node;
            TreePath tp = this.getPathForLocation(e.getX(), e.getY());
            if (tp != null) {
                this.setSelectionPath(tp);
            }
            if ((node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent()) != null) {
                Object usrObj = node.getUserObject();
                if (node.isLeaf() && !(usrObj instanceof LibraryFolder)) {
                    AppAction.updateAllActions();
                    if (this.m_nodePopup != null) {
                        this.m_nodePopup.show(this, e.getX(), e.getY());
                    }
                } else if (this.m_folderPopup != null) {
                    this.m_folderPopup.show(this, e.getX(), e.getY());
                }
            } else {
                ExplorerPane ep = MinerApp.getMainFrame().getExplorerPane();
                ep.m_libraryMenu.show(this, e.getX(), e.getY());
            }
            consumed = true;
        } else if (e.getClickCount() == 2) {
            this.onDoubleClick();
            consumed = true;
        }
        return consumed;
    }

    public static class InvisibleTreeModel
    extends DefaultTreeModel {
        protected boolean filterIsActive;

        public InvisibleTreeModel(TreeNode root) {
            this(root, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren) {
            this(root, false, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren, boolean filterIsActive) {
            super(root, asksAllowsChildren);
            this.filterIsActive = filterIsActive;
        }

        public void activateFilter(boolean newValue) {
            this.filterIsActive = newValue;
        }

        public boolean isActivatedFilter() {
            return this.filterIsActive;
        }

        public Object getChild(Object parent, int index) {
            if (this.filterIsActive && parent instanceof InvisibleNode) {
                return ((InvisibleNode)parent).getChildAt(index, this.filterIsActive);
            }
            return ((TreeNode)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            if (this.filterIsActive && parent instanceof InvisibleNode) {
                return ((InvisibleNode)parent).getChildCount(this.filterIsActive);
            }
            return ((TreeNode)parent).getChildCount();
        }
    }

    public static class InvisibleNode
    extends DefaultMutableTreeNode
    implements Transferable,
    Serializable {
        public static DataFlavor nodeFlavor = InvisibleNode.setDataFlavor();
        protected boolean isVisible;

        public InvisibleNode() {
            this(null);
        }

        public InvisibleNode(Object userObject) {
            this(userObject, true, true);
        }

        public InvisibleNode(Object userObject, boolean allowsChildren, boolean isVisible) {
            super(userObject, allowsChildren);
            this.isVisible = isVisible;
        }

        public InvisibleNode copy() {
            InvisibleNode copy = (InvisibleNode)this.clone();
            if (this.children != null) {
                copy.children = new Vector();
                for (int i = 0; i < this.children.size(); ++i) {
                    InvisibleNode cp = ((InvisibleNode)this.children.get(i)).copy();
                    copy.children.add(cp);
                }
            }
            copy.isVisible = this.isVisible;
            if (this.userObject instanceof LibraryTreeNode) {
                try {
                    Element elt = (Element)((LibraryTreeNode)this.userObject).getXml().cloneNode(true);
                    copy.userObject = new LibraryTreeNode(elt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                copy.userObject = this.userObject;
            }
            return copy;
        }

        public TreeNode getChildAt(int index, boolean filterIsActive) {
            if (!filterIsActive) {
                return super.getChildAt(index);
            }
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            int realIndex = -1;
            int visibleIndex = -1;
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                InvisibleNode node = (InvisibleNode)enumeration.nextElement();
                if (node.isVisible()) {
                    ++visibleIndex;
                }
                ++realIndex;
                if (visibleIndex != index) continue;
                return (TreeNode)this.children.elementAt(realIndex);
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public int getChildCount(boolean filterIsActive) {
            if (!filterIsActive) {
                return super.getChildCount();
            }
            if (this.children == null) {
                return 0;
            }
            int count = 0;
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                InvisibleNode node = (InvisibleNode)enumeration.nextElement();
                if (!node.isVisible()) continue;
                ++count;
            }
            return count;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public static DataFlavor setDataFlavor() {
            DataFlavor df = new DataFlavor(InvisibleNode.class, "Explorer Folder");
            return df;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] fl = new DataFlavor[]{nodeFlavor};
            return fl;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(nodeFlavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(nodeFlavor)) {
                return this;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public static class LibraryFolder
    implements DragOverData,
    Serializable {
        private int m_currentEffect;
        private String m_label;

        public LibraryFolder(String str) {
            this.m_label = str;
        }

        public String toString() {
            return this.m_label;
        }

        public void setCurrentEffect(int eff) {
            this.m_currentEffect = eff;
        }

        public int getCurrentEffect() {
            return this.m_currentEffect;
        }
    }

    public class NavigationKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int navCode = e.getKeyCode();
            if (navCode == 10) {
                DragAndDropTree.this.onDoubleClick();
            } else if (navCode == 27) {
                MinerApp.getMainFrame().getExplorerPane().requestFocusInWindow();
            } else if (navCode == 127 && DragAndDropTree.this.m_disableDeleteKey) {
                e.consume();
            }
        }
    }

    public class DefaultValuesMouseListener
    extends MouseAdapter {
        private boolean consumed = true;

        public void mousePressed(MouseEvent e) {
            Point mouseClickLoc = e.getPoint();
            int row = DragAndDropTree.this.getRowForLocation(mouseClickLoc.x, mouseClickLoc.y);
            if (row == -1) {
                DragAndDropTree.this.setSelectionRow(-1);
            }
            this.consumed = false;
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.consumed) {
                this.consumed = DragAndDropTree.this.doMouseAction(e);
            }
        }

        public void mouseClicked(MouseEvent e) {
            if (!this.consumed) {
                this.consumed = DragAndDropTree.this.doMouseAction(e);
            }
        }
    }

    public static class DnDTreeCellEditor
    extends DefaultCellEditor {
        DragAndDropTree m_tree;

        public DnDTreeCellEditor(JTextField tf, DragAndDropTree tree) {
            super(tf);
            this.m_tree = tree;
        }

        public boolean isCellEditable(EventObject e) {
            return !(e instanceof MouseEvent);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object val, boolean sel, boolean exp, boolean leaf, int row) {
            JTextField tf = (JTextField)super.getTreeCellEditorComponent(tree, "", sel, exp, leaf, row);
            tf.setText(tree.convertValueToText(val, sel, exp, leaf, row, false));
            tf.selectAll();
            return tf;
        }

        public JComponent getUnsetComponent() {
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.m_tree.getSelectionPath().getLastPathComponent();
            String newname = (String)super.getCellEditorValue();
            if (newname.equals(node.toString())) {
                return node.getUserObject();
            }
            return this.m_tree.renameNode(node, newname, node.toString());
        }
    }

    private abstract class DnDTreeAction
    extends AppAction {
        public DnDTreeAction(String name, Icon icon) {
            super(name, icon);
        }

        public boolean canAct() {
            return DragAndDropTree.this.isDropable();
        }
    }
}

