/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.FileUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExplorerPane
extends JTabbedPane
implements ChangeListener,
DropTargetListener {
    public static final String EXPLORER_PAGE_NODE_TAG = "ExplorerPage";
    public static final String EXPLORER_FILE_NAME = MinerApp.getImlFileName("DefaultExplorer");
    public static final String SPLUS_LIBRARY_FILE_NAME = MinerApp.getImlFileName("SPlusLibrary");
    public static final String USER_LIBRARY_FILE_NAME = "UserLibrary.iml";
    public static final String USER_LIBRARY_TAG = "UserLibrary";
    public static final String SPLUS_LIBRARY_TITLE = "S-PLUS";
    public static final String USER_LIBRARY_TITLE = "User";
    public static final String DEFAULT_LIBRARY_TITLE = "Insightful Library";
    public static final String SETTINGS_DIR = new File(MinerApp.getSettingsDir() + "/").getAbsolutePath() + File.separator;
    public static final String XML_DIR = new File(MinerApp.getSplusHome() + "/library/bigdata/xml/").getAbsolutePath() + File.separator;
    protected DragAndDropTree m_defaultLibrary = null;
    protected DragAndDropTree m_userLibrary = null;
    protected JPopupMenu m_libraryMenu = null;
    protected JPopupMenu m_folderMenu = null;
    protected JPopupMenu m_nodeMenu = null;
    protected DragAndDropTree m_currentTree = null;
    protected int m_currentTab = -1;
    protected Vector m_extensionLibraryNames;
    protected Vector m_extensionLibraryTrees;
    protected int m_indexToSwitchTo = -1;
    protected Timer m_timerSwitchTabs = new Timer(800, new ActionListener(){

        public void actionPerformed(ActionEvent ev) {
            if (ExplorerPane.this.m_indexToSwitchTo != -1) {
                ExplorerPane.this.setSelectedIndex(ExplorerPane.this.m_indexToSwitchTo);
                ExplorerPane.this.m_indexToSwitchTo = -1;
            }
        }
    });
    private AppAction m_createNewFolderAction;
    private AppAction m_hideLibraryAction;
    private AppAction m_propertiesAction;
    private AppAction m_saveLibraryAsAction;
    private AppAction m_revertLibraryAction;
    private AppAction m_createNewLibraryAction;
    private AppAction m_manageLibrariesAction;

    public ExplorerPane() {
        this(null);
    }

    public ExplorerPane(XTProps globalProps) {
        this(globalProps, true);
    }

    protected ExplorerPane(XTProps globalProps, boolean addLibs) {
        this.createMenus();
        this.m_extensionLibraryNames = new Vector();
        this.m_extensionLibraryTrees = new Vector();
        if (addLibs) {
            String origPath;
            int i;
            String[] libraryPath = new String[]{EXPLORER_PAGE_NODE_TAG, "", "show"};
            String homeDir = XML_DIR;
            Vector editableNames = globalProps.getSubProperties(libraryPath[0]);
            Vector originalPaths = globalProps.getSubPropertyValues(libraryPath[0]);
            int numPaths = originalPaths.size();
            boolean[] pathsShow = new boolean[numPaths];
            for (i = 0; i < numPaths; ++i) {
                libraryPath[1] = (String)editableNames.get(i);
                pathsShow[i] = globalProps.getBoolean(libraryPath, true);
            }
            globalProps.removeProperty(new String[]{libraryPath[0]});
            for (i = 0; i < editableNames.size(); ++i) {
                String ename = (String)editableNames.get(i);
                if (ename.startsWith("DefaultExplorer") && !ename.equals(EXPLORER_FILE_NAME)) {
                    editableNames.setElementAt(EXPLORER_FILE_NAME, i);
                    originalPaths.setElementAt(homeDir + EXPLORER_FILE_NAME, i);
                    continue;
                }
                if (!ename.startsWith("SPlusLibrary") || ename.equals(SPLUS_LIBRARY_FILE_NAME)) continue;
                editableNames.setElementAt(SPLUS_LIBRARY_FILE_NAME, i);
                originalPaths.setElementAt(homeDir + SPLUS_LIBRARY_FILE_NAME, i);
            }
            boolean propsNeedSaving = editableNames.size() == 0;
            HashMap<String, DragAndDropTree> librariesInXMLDir = new HashMap<String, DragAndDropTree>();
            File dir = new File(homeDir);
            File[] sprimeFiles = dir.listFiles(new LibraryFilenameFilter());
            DragAndDropTree splusTree = null;
            for (int i2 = 0; sprimeFiles != null && i2 < sprimeFiles.length; ++i2) {
                String origName = sprimeFiles[i2].getName();
                DragAndDropTree dTree = ExplorerPane.getLibrary(origName, origPath = homeDir + origName);
                if (dTree == null) continue;
                if (origName.equals(SPLUS_LIBRARY_FILE_NAME)) {
                    splusTree = dTree;
                }
                dTree.setEditableFilename(origName);
                dTree.setOriginalFilepath(origPath);
                librariesInXMLDir.put(origPath, dTree);
            }
            boolean nextLibShouldBeSplus = false;
            String string = libraryPath[1] = numPaths == 0 ? "" : (String)editableNames.get(0);
            if (numPaths == 0 || !EXPLORER_FILE_NAME.equals(libraryPath[1])) {
                this.addTreeAndUpdateProps(EXPLORER_FILE_NAME, homeDir + EXPLORER_FILE_NAME, librariesInXMLDir, globalProps, true, !propsNeedSaving);
                nextLibShouldBeSplus = true;
                if (splusTree != null && (numPaths == 0 || !SPLUS_LIBRARY_FILE_NAME.equals(libraryPath[1])) && MinerApp.shouldSplusBeHidden()) {
                    this.addTreeAndUpdateProps(SPLUS_LIBRARY_FILE_NAME, homeDir + SPLUS_LIBRARY_FILE_NAME, librariesInXMLDir, globalProps, true, !propsNeedSaving);
                    nextLibShouldBeSplus = false;
                }
            }
            for (int i3 = 0; i3 < numPaths; ++i3) {
                origPath = (String)originalPaths.get(i3);
                libraryPath[1] = (String)editableNames.get(i3);
                String origName = new File(origPath).getName();
                if (origName.equals(SPLUS_LIBRARY_FILE_NAME) && MinerApp.shouldSplusBeHidden()) continue;
                this.addTreeAndUpdateProps(libraryPath[1], origPath, librariesInXMLDir, globalProps, pathsShow[i3], true);
                if (libraryPath[1].equals(EXPLORER_FILE_NAME)) {
                    nextLibShouldBeSplus = true;
                } else if (origName.equals(SPLUS_LIBRARY_FILE_NAME)) {
                    nextLibShouldBeSplus = false;
                }
                if (splusTree == null || !nextLibShouldBeSplus || i3 != numPaths - 1 && SPLUS_LIBRARY_FILE_NAME.equals(new File((String)originalPaths.get(i3 + 1)).getName()) || MinerApp.shouldSplusBeHidden()) continue;
                this.addTreeAndUpdateProps(SPLUS_LIBRARY_FILE_NAME, homeDir + SPLUS_LIBRARY_FILE_NAME, librariesInXMLDir, globalProps, true, true);
                nextLibShouldBeSplus = false;
            }
            for (String location : librariesInXMLDir.keySet()) {
                String editableName = new File(location).getName();
                if (new File(location).getName().equals(SPLUS_LIBRARY_FILE_NAME) && MinerApp.shouldSplusBeHidden()) continue;
                this.addTreeAndUpdateProps(editableName, location, librariesInXMLDir, globalProps, true, !propsNeedSaving, false);
            }
            this.getUserLibrary();
            if (propsNeedSaving) {
                this.save(globalProps, true);
            }
        }
        this.addChangeListener(this);
        this.addKeyListener(new NavigationKeyListener());
        this.addMouseListener(new LibraryManagerMouseListener());
        this.stateChanged(null);
        ToolTipManager.sharedInstance().registerComponent(this);
        DropTarget dTarget = new DropTarget(this, this);
    }

    private void addTreeAndUpdateProps(String editName, String origPath, HashMap treeMap, XTProps globalProps, boolean showing, boolean updateProps) {
        this.addTreeAndUpdateProps(editName, origPath, treeMap, globalProps, showing, updateProps, true);
    }

    private void addTreeAndUpdateProps(String editName, String origPath, HashMap treeMap, XTProps globalProps, boolean showing, boolean updateProps, boolean removeFromMap) {
        String[] libraryPath = new String[]{EXPLORER_PAGE_NODE_TAG, editName, "show"};
        DragAndDropTree tree = (DragAndDropTree)treeMap.get(origPath);
        if (tree == null) {
            tree = ExplorerPane.getLibrary(editName, origPath);
        }
        if (origPath.endsWith(SPLUS_LIBRARY_FILE_NAME) && tree != null && !tree.getVersion().equals(XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG) && new File(origPath).exists()) {
            Element element = ExplorerPane.getLibraryAsElement(origPath, true, false, false);
            try {
                XMLTree.recursiveFormattingWhitespaceRemoval(element);
                DragAndDropTree origTree = null;
                origTree = ExplorerPane.xmlToPages(element, origTree);
                if (origTree.getVersion().equals(XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG)) {
                    int choice = AcceleratorOptionPane.showOKCancelDialog(this, MinerApp.getText("ExplorerPane_updateSplusText"), MinerApp.getText("ExplorerPane_updateSplus"), 1);
                    if (choice == 0) {
                        origTree.setEditableFilename(tree.getEditableFilename());
                        origTree.setOriginalFilepath(tree.getOriginalFilepath());
                        tree = origTree;
                    } else {
                        tree.setVersion(XMLTree.CURRENT_VERSION_ATTRIBUTE_TAG);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (tree != null && showing) {
            this.add(tree, editName);
        }
        if (removeFromMap) {
            treeMap.remove(origPath);
        }
        if (updateProps) {
            globalProps.set(libraryPath[0], editName, origPath);
            globalProps.set(libraryPath, showing && tree != null);
        }
    }

    public void setEnabled(boolean enable) {
        for (int i = 0; i < this.m_extensionLibraryTrees.size(); ++i) {
            ((DragAndDropTree)this.m_extensionLibraryTrees.get(i)).setEnabled(enable);
        }
        super.setEnabled(enable);
    }

    public void removeAllTreeListeners() {
        for (int i = 0; i < this.m_extensionLibraryTrees.size(); ++i) {
            ((DragAndDropTree)this.m_extensionLibraryTrees.get(i)).removeListeners();
        }
    }

    public void addAllTreeListeners() {
        for (int i = 0; i < this.m_extensionLibraryTrees.size(); ++i) {
            ((DragAndDropTree)this.m_extensionLibraryTrees.get(i)).addListeners();
        }
    }

    public int getTabPosition(DragAndDropTree tree) {
        return this.m_extensionLibraryTrees.indexOf(tree);
    }

    public int getTabPosition(String filename) {
        return this.m_extensionLibraryNames.indexOf(filename);
    }

    public DragAndDropTree getTreeAtTab(int tabNum) {
        if (tabNum >= this.m_extensionLibraryTrees.size()) {
            return null;
        }
        return (DragAndDropTree)this.m_extensionLibraryTrees.get(tabNum);
    }

    public void copySelToUserLibrary(BaseNodeArea area) {
        DragAndDropTree dTree = this.getUserLibrary();
        DragAndDropTree.InvisibleNode iNode = new DragAndDropTree.InvisibleNode(area, false, true);
        dTree.addChildNodeToNode(null, iNode);
    }

    private DragAndDropTree getDefaultLibrary() {
        if (this.m_defaultLibrary == null) {
            String origPath = XML_DIR + EXPLORER_FILE_NAME;
            this.m_defaultLibrary = ExplorerPane.getLibrary(EXPLORER_FILE_NAME, origPath);
            if (this.m_defaultLibrary == null) {
                this.m_defaultLibrary = new DragAndDropTree();
                this.m_defaultLibrary.setTitle(DEFAULT_LIBRARY_TITLE);
                this.m_defaultLibrary.setEditableFilename(EXPLORER_FILE_NAME);
                this.m_defaultLibrary.setOriginalFilepath(origPath);
            }
            this.add(this.m_defaultLibrary, EXPLORER_FILE_NAME);
        }
        return this.m_defaultLibrary;
    }

    DragAndDropTree getUserLibrary() {
        if (this.m_userLibrary == null) {
            String origPath = SETTINGS_DIR + USER_LIBRARY_FILE_NAME;
            this.m_userLibrary = ExplorerPane.getLibrary(USER_LIBRARY_FILE_NAME, origPath);
            if (this.m_userLibrary == null) {
                this.m_userLibrary = new DragAndDropTree();
                this.m_userLibrary.setTitle(USER_LIBRARY_TITLE);
                this.m_userLibrary.setEditableFilename(USER_LIBRARY_FILE_NAME);
                this.m_userLibrary.setOriginalFilepath(origPath);
            }
            this.add(this.m_userLibrary, USER_LIBRARY_FILE_NAME);
        }
        return this.m_userLibrary;
    }

    public void setTreeTitle(String title) {
        if (this.m_currentTree != null) {
            this.m_currentTree.setTitle(title);
            this.setTitleAt(this.m_currentTab, title);
        }
    }

    public void setTreeDescription(String descr) {
        if (this.m_currentTree != null) {
            this.m_currentTree.setDescription(descr);
            this.setToolTipTextAt(this.m_currentTab, descr.length() > 0 ? descr : null);
        }
    }

    public void setTreeAuthor(String auth) {
        if (this.m_currentTree != null) {
            this.m_currentTree.setAuthor(auth);
        }
    }

    public void setDropable(boolean b) {
        if (this.m_currentTree != null) {
            this.m_currentTree.setDropable(b);
        }
    }

    public String getTreeTitle() {
        if (this.m_currentTree != null) {
            return this.m_currentTree.getTitle();
        }
        return "";
    }

    public String getTreeDescription() {
        if (this.m_currentTree != null) {
            return this.m_currentTree.getDescription();
        }
        return "";
    }

    public String getTreeAuthor() {
        if (this.m_currentTree != null) {
            return this.m_currentTree.getAuthor();
        }
        return "";
    }

    public boolean getDropable() {
        if (this.m_currentTree != null) {
            return this.m_currentTree.isDropable();
        }
        return false;
    }

    public void save() {
        this.save(MinerApp.getGlobalOptions());
    }

    public void save(XTProps globalProps) {
        this.save(globalProps, false);
    }

    public void save(XTProps globalProps, boolean justProps) {
        block14: {
            String saveDir;
            String[] showPath;
            String[] libraryPath;
            Vector origFilepaths;
            Vector editFilenames;
            block13: {
                int i;
                editFilenames = globalProps.getSubProperties(EXPLORER_PAGE_NODE_TAG);
                origFilepaths = globalProps.getSubPropertyValues(EXPLORER_PAGE_NODE_TAG);
                globalProps.removeProperty(new String[]{EXPLORER_PAGE_NODE_TAG});
                libraryPath = new String[]{EXPLORER_PAGE_NODE_TAG, ""};
                showPath = new String[]{EXPLORER_PAGE_NODE_TAG, "", "show"};
                saveDir = SETTINGS_DIR;
                if (editFilenames.size() != 0) break block13;
                for (i = 0; i < this.m_extensionLibraryTrees.size(); ++i) {
                    DragAndDropTree dTree = (DragAndDropTree)this.m_extensionLibraryTrees.get(i);
                    showPath[1] = libraryPath[1] = dTree.getEditableFilename();
                    String origPath = dTree.getOriginalFilepath();
                    try {
                        int index;
                        if (!justProps) {
                            File explorerFile = new File(saveDir + libraryPath[1]);
                            FileOutputStream fstream = new FileOutputStream(explorerFile);
                            dTree.storeXML(fstream);
                            fstream.close();
                        }
                        if ((index = editFilenames.indexOf(libraryPath[1])) != -1) {
                            editFilenames.remove(index);
                            origFilepaths.remove(index);
                        }
                        if (libraryPath[1].equals(USER_LIBRARY_FILE_NAME)) continue;
                        globalProps.set(libraryPath, new File(origPath).getAbsolutePath());
                        globalProps.set(showPath, true);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                for (i = 0; i < editFilenames.size(); ++i) {
                    showPath[1] = libraryPath[1] = (String)editFilenames.get(i);
                    String originalPath = new File((String)origFilepaths.get(i)).getAbsolutePath();
                    globalProps.set(libraryPath, originalPath);
                    globalProps.set(showPath, false);
                }
                break block14;
            }
            boolean handledUserLib = false;
            int t = 0;
            for (int i = 0; i < editFilenames.size(); ++i) {
                boolean showing;
                showPath[1] = libraryPath[1] = (String)editFilenames.get(i);
                String originalPath = new File((String)origFilepaths.get(i)).getAbsolutePath();
                boolean bl = showing = this.getTabPosition(libraryPath[1]) != -1;
                if (!libraryPath[1].equals(USER_LIBRARY_FILE_NAME)) {
                    globalProps.set(libraryPath, originalPath);
                    globalProps.set(showPath, showing);
                } else {
                    handledUserLib = true;
                }
                try {
                    if (justProps || !showing) continue;
                    DragAndDropTree dTree = (DragAndDropTree)this.m_extensionLibraryTrees.get(t++);
                    File explorerFile = new File(saveDir + libraryPath[1]);
                    FileOutputStream fstream = new FileOutputStream(explorerFile);
                    dTree.storeXML(fstream);
                    fstream.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (handledUserLib || justProps) break block14;
            try {
                DragAndDropTree dTree = this.getUserLibrary();
                File explorerFile = new File(saveDir + dTree.getEditableFilename());
                FileOutputStream fstream = new FileOutputStream(explorerFile);
                dTree.storeXML(fstream);
                fstream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeTreeTab(int tabNum) {
        this.m_extensionLibraryNames.remove(tabNum);
        this.m_extensionLibraryTrees.remove(tabNum);
        this.removeTabAt(tabNum);
    }

    public void changeVisibility(String editableName, String origPath, boolean show, String newLibTitle) {
        this.changeVisibility(editableName, origPath, show, newLibTitle, -1);
    }

    public void changeVisibility(String editableName, String origPath, boolean show, String newLibTitle, int tabPos) {
        if (show) {
            if (editableName.length() == 0) {
                this.addNewLibrary(origPath, newLibTitle, tabPos);
            } else {
                DragAndDropTree tree = ExplorerPane.getLibrary(editableName, origPath);
                if (tree == null) {
                    tree = new DragAndDropTree();
                    tree.setTitle(newLibTitle);
                    tree.setOriginalFilepath(origPath);
                    tree.setEditableFilename(editableName);
                }
                if (!this.m_extensionLibraryNames.contains(editableName)) {
                    if (tabPos == -1) {
                        this.add(tree, editableName);
                    } else {
                        this.addAt(tree, editableName, tabPos);
                    }
                    if (new File(origPath).getName().equals(SPLUS_LIBRARY_FILE_NAME)) {
                        MinerApp.resetSplusLicensedGlobalOptions();
                    }
                    try {
                        File explorerFile = new File(SETTINGS_DIR + editableName);
                        FileOutputStream fstream = new FileOutputStream(explorerFile);
                        tree.storeXML(fstream);
                        fstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            int num = this.m_extensionLibraryNames.indexOf(editableName);
            String filename = editableName;
            DragAndDropTree tree = null;
            if (num > -1) {
                this.m_extensionLibraryNames.remove(num);
                tree = (DragAndDropTree)this.m_extensionLibraryTrees.remove(num);
                this.removeTabAt(num);
            } else if (!new File(origPath).exists()) {
                tree = new DragAndDropTree();
                tree.setTitle(newLibTitle);
                tree.setEditableFilename(editableName);
                tree.setOriginalFilepath(origPath);
            }
            if (tree != null) {
                try {
                    File file = new File(SETTINGS_DIR + filename);
                    FileOutputStream fstream = new FileOutputStream(file);
                    tree.storeXML(fstream);
                    fstream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.updateProps(editableName, origPath, show);
        MinerApp.getHideLibraryAction().updateEnabled();
    }

    public static String generateUniqueEditName(String desiredName) {
        String settingsPath = SETTINGS_DIR;
        String extension = "";
        String fileName = desiredName;
        String tFileName = desiredName;
        int extensionLoc = desiredName.lastIndexOf(".");
        if (extensionLoc > -1) {
            tFileName = fileName = desiredName.substring(0, extensionLoc);
            extension = desiredName.substring(extensionLoc);
        }
        int num = 2;
        File editTree = new File(settingsPath + fileName + extension);
        while (editTree.exists()) {
            fileName = tFileName + Integer.toString(num++);
            editTree = new File(settingsPath + fileName + extension);
        }
        return fileName + extension;
    }

    public static DragAndDropTree getLibrary(String originalPath) {
        File origFile = new File(originalPath);
        String uniqueEditableFilename = ExplorerPane.generateUniqueEditName(origFile.getName());
        return ExplorerPane.getLibrary(uniqueEditableFilename, originalPath);
    }

    public static DragAndDropTree getLibrary(String editableFilename, String originalPath) {
        String usePath;
        if (editableFilename.length() == 0) {
            return ExplorerPane.getLibrary(originalPath);
        }
        String editablePath = SETTINGS_DIR + editableFilename;
        File editableFile = new File(editablePath);
        File originalFile = new File(originalPath);
        String string = editableFile.exists() && !editableFile.isDirectory() ? editablePath : (usePath = originalFile.exists() ? originalPath : null);
        if (usePath == null) {
            return null;
        }
        DragAndDropTree dTree = null;
        Document document = null;
        try {
            FileInputStream ins = new FileInputStream(usePath);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ins);
            }
            catch (SAXException e) {
                ins.close();
                if (!editableFile.exists()) {
                    return null;
                }
                ins = new FileInputStream(originalPath);
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ins);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Element elt = document.getDocumentElement();
        XMLTree.recursiveFormattingWhitespaceRemoval(elt);
        dTree = ExplorerPane.xmlToPages(elt, dTree);
        dTree.setEditableFilename(editableFilename);
        dTree.setOriginalFilepath(originalPath);
        return dTree;
    }

    public static Element getLibraryAsElement(String nameOrPath, boolean absolutePath, boolean throwFileNotFound, boolean checkSettingsDir) {
        Element elt = null;
        try {
            File orig = new File(nameOrPath);
            String origPath = absolutePath ? nameOrPath : XML_DIR + nameOrPath;
            String userPath = absolutePath ? SETTINGS_DIR + orig.getName() : SETTINGS_DIR + nameOrPath;
            boolean usedSprimeHome = false;
            File explorerFile = new File(userPath);
            if (!checkSettingsDir || !explorerFile.exists()) {
                explorerFile = new File(origPath);
                usedSprimeHome = true;
            }
            if (!throwFileNotFound && !explorerFile.exists()) {
                return null;
            }
            FileInputStream ins = new FileInputStream(explorerFile);
            Document document = null;
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ins);
            }
            catch (SAXException e) {
                ins.close();
                if (usedSprimeHome) {
                    throw e;
                }
                explorerFile = new File(origPath);
                ins = new FileInputStream(explorerFile);
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(ins);
            }
            elt = document.getDocumentElement();
            XMLTree.recursiveFormattingWhitespaceRemoval(elt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return elt;
    }

    public void add(DragAndDropTree tree, String filename) {
        this.externalAdd(tree, filename, false);
    }

    public void externalAdd(DragAndDropTree tree, String filename, boolean updateProps) {
        boolean playWithUserLib;
        boolean bl = playWithUserLib = this.m_userLibrary != null && tree != this.m_userLibrary;
        if (playWithUserLib) {
            int num = this.getTabCount() - 1;
            this.removeTree(num);
        }
        String title = tree.getTitle();
        this.m_extensionLibraryNames.add(filename);
        this.m_extensionLibraryTrees.add(tree);
        this.add(title, tree);
        if (updateProps) {
            XTProps globalProps = MinerApp.getGlobalOptions();
            String[] libraryPath = new String[]{EXPLORER_PAGE_NODE_TAG, ""};
            String[] showPath = new String[]{EXPLORER_PAGE_NODE_TAG, "", "show"};
            showPath[1] = libraryPath[1] = tree.getEditableFilename();
            globalProps.set(libraryPath, tree.getOriginalFilepath());
            globalProps.set(showPath, true);
        }
        if (playWithUserLib) {
            this.getUserLibrary();
            this.add(this.m_userLibrary, USER_LIBRARY_FILE_NAME);
        }
    }

    public void addAt(DragAndDropTree tree, String filename, int tabPos) {
        String title = tree.getTitle();
        this.m_extensionLibraryNames.insertElementAt(filename, tabPos);
        this.m_extensionLibraryTrees.insertElementAt(tree, tabPos);
        JScrollPane comp = new JScrollPane(tree);
        this.insertTab(title, comp, tree.getDescription(), tabPos);
    }

    public Component add(String label, DragAndDropTree tree) {
        JScrollPane comp = new JScrollPane(tree);
        this.insertTab(label, comp, tree.getDescription(), this.getTabCount());
        return comp;
    }

    public void insertTab(String label, Component comp, String tip, int loc) {
        String toolTip = tip.length() > 0 ? tip : null;
        super.insertTab(label, null, comp, toolTip, loc);
        MinerApp.getHideLibraryAction().updateEnabled();
    }

    public void removeTree(int treeNum) {
        this.m_extensionLibraryNames.remove(treeNum);
        this.m_extensionLibraryTrees.remove(treeNum);
        this.removeTabAt(treeNum);
        MinerApp.getHideLibraryAction().updateEnabled();
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (WorksheetView.isIMinerDnDFlavor(dtde.getCurrentDataFlavors())) {
            Point point = dtde.getLocation();
            try {
                int newIndex = this.getUI().tabForCoordinate(this, point.x, point.y);
                if (!this.m_timerSwitchTabs.isRunning() || newIndex != this.m_indexToSwitchTo) {
                    this.m_timerSwitchTabs.stop();
                    this.m_indexToSwitchTo = newIndex;
                    this.m_timerSwitchTabs.start();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
        this.m_indexToSwitchTo = -1;
    }

    public void drop(DropTargetDropEvent dtde) {
    }

    private static DragAndDropTree xmlToPages(Element elt, DragAndDropTree dTree) {
        dTree = DragAndDropTree.convertXmlToPages(elt, dTree);
        return dTree;
    }

    public void expandJTree() {
        if (this.m_currentTree != null) {
            this.m_currentTree.expandJTree();
        }
    }

    public void collapseJTree() {
        if (this.m_currentTree != null) {
            this.m_currentTree.collapseJTree();
        }
    }

    public void stateChanged(ChangeEvent e) {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            this.m_currentTree = (DragAndDropTree)this.m_extensionLibraryTrees.get(index);
            this.m_currentTab = index;
        }
        if (e != null) {
            AppAction.updateAllActions();
        }
    }

    public static String[] openNewLibrary(Component comp) {
        JPanel enterText = new JPanel(new GridBagLayout());
        JTextField libraryFilename = new JTextField(25);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        enterText.add((Component)new JLabel(ExplorerPane.getText("ExplorerPane_libraryFilename") + ":"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        enterText.add((Component)libraryFilename, gbc);
        while (AcceleratorOptionPane.showOKCancelDialog(comp, enterText, ExplorerPane.getText("ExplorerPane_libraryFilename"), -1) != 2) {
            String title = libraryFilename.getText().trim();
            String filename = title.replaceAll(" ", "_");
            if (filename.length() == 0) {
                AcceleratorOptionPane.showOKDialog(comp, ExplorerPane.getText("ExplorerPane_emptyFilename"), ExplorerPane.getText("ExplorerPane_libraryFileError"), 0);
                continue;
            }
            if ((filename = new File(filename).getName()).endsWith(".iml") || filename.endsWith(".xml")) {
                return new String[]{filename, title};
            }
            filename = filename + ".iml";
            return new String[]{filename, title};
        }
        return null;
    }

    public static String openLibrary(Component comp, boolean existing) {
        String defaultPath = SplusSystem.getCwd().getAbsolutePath();
        WideFileChooser fc = new WideFileChooser(defaultPath);
        fc.setAcceptAllFileFilterUsed(true);
        fc.addChoosableFileFilter(new LibraryFilter());
        if (existing) {
            fc.setDialogTitle(ExplorerPane.getText("ExplorerPane_loadExisting"));
        } else {
            fc.setDialogTitle(ExplorerPane.getText("ExplorerPane_loadNew"));
        }
        fc.setMultiSelectionEnabled(false);
        int result = fc.showOpenDialog(comp);
        if (result == 0) {
            File newFile = fc.getSelectedFile();
            String path = newFile.getAbsolutePath();
            if (newFile.getName().indexOf(".") == -1) {
                path = path + ".iml";
                newFile = new File(path);
            }
            return path;
        }
        return null;
    }

    public static String saveLibrary(Component comp) {
        String defaultPath = SplusSystem.getCwd().getAbsolutePath();
        WideFileChooser fc = new WideFileChooser(defaultPath);
        fc.setAcceptAllFileFilterUsed(true);
        fc.addChoosableFileFilter(new LibraryFilter());
        fc.setDialogTitle(ExplorerPane.getText("ExplorerPane_saveLibrary"));
        fc.setMultiSelectionEnabled(false);
        int result = fc.showSaveDialog(comp);
        while (result == 0) {
            File newFile = fc.getSelectedFile();
            String path = newFile.getAbsolutePath();
            String name = newFile.getName();
            if (name.indexOf(".") == -1) {
                path = path + ".iml";
                newFile = new File(path);
            }
            if (!FileUtilities.confirmSaveAs((Component)comp, (String)newFile.getAbsolutePath())) {
                result = fc.showSaveDialog(comp);
                continue;
            }
            return path;
        }
        return null;
    }

    public void addNewLibrary(String path, String newLibTitle) {
        this.addNewLibrary(path, newLibTitle, -1);
    }

    public void addNewLibrary(String path, String newLibTitle, int tabPos) {
        DragAndDropTree newLib = new DragAndDropTree();
        String editName = ExplorerPane.generateUniqueEditName(new File(path).getName());
        String origPath = SETTINGS_DIR + editName;
        newLib.setOriginalFilepath(origPath);
        newLib.setEditableFilename(editName);
        if (newLibTitle.length() > 0) {
            newLib.setTitle(newLibTitle);
        } else {
            newLib.setTitle(ExplorerPane.getText("ExplorerPane_newLibrary"));
        }
        if (tabPos == -1) {
            this.add(newLib, editName);
        } else {
            this.addAt(newLib, editName, tabPos);
        }
        this.setSelectedIndex(this.getTabCount() - 2);
        try {
            FileOutputStream fstream = new FileOutputStream(origPath);
            newLib.storeXML(fstream);
            fstream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.save(MinerApp.getGlobalOptions(), true);
        MinerApp.getHideLibraryAction().updateEnabled();
    }

    public void createNewFolder() {
        DragAndDropTree.LibraryFolder folder = new DragAndDropTree.LibraryFolder("New Folder");
        DragAndDropTree.InvisibleNode newNode = new DragAndDropTree.InvisibleNode(folder, true, true);
        this.m_currentTree.addNodeToCurrentSelection(newNode);
    }

    public boolean canHideLibrary() {
        return this.m_currentTab != this.getTabCount() - 1;
    }

    public void hideLibrary() {
        String origPath = this.m_currentTree.getOriginalFilepath();
        String editName = this.m_currentTree.getEditableFilename();
        this.changeVisibility(editName, origPath, false, null);
    }

    public void libraryProperties() {
        new LibraryPropertiesDialog(this).show();
    }

    public void saveLibraryAs() {
        String path = ExplorerPane.saveLibrary(MinerApp.getMainFrame());
        if (path != null && path.length() > 0) {
            try {
                FileOutputStream fstream = new FileOutputStream(path);
                this.m_currentTree.storeXML(fstream);
                fstream.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void revertLibrary() {
        String origPath = this.m_currentTree.getOriginalFilepath();
        if (!new File(origPath).exists()) {
            String revertErrorStr = MinerApp.getText("ExplorerPane_revertFileNotFound") + origPath;
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), revertErrorStr, MinerApp.getText("ExplorerPane_revertError"), 0);
            return;
        }
        if (2 == AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), ExplorerPane.getText("ExplorerPane_revertWarningMessage"), ExplorerPane.getText("ExplorerPane_revertWarningTitle"), 2)) {
            return;
        }
        int index = this.m_currentTab;
        this.m_extensionLibraryTrees.removeElementAt(index);
        this.removeTabAt(index);
        String filename = (String)this.m_extensionLibraryNames.get(index);
        DragAndDropTree tree = ExplorerPane.getLibrary(origPath);
        tree.setEditableFilename(filename);
        this.m_extensionLibraryTrees.insertElementAt(tree, index);
        this.insertTab(tree.getTitle(), null, new JScrollPane(tree), null, index);
        this.setSelectedIndex(index);
    }

    public void createNewLibrary() {
        String[] pathAndTitle = ExplorerPane.openNewLibrary(MinerApp.getMainFrame());
        if (pathAndTitle != null && pathAndTitle[0].length() > 0) {
            this.addNewLibrary(pathAndTitle[0], pathAndTitle[1]);
        }
        this.updateProps(pathAndTitle[0], SETTINGS_DIR + pathAndTitle[0], true);
    }

    public void updateProps(String editableName, String origPath, boolean show) {
        String[] path = new String[]{EXPLORER_PAGE_NODE_TAG, editableName, "show"};
        XTProps gProps = MinerApp.getGlobalOptions();
        gProps.set(EXPLORER_PAGE_NODE_TAG, editableName, origPath);
        gProps.set(path, show);
    }

    private void createActions() {
        this.m_manageLibrariesAction = MinerApp.getManageLibraryAction();
        this.m_createNewFolderAction = MinerApp.getCreateNewFolderAction();
        this.m_hideLibraryAction = MinerApp.getHideLibraryAction();
        this.m_propertiesAction = MinerApp.getLibraryPropertiesAction();
        this.m_saveLibraryAsAction = MinerApp.getSaveLibraryAsAction();
        this.m_revertLibraryAction = MinerApp.getRevertLibraryAction();
        this.m_createNewLibraryAction = MinerApp.getNewLibraryAction();
    }

    public AppAction getManageLibraryAction() {
        return this.m_manageLibrariesAction;
    }

    public boolean isDropable() {
        return this.m_currentTree.isDropable();
    }

    public void toggleDropable() {
        this.m_currentTree.setDropable(!this.m_currentTree.isDropable());
    }

    public void doPaste() {
        this.m_currentTree.paste();
    }

    public void doCopyFromLibraryToUserLibrary() {
        try {
            Transferable transfer = this.m_currentTree.convertSelectionToTransferable();
            Clipboard clipboard = this.getToolkit().getSystemClipboard();
            clipboard.setContents(transfer, null);
            transfer = clipboard.getContents(this);
            DragAndDropTree.InvisibleNode iNode = null;
            if (transfer.isDataFlavorSupported(DragAndDropTree.InvisibleNode.nodeFlavor)) {
                iNode = (DragAndDropTree.InvisibleNode)transfer.getTransferData(DragAndDropTree.InvisibleNode.nodeFlavor);
            } else if (transfer.isDataFlavorSupported(BaseNodeArea.nodeFlavor)) {
                BaseNodeArea area = BaseNodeArea.convertTransferToArea(transfer);
                iNode = new DragAndDropTree.InvisibleNode(area, false, true);
            }
            if (iNode != null) {
                this.getUserLibrary().addChildNodeToNode(null, iNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMenus() {
        this.createActions();
        this.m_libraryMenu = new MinerPopupMenu();
        this.m_libraryMenu.add(this.m_createNewFolderAction);
        this.m_libraryMenu.add(MinerApp.getLibraryPasteAction());
        this.m_libraryMenu.addSeparator();
        this.m_libraryMenu.add(this.m_manageLibrariesAction);
        this.m_libraryMenu.add(this.m_createNewLibraryAction);
        this.m_libraryMenu.add(this.m_saveLibraryAsAction);
        this.m_libraryMenu.addSeparator();
        this.m_libraryMenu.add(this.m_propertiesAction);
        this.m_libraryMenu.add(this.m_hideLibraryAction);
        this.m_libraryMenu.add(this.m_revertLibraryAction);
    }

    public static String getText(String key) {
        return MinerApp.getText(key);
    }

    public static Icon getPlainGrayIcon() {
        return ExplorerPane.getIcon("plain_gray.gif");
    }

    public static Icon getIcon(String key) {
        return MinerApp.getIcon(key);
    }

    public class LibraryPropertiesDialog
    extends JDialog {
        public String HELP_TOPIC;
        private ExplorerPane m_explorerPane;
        private JTextField m_titleTF;
        private JTextArea m_descriptionTA;
        private JTextField m_authorTF;
        private JCheckBox m_editableCB;

        public LibraryPropertiesDialog(ExplorerPane pane) {
            super((Frame)MinerApp.getMainFrame(), MinerApp.getText("LibraryPropertiesDialog_libraryProperties"));
            this.HELP_TOPIC = "Library Properties";
            this.m_explorerPane = pane;
            this.m_titleTF = new JTextField(10);
            this.m_titleTF.setDocument(new SizeLimitDocument(20));
            this.m_descriptionTA = new JTextArea(3, 10);
            this.m_descriptionTA.setLineWrap(true);
            this.m_descriptionTA.setWrapStyleWord(true);
            this.m_descriptionTA.setBorder(this.m_titleTF.getBorder());
            this.m_descriptionTA.setDocument(new SizeLimitDocument(200));
            this.m_authorTF = new JTextField(10);
            this.m_editableCB = new JCheckBox(MinerApp.getText("LibraryPropertiesDialog_readOnly"));
            this.m_editableCB.setMnemonic(MinerApp.getText("LibraryPropertiesDialog_readOnlyHotkey").charAt(0));
            JLabel titleL = new JLabel(MinerApp.getText("LibraryPropertiesDialog_libraryTitle"));
            JLabel descriptionL = new JLabel(MinerApp.getText("LibraryPropertiesDialog_libraryDescription"));
            JLabel authorL = new JLabel(MinerApp.getText("LibraryPropertiesDialog_libraryAuthor"));
            titleL.setDisplayedMnemonic(MinerApp.getText("LibraryPropertiesDialog_libraryTitleHotkey").charAt(0));
            descriptionL.setDisplayedMnemonic(MinerApp.getText("LibraryPropertiesDialog_libraryDescriptionHotkey").charAt(0));
            authorL.setDisplayedMnemonic(MinerApp.getText("LibraryPropertiesDialog_libraryAuthorHotkey").charAt(0));
            titleL.setLabelFor(this.m_titleTF);
            descriptionL.setLabelFor(this.m_descriptionTA);
            authorL.setLabelFor(this.m_authorTF);
            this.m_editableCB.setSelected(!this.m_explorerPane.isDropable());
            this.m_titleTF.setText(this.m_explorerPane.getTreeTitle());
            this.m_descriptionTA.setText(this.m_explorerPane.getTreeDescription());
            this.m_descriptionTA.setCaretPosition(0);
            this.m_authorTF.setText(this.m_explorerPane.getTreeAuthor());
            JButton ok = new JButton(new AppAction(MinerApp.getText("NodeDialog_ok")){

                public void actionPerformed(ActionEvent e) {
                    LibraryPropertiesDialog.this.m_explorerPane.setTreeTitle(LibraryPropertiesDialog.this.m_titleTF.getText());
                    LibraryPropertiesDialog.this.m_explorerPane.setTreeDescription(LibraryPropertiesDialog.this.m_descriptionTA.getText());
                    LibraryPropertiesDialog.this.m_explorerPane.setTreeAuthor(LibraryPropertiesDialog.this.m_authorTF.getText());
                    LibraryPropertiesDialog.this.m_explorerPane.setDropable(!LibraryPropertiesDialog.this.m_editableCB.isSelected());
                    LibraryPropertiesDialog.this.dispose();
                }
            });
            ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
            JButton cancel = new JButton(new AppAction(MinerApp.getText("NodeDialog_cancel")){

                public void actionPerformed(ActionEvent e) {
                    LibraryPropertiesDialog.this.dispose();
                }
            });
            cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
            cancel.registerKeyboardAction(cancel.getAction(), KeyStroke.getKeyStroke("ESCAPE"), 2);
            JButton help = new JButton(new AppAction(MinerApp.getText("NodeDialog_help")){

                public void actionPerformed(ActionEvent e) {
                    MinerApp.getHelpManager().showTopic(LibraryPropertiesDialog.this.HELP_TOPIC);
                }
            });
            help.setMnemonic(MinerApp.getText("NodeDialog_helpHotkey").charAt(0));
            Insets labels = new Insets(2, 0, 2, 5);
            Insets others = new Insets(2, 0, 2, 0);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("LibraryPropertiesDialog_properties")), BorderFactory.createEmptyBorder(5, 5, 5, 10)));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = labels;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.gridy = 0;
            gbc.gridx = 0;
            mainPanel.add((Component)titleL, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = others;
            mainPanel.add((Component)this.m_titleTF, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets = labels;
            mainPanel.add((Component)descriptionL, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = others;
            mainPanel.add((Component)new JScrollPane(this.m_descriptionTA), gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.insets = labels;
            gbc.fill = 2;
            mainPanel.add((Component)authorL, gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            gbc.insets = others;
            mainPanel.add((Component)this.m_authorTF, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            mainPanel.add((Component)this.m_editableCB, gbc);
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            buttonsPanel.add(Box.createHorizontalGlue());
            buttonsPanel.add(ok);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(cancel);
            buttonsPanel.add(Box.createHorizontalStrut(5));
            buttonsPanel.add(help);
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)mainPanel, "Center");
            container.add((Component)buttonsPanel, "South");
            this.setSize(400, 300);
            this.setLocationRelativeTo(MinerApp.getMainFrame());
        }

        private class SizeLimitDocument
        extends PlainDocument {
            private int m_maxChars;

            public SizeLimitDocument(int maxChars) {
                this.m_maxChars = maxChars;
            }

            public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
                if (s.equals("\n")) {
                    return;
                }
                s = s.replace('\n', ' ');
                String pre = super.getText(0, offset);
                String post = super.getText(offset, this.getLength() - offset);
                String full = pre + s + post;
                if (full.length() <= this.m_maxChars) {
                    super.insertString(offset, s, attributeSet);
                }
            }
        }
    }

    private abstract class ExplorerAction
    extends AppAction {
        public ExplorerAction(String name, Icon icon) {
            super(name, icon);
        }

        public boolean canAct() {
            return true;
        }
    }

    public static class LibraryFilenameFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.equals(EXPLORER_FILE_NAME) || name.equals(SPLUS_LIBRARY_FILE_NAME);
        }
    }

    public static class LibraryFilter
    extends FileFilter {
        public static final String FILTER_DESCRIPTION = "Library Files (*.iml)";
        public static final String FILTER_EXTENSION = ".iml";

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(FILTER_EXTENSION);
        }

        public String getDescription() {
            return FILTER_DESCRIPTION;
        }
    }

    public class NavigationKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            int navCode = e.getKeyCode();
            if (navCode == 10) {
                JScrollPane comp = (JScrollPane)ExplorerPane.this.getSelectedComponent();
                DragAndDropTree dndTree = (DragAndDropTree)comp.getViewport().getComponent(0);
                dndTree.requestFocusInWindow();
                dndTree.setSelectionRow(0);
            }
        }
    }

    private class LibraryManagerMouseListener
    extends MouseAdapter {
        private boolean consumed = true;

        private LibraryManagerMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.consumed = false;
        }

        public void mouseClicked(MouseEvent e) {
            this.mouseAction(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.mouseAction(e);
        }

        private void mouseAction(MouseEvent e) {
            if (!this.consumed && e.getButton() != 1 && ExplorerPane.this.isEnabled()) {
                ExplorerPane.this.m_libraryMenu.show(ExplorerPane.this, e.getX(), e.getY());
                this.consumed = true;
            }
        }
    }
}

