/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.EngineOrderNodeModelInputIterator;
import com.insightful.miner.JoinEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class JoinDialog
extends NodeDialog {
    private static JoinDialog g_instance = null;
    private int m_rowHeight = 25;
    private int m_iconWidth = 75;
    private static final int g_inputNameColumn = 0;
    private static final int g_includeUnmatchedColumn = 1;
    private static final int g_suffixColumn = 2;
    private static final int g_keyStartColumn = 3;
    private JComboBox m_keyNumCB;
    private JComboBox m_keyValCB;
    private JCheckBox m_joinByRow;
    private MJTableModel m_tableModel;
    private NodeDialog.DialogTable m_table;
    private JCheckBox sortCheckBox;
    private AbstractAction addKeyAction;
    private AbstractAction removeKeyAction;
    private AbstractAction setAllAction;
    private AbstractAction includeAllAction;
    private AbstractAction excludeAllAction;
    private AbstractAction joinByRowAction;
    private static Color g_enabledBGColor = null;
    private static Color g_disabledBGColor = null;
    private static Color g_enabledFGColor = null;
    private static Color g_disabledFGColor = null;

    public static JoinDialog getInstance() {
        if (g_instance == null) {
            g_instance = new JoinDialog();
        }
        return g_instance;
    }

    private JoinDialog() {
        Dimension dim = new Dimension(550, 525);
        this.setMinimumSize(dim);
        this.setSize(dim);
    }

    public void restoreProperties() {
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        super.restoreProperties();
        try {
            this.m_tableModel.clearTable();
            ActivityNodeModel model = this.getNodeModel();
            XTProps props = model.getXTProps();
            Hashtable<String, String> columnNameMap = new Hashtable<String, String>();
            int nInputs = model.getExistingNumberInputs();
            XTMetaData[] inMDs = new XTMetaData[nInputs];
            String[] path = new String[2];
            int numKeys = 0;
            Vector[] pKeys = JoinEngineNode.getMultiColumnKeys(props, nInputs);
            String[] pSuffii = JoinEngineNode.getMultiSuffii(props, nInputs);
            boolean[] pInclude = JoinEngineNode.getMultiUnmatched(props, nInputs);
            EngineOrderNodeModelInputIterator iterator = new EngineOrderNodeModelInputIterator(model);
            while (iterator.hasNext()) {
                int i = iterator.getInputNumber();
                inMDs[i] = iterator.peekInputMetaData();
                ActivityNodeModel aModel = (ActivityNodeModel)iterator.next();
                int nodeID = aModel.getID();
                Vector<Object> row = new Vector<Object>();
                Vector cNames = inMDs[i].getColumnNames();
                for (int j = 0; j < cNames.size(); ++j) {
                    String cName = (String)cNames.get(j);
                    if (columnNameMap.get(cName) != null) continue;
                    columnNameMap.put(cName, cName);
                }
                row.add(aModel.getLabelText());
                row.add(new Boolean(pInclude[i]));
                row.add(pSuffii[i]);
                Vector keys = pKeys[i];
                numKeys = keys.size();
                int nkeys = numKeys == 0 ? 1 : numKeys;
                for (int j = 0; j < nkeys; ++j) {
                    if (i == 0 && j != 0) {
                        this.m_tableModel.addColumn("");
                    }
                    if (numKeys == 0) {
                        row.add("");
                        continue;
                    }
                    row.add(keys.get(j));
                }
                this.m_tableModel.addRow(row);
            }
            this.m_keyValCB.removeAllItems();
            Enumeration allColumnNames = columnNameMap.keys();
            while (allColumnNames.hasMoreElements()) {
                this.m_keyValCB.addItem(allColumnNames.nextElement());
            }
            this.setTableProperties();
            this.m_keyNumCB.removeAllItems();
            int nkeys = numKeys == 0 ? 1 : numKeys;
            for (int i = 0; i < nkeys; ++i) {
                this.m_keyNumCB.addItem(new Integer(i + 1));
            }
            this.m_joinByRow.setSelected(!JoinEngineNode.useKeys(props));
            this.setJoinByKey(!this.m_joinByRow.isSelected());
            this.sortCheckBox.setSelected(props.getBoolean(JoinEngineNode.SORT_ATTRIBUTE_TAG, true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setJoinByKey(boolean isByKey) {
        this.m_keyNumCB.setEnabled(isByKey);
        this.m_keyValCB.setEnabled(isByKey);
        this.setAllAction.setEnabled(isByKey);
        boolean atLeastOneKeyCol = this.m_table == null || this.m_table.getColumnCount() > 4;
        this.removeKeyAction.setEnabled(isByKey && atLeastOneKeyCol);
        this.addKeyAction.setEnabled(isByKey);
        if (this.m_table != null) {
            int[] widths = new int[this.m_table.getColumnCount()];
            for (int i = 0; i < widths.length; ++i) {
                widths[i] = this.m_table.getColumnModel().getColumn(i).getWidth();
            }
            this.m_tableModel.fireTableStructureChanged();
            this.setTableProperties();
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        if (this.m_table.isEditing()) {
            this.m_table.getCellEditor().stopCellEditing();
        }
        super.saveProperties();
        ActivityNodeModel model = this.getNodeModel();
        XTProps props = model.getXTProps();
        String[] unmatchedPath = new String[]{JoinEngineNode.JOIN_VALUES_ATTRIBUTE_TAG, ""};
        String[] suffixPath = new String[]{JoinEngineNode.COLUMN_SUFFII_ATTRIBUTE_TAG, ""};
        String[] keysPath = new String[]{JoinEngineNode.KEY_COLUMN_KEY_ATTRIBUTE_TAG, "", ""};
        props.removeProperty(new String[]{JoinEngineNode.KEY_COLUMN_KEY_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.LEFT_COLUMN_SUFFIX_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.RIGHT_COLUMN_SUFFIX_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.LEFT_KEY_COLUMN_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.RIGHT_KEY_COLUMN_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.LEFT_TYPE_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.RIGHT_TYPE_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.JOIN_TYPE_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.KEY_COLUMN_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.SORT_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.KEY_COLUMN_KEY_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.COLUMN_SUFFII_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{JoinEngineNode.JOIN_VALUES_ATTRIBUTE_TAG});
        int nInputs = this.m_table.getRowCount();
        for (int i = 0; i < nInputs; ++i) {
            suffixPath[1] = keysPath[1] = Integer.toString(i);
            unmatchedPath[1] = keysPath[1];
            props.set(unmatchedPath, (boolean)((Boolean)this.m_tableModel.getValueAt(i, 1)));
            props.set(suffixPath, (String)this.m_tableModel.getValueAt(i, 2));
            int numKeys = this.m_table.getColumnCount() - 3;
            int j = 0;
            int k = 3;
            while (j < numKeys) {
                keysPath[2] = Integer.toString(j);
                String keyVal = (String)this.m_tableModel.getValueAt(i, k);
                props.set(keysPath, keyVal == null ? "" : keyVal);
                ++j;
                ++k;
            }
        }
        props.set(JoinEngineNode.KEY_COLUMN_ATTRIBUTE_TAG, !this.m_joinByRow.isSelected());
        props.set(JoinEngineNode.SORT_ATTRIBUTE_TAG, this.sortCheckBox.isSelected());
    }

    public JPanel createOptionsPanel() {
        JLabel numInputsLabel = new JLabel(MinerApp.getText("JoinDialog_setNumInputs"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = new Insets(5, 15, 5, 5);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        panel.add((Component)this.createKeyColumnPanel(), gbc);
        return panel;
    }

    public void createActions() {
        super.createActions();
        this.addKeyAction = new AbstractAction(MinerApp.getText("JoinDialog_addKey")){

            public void actionPerformed(ActionEvent e) {
                JoinDialog.this.m_tableModel.addColumn("");
                if (JoinDialog.this.m_tableModel.getColumnCount() > 3) {
                    JoinDialog.this.removeKeyAction.setEnabled(true);
                }
                JoinDialog.this.m_keyNumCB.addItem(Integer.toString(JoinDialog.this.m_keyNumCB.getItemCount() + 1));
                JoinDialog.this.setTableProperties();
            }
        };
        this.removeKeyAction = new AbstractAction(MinerApp.getText("JoinDialog_removeKey")){

            public void actionPerformed(ActionEvent e) {
                if (JoinDialog.this.m_table.isEditing()) {
                    JoinDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                JoinDialog.this.m_tableModel.removeColumn();
                if (JoinDialog.this.m_tableModel.getColumnCount() <= 4) {
                    JoinDialog.this.removeKeyAction.setEnabled(false);
                }
                JoinDialog.this.m_keyNumCB.removeItemAt(JoinDialog.this.m_keyNumCB.getItemCount() - 1);
            }
        };
        this.setAllAction = new AbstractAction(MinerApp.getText("JoinDialog_setAll")){

            public void actionPerformed(ActionEvent e) {
                if (JoinDialog.this.m_table.isEditing()) {
                    JoinDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                String keyNumStr = JoinDialog.this.m_keyNumCB.getSelectedItem().toString();
                String keyValStr = JoinDialog.this.m_keyValCB.getSelectedItem().toString();
                int keyNum = Integer.parseInt(keyNumStr) - 1;
                int nRows = JoinDialog.this.m_table.getRowCount();
                for (int i = 0; i < nRows; ++i) {
                    JoinDialog.this.m_tableModel.setValueAt(keyValStr, i, 3 + keyNum);
                }
                JoinDialog.this.m_tableModel.fireTableDataChanged();
            }
        };
        this.includeAllAction = new AbstractAction(MinerApp.getText("JoinDialog_includeAll")){

            public void actionPerformed(ActionEvent e) {
                if (JoinDialog.this.m_table.isEditing()) {
                    JoinDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                int rows = JoinDialog.this.m_table.getRowCount();
                Boolean include = new Boolean(true);
                for (int i = 0; i < rows; ++i) {
                    JoinDialog.this.m_tableModel.setValueAt(include, i, 1);
                }
                JoinDialog.this.m_tableModel.fireTableDataChanged();
            }
        };
        this.excludeAllAction = new AbstractAction(MinerApp.getText("JoinDialog_excludeAll")){

            public void actionPerformed(ActionEvent e) {
                if (JoinDialog.this.m_table.isEditing()) {
                    JoinDialog.this.m_table.getCellEditor().stopCellEditing();
                }
                int rows = JoinDialog.this.m_table.getRowCount();
                Boolean include = new Boolean(false);
                for (int i = 0; i < rows; ++i) {
                    JoinDialog.this.m_tableModel.setValueAt(include, i, 1);
                }
                JoinDialog.this.m_tableModel.fireTableDataChanged();
            }
        };
        this.joinByRowAction = new AbstractAction(MinerApp.getText("JoinDialog_joinByRow")){

            public void actionPerformed(ActionEvent e) {
                JoinDialog.this.setJoinByKey(!JoinDialog.this.m_joinByRow.isSelected());
            }
        };
    }

    public JPanel createNodePanel() {
        JPanel globalPanel = new JPanel(new BorderLayout());
        globalPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("NodeDialog_sortOptions")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.sortCheckBox = new JCheckBox(MinerApp.getText("NodeDialog_sortRequired"));
        globalPanel.add((Component)this.sortCheckBox, "North");
        return globalPanel;
    }

    public JPanel createKeyColumnPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        Insets margins = new Insets(5, 5, 5, 5);
        this.m_joinByRow = new JCheckBox(this.joinByRowAction);
        this.m_tableModel = new MJTableModel();
        NodeDialog.TableSorter sortingModel = new NodeDialog.TableSorter(this.m_tableModel);
        this.m_table = new NodeDialog.DialogTable(sortingModel);
        sortingModel.addMouseListenerToHeaderInTable(this.m_table);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setAutoResizeMode(0);
        this.setTableProperties();
        JScrollPane scrollingTable = new JScrollPane(this.m_table);
        scrollingTable.setPreferredSize(new Dimension(400, 150));
        JButton addKey = new JButton(this.addKeyAction);
        JButton removeKey = new JButton(this.removeKeyAction);
        JLabel keyNumLabel = new JLabel(MinerApp.getText("JoinDialog_key"));
        this.m_keyNumCB = new JComboBox();
        this.m_keyValCB = new JComboBox();
        JButton setAll = new JButton(this.setAllAction);
        JButton includeAll = new JButton(this.includeAllAction);
        JButton excludeAll = new JButton(this.excludeAllAction);
        JPanel addRemKeyPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = margins;
        gbc.gridy = 0;
        addRemKeyPanel.add((Component)addKey, gbc);
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        addRemKeyPanel.add((Component)removeKey, gbc);
        JPanel setKeysPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = margins;
        gbc.weightx = 0.0;
        setKeysPanel.add((Component)keyNumLabel, gbc);
        gbc.weightx = 0.5;
        setKeysPanel.add((Component)this.m_keyNumCB, gbc);
        setKeysPanel.add((Component)this.m_keyValCB, gbc);
        gbc.weightx = 0.0;
        setKeysPanel.add((Component)setAll, gbc);
        JPanel inclExclUnmatchedPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = margins;
        gbc.weightx = 0.5;
        inclExclUnmatchedPanel.add((Component)includeAll, gbc);
        inclExclUnmatchedPanel.add((Component)excludeAll, gbc);
        JPanel setForAllPanel = new JPanel(new GridBagLayout());
        setForAllPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("JoinDialog_setForAll")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.gridy = 1;
        setForAllPanel.add((Component)inclExclUnmatchedPanel, gbc);
        gbc.gridy = 2;
        setForAllPanel.add((Component)setKeysPanel, gbc);
        JPanel joinTypePanel = new JPanel(new GridBagLayout());
        joinTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("JoinDialog_setJoinType")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        gbc.gridy = 1;
        joinTypePanel.add((Component)this.m_joinByRow, gbc);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridy = 0;
        leftPanel.add((Component)scrollingTable, gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 1;
        leftPanel.add((Component)setForAllPanel, gbc);
        gbc.gridy = 3;
        leftPanel.add((Component)joinTypePanel, gbc);
        JPanel panel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridx = 0;
        panel.add((Component)leftPanel, gbc);
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        panel.add((Component)addRemKeyPanel, gbc);
        return panel;
    }

    public void setTableProperties() {
        ActivityNodeModel model = this.getNodeModel();
        KeyColumnEditor KCeditor = null;
        if (model != null) {
            int nInputs = model.getExistingNumberInputs();
            XTMetaData[] inMDs = new XTMetaData[nInputs];
            try {
                for (int i = 0; i < nInputs; ++i) {
                    inMDs[i] = model.getInputMetaData(i);
                }
                KCeditor = new KeyColumnEditor(this.m_table, inMDs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_table.setRowHeight(this.m_rowHeight);
        }
        int columnCount = this.m_tableModel.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = this.m_table.getColumn(this.m_table.getColumnName(i));
            column.setPreferredWidth(this.m_iconWidth);
            if (i >= 3 && KCeditor != null) {
                column.setCellEditor(KCeditor);
            }
            column.setCellRenderer(new OtherRenderer());
        }
        String inputColName = this.m_table.getColumnName(0);
        int width = new JLabel((String)inputColName).getPreferredSize().width * 5;
        this.m_table.getColumn(inputColName).setPreferredWidth(width);
        String inclUnmatchName = this.m_table.getColumnName(1);
        TableColumn checkBoxTableColumn = this.m_table.getColumn(inclUnmatchName);
        checkBoxTableColumn.setCellEditor(new DefaultCellEditor(new JCheckBox()));
        checkBoxTableColumn.setCellRenderer(new BooleanRenderer());
        width = (int)((double)new JLabel((String)inclUnmatchName).getPreferredSize().width * 1.5);
        checkBoxTableColumn.setPreferredWidth(width);
    }

    private class BooleanRenderer
    implements TableCellRenderer,
    Serializable {
        private Color background = new JTextField("").getBackground();
        private JCheckBox rend = new JCheckBox();

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null || !(value instanceof Boolean)) {
                return null;
            }
            this.rend.setSelected((Boolean)value);
            this.rend.setBackground(this.background);
            return this.rend;
        }
    }

    private class OtherRenderer
    extends NodeDialog.LeftJustifiedStringRenderer {
        public OtherRenderer() {
            if (g_enabledBGColor == null) {
                JTextField tf = new JTextField("test");
                g_enabledBGColor = tf.getBackground();
                g_enabledFGColor = tf.getForeground();
                tf.setEnabled(false);
                tf.setEditable(false);
                g_disabledFGColor = tf.getForeground();
                g_disabledBGColor = tf.getBackground();
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object val = value;
            if (val == null) {
                val = "";
            }
            Component comp = super.getTableCellRendererComponent(table, val, isSelected, hasFocus, row, column);
            if (JoinDialog.this.m_joinByRow != null && comp != null && column >= 3) {
                boolean byRow = JoinDialog.this.m_joinByRow.isSelected();
                if (comp instanceof JLabel) {
                    ((JLabel)comp).setOpaque(true);
                    if (byRow) {
                        comp.setForeground(g_disabledFGColor);
                        comp.setBackground(g_disabledBGColor);
                    } else {
                        comp.setForeground(g_enabledFGColor);
                        comp.setBackground(g_enabledBGColor);
                    }
                }
            }
            return comp;
        }
    }

    private class MJTableModel
    extends DefaultTableModel {
        private Vector m_columnNames = new Vector();
        private int m_numPreKeyColumns = 3;
        private int m_numKeyColumns = 1;

        public MJTableModel() {
            this.setColumnNames();
        }

        private void setColumnNames() {
            this.m_columnNames.clear();
            this.m_columnNames.add(MinerApp.getText("JoinDialog_inputName"));
            this.m_columnNames.add(MinerApp.getText("JoinDialog_includeUnmatched"));
            this.m_columnNames.add(MinerApp.getText("JoinDialog_suffix"));
            for (int i = 0; i < this.m_numKeyColumns; ++i) {
                String keyColName = MinerApp.getText("JoinDialog_key") + Integer.toString(i + 1);
                this.m_columnNames.add(keyColName);
            }
            this.setColumnIdentifiers(this.m_columnNames);
            if (JoinDialog.this.m_tableModel != null) {
                JoinDialog.this.setTableProperties();
            }
        }

        public void addColumn(Object obj) {
            super.addColumn(obj);
            ++this.m_numKeyColumns;
            this.setColumnNames();
        }

        public void removeColumn() {
            int colToRem = this.m_numPreKeyColumns + --this.m_numKeyColumns;
            int nRows = this.dataVector.size();
            for (int i = 0; i < nRows; ++i) {
                Vector rowData = (Vector)this.dataVector.get(i);
                rowData.remove(colToRem);
            }
            this.setColumnNames();
        }

        public void setValueAt(Object aValue, int row, int column) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
        }

        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return false;
            }
            return !JoinDialog.this.m_joinByRow.isSelected() || column < 3;
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.m_numKeyColumns = 1;
            this.setColumnNames();
            this.fireTableDataChanged();
        }
    }

    private class KeyColumnEditor
    extends DefaultCellEditor {
        private XTMetaData[] inputMD;
        private JTable myOwner;

        public KeyColumnEditor(JTable owner, XTMetaData[] inMDs) {
            super(new JComboBox());
            this.inputMD = null;
            this.myOwner = null;
            this.myOwner = owner;
            this.inputMD = inMDs;
        }

        public void editingCanceled(ChangeEvent e) {
            super.cancelCellEditing();
            this.myOwner.getCellEditor().cancelCellEditing();
        }

        public void editingStopped(ChangeEvent e) {
            super.stopCellEditing();
            this.myOwner.getCellEditor().cancelCellEditing();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean sel, int row, int column) {
            String strVal = (String)table.getValueAt(row, 0);
            Vector cols = this.inputMD[row].getColumnNames();
            JComboBox cb = (JComboBox)super.getTableCellEditorComponent(table, strVal, sel, row, column);
            cb.removeAllItems();
            if (cols != null && cols.size() > 0) {
                for (int i = 0; i < cols.size(); ++i) {
                    cb.addItem(cols.get(i));
                }
                cb.setSelectedItem(value == null ? "" : value.toString());
            }
            cb.setEditable(false);
            return cb;
        }
    }
}

