/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.UniqueEngineNode;
import com.insightful.miner.XTMetaData;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;

public class OrderEngineNode
extends UniqueEngineNode {
    public static final String ORDER_COL_NAME = "ORDER";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    protected double getIndexStartVal() {
        return 1.0;
    }

    protected boolean handleRows() throws Exception {
        return true;
    }

    protected boolean handleUnsort() throws Exception {
        return true;
    }

    protected boolean handleOutput() throws Exception {
        File outputFile = new File(this.getOutputDataCacheFileName(0));
        File outputBlobFile = new File(this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0));
        XTMetaData outputMD = this.getOutputMD();
        this.setOutputMetaData(0, outputMD);
        return this.fileManipulation(this.m_sortedFile, this.m_sortedBlobFile, this.getSortedMD(), outputFile, outputBlobFile, outputMD, 4);
    }

    protected boolean drop(DataCacheRowBuf preBuf, DataInput preStream, DataCacheRowBuf newBuf, DataOutput newStream, XTMetaData preMD, XTMetaData newMD) {
        long numRows = preMD.getNumRows();
        int indexColNum = preMD.nameToOrdinal(".im_index_im.");
        int numColumns = preMD.getNumColumns();
        for (long rowNum = 0L; rowNum < numRows; ++rowNum) {
            try {
                preBuf.readRow(preStream);
                int c = 0;
                for (int i = 0; i < numColumns; ++i) {
                    if (i != indexColNum) continue;
                    newBuf.copyColumn(c++, i, preBuf);
                }
                newBuf.writeRow(newStream);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        return true;
    }

    protected XTMetaData getOutputMD() {
        try {
            XTMetaData md = new XTMetaData();
            md.appendContinousDataField(ORDER_COL_NAME);
            md.setNumRows(this.getUnsortedMD().getNumRows());
            return md;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

